/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Vibrator;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.PTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.nos.NosCallActionRceiver;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.ptapp.mm.ZoomSubscribeRequest;
import com.zipow.videobox.util.ZMServiceHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class NotificationMgr {
    private static final String TAG = NotificationMgr.class.getSimpleName();
    public static final int PT_NOTICICATION_ID = 4;
    public static final int LOGIN_EXPIRED_NOTICICATION_ID = 5;
    public static final int PT_SIP_NOTICICATION_ID = 6;
    private static final int ZOOM_MESSENGER_MESSAGE_NOTICICATION_ID = 7;
    private static final int ZOOM_NOS_CALL_NOTICICATION_ID = 8;
    public static final int ZOOM_SERVICE_NOTIFY_NOTICICATION_ID = 9;
    private static final int ZOOM_MESSENGER_MESSAGE_NOTICICATION_ID_START = 10000;
    private static final long[] VIBRATES = new long[]{0L, 200L, 200L, 200L};
    private static final long[] CALLING_VIBRATES = new long[]{2000L, 1000L, 2000L, 1000L};
    public static final String ZOOM_NOS_CALL_CANCEL_ACTION = "nos_call_cancel";
    public static final String ZOOM_NOS_CALL_ACCEPT_ACTION = "nos_call_accept";
    public static final String KEY_NOS_CALL_MESSAGE_BODY = "call_body";
    public static final String KEY_NOS_CALL_MESSAGE_TYPE = "call_type";
    public static final String ZOOM_NOTIFICATION_CHANNEL_ID = "zoom_notification_channel_id";
    public static final String ZOOM_SERVICE_NOTIFICATION_CHANNEL_ID = "zoom_service_notification_channel_id";
    private static Ringtone s_ringtone;
    private static Handler s_handler;
    private static Runnable s_updateNotificationRunnable;
    private static long s_lastMessageNotificationTime;
    private static Map<String, Long> s_lastMessageSoundNotificationTimes;
    private static boolean isConfNotificatonShowed;

    private static boolean isAlertImMsgEnabled() {
        return PTSettingHelper.getShowChatMessageReminder() != 2;
    }

    public static synchronized void playNotificationSound(Context context) {
        long curTime = System.currentTimeMillis();
        if (curTime - s_lastMessageNotificationTime > 3000L || curTime < s_lastMessageNotificationTime) {
            NotificationMgr.playNotificationSoundImpl(context);
        }
        s_lastMessageNotificationTime = curTime;
    }

    private static synchronized void playNotificationSoundImpl(Context context) {
        if (context == null) {
            return;
        }
        if (!NotificationMgr.isAlertImMsgEnabled()) {
            return;
        }
        int ringerMode = 2;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            if (audioManager == null) {
                return;
            }
            ringerMode = audioManager.getRingerMode();
        }
        catch (Exception audioManager) {
            // empty catch block
        }
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        if (ringerMode == 2) {
            if (settingHelper.getPlayAlertSound()) {
                try {
                    Uri notification = RingtoneManager.getDefaultUri((int)2);
                    if (notification != null) {
                        if (s_ringtone != null && s_ringtone.isPlaying()) {
                            s_ringtone.stop();
                        }
                        if ((s_ringtone = RingtoneManager.getRingtone((Context)context, (Uri)notification)) != null) {
                            s_ringtone.setStreamType(5);
                            s_ringtone.play();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static synchronized void playNotificationVibrate(Context context) {
        long curTime = System.currentTimeMillis();
        if (curTime - s_lastMessageNotificationTime > 3000L || curTime < s_lastMessageNotificationTime) {
            NotificationMgr.playNotificationVibrateImpl(context);
        }
        s_lastMessageNotificationTime = curTime;
    }

    private static synchronized void playNotificationVibrateImpl(Context context) {
        block11: {
            Vibrator vib;
            block10: {
                if (context == null) {
                    return;
                }
                if (!NotificationMgr.isAlertImMsgEnabled()) {
                    return;
                }
                int ringerMode = 2;
                try {
                    AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                    if (audioManager == null) {
                        return;
                    }
                    ringerMode = audioManager.getRingerMode();
                }
                catch (Exception audioManager) {
                    // empty catch block
                }
                PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
                if (settingHelper == null) {
                    return;
                }
                if (ringerMode == 2) break block10;
                if (ringerMode != 1) break block11;
            }
            if (settingHelper.getPlayAlertVibrate() && (vib = (Vibrator)context.getSystemService("vibrator")) != null) {
                vib.vibrate(VIBRATES, -1);
            }
        }
    }

    public static synchronized void showMessageNotificationMM(Context context, boolean sound, String sessionJid) {
        if (context == null || StringUtil.isEmptyOrNull((String)sessionJid)) {
            return;
        }
        NotificationMgr.showMessageNotificationMMImpl(context, sound, sessionJid);
    }

    public static NotificationItem generateNotificationItem(Context context, int showStatus, int countOfUnreadMsg, String showName) {
        String title = context.getString(R.string.zm_system_notification_title);
        if (countOfUnreadMsg == 0) {
            return null;
        }
        if (countOfUnreadMsg > 1) {
            title = context.getResources().getQuantityString(R.plurals.zm_msg_notification_unread_num_8295, countOfUnreadMsg, new Object[]{title, countOfUnreadMsg});
        }
        if (StringUtil.isEmptyOrNull((String)showName)) {
            return null;
        }
        String content = "";
        switch (showStatus) {
            case 1: {
                content = context.getString(R.string.zm_session_contact_request_accept_byother, new Object[]{showName});
                break;
            }
            case 2: {
                content = context.getString(R.string.zm_session_contact_request_decline_byother, new Object[]{showName});
                break;
            }
            case 0: {
                content = context.getString(R.string.zm_session_recive_contact_request, new Object[]{showName});
                break;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)title) && !TextUtils.isEmpty((CharSequence)content)) {
            return new NotificationItem(title, content);
        }
        return null;
    }

    public static NotificationItem generateNotificationItem(Context context, int messageType, String senderName, String messageBody, int countOfUnreadMsg) {
        String title = "";
        String content = "";
        switch (messageType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: {
                title = senderName;
                content = messageBody;
            }
        }
        if (countOfUnreadMsg == 0) {
            return null;
        }
        if (countOfUnreadMsg > 1) {
            title = context.getResources().getQuantityString(R.plurals.zm_msg_notification_unread_num_8295, countOfUnreadMsg, new Object[]{title, countOfUnreadMsg});
        }
        if (!TextUtils.isEmpty((CharSequence)title) && !TextUtils.isEmpty((CharSequence)content)) {
            return new NotificationItem(title, content);
        }
        return null;
    }

    public static NotificationItem generateNotificationItem(Context context, boolean isGroup, boolean isE2EMessage, boolean atMe, boolean atALL, int messageType, String senderName, String groupName, String fileName, CharSequence msgBody, int countOfUnreadMsg) {
        CharSequence content = null;
        if (isE2EMessage) {
            content = isGroup ? context.getString(R.string.zm_msg_lbl_message_decrypt_group_31105) : context.getString(R.string.zm_msg_lbl_message_decrypt_31105);
        } else {
            switch (messageType) {
                case 0: {
                    if (!isGroup) {
                        content = msgBody;
                        break;
                    }
                    content = msgBody;
                    if (!atMe && !atALL) break;
                    String atMeStr = context.getString(atMe ? R.string.zm_mm_lbl_message_mentioned_me : R.string.zm_mm_lbl_message_mentioned_all);
                    SpannableString ss = new SpannableString(TextUtils.concat((CharSequence[])new CharSequence[]{atMeStr, " ", content}));
                    ForegroundColorSpan span = new ForegroundColorSpan(context.getResources().getColor(R.color.zm_im_mentioned));
                    ss.setSpan((Object)span, 0, atMeStr.length(), 33);
                    content = ss;
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 12: {
                    if (isGroup) {
                        content = context.getString(R.string.zm_mm_lbl_nos_message_picture_group_31105);
                        break;
                    }
                    content = context.getString(R.string.zm_mm_lbl_nos_message_picture_31105);
                    break;
                }
                case 2: {
                    if (isGroup) {
                        content = context.getString(R.string.zm_mm_lbl_nos_message_voice_group_31105);
                        break;
                    }
                    content = context.getString(R.string.zm_mm_lbl_nos_message_voice_31105);
                    break;
                }
                case 4: {
                    if (!isGroup) {
                        content = context.getString(R.string.zm_mm_lbl_message_meeting_invitation);
                        break;
                    }
                    content = senderName + ": " + context.getString(R.string.zm_mm_lbl_message_meeting_invitation);
                    break;
                }
                case 10: {
                    if (isGroup) {
                        content = context.getString(R.string.zm_mm_lbl_nos_message_file_group_31105);
                        break;
                    }
                    content = context.getString(R.string.zm_mm_lbl_nos_message_file_31105);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    content = msgBody;
                    GroupAction action = GroupAction.loadFromString(content == null ? null : content.toString());
                    if (action == null) break;
                    content = action.toMessage(context);
                    break;
                }
                case 71: {
                    content = context.getString(R.string.zm_msg_e2e_invite_accepted, new Object[]{senderName});
                    break;
                }
                case 70: {
                    content = context.getString(R.string.zm_msg_e2e_get_invite, new Object[]{senderName});
                    break;
                }
                case 88: {
                    content = msgBody;
                    break;
                }
                case 80: {
                    content = context.getString(R.string.zm_msg_delete_by_other_24679, new Object[]{senderName});
                    break;
                }
                case 11: 
                case 14: {
                    content = context.getString(R.string.zm_msg_webhoot_new_notification, new Object[]{senderName});
                    break;
                }
                case 13: {
                    if (isGroup) {
                        content = context.getString(R.string.zm_mm_lbl_nos_message_code_snippet_group_31945);
                        break;
                    }
                    content = context.getString(R.string.zm_mm_lbl_nos_message_code_snippet_31945);
                    break;
                }
            }
        }
        String title = "";
        title = isGroup ? senderName + " " + context.getString(R.string.zm_msg_notification_group_in_31105) + " " + groupName : senderName;
        if (countOfUnreadMsg == 0) {
            return null;
        }
        if (countOfUnreadMsg > 1) {
            title = context.getResources().getQuantityString(R.plurals.zm_msg_notification_unread_num_8295, countOfUnreadMsg, new Object[]{title, countOfUnreadMsg});
        }
        if (!TextUtils.isEmpty((CharSequence)title) && !TextUtils.isEmpty((CharSequence)content)) {
            return new NotificationItem(title, content);
        }
        return null;
    }

    private static synchronized void showMessageNotificationMMImpl(Context context, boolean sound, String sessionJid) {
        if (context == null) {
            return;
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            return;
        }
        if (!NotificationMgr.isAlertImMsgEnabled()) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        long time = 0L;
        int countOfUnreadMsg = 0;
        NotificationItem notificationItem = null;
        if ("######SYSTEM_NOTIFICATION_SESSION".equals(sessionJid)) {
            String showName;
            int count = messenger.getSubscribeRequestCount();
            if (count == 0) {
                return;
            }
            ZoomSubscribeRequest request = messenger.getSubscribeRequestAt(0);
            if (request == null) {
                return;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(request.getRequestJID());
            if (buddy == null) {
                return;
            }
            countOfUnreadMsg = messenger.getUnreadRequestCount();
            String string2 = showName = (buddy.isPending() || request.getRequestStatus() == 2) && request.getRequestType() != 0 ? buddy.getEmail() : buddy.getScreenName();
            if (StringUtil.isEmptyOrNull((String)showName)) {
                showName = buddy.getScreenName();
            }
            if (StringUtil.isEmptyOrNull((String)showName)) {
                return;
            }
            int showStatus = request.getRequestType() == 0 ? 0 : request.getRequestStatus();
            notificationItem = NotificationMgr.generateNotificationItem(context, showStatus, countOfUnreadMsg, showName);
        } else {
            ZoomChatSession session = messenger.getSessionById(sessionJid);
            if (session == null) {
                return;
            }
            ZoomMessage message = session.getLastMessage();
            if (message == null) {
                return;
            }
            time = message.getStamp();
            boolean isGroup = session.isGroup();
            String senderName = message.getSenderName();
            if (TextUtils.isEmpty((CharSequence)senderName)) {
                ZoomBuddy buddy = messenger.getBuddyWithJID(message.getSenderID());
                if (buddy == null) {
                    return;
                }
                senderName = BuddyNameUtil.getBuddyDisplayName(buddy, null);
            }
            boolean isAtMe = session.hasUnreadMessageAtMe();
            boolean isAtAll = session.hasUnreadedMessageAtAllMembers();
            boolean isE2EMessage = message.isE2EMessage();
            countOfUnreadMsg = session.getUnreadMessageCount();
            String fileName = "";
            CharSequence msgBody = null;
            String groupName = "";
            ZoomMessage.FileInfo fileInfo = message.getFileInfo();
            if (fileInfo != null) {
                fileName = fileInfo.name;
            }
            if (countOfUnreadMsg == 0) {
                return;
            }
            switch (message.getMessageType()) {
                case 0: {
                    msgBody = message.getBodyWithShortcut();
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    msgBody = message.getBody();
                    break;
                }
                case 88: {
                    msgBody = message.getBody();
                    break;
                }
            }
            if (isGroup) {
                groupName = session.getSessionGroup().getGroupDisplayName((Context)VideoBoxApplication.getInstance());
            }
            notificationItem = NotificationMgr.generateNotificationItem(context, isGroup, isE2EMessage, isAtMe, isAtAll, message.getMessageType(), senderName, groupName, fileName, msgBody, countOfUnreadMsg);
        }
        NotificationMgr.showMessageNotificationMMImpl(context, sound, time, countOfUnreadMsg, sessionJid, notificationItem);
    }

    public static synchronized void showMessageNotificationMMImpl(Context context, boolean sound, long time, int countOfUnreadMsg, String sessionJid, NotificationItem notificationItem) {
        if (context == null || notificationItem == null || TextUtils.isEmpty((CharSequence)sessionJid)) {
            return;
        }
        NotificationManager notificationMgr = (NotificationManager)context.getSystemService("notification");
        Intent clickIntent = new Intent(context, IntegrationActivity.class);
        clickIntent.setAction(IntegrationActivity.ACTION_SHOW_UNREAD_MESSAGE_MM);
        clickIntent.putExtra("unreadMsgSession", sessionJid);
        clickIntent.setFlags(0x10000000);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)(10000 + sessionJid.hashCode()), (Intent)clickIntent, (int)0x10000000);
        int color2 = context.getResources().getColor(R.color.zm_notification_icon_bg);
        int smallIcon = R.drawable.zm_unread_message;
        if (Build.VERSION.SDK_INT >= 21) {
            smallIcon = R.drawable.zm_unread_message_5_0;
        }
        Bitmap largeIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.zm_launcher);
        NotificationCompat.Builder builder = NotificationMgr.getNotificationCompatBuilder(context).setWhen(time).setSmallIcon(smallIcon).setColor(color2).setContentTitle((CharSequence)notificationItem.getTitle()).setContentText(notificationItem.getContent()).setContentIntent(contentIntent).setVisibility(1).setTicker((CharSequence)(context.getResources().getString(R.string.zm_lbl_message_notifications_19898) + "\n" + notificationItem.getTitle() + "\n" + notificationItem.getContent())).setAutoCancel(true);
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setPriority(1);
        }
        long curTime = System.currentTimeMillis();
        Long lastSound = s_lastMessageSoundNotificationTimes.get(sessionJid);
        if ((lastSound == null || curTime - lastSound > 5000L || curTime < lastSound) && sound) {
            if (PTSettingHelper.getPlayAlertSound()) {
                builder.setDefaults(5);
            }
            if (PTSettingHelper.getPlayAlertVibrate()) {
                builder.setVibrate(VIBRATES);
            }
        }
        s_lastMessageSoundNotificationTimes.put(sessionJid, curTime);
        if (Build.VERSION.SDK_INT >= 21 && context.getResources().getBoolean(R.bool.zm_config_show_large_icon_in_notification_on_api21_above)) {
            builder.setLargeIcon(largeIcon);
        }
        Notification notification = builder.build();
        UIUtil.setNotificationMessageCount((Notification)notification, (int)countOfUnreadMsg);
        if (notificationMgr != null) {
            try {
                notificationMgr.notify(10000 + sessionJid.hashCode(), notification);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized void showMessageNotificationMM(Context context, boolean sound) {
        if (context == null) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (curTime - s_lastMessageNotificationTime > 3000L || curTime < s_lastMessageNotificationTime) {
            NotificationMgr.showMessageNotificationMMImpl(context, sound);
        }
        s_lastMessageNotificationTime = curTime;
    }

    public static void nosCallNotificationImpl(final Context context, int messageType, String callBody) {
        if (context == null) {
            return;
        }
        NotificationManager notificationMgr = (NotificationManager)context.getSystemService("notification");
        Intent clickIntent = new Intent(context, LauncherActivity.class);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)clickIntent, (int)0x10000000);
        Intent broadcastIntent = new Intent(context, NosCallActionRceiver.class);
        broadcastIntent.setAction(ZOOM_NOS_CALL_CANCEL_ACTION);
        PendingIntent cancelIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)broadcastIntent, (int)0x10000000);
        Intent broadcastIntent2 = new Intent(context, NosCallActionRceiver.class);
        broadcastIntent2.setAction(ZOOM_NOS_CALL_ACCEPT_ACTION);
        broadcastIntent2.putExtra(KEY_NOS_CALL_MESSAGE_TYPE, messageType);
        broadcastIntent2.putExtra(KEY_NOS_CALL_MESSAGE_BODY, callBody);
        PendingIntent acceptIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)broadcastIntent2, (int)0x10000000);
        String contentTitle = context.getString(R.string.zm_app_name);
        String contentText = context.getString(R.string.zm_msg_chat_notification);
        int color2 = context.getResources().getColor(R.color.zm_notification_icon_bg);
        int smallIcon = R.drawable.zm_unread_message;
        if (Build.VERSION.SDK_INT >= 21) {
            smallIcon = R.drawable.zm_unread_message_5_0;
        }
        Bitmap largeIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.zm_launcher);
        NotificationCompat.Builder builder = NotificationMgr.getNotificationCompatBuilder(context).setWhen(0L).setSmallIcon(smallIcon).setColor(color2).setVisibility(1).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setContentIntent(contentIntent).setFullScreenIntent(contentIntent, true).addAction(R.drawable.zm_mm_delete_btn_pressed, (CharSequence)"accept", acceptIntent).addAction(R.drawable.zm_voice_rcd_cancel_icon, (CharSequence)"cancel", cancelIntent).setAutoCancel(true);
        builder.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + "/" + R.raw.ring_original)));
        builder.setVibrate(CALLING_VIBRATES);
        if (Build.VERSION.SDK_INT >= 21 && context.getResources().getBoolean(R.bool.zm_config_show_large_icon_in_notification_on_api21_above)) {
            builder.setLargeIcon(largeIcon);
        }
        Notification notification = builder.build();
        notification.flags |= 4;
        if (notificationMgr != null) {
            try {
                notificationMgr.notify(8, notification);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationMgr.removeNosCallNotification(context);
                    }
                });
            }
        }, 60000L);
    }

    public static void removeNosCallNotification(Context context) {
        if (context == null) {
            return;
        }
        NotificationManager notificationMgr = (NotificationManager)context.getSystemService("notification");
        if (notificationMgr != null) {
            try {
                notificationMgr.cancel(8);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void showMessageNotificationMMImpl(Context context, boolean sound) {
        IMHelper imHelper;
        if (context == null) {
            return;
        }
        if (VideoBoxApplication.getInstance() != null && VideoBoxApplication.getInstance().isSDKMode()) {
            return;
        }
        if (!NotificationMgr.isAlertImMsgEnabled()) {
            return;
        }
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        NotificationManager notificationMgr = (NotificationManager)context.getSystemService("notification");
        Intent clickIntent = new Intent(context, IntegrationActivity.class);
        clickIntent.setAction(IntegrationActivity.ACTION_SHOW_UNREAD_MESSAGE_MM);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)clickIntent, (int)0x10000000);
        int countOfZoomMessenger = 0;
        int countOfThirdPartyIM = 0;
        int countOfSystemNotification = 0;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            countOfZoomMessenger = messenger.getTotalUnreadMessageCount();
            countOfSystemNotification = messenger.getUnreadRequestCount();
        }
        if ((imHelper = PTApp.getInstance().getIMHelper()) != null) {
            countOfThirdPartyIM = imHelper.getUnreadMsgCount();
        }
        int countAll = countOfZoomMessenger + countOfThirdPartyIM + countOfSystemNotification;
        String contentTitle = context.getString(R.string.zm_app_name);
        String contentText = context.getString(R.string.zm_msg_chat_notification);
        int color2 = context.getResources().getColor(R.color.zm_notification_icon_bg);
        int smallIcon = R.drawable.zm_unread_message;
        if (Build.VERSION.SDK_INT >= 21) {
            smallIcon = R.drawable.zm_unread_message_5_0;
        }
        Bitmap largeIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.zm_launcher);
        NotificationCompat.Builder builder = NotificationMgr.getNotificationCompatBuilder(context).setWhen(0L).setSmallIcon(smallIcon).setColor(color2).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setContentIntent(contentIntent).setAutoCancel(true);
        if (sound) {
            if (settingHelper.getPlayAlertSound()) {
                builder.setDefaults(5);
            }
            if (settingHelper.getPlayAlertVibrate()) {
                builder.setVibrate(VIBRATES);
            }
        }
        if (Build.VERSION.SDK_INT >= 21 && context.getResources().getBoolean(R.bool.zm_config_show_large_icon_in_notification_on_api21_above)) {
            builder.setLargeIcon(largeIcon);
        }
        Notification notification = builder.build();
        UIUtil.setNotificationMessageCount((Notification)notification, (int)countAll);
        if (notificationMgr != null) {
            try {
                notificationMgr.notify(7, notification);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void removeMessageNotificationMM(Context context, String sessionId) {
        if (context == null || StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        NotificationManager notificationMgr = (NotificationManager)context.getSystemService("notification");
        if (notificationMgr != null) {
            try {
                notificationMgr.cancel(10000 + sessionId.hashCode());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void removeAllMessageNotificationMM(Context context) {
        if (context == null) {
            return;
        }
        NotificationManager notificationMgr = (NotificationManager)context.getSystemService("notification");
        if (notificationMgr != null) {
            try {
                notificationMgr.cancelAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void removeMessageNotificationMM(Context context) {
        NotificationManager notificationMgr;
        if (context == null) {
            return;
        }
        if (s_updateNotificationRunnable != null) {
            s_handler.removeCallbacks(s_updateNotificationRunnable);
        }
        if ((notificationMgr = (NotificationManager)context.getSystemService("notification")) != null) {
            try {
                notificationMgr.cancel(7);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void showConfNotification(Context context) {
        if (context == null) {
            return;
        }
        if (!isConfNotificatonShowed) {
            isConfNotificatonShowed = true;
            ZMServiceHelper.doServiceActionInFront(PTService.ACTION_SHOW_CONF_NOTIFICATION, PTService.class);
        }
    }

    public static void removeConfNotification(Context context) {
        if (context == null) {
            return;
        }
        ZMServiceHelper.doServiceAction(PTService.ACTION_REMOVE_CONF_NOTIFICATION, PTService.class);
        isConfNotificatonShowed = false;
    }

    public static void showSipNotification(Context context) {
        if (context == null) {
            return;
        }
        ZMServiceHelper.doServiceAction(PTService.ACTION_SHOW_SIP_NOTIFICATION, PTService.class);
    }

    public static void removeSipNotification(Context context) {
        if (context == null) {
            return;
        }
        ZMServiceHelper.doServiceAction(PTService.ACTION_REMOVE_SIP_NOTIFICATION, PTService.class);
    }

    public static void showLoginExpiredNotification(Context context, int loginType) {
        if (context == null) {
            return;
        }
        NotificationManager notificationMgr = (NotificationManager)context.getSystemService("notification");
        Intent clickIntent = new Intent(context, IntegrationActivity.class);
        clickIntent.setAction(IntegrationActivity.ACTION_LOGIN_EXPIRED);
        clickIntent.putExtra("loginType", loginType);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)clickIntent, (int)0x10000000);
        String contentTitle = context.getString(R.string.zm_app_name);
        String contentText = context.getString(R.string.zm_msg_login_expired);
        int smallIcon = 17301543;
        Notification notification = NotificationMgr.getNotificationCompatBuilder(context).setWhen(0L).setSmallIcon(smallIcon).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setContentIntent(contentIntent).setAutoCancel(true).build();
        if (notificationMgr != null) {
            try {
                notificationMgr.notify(5, notification);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void removeLoginExpiredNotificaiton(Context context) {
        if (context == null) {
            return;
        }
        NotificationManager notificationMgr = (NotificationManager)context.getSystemService("notification");
        if (notificationMgr != null) {
            try {
                notificationMgr.cancel(5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean areNotificationsEnabled(Context context) {
        NotificationManagerCompat mgr = NotificationManagerCompat.from((Context)context);
        return mgr.areNotificationsEnabled();
    }

    public static NotificationCompat.Builder getNotificationCompatBuilder(Context context) {
        return NotificationMgr.getNotificationCompatBuilder(context, true);
    }

    public static NotificationCompat.Builder getNotificationCompatBuilder(Context context, boolean isHighImportance) {
        NotificationCompat.Builder builder = null;
        NotificationManager notificationMgr = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel(ZOOM_NOTIFICATION_CHANNEL_ID, (CharSequence)context.getResources().getString(R.string.zm_notification_channel_name), isHighImportance ? 4 : 3);
            if (notificationChannel.canShowBadge()) {
                notificationChannel.setShowBadge(false);
            }
            if (notificationMgr != null) {
                notificationMgr.createNotificationChannel(notificationChannel);
            }
            builder = new NotificationCompat.Builder(context, ZOOM_NOTIFICATION_CHANNEL_ID);
        } else {
            builder = new NotificationCompat.Builder(context);
        }
        return builder;
    }

    public static String getServiceNotificationChannelName(Context context) {
        if (context == null) {
            return "";
        }
        return context.getResources().getString(R.string.zm_service_notification_channel_name);
    }

    static {
        s_handler = new Handler(Looper.getMainLooper());
        s_updateNotificationRunnable = null;
        s_lastMessageNotificationTime = 0L;
        s_lastMessageSoundNotificationTimes = new HashMap<String, Long>();
        isConfNotificatonShowed = false;
    }

    public static class NotificationItem {
        private String title;
        private CharSequence content;

        public NotificationItem(String title, CharSequence content) {
            this.title = title;
            this.content = content;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public CharSequence getContent() {
            return this.content;
        }

        public void setContent(CharSequence content) {
            this.content = content;
        }
    }
}

