/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import java.util.HashMap;
import java.util.LinkedList;

public class MemCache<Key, Value> {
    private LinkedList<Key> mKeyList = new LinkedList();
    private HashMap<Key, Value> mCacheMap = new HashMap();
    private int mCacheSize = 0;

    public MemCache(int cacheSize) {
        this.mCacheSize = cacheSize;
    }

    public void cacheItem(Key key, Value value) {
        Key first;
        this.mKeyList.remove(key);
        this.mCacheMap.put(key, value);
        this.mKeyList.add(key);
        if (this.mKeyList.size() > this.mCacheSize && (first = this.mKeyList.removeFirst()) != null) {
            this.mCacheMap.remove(first);
        }
    }

    public void removeItem(Key key) {
        this.mKeyList.remove(key);
        this.mCacheMap.remove(key);
    }

    public Value getCachedItem(Key key) {
        Value item = this.mCacheMap.get(key);
        if (item != null) {
            this.mKeyList.remove(key);
            this.mKeyList.add(key);
        }
        return item;
    }

    public void clear() {
        this.mKeyList.clear();
        this.mCacheMap.clear();
    }
}

