/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.text.Editable;
import com.zipow.videobox.confapp.meeting.SelectAlterHostItem;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.MMSelectContactsListItemSpan;
import com.zipow.videobox.view.mm.MMSelectContactsListItem;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMEditText;

public class MMLocalHelper {
    public static int getMMSelectContactsListItemSpanCount(ZMEditText zmEditText) {
        Editable editable = zmEditText.getText();
        if (editable == null) {
            return 0;
        }
        MMSelectContactsListItemSpan[] spans = (MMSelectContactsListItemSpan[])editable.getSpans(0, editable.length(), MMSelectContactsListItemSpan.class);
        return spans == null ? 0 : spans.length;
    }

    public static void onSelected(Context context, ZMEditText zmEditText, boolean selected, MMSelectContactsListItem item) {
        if (item == null || context == null) {
            return;
        }
        Editable editable = zmEditText.getText();
        MMSelectContactsListItemSpan[] spans = (MMSelectContactsListItemSpan[])editable.getSpans(0, editable.length(), MMSelectContactsListItemSpan.class);
        MMSelectContactsListItemSpan itemSpan = null;
        for (MMSelectContactsListItemSpan span : spans) {
            MMSelectContactsListItem item1 = span.getItem();
            if (item1 == null || !MMLocalHelper.isSameMMSelectContactsListItem(item1.isAlternativeHost(), item1, item)) continue;
            itemSpan = span;
            break;
        }
        if (selected) {
            if (itemSpan != null) {
                itemSpan.setItem(item);
                return;
            }
            int count = spans.length;
            if (count > 0) {
                int length;
                MMSelectContactsListItemSpan lastSpan = spans[count - 1];
                int lastSpanEnd = editable.getSpanEnd((Object)lastSpan);
                if (lastSpanEnd < (length = editable.length())) {
                    editable.delete(lastSpanEnd, length);
                }
            } else {
                editable.clear();
            }
            itemSpan = new MMSelectContactsListItemSpan(context, item);
            itemSpan.setInterval(UIUtil.dip2px((Context)context, (float)2.0f));
            String name = item.getScreenName();
            int start = editable.length();
            int end = start + name.length();
            editable.append((CharSequence)item.getScreenName());
            editable.setSpan((Object)itemSpan, start, end, 33);
            zmEditText.setSelection(end);
            zmEditText.setCursorVisible(true);
        } else {
            if (itemSpan == null) {
                return;
            }
            int start = editable.getSpanStart((Object)itemSpan);
            int end = editable.getSpanEnd((Object)itemSpan);
            if (start >= 0 && end >= 0 && end >= start) {
                editable.delete(start, end);
                editable.removeSpan((Object)itemSpan);
            }
        }
    }

    public static boolean searchBuddyByKey(String key) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isConnectionGood()) {
            return false;
        }
        return messenger.searchBuddyByKey(key);
    }

    public static ZoomMessenger getGoodConnectedZoomMessenger() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isConnectionGood()) {
            return null;
        }
        return messenger;
    }

    public static MMSelectContactsListItem transformSelectAlterHostToMMSelectContactsListItem(SelectAlterHostItem selectAlterHostItem) {
        IMAddrBookItem item = new IMAddrBookItem();
        item.setAccoutEmail(selectAlterHostItem.getEmail());
        item.setPmi(selectAlterHostItem.getPmi());
        item.setScreenName(selectAlterHostItem.getScreenName());
        item.setJid(selectAlterHostItem.getHostID());
        MMSelectContactsListItem buddyItem = new MMSelectContactsListItem(item);
        if (StringUtil.isEmptyOrNull((String)item.getAccountEmail())) {
            item.setAccoutEmail(selectAlterHostItem.getEmail());
        }
        if (StringUtil.isEmptyOrNull((String)item.getScreenName())) {
            item.setScreenName(selectAlterHostItem.getScreenName());
        }
        if (StringUtil.isEmptyOrNull((String)buddyItem.getEmail())) {
            buddyItem.setEmail(selectAlterHostItem.getEmail());
        }
        if (StringUtil.isEmptyOrNull((String)buddyItem.getScreenName())) {
            buddyItem.setScreenName(selectAlterHostItem.getScreenName());
        }
        buddyItem.setIsDisabled(false);
        buddyItem.setIsChecked(true);
        buddyItem.setAlternativeHost(true);
        return buddyItem;
    }

    public static MMSelectContactsListItem transformEmailToMMSelectContactsListItem(String email) {
        IMAddrBookItem item = new IMAddrBookItem();
        item.setAccoutEmail(email);
        MMSelectContactsListItem buddyItem = new MMSelectContactsListItem(item);
        if (StringUtil.isEmptyOrNull((String)item.getAccountEmail())) {
            item.setAccoutEmail(email);
        }
        if (StringUtil.isEmptyOrNull((String)item.getScreenName())) {
            item.setScreenName(email);
        }
        if (StringUtil.isEmptyOrNull((String)buddyItem.getEmail())) {
            buddyItem.setEmail(email);
        }
        if (StringUtil.isEmptyOrNull((String)buddyItem.getScreenName())) {
            buddyItem.setScreenName(email);
        }
        buddyItem.setIsDisabled(false);
        buddyItem.setIsChecked(true);
        buddyItem.setAlternativeHost(true);
        return buddyItem;
    }

    public static boolean isSameMMSelectContactsListItem(boolean isAlterHost, MMSelectContactsListItem item1, MMSelectContactsListItem item2) {
        if (isAlterHost) {
            return StringUtil.isSameStringForNotAllowNull((String)item1.getBuddyJid(), (String)item2.getBuddyJid()) || StringUtil.isSameStringForNotAllowNull((String)item1.getEmail(), (String)item2.getEmail());
        }
        return StringUtil.isSameStringForNotAllowNull((String)item1.getBuddyJid(), (String)item2.getBuddyJid());
    }
}

