/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import com.zipow.videobox.LoginActivity;
import java.lang.reflect.Method;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;
import us.zoom.videomeetings.ZMBuildConfig;

public class LoginUtil {
    private static final String TAG = LoginUtil.class.getSimpleName();

    public static boolean showLoginUI(Context context, boolean autoLogin, int vendor) {
        if (ResourcesUtil.getBoolean((Context)context, (int)R.bool.zm_config_use_zoom_login, (boolean)true)) {
            return LoginActivity.show(context, autoLogin, vendor);
        }
        String activityClass = ResourcesUtil.getString((Context)context, (int)R.string.zm_config_login_activity);
        if (!StringUtil.isEmptyOrNull((String)activityClass)) {
            return LoginUtil.showLoginActivity(context, activityClass);
        }
        return false;
    }

    private static boolean showLoginActivity(Context context, String activityClass) {
        try {
            Class<?> clazz = Class.forName(activityClass);
            Method method = clazz.getMethod("show", Context.class);
            return (Boolean)method.invoke(null, context);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getDefaultVendor() {
        if (ZMBuildConfig.BUILD_TARGET != 0) {
            return 0;
        }
        if (Locale.CHINA.getCountry().equalsIgnoreCase(CompatUtils.getLocalDefault().getCountry())) {
            return 1;
        }
        return 0;
    }
}

