/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.os.Build;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.SystemInfoHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import us.zoom.androidlib.util.StringUtil;

public class LogUtil {
    private static final String TAG = LogUtil.class.getSimpleName();
    public static final String CRASH_LOG_PREFIX = "crash-";
    public static final String CRASH_LOG_SUFIX = ".log";
    public static final String FREEZE_LOG_PREFIX = "freeze-";
    public static final String FREEZE_LOG_SUFIX = ".log";
    public static final int MAX_CRASH_LOG_COUNT = 5;
    public static final int MAX_FREEZE_LOG_COUNT = 5;
    private static final String JAVA_CRASH_PREFIX = "crash-java-";
    private static final String OLD_NATIVE_CRASH_PREFIX = "crash-native-";
    private static final String NEW_NATIVE_CRASH_PREFIX = "crash-native-zmdump-";
    private static final String KEY_VERSION = "version:";
    private static final int CRASH_TYPE_JAVA = 0;
    private static final int CRASH_TYPE_NATIVE_OLD = 1;
    private static final int CRASH_TYPE_NATIVE_NEW = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeCrashLogToFile(String prefix, String sufix, int maxLogFileCount, long time, String meetingInfo, String memInfo, boolean isBAASecurityEnabled, byte[] data) {
        File logFile = LogUtil.getNewLogFile(prefix, sufix, maxLogFileCount, time);
        if (logFile == null) {
            return null;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(logFile);
            PrintStream os = new PrintStream(fos);
            os.println(KEY_VERSION + VideoBoxApplication.getInstance().getVersionName());
            os.println("Kernel Version: " + VideoBoxApplication.getInstance().getKernelVersion());
            os.println("OS:" + SystemInfoHelper.getOSInfo());
            if (!isBAASecurityEnabled) {
                os.println("Hardware:" + SystemInfoHelper.getHardwareInfo());
            }
            if (memInfo != null) {
                os.println(memInfo);
            }
            if (!isBAASecurityEnabled && meetingInfo != null) {
                os.println(meetingInfo);
            }
            os.println();
            os.println("*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***");
            os.write(data);
            os.flush();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        return logFile;
    }

    public static String getLogFolder() {
        String dir = AppUtil.getLogParentPath() + "/logs";
        File file = new File(dir);
        boolean flag = false;
        try {
            flag = !file.exists() ? file.mkdirs() : true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag ? dir : null;
    }

    public static String getDeviceInfo() {
        String version = VideoBoxApplication.getInstance().getKernelVersion();
        String device = Build.MANUFACTURER + "-" + Build.MODEL;
        String signature = VideoBoxApplication.getInstance().isValidSignature() ? "" : "resigned-";
        return version + "-" + signature + device;
    }

    public static File getNewLogFile(final String prefix, final String sufix, int maxLogFileCount, long time) {
        if (prefix == null || sufix == null) {
            return null;
        }
        String dir = LogUtil.getLogFolder();
        if (dir == null) {
            return null;
        }
        File fDir = new File(dir);
        if (!fDir.exists() && !fDir.mkdirs()) {
            return null;
        }
        LogUtil.removeOldestLogFiles(maxLogFileCount, fDir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName();
                return fileName.startsWith(prefix) && (fileName.endsWith(sufix) || fileName.endsWith(sufix + ".sent"));
            }
        });
        String version = VideoBoxApplication.getInstance().getKernelVersion();
        String device = Build.MANUFACTURER + "-" + Build.MODEL;
        String signature = VideoBoxApplication.getInstance().isValidSignature() ? "" : "resigned-";
        String fileName = dir + File.separator + prefix + version + "-" + signature + device + "-" + new SimpleDateFormat("yyyy-MMdd-HHmmss", Locale.US).format(new Date(time)) + sufix;
        return new File(fileName);
    }

    public static void removeOldestLogFiles(int maxCount, File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files == null || files.length <= maxCount) {
            return;
        }
        for (int count = files.length; count > maxCount; --count) {
            int indexOldest = 0;
            File fileOldest = files[0];
            for (int i = 1; i < files.length; ++i) {
                if (fileOldest == null) {
                    fileOldest = files[i];
                    indexOldest = i;
                    continue;
                }
                if (files[i] == null || fileOldest.lastModified() <= files[i].lastModified()) continue;
                fileOldest = files[i];
                indexOldest = i;
            }
            files[indexOldest] = null;
            if (fileOldest == null) continue;
            fileOldest.delete();
        }
    }

    public static boolean isSameCrashReported(String logsDir, final File crashFile, final String prefix) {
        File[] files;
        if (crashFile == null || logsDir == null || prefix == null) {
            return false;
        }
        CrashInfo crashInfo = LogUtil.loadCrashInfo(crashFile);
        File fDir = new File(logsDir);
        if (fDir.exists() && (files = fDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.equals(crashFile)) {
                    return false;
                }
                String fileName = pathname.getName();
                return fileName.startsWith(prefix);
            }
        })).length > 0) {
            for (int i = 0; i < files.length; ++i) {
                CrashInfo info = LogUtil.loadCrashInfo(files[i]);
                if (!LogUtil.isSameCrashInfo(crashInfo, info)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSameCrashInfo(CrashInfo info1, CrashInfo info2) {
        if (info1 == null || info2 == null) {
            return false;
        }
        return info1.equals(info2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrashInfo loadCrashInfo(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        int crashType = -1;
        String name = file.getName();
        if (name.contains(JAVA_CRASH_PREFIX)) {
            crashType = 0;
        } else if (name.contains(NEW_NATIVE_CRASH_PREFIX)) {
            crashType = 2;
        } else if (name.contains(OLD_NATIVE_CRASH_PREFIX)) {
            crashType = 1;
        }
        if (crashType < 0) {
            return null;
        }
        CrashInfo crashInfo = new CrashInfo();
        crashInfo.crashType = crashType;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            boolean findVersion = false;
            boolean stackBegin = false;
            while ((line = reader.readLine()) != null) {
                if (!findVersion) {
                    if (!line.startsWith(KEY_VERSION)) continue;
                    crashInfo.version = line.substring(KEY_VERSION.length()).trim();
                    findVersion = true;
                    continue;
                }
                if (!stackBegin) {
                    if (!LogUtil.isStackBegin(crashType, line)) continue;
                    stackBegin = true;
                    if (crashType == 0) continue;
                    crashInfo.stackTrace = crashInfo.stackTrace + LogUtil.parseStackTraceLine(crashType, line) + "\n";
                    continue;
                }
                if (LogUtil.isStackEnd(crashType, line)) {
                    break;
                }
                if (crashType == 0 && line.startsWith("Caused by:")) {
                    crashInfo.stackTrace = "";
                }
                crashInfo.stackTrace = crashInfo.stackTrace + LogUtil.parseStackTraceLine(crashType, line) + "\n";
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return crashInfo;
    }

    private static boolean isStackBegin(int crashType, String line) {
        switch (crashType) {
            case 0: {
                if (line.length() != 0) break;
                return true;
            }
            case 1: 
            case 2: {
                if (!line.matches(".+#00  pc .+")) break;
                return true;
            }
        }
        return false;
    }

    private static boolean isStackEnd(int crashType, String line) {
        switch (crashType) {
            case 0: {
                if (line.length() != 0 && !line.startsWith("frag")) break;
                return true;
            }
            case 1: {
                if (line.length() == 0) {
                    return true;
                }
                if (!line.endsWith(" I DEBUG   : ")) break;
                return true;
            }
            case 2: {
                if (line.length() != 0) break;
                return true;
            }
        }
        return false;
    }

    private static String parseStackTraceLine(int crashType, String line) {
        switch (crashType) {
            case 0: {
                return line;
            }
            case 1: 
            case 2: {
                int from = line.indexOf(35);
                if (from < 0) break;
                return line.substring(from);
            }
        }
        return "";
    }

    public static class CrashInfo {
        public int crashType = -1;
        public String version = "";
        public String stackTrace = "";

        public boolean equals(Object o) {
            if (!(o instanceof CrashInfo)) {
                return false;
            }
            CrashInfo info = (CrashInfo)o;
            return info.crashType == this.crashType && StringUtil.isSameString((String)info.version, (String)this.version) && StringUtil.isSameString((String)info.stackTrace, (String)this.stackTrace);
        }
    }
}

