/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.zipow.videobox.util.ZMBitmapFactory;

public class LazyLoadDrawable
extends Drawable {
    private final String TAG = LazyLoadDrawable.class.getSimpleName();
    private String mImagePath;
    private Bitmap mBitmap;
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private int mAlpha = -1;
    private ColorFilter mColorFilter;
    private boolean mbValid = false;
    private int mMaxArea;
    private int safeMaxArea = 0xA00000;

    public LazyLoadDrawable(String imagePath) {
        this(imagePath, 0);
    }

    public LazyLoadDrawable(String imagePath, int maxArea) {
        if (imagePath == null) {
            return;
        }
        this.mImagePath = imagePath;
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeFile((String)this.mImagePath, (BitmapFactory.Options)o);
        }
        catch (Exception e) {
            return;
        }
        this.mIntrinsicWidth = o.outWidth;
        this.mIntrinsicHeight = o.outHeight;
        this.mbValid = this.mIntrinsicWidth > 0 && this.mIntrinsicHeight > 0;
        this.mMaxArea = maxArea;
    }

    public void setMaxArea(int maxArea) {
        this.mMaxArea = maxArea;
    }

    public boolean isValidDrawable() {
        return this.mbValid;
    }

    public int getIntrinsicWidth() {
        if (this.mBitmap != null) {
            return this.mBitmap.getWidth();
        }
        return this.mIntrinsicWidth;
    }

    public int getIntrinsicHeight() {
        if (this.mBitmap != null) {
            return this.mBitmap.getHeight();
        }
        return this.mIntrinsicHeight;
    }

    public void draw(Canvas canvas) {
        if (this.mBitmap == null || this.mBitmap.isRecycled()) {
            this.mBitmap = this.mMaxArea <= 0 ? ZMBitmapFactory.decodeFile(this.mImagePath) : ZMBitmapFactory.decodeFile(this.mImagePath, this.mMaxArea);
        }
        if (this.mBitmap == null) {
            return;
        }
        Rect bounds = this.getBounds();
        Paint paint = new Paint();
        if (this.mAlpha >= 0 && this.mAlpha <= 255) {
            paint.setAlpha(this.mAlpha);
        }
        if (this.mColorFilter != null) {
            paint.setColorFilter(this.mColorFilter);
        }
        while (true) {
            try {
                canvas.drawBitmap(this.mBitmap, new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight()), bounds, paint);
            }
            catch (Exception e) {
                if (this.safeMaxArea <= 1) break;
                if (this.mBitmap.getAllocationByteCount() < this.safeMaxArea) {
                    this.safeMaxArea = this.mBitmap.getAllocationByteCount() / 2;
                }
                this.mBitmap = ZMBitmapFactory.decodeFile(this.mImagePath, this.safeMaxArea);
                this.safeMaxArea /= 2;
                continue;
            }
            break;
        }
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
    }

    public int getOpacity() {
        return 0;
    }
}

