/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.text.TextUtils;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.GroupAvatarDrawable;
import com.zipow.videobox.util.ZMBitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.StringUtil;

public class ImageUtil {
    private static final String TAG = ImageUtil.class.getSimpleName();

    public static String getNewFilePathForTakingPhoto() {
        File dir = ImageUtil.getZoomGalleryPath();
        if (dir != null) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (dir.exists()) {
                Date time = new Date();
                SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US);
                String fileName = formater.format(time);
                String path = dir.getAbsolutePath() + File.separator + fileName + ".jpg";
                int index = 1;
                while (new File(path).exists()) {
                    path = dir.getAbsolutePath() + File.separator + fileName + "(" + ++index + ").jpg";
                }
                return path;
            }
        }
        return AppUtil.getTempPath() + "/capture.jpg";
    }

    public static File getZoomGalleryPath() {
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        if (dir != null && !(dir = new File(dir.getAbsolutePath() + "/zoom.us")).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static boolean translateImageAsSmallJpeg(Context context, Uri imageUri, int maxWidthHeight, String outFile) throws FileNotFoundException {
        return ImageUtil.translateImageAsSmallJpeg(context, imageUri, maxWidthHeight, false, outFile);
    }

    public static boolean translateImageAsSmallJpegInArea(Context context, Uri imageUri, int maxArea, String outFile) throws FileNotFoundException {
        return ImageUtil.translateImageAsSmallJpegInArea(context, imageUri, maxArea, false, outFile);
    }

    public static boolean translateImageAsSmallJpeg(Context context, Uri imageUri, int maxWidthHeight, boolean cropCenter, String outFile) throws FileNotFoundException {
        if (outFile == null) {
            return false;
        }
        return ImageUtil.translateImageAsSmallJpeg(context, imageUri, maxWidthHeight, cropCenter, new FileOutputStream(outFile));
    }

    public static boolean translateImageAsSmallJpegInArea(Context context, Uri imageUri, int maxArea, boolean cropCenter, String outFile) throws FileNotFoundException {
        if (outFile == null) {
            return false;
        }
        return ImageUtil.translateImageAsSmallJpegInArea(context, imageUri, maxArea, cropCenter, new FileOutputStream(outFile));
    }

    public static boolean translateImageAsSmallPngInArea(Context context, Uri imageUri, int maxArea, String outFile) throws FileNotFoundException {
        return ImageUtil.translateImageAsSmallPngInArea(context, imageUri, maxArea, false, outFile);
    }

    public static boolean translateImageAsSmallPngInArea(Context context, Uri imageUri, int maxArea, boolean cropCenter, String outFile) throws FileNotFoundException {
        if (outFile == null) {
            return false;
        }
        return ImageUtil.translateImageAsSmallPngInArea(context, imageUri, maxArea, cropCenter, new FileOutputStream(outFile));
    }

    public static boolean translateImageAsSmallJpeg(Context context, Uri imageUri, int maxWidthHeight, boolean cropCenter, OutputStream stream) {
        if (context == null || imageUri == null || stream == null) {
            return false;
        }
        if (maxWidthHeight <= 0) {
            return false;
        }
        try {
            Bitmap bitmap = ImageUtil.translateImageAsSmallBitmap(context, imageUri, maxWidthHeight, false, cropCenter);
            if (bitmap == null) {
                return false;
            }
            boolean res = bitmap.compress(Bitmap.CompressFormat.JPEG, 60, stream);
            bitmap.recycle();
            return res;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean translateImageAsSmallImageInArea(Context context, Uri imageUri, int maxArea, boolean cropCenter, OutputStream stream, Bitmap.CompressFormat format) {
        if (context == null || imageUri == null || stream == null) {
            return false;
        }
        if (maxArea <= 0) {
            return false;
        }
        try {
            Bitmap bitmap = ImageUtil.translateImageAsSmallBitmapInArea(context, imageUri, maxArea, false, cropCenter);
            if (bitmap == null) {
                return false;
            }
            boolean res = bitmap.compress(format, 60, stream);
            bitmap.recycle();
            return res;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean translateImageAsSmallPngInArea(Context context, Uri imageUri, int maxArea, boolean cropCenter, OutputStream stream) {
        return ImageUtil.translateImageAsSmallImageInArea(context, imageUri, maxArea, cropCenter, stream, Bitmap.CompressFormat.PNG);
    }

    public static boolean translateImageAsSmallJpegInArea(Context context, Uri imageUri, int maxArea, boolean cropCenter, OutputStream stream) {
        return ImageUtil.translateImageAsSmallImageInArea(context, imageUri, maxArea, cropCenter, stream, Bitmap.CompressFormat.JPEG);
    }

    public static Bitmap translateImageAsSmallBitmap(Context context, Uri imageUri, int maxWidthHeight, boolean strict) {
        return ImageUtil.translateImageAsSmallBitmap(context, imageUri, maxWidthHeight, strict, false);
    }

    public static Bitmap translateImageAsSmallBitmap(Context context, String imagePath, int maxWidthHeight, boolean strict) {
        return ImageUtil.translateImageAsSmallBitmap(context, imagePath, maxWidthHeight, strict, false);
    }

    public static Bitmap translateImageAsSmallBitmapInArea(Context context, Uri imageUri, int maxArea, boolean strict) {
        return ImageUtil.translateImageAsSmallBitmapInArea(context, imageUri, maxArea, strict, false);
    }

    public static Bitmap translateImageAsSmallBitmap(Context context, Uri imageUri, int maxWidthHeight, boolean strict, boolean cropCenter) {
        if (context == null || imageUri == null) {
            return null;
        }
        if (maxWidthHeight <= 0) {
            return null;
        }
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            InputStream is = null;
            String scheme = imageUri.getScheme();
            if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                String file = FileUtils.downloadFile((Context)context, (URL)new URL(imageUri.toString()));
                if (file == null) {
                    return null;
                }
                is = new FileInputStream(file);
                imageUri = Uri.parse((String)("file://" + file));
            } else {
                is = context.getContentResolver().openInputStream(imageUri);
            }
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)o);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ImageUtil.translateImageAsSmallBitmap(context, imageUri, o.outWidth, o.outHeight, maxWidthHeight, strict, cropCenter);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Bitmap translateImageAsSmallBitmap(Context context, String imagePath, int maxWidthHeight, boolean strict, boolean cropCenter) {
        if (context == null || imagePath == null || !new File(imagePath).exists()) {
            return null;
        }
        if (maxWidthHeight <= 0) {
            return null;
        }
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)o);
            return ImageUtil.translateImageAsSmallBitmap(context, imagePath, o.outWidth, o.outHeight, maxWidthHeight, strict, cropCenter);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Bitmap translateImageAsSmallBitmapInArea(Context context, Uri imageUri, int maxArea, boolean strict, boolean cropCenter) {
        if (context == null || imageUri == null) {
            return null;
        }
        if (maxArea <= 0) {
            return null;
        }
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            InputStream is = null;
            String scheme = imageUri.getScheme();
            if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                String file = FileUtils.downloadFile((Context)context, (URL)new URL(imageUri.toString()));
                if (file == null) {
                    return null;
                }
                is = new FileInputStream(file);
                imageUri = Uri.parse((String)("file://" + file));
            } else {
                is = context.getContentResolver().openInputStream(imageUri);
            }
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)o);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception file) {
                // empty catch block
            }
            int width = (int)Math.sqrt((float)maxArea * ((float)o.outWidth / (float)o.outHeight));
            int height = width * o.outHeight / o.outWidth;
            int maxWidthHeight = width > height ? width : height;
            return ImageUtil.translateImageAsSmallBitmap(context, imageUri, o.outWidth, o.outHeight, maxWidthHeight, strict, cropCenter);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Bitmap translateImageAsSmallBitmap(Context context, Uri imageUri, int origWidth, int origHeight, int maxWidthHeight, boolean strict, boolean cropCenter) {
        if (context == null || imageUri == null) {
            return null;
        }
        if (maxWidthHeight <= 0) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            String imagePath = ImageUtil.getPathFromUri(context, imageUri);
            int width = origWidth;
            int height = origHeight;
            int scale = 1;
            if (cropCenter) {
                while ((scale >= 3 || origWidth / (scale + 1) >= maxWidthHeight * 3 / 4 && origHeight / (scale + 1) >= maxWidthHeight * 3 / 4) && width >= maxWidthHeight * 3 / 2 && height >= maxWidthHeight * 3 / 2) {
                    width = origWidth / ++scale;
                    height = origHeight / scale;
                }
            } else {
                while (!(scale < 3 && origWidth / (scale + 1) < maxWidthHeight * 3 / 4 && origHeight / (scale + 1) < maxWidthHeight * 3 / 4 || width < maxWidthHeight * 3 / 2 && height < maxWidthHeight * 3 / 2)) {
                    width = origWidth / ++scale;
                    height = origHeight / scale;
                }
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            while (true) {
                try {
                    InputStream is;
                    String scheme = imageUri.getScheme();
                    if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                        String file = FileUtils.downloadFile((Context)context, (URL)new URL(imageUri.toString()));
                        if (file == null) {
                            return null;
                        }
                        is = new FileInputStream(file);
                        imageUri = Uri.parse((String)("file://" + file));
                    } else {
                        is = context.getContentResolver().openInputStream(imageUri);
                    }
                    bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)o2);
                    try {
                        if (is == null) break;
                        is.close();
                    }
                    catch (Exception file) {}
                }
                catch (OutOfMemoryError e) {
                    width = origWidth / ++scale;
                    height = origHeight / scale;
                    o2.inSampleSize = scale;
                    if (width >= maxWidthHeight / 4 || height >= maxWidthHeight / 4) continue;
                    return null;
                }
                break;
            }
            if (ImageUtil.isJpegFile(imagePath)) {
                try {
                    Bitmap rotatedBmp;
                    int rotation = ImageUtil.getJpegRotation(imagePath);
                    if (rotation > 0 && (rotatedBmp = ImageUtil.rotateBitmap(bitmap, rotation)) != null && rotatedBmp != bitmap) {
                        bitmap.recycle();
                        bitmap = rotatedBmp;
                    }
                }
                catch (Exception rotation) {
                    // empty catch block
                }
            }
            if (!(strict && (width > maxWidthHeight || height > maxWidthHeight) || cropCenter && width != height)) {
                return bitmap;
            }
            width = bitmap.getWidth();
            height = bitmap.getHeight();
            int w2 = 0;
            int h2 = 0;
            if (width >= height) {
                w2 = maxWidthHeight;
                h2 = w2 * height / width;
            } else {
                h2 = maxWidthHeight;
                w2 = h2 * width / height;
            }
            int hOffset = 0;
            int vOffset = 0;
            if (cropCenter) {
                if (w2 > h2) {
                    vOffset = 0;
                    hOffset = (w2 - h2) / 2;
                } else {
                    hOffset = 0;
                    vOffset = (h2 - w2) / 2;
                }
                w2 = h2 = Math.min(w2, h2);
            }
            Bitmap baseBitmap = null;
            try {
                baseBitmap = Bitmap.createBitmap((int)w2, (int)h2, (Bitmap.Config)bitmap.getConfig());
            }
            catch (OutOfMemoryError e) {
                return bitmap;
            }
            Canvas canvas = new Canvas(baseBitmap);
            Paint paint = new Paint();
            canvas.drawBitmap(bitmap, new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Rect(-hOffset, -vOffset, w2 + hOffset, h2 + vOffset), paint);
            bitmap.recycle();
            return baseBitmap;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Bitmap translateImageAsSmallBitmap(Context context, String imagePath, int origWidth, int origHeight, int maxWidthHeight, boolean strict, boolean cropCenter) {
        if (context == null || imagePath == null || !new File(imagePath).exists()) {
            return null;
        }
        if (maxWidthHeight <= 0) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            int width = origWidth;
            int height = origHeight;
            int scale = 1;
            if (cropCenter) {
                while ((scale >= 3 || origWidth / (scale + 1) >= maxWidthHeight * 3 / 4 && origHeight / (scale + 1) >= maxWidthHeight * 3 / 4) && width >= maxWidthHeight * 3 / 2 && height >= maxWidthHeight * 3 / 2) {
                    width = origWidth / ++scale;
                    height = origHeight / scale;
                }
            } else {
                while (!(scale < 3 && origWidth / (scale + 1) < maxWidthHeight * 3 / 4 && origHeight / (scale + 1) < maxWidthHeight * 3 / 4 || width < maxWidthHeight * 3 / 2 && height < maxWidthHeight * 3 / 2)) {
                    width = origWidth / ++scale;
                    height = origHeight / scale;
                }
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            while (true) {
                try {
                    bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)o2);
                }
                catch (OutOfMemoryError e) {
                    width = origWidth / ++scale;
                    height = origHeight / scale;
                    o2.inSampleSize = scale;
                    if (width >= maxWidthHeight / 4 || height >= maxWidthHeight / 4) continue;
                    return null;
                }
                break;
            }
            if (ImageUtil.isJpegFile(imagePath)) {
                try {
                    Bitmap rotatedBmp;
                    int rotation = ImageUtil.getJpegRotation(imagePath);
                    if (rotation > 0 && (rotatedBmp = ImageUtil.rotateBitmap(bitmap, rotation)) != null && rotatedBmp != bitmap) {
                        bitmap.recycle();
                        bitmap = rotatedBmp;
                    }
                }
                catch (Exception rotation) {
                    // empty catch block
                }
            }
            if (!(strict && (width > maxWidthHeight || height > maxWidthHeight) || cropCenter && width != height)) {
                return bitmap;
            }
            width = bitmap.getWidth();
            height = bitmap.getHeight();
            int w2 = 0;
            int h2 = 0;
            if (width >= height) {
                w2 = maxWidthHeight;
                h2 = w2 * height / width;
            } else {
                h2 = maxWidthHeight;
                w2 = h2 * width / height;
            }
            int hOffset = 0;
            int vOffset = 0;
            if (cropCenter) {
                if (w2 > h2) {
                    vOffset = 0;
                    hOffset = (w2 - h2) / 2;
                } else {
                    hOffset = 0;
                    vOffset = (h2 - w2) / 2;
                }
                w2 = h2 = Math.min(w2, h2);
            }
            Bitmap baseBitmap = null;
            try {
                baseBitmap = Bitmap.createBitmap((int)w2, (int)h2, (Bitmap.Config)bitmap.getConfig());
            }
            catch (OutOfMemoryError e) {
                return bitmap;
            }
            Canvas canvas = new Canvas(baseBitmap);
            Paint paint = new Paint();
            canvas.drawBitmap(bitmap, new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Rect(-hOffset, -vOffset, w2 + hOffset, h2 + vOffset), paint);
            bitmap.recycle();
            return baseBitmap;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean compressImage(String filePath, int maxSize) {
        return ImageUtil.compressImage(filePath, null, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressImage(String srcFilePath, String destFilePath, int maxSize) {
        block34: {
            File file;
            if (maxSize <= 0) {
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)destFilePath)) {
                destFilePath = srcFilePath;
            }
            if ((file = new File(srcFilePath)).length() < (long)maxSize) {
                if (!destFilePath.equals(srcFilePath)) {
                    return FileUtils.copyFile((String)srcFilePath, (String)destFilePath);
                }
                return true;
            }
            Bitmap bitmap = ZMBitmapFactory.decodeFile(srcFilePath, Bitmap.Config.RGB_565);
            if (bitmap == null) {
                return false;
            }
            if (ImageUtil.isJpegFile(srcFilePath)) {
                try {
                    Bitmap rotatedBmp;
                    int rotation = ImageUtil.getJpegRotation(srcFilePath);
                    if (rotation > 0 && (rotatedBmp = ImageUtil.rotateBitmap(bitmap, rotation)) != null && rotatedBmp != bitmap) {
                        bitmap.recycle();
                        bitmap = rotatedBmp;
                    }
                }
                catch (Exception rotation) {
                    // empty catch block
                }
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int quality = 75;
            do {
                if (quality == 0) {
                    float sx;
                    float c = file.length() / (long)maxSize;
                    float sy = sx = 1.0f / (float)Math.pow(2.0, Math.ceil(Math.log(c) / Math.log(2.0)));
                    Matrix matrix = new Matrix();
                    matrix.setScale(sx, sy);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    out.reset();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
                    break;
                }
                out.reset();
                bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
                quality -= 25;
            } while (out.toByteArray().length > maxSize);
            OutputStream os = null;
            try {
                boolean b = FileUtils.createFile((String)destFilePath, (boolean)false);
                if (b) {
                    os = new FileOutputStream(destFilePath);
                    os.write(out.toByteArray());
                    os.flush();
                    break block34;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getPreviewImgData(String filePath, int maxSize) {
        if (StringUtil.isEmptyOrNull((String)filePath) || maxSize <= 0) {
            return null;
        }
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            return null;
        }
        if (options.outHeight == 0 || options.outWidth == 0) {
            return null;
        }
        if (file.length() <= (long)maxSize) {
            ByteArrayOutputStream out = null;
            FileInputStream in = null;
            try {
                out = new ByteArrayOutputStream();
                in = new FileInputStream(file);
                byte[] buff = new byte[8192];
                int i = -1;
                while ((i = ((InputStream)in).read(buff)) > 0) {
                    out.write(buff, 0, i);
                }
            }
            catch (Exception e) {
                byte[] i = null;
                return i;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return out.toByteArray();
        }
        int sample = 1;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        do {
            Bitmap bitmap = ZMBitmapFactory.decodeFile(filePath, 40000 / sample, false, false);
            if (ImageUtil.isJpegFile(filePath)) {
                try {
                    Bitmap rotatedBmp;
                    int rotation = ImageUtil.getJpegRotation(filePath);
                    if (rotation > 0 && (rotatedBmp = ImageUtil.rotateBitmap(bitmap, rotation)) != null && rotatedBmp != bitmap) {
                        bitmap.recycle();
                        bitmap = rotatedBmp;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            out.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)out);
            sample *= 4;
        } while (out.size() > maxSize);
        byte[] data = out.toByteArray();
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data;
    }

    private static boolean isJpegFile(String imagePath) {
        return imagePath != null && (imagePath.endsWith(".jpg") || imagePath.endsWith(".JPG") || imagePath.endsWith(".jpeg") || imagePath.endsWith(".JPEG"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageMimeType(String path) {
        String type = "unknow";
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            byte[] info = new byte[10];
            in.read(info);
            byte b0 = info[0];
            byte b1 = info[1];
            byte b2 = info[2];
            byte b3 = info[3];
            byte b6 = info[6];
            byte b7 = info[7];
            byte b8 = info[8];
            byte b9 = info[9];
            if (b0 == 71 && b1 == 73 && b2 == 70) {
                type = "image/gif";
            } else if (b1 == 80 && b2 == 78 && b3 == 71) {
                type = "image/png";
            } else if (b6 == 74 && b7 == 70 && b8 == 73 && b9 == 70) {
                type = "image/jpeg";
            }
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return type;
    }

    public static String getPathFromUri(Context context, Uri uri) {
        if (context == null || uri == null) {
            return null;
        }
        return FileUtils.getPathFromUri((Context)context, (Uri)uri);
    }

    private static int getJpegRotation(String imagePath) throws IOException {
        ExifInterface exif = new ExifInterface(imagePath);
        int orientation = exif.getAttributeInt("Orientation", 1);
        int angle = 0;
        if (orientation == 6) {
            angle = 90;
        } else if (orientation == 3) {
            angle = 180;
        } else if (orientation == 8) {
            angle = 270;
        }
        return angle;
    }

    public static Bitmap getJpegThumbnail(String imagePath) {
        if (StringUtil.isEmptyOrNull((String)imagePath)) {
            return null;
        }
        File f = new File(imagePath);
        try {
            ExifInterface exif = new ExifInterface(f.getPath());
            if (!exif.hasThumbnail()) {
                return null;
            }
            byte[] data = exif.getThumbnail();
            if (data == null) {
                return null;
            }
            Bitmap bmp = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)new BitmapFactory.Options());
            return bmp;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Bitmap rotateBitmap(Bitmap bmp, int angle) {
        Matrix mat = new Matrix();
        mat.postRotate((float)angle);
        try {
            Bitmap bitmap = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)bmp.getWidth(), (int)bmp.getHeight(), (Matrix)mat, (boolean)true);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            return null;
        }
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float roundRatioX, float roundRatioY) {
        if (bitmap == null) {
            return null;
        }
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -65536;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float roundPx = roundRatioX * (float)bitmap.getWidth();
        float roundPy = roundRatioY * (float)bitmap.getHeight();
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-65536);
        canvas.drawRoundRect(rectF, roundPx, roundPy, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean makeGroupAvatarFromMembers(Context context, List<GroupAvatarDrawable.GroupAvatarItem> memberAvatars, int size, String outputFile) {
        if (StringUtil.isEmptyOrNull((String)outputFile)) {
            return false;
        }
        Bitmap bmpOutput = ImageUtil.makeGroupAvatarFromMembers(context, memberAvatars, size);
        if (bmpOutput == null) {
            return false;
        }
        FileOutputStream os = null;
        boolean res = false;
        try {
            os = new FileOutputStream(outputFile);
            res = bmpOutput.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
        }
        catch (Exception exception) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        bmpOutput.recycle();
        return res;
    }

    public static Bitmap makeGroupAvatarFromMembers(Context context, List<GroupAvatarDrawable.GroupAvatarItem> memberAvatars, int size) {
        if (size <= 0) {
            return null;
        }
        Bitmap bmpOutput = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bmpOutput);
        canvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        GroupAvatarDrawable drawable2 = new GroupAvatarDrawable(memberAvatars);
        drawable2.draw(canvas);
        return bmpOutput;
    }

    public static boolean isValidImageFile(String pathName) {
        if (StringUtil.isEmptyOrNull((String)pathName)) {
            return false;
        }
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)o);
        }
        catch (Exception e) {
            return false;
        }
        return o.outWidth > 0 && o.outHeight > 0;
    }

    public static boolean compressImageFile(String srcFile, String destFile, int quality) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        Bitmap bitmap = ZMBitmapFactory.decodeFile(srcFile, -1, false, false);
        if (bitmap == null) {
            return false;
        }
        boolean res = ImageUtil.saveBitmapAsJPEG(bitmap, destFile, quality);
        bitmap.recycle();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBitmapAsJPEG(Bitmap bitmap, String destFile, int quality) {
        if (bitmap == null || destFile == null) {
            return false;
        }
        if (quality == 0) {
            quality = 100;
        }
        boolean res = false;
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(destFile);
            res = bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)os);
        }
        catch (Exception exception) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    public static Bitmap blurBitmap(Bitmap bitmap) {
        try {
            if (bitmap == null || bitmap.isRecycled()) {
                return null;
            }
            Bitmap dest = bitmap.copy(bitmap.getConfig(), true);
            RenderScript rs = RenderScript.create((Context)VideoBoxApplication.getGlobalContext());
            Allocation overlayAlloc = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)dest);
            ScriptIntrinsicBlur blur = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)overlayAlloc.getElement());
            blur.setInput(overlayAlloc);
            blur.setRadius(10.0f);
            blur.forEach(overlayAlloc);
            overlayAlloc.copyTo(dest);
            rs.destroy();
            return dest;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

