/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import com.zipow.videobox.view.IMBuddyItem;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import us.zoom.androidlib.util.StringUtil;

public class IMBuddyItemComparator
implements Comparator<IMBuddyItem> {
    private Collator mCollator;
    private boolean mCompareUnreadMsgCount;
    private boolean mComparePresence;

    public IMBuddyItemComparator(Locale locale, boolean compareUnreadMsgCount, boolean comparePresence) {
        this.mCollator = Collator.getInstance(locale);
        this.mCollator.setStrength(0);
        this.mCompareUnreadMsgCount = compareUnreadMsgCount;
        this.mComparePresence = comparePresence;
    }

    @Override
    public int compare(IMBuddyItem lhs, IMBuddyItem rhs) {
        if (lhs == rhs) {
            return 0;
        }
        if (this.mCompareUnreadMsgCount) {
            if (lhs.unreadMessageCount > 0 && rhs.unreadMessageCount == 0) {
                return -1;
            }
            if (rhs.unreadMessageCount > 0 && lhs.unreadMessageCount == 0) {
                return 1;
            }
        }
        if (this.mComparePresence) {
            int res;
            if (lhs.isNoneFriend && !rhs.isNoneFriend) {
                return 1;
            }
            if (!lhs.isNoneFriend && rhs.isNoneFriend) {
                return -1;
            }
            if (lhs.isPending && !rhs.isPending) {
                return 1;
            }
            if (rhs.isPending && !lhs.isPending) {
                return -1;
            }
            if (lhs.presence != rhs.presence && (res = this.comparePresence(lhs.presence, rhs.presence)) != 0) {
                return res;
            }
        }
        String str1 = this.getItemSortKey(lhs);
        String str2 = this.getItemSortKey(rhs);
        return this.mCollator.compare(str1, str2);
    }

    private String getItemSortKey(IMBuddyItem item) {
        String name = item.sortKey;
        if (StringUtil.isEmptyOrNull((String)name) && (name = item.email) == null) {
            name = "";
        }
        return name;
    }

    private int comparePresence(int lhs, int rhs) {
        if (lhs == 0 && rhs != 0) {
            return -1;
        }
        if (rhs == 0 && lhs != 0) {
            return 1;
        }
        return 0;
    }
}

