/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.ContactsAvatarCache;
import com.zipow.videobox.util.LazyLoadDrawable;
import com.zipow.videobox.util.NameAbbrAvatarDrawable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class GroupAvatarDrawable
extends Drawable {
    private List<Drawable> mDrawables = new ArrayList<Drawable>();
    private List<GroupAvatarItem> mNoAvatarItems = new ArrayList<GroupAvatarItem>();
    private int mCountMembers;
    private int mAlpha = -1;
    private ColorFilter mColorFilter;

    public GroupAvatarDrawable(List<GroupAvatarItem> memberAvatars) {
        this.mCountMembers = memberAvatars.size();
        for (int i = 0; i < memberAvatars.size(); ++i) {
            GroupAvatarItem item = memberAvatars.get(i);
            String pathName = item.avatar;
            if ((pathName == null || pathName.length() == 0) && item.contactId < 0) {
                this.mNoAvatarItems.add(item);
                continue;
            }
            if (pathName == null || pathName.length() == 0) {
                int contactId = item.contactId;
                Bitmap bmp = ContactsAvatarCache.getInstance().getContactAvatar((Context)VideoBoxApplication.getInstance(), contactId);
                if (bmp != null) {
                    this.mDrawables.add((Drawable)new BitmapDrawable(VideoBoxApplication.getInstance().getResources(), bmp));
                    continue;
                }
                this.mNoAvatarItems.add(item);
                continue;
            }
            File file = new File(pathName);
            if (file.exists() && file.isFile()) {
                this.mDrawables.add(new LazyLoadDrawable(pathName));
                if (this.mDrawables.size() < this.mCountMembers) continue;
                break;
            }
            this.mNoAvatarItems.add(item);
        }
    }

    public void draw(Canvas canvas) {
        if (this.mCountMembers <= 0) {
            return;
        }
        Rect bounds = this.getBounds();
        int size = bounds.width();
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        int inset = UIUtil.dip2px((Context)context, (float)1.0f);
        if (this.mCountMembers == 1) {
            Rect rcDest = new Rect(0, 0, size, size);
            rcDest.inset(inset, inset);
            rcDest.offset(bounds.left, bounds.top);
            float radius = (float)rcDest.width() / 2.0f;
            Path path = new Path();
            path.addCircle((float)rcDest.left + radius, (float)rcDest.top + radius, radius, Path.Direction.CCW);
            this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, 0, path, rcDest);
        } else if (this.mCountMembers == 2) {
            double radiusBig = Math.sqrt(size / 4 * (size / 4) + size / 2 * (size / 2));
            RectF rcArc = new RectF(0.0f, 0.0f, (float)size, (float)size);
            rcArc.inset((float)inset, (float)inset);
            rcArc.offset((float)bounds.left, (float)bounds.top);
            int idx = 0;
            float radius = rcArc.width() / 2.0f;
            Path path = new Path();
            path.arcTo(rcArc, 90.0f, 180.0f);
            path.lineTo(rcArc.left + radius, rcArc.bottom);
            path.close();
            Rect rcDest = new Rect((int)((double)((float)size / 4.0f) - radiusBig), (int)((double)((float)size / 2.0f) - radiusBig), (int)((double)((float)size / 4.0f) + radiusBig), (int)((double)((float)size / 2.0f) + radiusBig));
            rcDest.offset(bounds.left, bounds.top);
            idx = this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, 0, path, rcDest);
            path = new Path();
            path.arcTo(rcArc, 270.0f, 180.0f);
            path.lineTo(rcArc.left + radius, rcArc.top);
            path.close();
            rcDest.offset(size / 2, 0);
            idx = this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, idx + 1, path, rcDest);
        } else if (this.mCountMembers == 3) {
            double radiusSmall = Math.sqrt(size / 4 * (size / 4) * 2);
            RectF rcArc = new RectF(0.0f, 0.0f, (float)size, (float)size);
            rcArc.inset((float)inset, (float)inset);
            rcArc.offset((float)bounds.left, (float)bounds.top);
            int idx = 0;
            float radius = rcArc.width() / 2.0f;
            Path path = new Path();
            path.arcTo(rcArc, 180.0f, 90.0f);
            path.lineTo(rcArc.left + radius, rcArc.top + radius);
            path.lineTo(rcArc.left, rcArc.top + radius);
            path.close();
            Rect rcDest = new Rect((int)((double)((float)size / 4.0f) - radiusSmall), (int)((double)((float)size / 4.0f) - radiusSmall), (int)((double)((float)size / 4.0f) + radiusSmall), (int)((double)((float)size / 4.0f) + radiusSmall));
            rcDest.offset(bounds.left, bounds.top);
            idx = this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, 0, path, rcDest);
            path = new Path();
            path.moveTo(rcArc.left, rcArc.top + radius);
            path.lineTo(rcArc.left + radius, rcArc.top + radius);
            path.lineTo(rcArc.left + radius, rcArc.bottom);
            path.arcTo(rcArc, 90.0f, 90.0f);
            path.close();
            rcDest.offset(0, size / 2);
            idx = this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, idx + 1, path, rcDest);
            path = new Path();
            path.arcTo(rcArc, 270.0f, 180.0f);
            path.lineTo(rcArc.left + radius, rcArc.top);
            path.close();
            double radiusBig = Math.sqrt(size / 4 * (size / 4) + size / 2 * (size / 2));
            rcDest = new Rect((int)((double)((float)size * 3.0f / 4.0f) - radiusBig), (int)((double)((float)size / 2.0f) - radiusBig), (int)((double)((float)size * 3.0f / 4.0f) + radiusBig), (int)((double)((float)size / 2.0f) + radiusBig));
            rcDest.offset(bounds.left, bounds.top);
            idx = this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, idx + 1, path, rcDest);
        } else if (this.mCountMembers >= 4) {
            double radiusSmall = Math.sqrt(size / 4 * (size / 4) * 2);
            RectF rcArc = new RectF(0.0f, 0.0f, (float)size, (float)size);
            rcArc.inset((float)inset, (float)inset);
            rcArc.offset((float)bounds.left, (float)bounds.top);
            int idx = 0;
            float radius = rcArc.width() / 2.0f;
            Path path = new Path();
            path.arcTo(rcArc, 180.0f, 90.0f);
            path.lineTo(rcArc.left + radius, rcArc.top + radius);
            path.lineTo(rcArc.left, rcArc.top + radius);
            path.close();
            Rect rcDest = new Rect((int)((double)((float)size / 4.0f) - radiusSmall), (int)((double)((float)size / 4.0f) - radiusSmall), (int)((double)((float)size / 4.0f) + radiusSmall), (int)((double)((float)size / 4.0f) + radiusSmall));
            rcDest.offset(bounds.left, bounds.top);
            idx = this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, 0, path, rcDest);
            path = new Path();
            path.arcTo(rcArc, 270.0f, 90.0f);
            path.lineTo(rcArc.left + radius, rcArc.top + radius);
            path.lineTo(rcArc.left + radius, rcArc.top);
            path.close();
            rcDest.offset(size / 2, 0);
            idx = this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, idx + 1, path, rcDest);
            path = new Path();
            path.moveTo(rcArc.left, rcArc.top + radius);
            path.lineTo(rcArc.left + radius, rcArc.top + radius);
            path.lineTo(rcArc.left + radius, rcArc.bottom);
            path.arcTo(rcArc, 90.0f, 90.0f);
            path.close();
            rcDest.offset(-size / 2, size / 2);
            idx = this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, idx + 1, path, rcDest);
            path = new Path();
            path.moveTo(rcArc.left + radius, rcArc.bottom);
            path.lineTo(rcArc.left + radius, rcArc.top + radius);
            path.lineTo(rcArc.right, rcArc.top + radius);
            path.arcTo(rcArc, 0.0f, 90.0f);
            path.close();
            rcDest.offset(size / 2, 0);
            idx = this.drawMemberAvatar((Context)context, this.mDrawables, canvas, paint, idx + 1, path, rcDest);
        }
    }

    private int drawMemberAvatar(Context context, List<Drawable> drawables, Canvas canvas, Paint paint, int from, Path path, Rect rcDest) {
        Drawable drawable2 = null;
        Drawable srcDrawable = null;
        if (drawables.size() > from) {
            srcDrawable = drawables.get(from);
            if (srcDrawable instanceof LazyLoadDrawable) {
                LazyLoadDrawable tmp = (LazyLoadDrawable)srcDrawable;
                if (tmp.isValidDrawable()) {
                    drawable2 = srcDrawable;
                }
            } else {
                drawable2 = srcDrawable;
            }
        }
        if (drawable2 == null) {
            int idxName = from - drawables.size();
            if (idxName < this.mNoAvatarItems.size()) {
                GroupAvatarItem item = this.mNoAvatarItems.get(idxName);
                drawable2 = new NameAbbrAvatarDrawable(item.name, item.jid);
            } else {
                drawable2 = context.getResources().getDrawable(R.drawable.zm_no_avatar);
            }
        }
        canvas.save();
        canvas.clipPath(path);
        if (drawable2 != null) {
            canvas.drawColor(-1);
            drawable2.setBounds(rcDest);
            if (this.mAlpha >= 0 && this.mAlpha <= 255) {
                drawable2.setAlpha(this.mAlpha);
            }
            if (this.mColorFilter != null) {
                drawable2.setColorFilter(this.mColorFilter);
            }
            drawable2.draw(canvas);
        }
        canvas.restore();
        Paint borderPaint = new Paint();
        borderPaint.setAntiAlias(true);
        borderPaint.setColor(-1);
        borderPaint.setStyle(Paint.Style.STROKE);
        borderPaint.setStrokeWidth((float)UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)1.0f));
        canvas.drawPath(path, borderPaint);
        return from;
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
    }

    public int getOpacity() {
        return 0;
    }

    public static class GroupAvatarItem {
        public static final int INVALID_CONTACT_ID = -1;
        public String name;
        public String avatar;
        public int contactId = -1;
        public String jid;

        public GroupAvatarItem(String name, String avatar, int contactId, String jid) {
            this.name = name;
            this.avatar = avatar;
            this.contactId = contactId;
            this.jid = jid;
        }
    }
}

