/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.util.LongSparseArray;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.util.TextSpan;
import com.zipow.videobox.view.mm.sticker.CommonEmojiHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class EmojiHelper {
    public static final int EMOJI_TYPE_ZOOM = 0;
    public static final int EMOJI_TYPE_IOS = 1;
    private static int ZM_EMOJI_START = 0x100000;
    private static int IOS_20E3 = 8419;
    private static int IOS_20E3_START = 35;
    private static int IOS_20E3_END = 57;
    private static EmojiHelper mInstance;
    private LongSparseArray<EmojiIndex> mEmojiMaps = new LongSparseArray();
    private int mLongEmojiStartMax;
    private int mLongEmojiStartMin;
    private List<EmojiIndex> mZMEmojis = new ArrayList<EmojiIndex>();

    private EmojiHelper() {
        this.addEmojiConfig((Context)VideoBoxApplication.getInstance(), R.raw.zm_emoji_config);
        this.initZMEmojis();
    }

    public static synchronized EmojiHelper getInstance() {
        if (mInstance == null) {
            mInstance = new EmojiHelper();
        }
        return mInstance;
    }

    public String getRealMsg(String msg) {
        for (EmojiIndex index : this.mZMEmojis) {
            msg = msg.replaceAll(index.shortCut, index.repstr);
        }
        return msg;
    }

    private void initZMEmojis() {
        this.mZMEmojis.clear();
        ArrayList<Long> keys = new ArrayList<Long>();
        for (int i = 0; i < this.mEmojiMaps.size(); ++i) {
            Long key = this.mEmojiMaps.keyAt(i);
            EmojiIndex item = (EmojiIndex)this.mEmojiMaps.get(key.longValue());
            if (item.getType() != 0) continue;
            keys.add(key);
        }
        Collections.sort(keys);
        for (Long key : keys) {
            this.mZMEmojis.add((EmojiIndex)this.mEmojiMaps.get(key.longValue()));
        }
    }

    public List<EmojiIndex> getZMEmojis() {
        ArrayList<EmojiIndex> emojis = new ArrayList<EmojiIndex>();
        emojis.addAll(this.mZMEmojis);
        return emojis;
    }

    public CharSequence tranToEmojiText(CharSequence text, PTAppProtos.EmojiList emojiList) {
        if (text != null && text.length() > 0 && emojiList != null && emojiList.getEmojiItemCount() > 0) {
            VideoBoxApplication context = VideoBoxApplication.getInstance();
            SpannableStringBuilder ssb = new SpannableStringBuilder(text);
            for (int i = 0; i < emojiList.getEmojiItemCount(); ++i) {
                EmojiIndex index;
                PTAppProtos.EmojiItem item = emojiList.getEmojiItem(i);
                if (item.getPositionStart() >= item.getPositionEnd() || item.getPositionEnd() > text.length()) continue;
                int resource = 0;
                if (item.getType() == 0) {
                    resource = context.getResources().getIdentifier("zm_emoji_" + item.getIndex(), "drawable", context.getPackageName());
                } else {
                    if (UIUtil.isNavtiveSupportIOSEmoji()) continue;
                    resource = context.getResources().getIdentifier("emoji_" + item.getIndex(), "drawable", context.getPackageName());
                }
                if (resource == 0) {
                    ssb.setSpan((Object)new TextSpan(context.getString(R.string.zm_mm_msg_no_emoji)), item.getPositionStart(), item.getPositionEnd(), 33);
                    continue;
                }
                Drawable dd = context.getResources().getDrawable(resource);
                dd.setBounds(0, 0, dd.getIntrinsicWidth(), dd.getIntrinsicHeight());
                ZoomEmojiSpan is = new ZoomEmojiSpan(dd);
                String emojiCodeStr = text.subSequence(item.getPositionStart(), item.getPositionEnd()).toString();
                List<EmojiIndex> array = this.getEmojiIndex(emojiCodeStr);
                if (array == null || array.size() != 1 || (index = array.get(0)).drawResource != resource || !TextUtils.equals((CharSequence)index.repstr, (CharSequence)emojiCodeStr)) continue;
                ssb.setSpan((Object)is, item.getPositionStart(), item.getPositionEnd(), 33);
            }
            text = ssb;
        }
        return text;
    }

    public CharSequence tranToShortcutText(CharSequence text, PTAppProtos.EmojiList emojiList) {
        if (text != null && text.length() > 0 && emojiList != null && emojiList.getEmojiItemCount() > 0) {
            VideoBoxApplication context = VideoBoxApplication.getInstance();
            SpannableStringBuilder ssb = new SpannableStringBuilder(text);
            for (int i = emojiList.getEmojiItemCount() - 1; i >= 0; --i) {
                PTAppProtos.EmojiItem item = emojiList.getEmojiItem(i);
                if (item.getPositionStart() >= item.getPositionEnd() || item.getPositionEnd() > text.length()) continue;
                int resource = 0;
                if (item.getType() == 0) {
                    resource = context.getResources().getIdentifier("zm_emoji_" + item.getIndex(), "drawable", context.getPackageName());
                } else {
                    if (UIUtil.isNavtiveSupportIOSEmoji()) continue;
                    resource = context.getResources().getIdentifier("emoji_" + item.getIndex(), "drawable", context.getPackageName());
                }
                if (resource == 0) {
                    ssb.replace(item.getPositionStart(), item.getPositionEnd(), (CharSequence)context.getString(R.string.zm_mm_msg_no_emoji));
                    continue;
                }
                String shortCut = item.getShortcut();
                if (StringUtil.isEmptyOrNull((String)shortCut) && item.getType() == 0) {
                    for (EmojiIndex emoji : this.mZMEmojis) {
                        if (emoji.index != item.getIndex()) continue;
                        shortCut = emoji.shortCut;
                        break;
                    }
                }
                if (StringUtil.isEmptyOrNull((String)shortCut)) continue;
                ssb.replace(item.getPositionStart(), item.getPositionEnd(), (CharSequence)shortCut);
            }
            text = ssb;
        }
        return text;
    }

    public PTAppProtos.EmojiList getEmojiList(CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        List<EmojiIndex> emojiIndexs = this.getEmojiIndex(text);
        if (emojiIndexs != null && emojiIndexs.size() > 0) {
            PTAppProtos.EmojiList.Builder emojiListBuilder = PTAppProtos.EmojiList.newBuilder();
            for (EmojiIndex index : emojiIndexs) {
                PTAppProtos.EmojiItem.Builder itemBuilder = PTAppProtos.EmojiItem.newBuilder();
                itemBuilder.setIndex(index.getIndex());
                itemBuilder.setPositionEnd(index.getEnd());
                itemBuilder.setPositionStart(index.getStart());
                itemBuilder.setType(index.getType());
                itemBuilder.setShortcut(index.getShortCut());
                itemBuilder.setRepstr(index.getRepstr());
                emojiListBuilder.addEmojiItem(itemBuilder.build());
            }
            return emojiListBuilder.build();
        }
        return null;
    }

    public CommonEmojiHelper.ZMEmojiSpannableStringBuilder tranToEmojiText(CharSequence text) {
        if (text != null && text.length() > 0) {
            CommonEmojiHelper.ZMEmojiSpannableStringBuilder ssb = text instanceof CommonEmojiHelper.ZMEmojiSpannableStringBuilder ? (CommonEmojiHelper.ZMEmojiSpannableStringBuilder)((Object)text) : new CommonEmojiHelper.ZMEmojiSpannableStringBuilder(text);
            VideoBoxApplication context = VideoBoxApplication.getInstance();
            ZoomEmojiSpan[] spans = (ZoomEmojiSpan[])ssb.getSpans(0, ssb.length(), ZoomEmojiSpan.class);
            if (spans != null) {
                for (ZoomEmojiSpan span : spans) {
                    ssb.removeSpan((Object)span);
                }
            }
            StringBuffer temp = null;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == ':') {
                    if (temp == null) {
                        temp = new StringBuffer(":");
                        continue;
                    }
                    temp.append(':');
                    String str = temp.toString();
                    for (EmojiIndex index : this.mZMEmojis) {
                        if (!index.shortCut.equals(str)) continue;
                        Drawable dd = context.getResources().getDrawable(index.getDrawResource());
                        dd.setBounds(0, 0, dd.getIntrinsicWidth(), dd.getIntrinsicHeight());
                        ZoomEmojiSpan is = new ZoomEmojiSpan(dd);
                        ssb.setSpan((Object)is, i - index.shortCut.length() + 1, i + 1, 33);
                    }
                    temp = null;
                    continue;
                }
                if (temp == null) continue;
                temp.append(c);
            }
            List<EmojiIndex> indexs = EmojiHelper.getInstance().getEmojiIndex(text);
            if (indexs != null && indexs.size() > 0) {
                for (int i = indexs.size() - 1; i >= 0; --i) {
                    EmojiIndex index = indexs.get(i);
                    if (UIUtil.isNavtiveSupportIOSEmoji() && index.type == 1) continue;
                    int resource = index.getDrawResource();
                    if (resource == 0) {
                        ssb.setSpan((Object)new TextSpan(context.getString(R.string.zm_mm_msg_no_emoji)), index.getStart(), index.getEnd(), 33);
                        continue;
                    }
                    Drawable dd = context.getResources().getDrawable(index.getDrawResource());
                    dd.setBounds(0, 0, dd.getIntrinsicWidth(), dd.getIntrinsicHeight());
                    ssb.replace(index.getStart(), index.getEnd(), index.getShortCut());
                    ZoomEmojiSpan is = new ZoomEmojiSpan(dd);
                    ssb.setSpan((Object)is, index.getStart(), index.getStart() + index.getShortCut().length(), 33);
                }
            }
            return ssb;
        }
        return null;
    }

    public List<EmojiIndex> getEmojiIndex(CharSequence source) {
        if (TextUtils.isEmpty((CharSequence)source)) {
            return null;
        }
        ArrayList<EmojiIndex> indexs = new ArrayList<EmojiIndex>();
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            if (c >= IOS_20E3_START && c <= IOS_20E3_END) {
                EmojiIndex info;
                if (i + 1 >= length || source.charAt(i + 1) != IOS_20E3 || (info = (EmojiIndex)this.mEmojiMaps.get((long)c)) == null) continue;
                EmojiIndex index = new EmojiIndex(i, i + 2, info.drawResource, info.type, info.index, info.shortCut, info.repstr);
                indexs.add(index);
                ++i;
                continue;
            }
            int unincode = Character.codePointAt(source, i);
            int num = Character.charCount(unincode);
            if (num <= 0 || unincode <= 0) continue;
            if (unincode >= this.mLongEmojiStartMin && unincode <= this.mLongEmojiStartMax && i + 4 <= length) {
                int unincode2 = Character.codePointAt(source, i + 2);
                num = Character.charCount(unincode2);
                if (num != 2 || unincode2 == 0) continue;
                long code = unincode;
                EmojiIndex info = (EmojiIndex)this.mEmojiMaps.get(code = (code << 32) + (long)unincode2);
                if (info == null) continue;
                EmojiIndex index = new EmojiIndex(i, i + 4, info.drawResource, info.type, info.index, info.shortCut, info.repstr);
                indexs.add(index);
                i += 3;
                continue;
            }
            EmojiIndex info = (EmojiIndex)this.mEmojiMaps.get(Long.valueOf(unincode).longValue());
            if (info == null) continue;
            EmojiIndex index = new EmojiIndex(i, i + num, info.drawResource, info.type, info.index, info.shortCut, info.repstr);
            indexs.add(index);
            i += num - 1;
        }
        return indexs;
    }

    private void parseConfigLine(String line, Context context) throws JSONException {
        if (context == null) {
            return;
        }
        JSONObject json = new JSONObject(line);
        int pos = json.optInt("emoji_pos");
        String utf = json.optString("utf16");
        String shortCut = json.optString("short_cut");
        if (TextUtils.isEmpty((CharSequence)utf)) {
            return;
        }
        long code = this.emojiToLong(utf);
        EmojiIndex index = null;
        if (code >= (long)ZM_EMOJI_START && code < Integer.MAX_VALUE) {
            int draw = context.getResources().getIdentifier("zm_emoji_" + pos, "drawable", context.getPackageName());
            index = new EmojiIndex(draw, 0, pos, shortCut, this.tranEmojiCodeToString(code));
        } else {
            int draw = context.getResources().getIdentifier("emoji_" + pos, "drawable", context.getPackageName());
            index = new EmojiIndex(draw, 1, pos, "", this.tranEmojiCodeToString(code));
        }
        this.mEmojiMaps.put(code, (Object)index);
    }

    private String tranEmojiCodeToString(long code) {
        long l1 = code >> 32;
        int l2 = (int)code;
        String str = "";
        if (l1 != 0L) {
            str = str + new String(Character.toChars((int)l1));
        }
        if (l2 != 0) {
            str = str + new String(Character.toChars(l2));
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmojiConfig(Context context, int resource) {
        if (context == null || resource == 0) {
            return;
        }
        InputStream in = null;
        try {
            String line;
            in = context.getResources().openRawResource(resource);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                this.parseConfigLine(line, context);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmojiConfig(Context context, String path) {
        if (context == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        File file = new File(URI.create(path));
        if (!file.exists()) {
            return;
        }
        FileInputStream in = null;
        try {
            String line;
            in = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                this.parseConfigLine(line, context);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int parseHex(String hex) {
        try {
            return Integer.parseInt(hex, 16);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private long emojiToLong(String utf16) {
        if (TextUtils.isEmpty((CharSequence)utf16)) {
            return 0L;
        }
        if (utf16.length() < 5) {
            return this.parseHex(utf16);
        }
        String[] dest = utf16.split(" ");
        if (dest.length != 2 && dest.length != 4) {
            return 0L;
        }
        char[] codes = new char[dest.length];
        for (int i = 0; i < dest.length; ++i) {
            codes[i] = (char)this.parseHex(dest[i]);
        }
        if (codes.length == 2) {
            return Character.codePointAt(codes, 0);
        }
        long l1 = Character.codePointAt(codes, 0);
        long l2 = Character.codePointAt(codes, 2);
        if (this.mLongEmojiStartMax == 0 && this.mLongEmojiStartMin == 0) {
            this.mLongEmojiStartMax = (int)l1;
            this.mLongEmojiStartMin = (int)l1;
        } else {
            if ((long)this.mLongEmojiStartMax < l1) {
                this.mLongEmojiStartMax = (int)l1;
            }
            if ((long)this.mLongEmojiStartMin > l1) {
                this.mLongEmojiStartMin = (int)l1;
            }
        }
        return l2 += l1 << 32;
    }

    public static class ZoomEmojiSpan
    extends ImageSpan {
        private int mWidth;
        private int mHeight;

        public ZoomEmojiSpan(Drawable d) {
            super(d);
        }

        public void updateSize(int width, int height) {
            if (width <= 0 || height <= 0 || this.mWidth == width && this.mHeight == height) {
                return;
            }
            Drawable drawable2 = this.getDrawable();
            drawable2.setBounds(0, 0, width, height);
            this.mWidth = width;
            this.mHeight = height;
        }
    }

    public static class EmojiIndex {
        private int start;
        private int end;
        private int drawResource;
        private int type;
        private int index;
        private String shortCut;
        private String repstr;

        EmojiIndex(int start, int end, int drawResource, int type, int index, String shortCut, String repstr) {
            this.start = start;
            this.end = end;
            this.drawResource = drawResource;
            this.type = type;
            this.index = index;
            this.shortCut = shortCut;
            this.repstr = repstr;
        }

        EmojiIndex(int drawResource, int type, int index, String shortCut, String repstr) {
            this.drawResource = drawResource;
            this.type = type;
            this.index = index;
            this.shortCut = shortCut;
            this.repstr = repstr;
        }

        public String getShortCut() {
            return this.shortCut;
        }

        public String getRepstr() {
            return this.repstr;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getDrawResource() {
            return this.drawResource;
        }

        public int getIndex() {
            return this.index;
        }

        public int getType() {
            return this.type;
        }
    }
}

