/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.view.AvatarView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class DialogUtils {
    public static boolean isCanShowDialog(ZMActivity activity) {
        return activity != null && !activity.isFinishing();
    }

    public static View createAvatarDialogTitleView(Context context, CharSequence screenName, Object avatar) {
        if (context == null || TextUtils.isEmpty((CharSequence)screenName)) {
            return null;
        }
        View view = View.inflate((Context)context, (int)R.layout.zm_avatar_dialog_header, null);
        TextView txtName = (TextView)view.findViewById(R.id.txtName);
        txtName.setText(screenName);
        AvatarView avatarView = (AvatarView)view.findViewById(R.id.avatarView);
        if (avatar != null) {
            if (avatar instanceof Integer) {
                avatarView.setAvatar((Integer)avatar);
            } else {
                avatarView.setAvatar(avatar.toString());
            }
        } else {
            avatarView.setVisibility(8);
        }
        return view;
    }

    public static void showAlertDialog(ZMActivity activity, int titleId, int msgId, int okButtonId) {
        if (!DialogUtils.isCanShowDialog(activity)) {
            return;
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)activity).setTitle(titleId).setMessage(msgId).setPositiveButton(okButtonId, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    public static void showAlertDialog(ZMActivity activity, int titleId, int okButtonId) {
        if (!DialogUtils.isCanShowDialog(activity)) {
            return;
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)activity).setTitle(titleId).setPositiveButton(okButtonId, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    public static void showAlertDialog(ZMActivity activity, String title, int okButtonId) {
        if (!DialogUtils.isCanShowDialog(activity)) {
            return;
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)activity).setTitle(title).setPositiveButton(okButtonId, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    public static void showAlertDialog(ZMActivity activity, int titleId, int okButtonId, int cancelId, DialogInterface.OnClickListener okClickListener) {
        if (!DialogUtils.isCanShowDialog(activity)) {
            return;
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)activity).setTitle(titleId).setPositiveButton(okButtonId, okClickListener).setNegativeButton(cancelId, null).create();
        dlg.show();
    }

    public static void showAlertDialog(ZMActivity activity, String title, CharSequence[] items, DialogInterface.OnClickListener clickListener) {
        if (!DialogUtils.isCanShowDialog(activity)) {
            return;
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)activity).setTitle(title).setSingleChoiceItems(items, -1, clickListener).create();
        dlg.show();
    }
}

