/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.util.ConfLocalHelper;
import us.zoom.videomeetings.R;

public class ConfShareLocalHelper {
    public static void updateShareTitle(Context context, long shareActiveUser, View panelSharingTitle) {
        panelSharingTitle.setBackgroundResource(R.color.zm_sharing_title_bg);
        if (shareActiveUser > 0L) {
            CmmUser user = ConfMgr.getInstance().getUserById(shareActiveUser);
            if (user != null) {
                String name = user.getScreenName();
                TextView txtSharingTitle = (TextView)panelSharingTitle.findViewById(R.id.txtSharingTitle);
                if (name.endsWith("s")) {
                    txtSharingTitle.setText((CharSequence)context.getString(R.string.zm_msg_sharing_s, new Object[]{name}));
                } else {
                    txtSharingTitle.setText((CharSequence)context.getString(R.string.zm_msg_sharing, new Object[]{name}));
                }
            }
            TextView txtMyScreenName = (TextView)panelSharingTitle.findViewById(R.id.txtMyScreenName);
            txtMyScreenName.setVisibility(8);
            if (ConfLocalHelper.isNeedShowPresenterNameToWaterMark()) {
                panelSharingTitle.setBackgroundResource(R.color.zm_sharing_title_half_bg);
                CmmUser mySelf = ConfMgr.getInstance().getMyself();
                if (mySelf != null) {
                    txtMyScreenName.setVisibility(0);
                    txtMyScreenName.setText((CharSequence)mySelf.getScreenName());
                }
            }
        }
    }

    public static boolean isOtherScreenSharing() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return false;
        }
        return shareMgr.getShareStatus() == 3;
    }

    public static boolean isOtherPureAudioSharing() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        return shareMgr != null && shareMgr.isViewingPureComputerAudio();
    }
}

