/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class CodeSnipptUtils {
    public static final String TAG = CodeSnipptUtils.class.getSimpleName();

    private static String validateFilename(String filename, String intendedDir) throws IOException {
        File iD;
        String canonicalID;
        File f = new File(filename);
        String canonicalPath = f.getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return canonicalPath;
        }
        throw new IllegalStateException("File is outside extraction target directory.");
    }

    public static String parseZipSnippetSrc(ZoomMessage message, String fileType) {
        CodeSnippetInfo codeSnippetInfo = CodeSnipptUtils.parseZipSnippet(message, fileType, -1);
        if (codeSnippetInfo != null) {
            return codeSnippetInfo.getSrc();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeSnippetInfo parseZipSnippet(ZoomMessage message, String fileType, int maxLines) {
        if (message == null || TextUtils.isEmpty((CharSequence)message.getLocalFilePath()) || TextUtils.isEmpty((CharSequence)fileType)) {
            return null;
        }
        ZipInputStream zin = null;
        try {
            String zipFile = message.getLocalFilePath();
            ZipFile zf = new ZipFile(zipFile);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
            zin = new ZipInputStream(in);
            int lineNo = 0;
            ArrayList<SpannableString> lines = new ArrayList<SpannableString>();
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                ZipEntry ze;
                if ((ze = zin.getNextEntry()) != null) {
                    String line;
                    String entryName = CodeSnipptUtils.validateFilename(ze.getName(), ".");
                    if (ze.isDirectory() || TextUtils.isEmpty((CharSequence)entryName) || !entryName.endsWith("_" + fileType)) continue;
                    BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                    while ((line = br.readLine()) != null) {
                        if (maxLines < 0) {
                            stringBuffer.append(line);
                        }
                        if (!line.endsWith("<br />")) continue;
                        if (lineNo < maxLines) {
                            Spanned spannable = Html.fromHtml((String)line);
                            SpannableString spannableString = new SpannableString((CharSequence)spannable);
                            lines.add(spannableString);
                        }
                        if (maxLines < 0) {
                            stringBuffer.append("\n");
                        }
                        ++lineNo;
                    }
                    br.close();
                    CodeSnippetInfo result = new CodeSnippetInfo();
                    result.lineNo = lineNo;
                    result.contents = lines;
                    result.src = stringBuffer.toString();
                    CodeSnippetInfo codeSnippetInfo = result;
                    return codeSnippetInfo;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (zin != null) {
                try {
                    zin.closeEntry();
                    zin.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeSnippetInfo parseSnippet(String fileName, int maxLines) {
        if (TextUtils.isEmpty((CharSequence)fileName) || maxLines <= 0) {
            return null;
        }
        File codeFile = new File(fileName);
        if (!codeFile.isFile()) {
            return null;
        }
        int lineNo = 0;
        ArrayList<SpannableString> lines = new ArrayList<SpannableString>();
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream in = new FileInputStream(fileName);
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                if (!line.endsWith("<br />")) continue;
                if (lineNo < maxLines) {
                    Spanned spannable = Html.fromHtml((String)line);
                    SpannableString spannableString = new SpannableString((CharSequence)spannable);
                    lines.add(spannableString);
                }
                ++lineNo;
            }
        }
        catch (Exception in) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException in) {}
            }
        }
        CodeSnippetInfo result = new CodeSnippetInfo();
        result.lineNo = lineNo;
        result.contents = lines;
        return result;
    }

    public static class CodeSnippetInfo {
        private int lineNo;
        private List<CharSequence> contents;
        private String src;

        public int getLineNo() {
            return this.lineNo;
        }

        public List<CharSequence> getContents() {
            return this.contents;
        }

        public String getSrc() {
            return this.src;
        }
    }
}

