/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.util;

import android.os.Handler;
import android.os.RemoteException;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.ConfProcessMgr;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class AppStateMonitor {
    private static final String TAG = AppStateMonitor.class.getSimpleName();
    private static AppStateMonitor instance = null;
    private ListenerList mListenerList = new ListenerList();
    private Handler mHandler = new Handler();
    private boolean mbPTAtForground = false;
    private boolean mbConfAtForground = false;

    public static synchronized AppStateMonitor getInstance() {
        if (instance == null) {
            instance = new AppStateMonitor();
        }
        return instance;
    }

    private AppStateMonitor() {
    }

    private boolean isConfProcessRunning() {
        return ConfProcessMgr.getInstance().isConfProcessRunning();
    }

    public void onPTUIMoveToFront() {
        if (!(this.mbPTAtForground || this.isConfProcessRunning() && this.mbConfAtForground)) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AppStateMonitor.this.notifyAppActive();
                }
            });
        }
        this.mbPTAtForground = true;
    }

    public void onPTUIMoveToBackground() {
        if (!this.isConfProcessRunning() || !this.mbConfAtForground) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AppStateMonitor.this.notifyAppInactive();
                }
            });
        }
        this.mbPTAtForground = false;
    }

    public void onConfUIMoveToFront() {
        if (!this.mbPTAtForground && !this.mbConfAtForground) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AppStateMonitor.this.notifyAppActive();
                }
            });
        }
        this.mbConfAtForground = true;
    }

    public void onConfUIMoveToBackground() {
        if (!this.mbPTAtForground) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AppStateMonitor.this.notifyAppInactive();
                }
            });
        }
        this.mbConfAtForground = false;
    }

    public void addListener(IAppStateListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i].getClass() != l.getClass()) continue;
            this.removeListener((IAppStateListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IAppStateListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public void start() {
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        if (app == null) {
            return;
        }
        if (app.isPTApp()) {
            ZMActivity activity = ZMActivity.getFrontActivity();
            this.mbPTAtForground = activity != null && activity.isActive();
            IConfService confService = VideoBoxApplication.getInstance().getConfService();
            if (confService != null) {
                try {
                    this.mbConfAtForground = confService.isConfAppAtFront();
                }
                catch (RemoteException remoteException) {}
            }
        } else if (app.isConfApp()) {
            ZMActivity activity = ZMActivity.getFrontActivity();
            this.mbConfAtForground = activity != null && activity.isActive();
            IPTService ptService = VideoBoxApplication.getInstance().getPTService();
            if (ptService != null) {
                try {
                    this.mbPTAtForground = ptService.isPTAppAtFront();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (!this.mbPTAtForground && !this.mbConfAtForground) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AppStateMonitor.this.notifyAppInactive();
                }
            });
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AppStateMonitor.this.notifyAppActive();
                }
            });
        }
    }

    private void notifyAppInactive() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IAppStateListener l = (IAppStateListener)lTmp;
                l.onAppInactivated();
            }
        }
    }

    private void notifyAppActive() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IAppStateListener l = (IAppStateListener)lTmp;
                l.onAppActivated();
            }
        }
    }

    public static interface IAppStateListener
    extends IListener {
        public void onAppActivated();

        public void onAppInactivated();
    }
}

