/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.upgrade;

import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class UpgradeMgr {
    private static final String TAG = UpgradeMgr.class.getSimpleName();
    private static UpgradeMgr instance;
    private long mDownloadId = -1L;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_PENDING = 3;
    public static final int STATUS_RUNNING = 4;
    public static final int STATUS_SUCCESSFUL = 5;
    public static final int DOWNLOAD_READY = 1;
    public static final int DOWNLOAD_RUNNING = 2;
    public static final int DOWNLOAD_FAILED = 3;
    private static final Uri CONTENT_URI;
    private DownloadsChangeObserver downloadObserver;
    private DownloadManager downloadMgr;
    private BroadcastReceiver mDownloadReceiver;
    private ListenerList listeners = new ListenerList();
    private int fileSize;
    private int downloadSize;
    private int status;
    private String packageCheckSum;

    public static synchronized UpgradeMgr getInstance(Context context) {
        if (instance == null) {
            instance = new UpgradeMgr(context);
        }
        return instance;
    }

    private UpgradeMgr(Context context) {
        this.downloadMgr = (DownloadManager)context.getSystemService("download");
        this.status = 1;
    }

    public synchronized void addUpgradeMgrListener(UpgradeMgrListener listener) {
        this.listeners.add((IListener)listener);
    }

    public synchronized void removeUpgradeMgrListener(UpgradeMgrListener listener) {
        this.listeners.remove((IListener)listener);
    }

    private synchronized void notifyEvent(int event, int value, int type) {
        IListener[] arrListeners;
        if (event == 1 || event == 5) {
            this.unregisterDownloadReceiver((Context)VideoBoxApplication.getInstance());
        }
        for (IListener l : arrListeners = this.listeners.getAll()) {
            ((UpgradeMgrListener)l).onUpgradeEvent(event, value, type);
        }
    }

    @SuppressLint(value={"NewApi"})
    public boolean installZoomByAPK(Context context, String siteUrl) {
        if (context == null) {
            return false;
        }
        this.packageCheckSum = UpgradeMgr.getZoomAPKCheckSum();
        String sUrl = UpgradeMgr.getZoomAPKDownloadUrl(siteUrl);
        if (StringUtil.isEmptyOrNull((String)sUrl) || StringUtil.isEmptyOrNull((String)this.packageCheckSum)) {
            return false;
        }
        Uri uri = null;
        try {
            uri = Uri.parse((String)sUrl);
        }
        catch (Exception e) {
            return false;
        }
        if (this.status == 2) {
            DownloadManager.Query query = new DownloadManager.Query();
            query.setFilterById(new long[]{this.mDownloadId});
            Cursor cursor = this.downloadMgr.query(query);
            if (cursor != null) {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    int statusIdx = cursor.getColumnIndex("status");
                    int status = cursor.getInt(statusIdx);
                    switch (status) {
                        case 16: {
                            this.downloadSize = 0;
                            this.fileSize = 0;
                            this.notifyEvent(1, 0, 0);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: {
                            cursor.close();
                            return true;
                        }
                        case 8: {
                            int uriIdx = cursor.getColumnIndex("local_uri");
                            String sUri = cursor.getString(uriIdx);
                            Uri localUri = Uri.parse((String)sUri);
                            this.checkApkAndInstall(localUri);
                            cursor.close();
                            return true;
                        }
                    }
                }
                cursor.close();
            }
        }
        DownloadManager.Request request = null;
        try {
            request = new DownloadManager.Request(uri);
        }
        catch (Exception e) {
            this.status = 1;
            return false;
        }
        request.setAllowedNetworkTypes(3);
        String apkName = this.getDownloadApkName(Environment.DIRECTORY_DOWNLOADS);
        if (apkName == null) {
            return false;
        }
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, apkName);
        request.setMimeType("application/vnd.android.package-archive");
        request.setVisibleInDownloadsUi(true);
        request.setTitle((CharSequence)context.getString(R.string.zm_app_full_name));
        this.downloadObserver = new DownloadsChangeObserver();
        context.getContentResolver().registerContentObserver(CONTENT_URI, true, (ContentObserver)this.downloadObserver);
        this.status = 2;
        try {
            this.mDownloadId = this.downloadMgr.enqueue(request);
        }
        catch (Throwable a) {
            this.status = 1;
            return false;
        }
        this.registerDownloadReceiver(context.getApplicationContext());
        return true;
    }

    private String getDownloadApkName(String dirType) {
        String latestVersion = PTApp.getInstance().getLatestVersionString();
        String packageName = PTApp.getInstance().getPackageName();
        if (StringUtil.isEmptyOrNull((String)packageName) || StringUtil.isEmptyOrNull((String)latestVersion)) {
            return null;
        }
        File dir = null;
        try {
            dir = Environment.getExternalStoragePublicDirectory((String)dirType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dir == null) {
            return null;
        }
        String fileName = null;
        String extName = ".apk";
        fileName = packageName.endsWith(extName) ? packageName.substring(0, packageName.length() - extName.length()) : packageName;
        String fullFileName = null;
        File file = null;
        int idx = 0;
        do {
            fullFileName = idx == 0 ? fileName + "-" + latestVersion + extName : fileName + "-" + latestVersion + "(" + idx + ")" + extName;
            ++idx;
        } while ((file = new File(dir.toString() + File.separator + fullFileName)).exists());
        return fullFileName;
    }

    private void registerDownloadReceiver(Context context) {
        if (this.mDownloadReceiver != null) {
            return;
        }
        this.mDownloadReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if ("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED".equals(intent.getAction())) {
                    try {
                        Intent intentDownloadList = new Intent("android.intent.action.VIEW_DOWNLOADS");
                        intentDownloadList.setFlags(0x10000000);
                        context.startActivity(intentDownloadList);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED");
        context.registerReceiver(this.mDownloadReceiver, filter);
    }

    private void unregisterDownloadReceiver(Context context) {
        if (this.mDownloadReceiver != null) {
            try {
                context.unregisterReceiver(this.mDownloadReceiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mDownloadReceiver = null;
        }
    }

    private void cleanDownload() {
        this.mDownloadId = -1L;
        this.downloadSize = 0;
        this.fileSize = 0;
    }

    private boolean installApk(Uri uri) {
        if (uri == null) {
            return false;
        }
        long timeStart = System.currentTimeMillis();
        String checkSum = this.md5(uri);
        if (checkSum == null) {
            return false;
        }
        if (!StringUtil.isSameString((String)checkSum, (String)this.packageCheckSum)) {
            return false;
        }
        Intent intentInstall = new Intent("android.intent.action.VIEW");
        intentInstall.setFlags(0x10000000);
        if (OsUtil.isAtLeastN()) {
            intentInstall.setFlags(1);
            uri = FileProvider.getUriForFile((Context)VideoBoxApplication.getInstance(), (String)"us.zoom.videomeetings.fileprovider", (File)new File(FileUtils.getPathFromUri((Context)VideoBoxApplication.getInstance(), (Uri)uri)));
        }
        intentInstall.setDataAndType(uri, "application/vnd.android.package-archive");
        VideoBoxApplication.getInstance().startActivity(intentInstall);
        return true;
    }

    public static String getZoomAPKDownloadUrl(String siteUrl) {
        return PTApp.getInstance().getPackageDownloadUrl();
    }

    private static String getZoomAPKCheckSum() {
        return PTApp.getInstance().getPackageCheckSum();
    }

    public long getDownloadId() {
        return this.mDownloadId;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public int getDownloadSize() {
        return this.downloadSize;
    }

    private void removeContentObserver() {
        ContentResolver resolver = VideoBoxApplication.getInstance().getContentResolver();
        if (resolver != null) {
            try {
                resolver.unregisterContentObserver((ContentObserver)this.downloadObserver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cancel(Context context) {
        if (context != null) {
            this.unregisterDownloadReceiver(context.getApplicationContext());
        }
        this.removeContentObserver();
        try {
            this.downloadMgr.remove(new long[]{this.mDownloadId});
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.status = 1;
        this.cleanDownload();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void install() {
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{this.mDownloadId});
        Uri localUri = null;
        Cursor cursor = this.downloadMgr.query(query);
        if (cursor != null && cursor.getCount() == 1 && cursor.moveToFirst()) {
            int uriIdx = cursor.getColumnIndex("local_uri");
            String sUri = cursor.getString(uriIdx);
            localUri = Uri.parse((String)sUri);
        }
        this.checkApkAndInstall(localUri);
    }

    private void checkApkAndInstall(Uri localUri) {
        this.cleanDownload();
        boolean success = false;
        if (localUri != null) {
            success = this.installApk(localUri);
        }
        if (!success) {
            this.status = 3;
            this.notifyEvent(1, 0, 0);
        } else {
            this.status = 1;
            this.notifyEvent(5, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String md5(Uri uri) {
        File file = new File(uri.getPath());
        if (!file.exists()) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        InputStream is = null;
        try {
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            int readLen = 0;
            byte[] buff = new byte[10240];
            is = new FileInputStream(file);
            do {
                if ((readLen = is.read(buff)) <= 0) continue;
                mdInst.update(buff, 0, readLen);
            } while (readLen > 0);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            String string2 = new String(str);
            return string2;
        }
        catch (Exception e) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static {
        CONTENT_URI = Uri.parse((String)"content://downloads/");
    }

    public static interface UpgradeMgrListener
    extends IListener {
        public void onUpgradeEvent(int var1, int var2, int var3);
    }

    private class DownloadsChangeObserver
    extends ContentObserver {
        private int currentStatus;

        public DownloadsChangeObserver() {
            super(null);
        }

        public void onChange(boolean selfChange) {
            DownloadManager.Query query = new DownloadManager.Query();
            query.setFilterById(new long[]{UpgradeMgr.this.mDownloadId});
            Cursor c = UpgradeMgr.this.downloadMgr.query(query);
            if (c != null && c.moveToFirst()) {
                int st = c.getInt(c.getColumnIndex("status"));
                int fileSizeIdx = c.getColumnIndex("total_size");
                int bytesDLIdx = c.getColumnIndex("bytes_so_far");
                UpgradeMgr.this.fileSize = c.getInt(fileSizeIdx);
                UpgradeMgr.this.downloadSize = c.getInt(bytesDLIdx);
                this.currentStatus = st;
                switch (st) {
                    case 4: {
                        UpgradeMgr.this.notifyEvent(2, 0, 0);
                        break;
                    }
                    case 16: {
                        UpgradeMgr.this.status = 3;
                        UpgradeMgr.this.notifyEvent(1, 0, 0);
                        UpgradeMgr.this.removeContentObserver();
                        break;
                    }
                    case 1: {
                        UpgradeMgr.this.notifyEvent(3, 0, 0);
                        break;
                    }
                    case 2: {
                        UpgradeMgr.this.status = 2;
                        UpgradeMgr.this.notifyEvent(4, UpgradeMgr.this.downloadSize, UpgradeMgr.this.fileSize);
                        break;
                    }
                    case 8: {
                        UpgradeMgr.this.removeContentObserver();
                        UpgradeMgr.this.install();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                c.close();
            } else if (this.currentStatus == 2) {
                UpgradeMgr.this.status = 3;
                UpgradeMgr.this.removeContentObserver();
                UpgradeMgr.this.notifyEvent(1, 0, 0);
            }
        }
    }
}

