/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.tempbean;

import android.text.TextUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.zipow.videobox.tempbean.IMessageTemplateActions;
import com.zipow.videobox.tempbean.IMessageTemplateAttachments;
import com.zipow.videobox.tempbean.IMessageTemplateBase;
import com.zipow.videobox.tempbean.IMessageTemplateFieldItem;
import com.zipow.videobox.tempbean.IMessageTemplateFields;
import com.zipow.videobox.tempbean.IMessageTemplateHead;
import com.zipow.videobox.tempbean.IMessageTemplateMessage;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.ZMLog;

public class IZoomMessageTemplate {
    private static final String TAG = IZoomMessageTemplate.class.getSimpleName();
    private IMessageTemplateHead head;
    private List<IMessageTemplateBase> body;

    public static IZoomMessageTemplate parse(JsonObject jsonObject) {
        JsonArray array;
        JsonElement element;
        if (jsonObject == null) {
            return null;
        }
        IZoomMessageTemplate template = new IZoomMessageTemplate();
        if (jsonObject.has("head") && (element = jsonObject.get("head")) != null) {
            template.setHead(IMessageTemplateHead.parse(element.getAsJsonObject()));
        }
        if (jsonObject.has("body") && (element = jsonObject.get("body")) != null && (array = element.getAsJsonArray()) != null) {
            ArrayList<IMessageTemplateBase> list = new ArrayList<IMessageTemplateBase>();
            block14: for (int i = 0; i < array.size(); ++i) {
                String type;
                JsonElement itemElement;
                JsonElement item = array.get(i);
                JsonObject jsonItem = item.getAsJsonObject();
                if (!jsonItem.has("type") || (itemElement = jsonItem.get("type")) == null) continue;
                switch (type = itemElement.getAsString()) {
                    case "message": {
                        list.add(IMessageTemplateMessage.parse(jsonItem));
                        continue block14;
                    }
                    case "select": {
                        continue block14;
                    }
                    case "fields": {
                        list.add(IMessageTemplateFields.parse(jsonItem));
                        continue block14;
                    }
                    case "attachments": {
                        list.add(IMessageTemplateAttachments.parse(jsonItem));
                        continue block14;
                    }
                    case "actions": {
                        list.add(IMessageTemplateActions.parse(jsonItem));
                    }
                }
            }
            template.setBody(list);
        }
        return template;
    }

    public String toJSONString() {
        StringWriter string2 = new StringWriter();
        JsonWriter json = new JsonWriter((Writer)string2);
        try {
            this.writeJson(json);
            json.close();
        }
        catch (Exception e) {
            ZMLog.e((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
        }
        return string2.toString();
    }

    public void writeJson(JsonWriter writer) throws IOException {
        writer.beginObject();
        if (this.head != null) {
            writer.name("head");
            this.head.writeJson(writer);
        }
        if (this.body != null) {
            writer.name("body");
            writer.beginArray();
            for (IMessageTemplateBase templateBase : this.body) {
                switch (templateBase.getType()) {
                    case "message": {
                        if (!(templateBase instanceof IMessageTemplateMessage)) break;
                        ((IMessageTemplateMessage)templateBase).writeJson(writer);
                        break;
                    }
                    case "select": {
                        break;
                    }
                    case "fields": {
                        if (!(templateBase instanceof IMessageTemplateFields)) break;
                        ((IMessageTemplateFields)templateBase).writeJson(writer);
                        break;
                    }
                    case "attachments": {
                        if (!(templateBase instanceof IMessageTemplateAttachments)) break;
                        ((IMessageTemplateAttachments)templateBase).writeJson(writer);
                        break;
                    }
                    case "actions": {
                        if (!(templateBase instanceof IMessageTemplateActions)) break;
                        ((IMessageTemplateActions)templateBase).writeJson(writer);
                    }
                }
            }
            writer.endArray();
        }
        writer.endObject();
    }

    public Object findEditItem(String eventID) {
        if (TextUtils.isEmpty((CharSequence)eventID)) {
            return null;
        }
        if (this.body == null || this.body.isEmpty()) {
            return null;
        }
        block8: for (IMessageTemplateBase templateBase : this.body) {
            switch (templateBase.getType()) {
                case "message": {
                    if (!(templateBase instanceof IMessageTemplateMessage)) break;
                    IMessageTemplateMessage item = (IMessageTemplateMessage)templateBase;
                    String id2 = item.getEvent_id();
                    if (!item.isEditable() || !TextUtils.equals((CharSequence)eventID, (CharSequence)id2)) continue block8;
                    return item;
                }
                case "fields": {
                    IMessageTemplateFields fields;
                    List<IMessageTemplateFieldItem> items;
                    if (!(templateBase instanceof IMessageTemplateFields) || (items = (fields = (IMessageTemplateFields)templateBase).getItems()) == null) break;
                    for (IMessageTemplateFieldItem fieldItem : items) {
                        if (!fieldItem.isEditable() || !TextUtils.equals((CharSequence)fieldItem.getEvent_id(), (CharSequence)eventID)) continue;
                        return fieldItem;
                    }
                    break;
                }
            }
        }
        return null;
    }

    public IMessageTemplateHead getHead() {
        return this.head;
    }

    public void setHead(IMessageTemplateHead head) {
        this.head = head;
    }

    public List<IMessageTemplateBase> getBody() {
        return this.body;
    }

    public void setBody(List<IMessageTemplateBase> body) {
        this.body = body;
    }
}

