/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.tempbean;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.zipow.videobox.tempbean.IMessageTemplateSubHead;
import com.zipow.videobox.tempbean.IMessageTemplateTextStyle;
import java.io.IOException;

public class IMessageTemplateHead {
    private String text;
    private IMessageTemplateTextStyle style;
    private IMessageTemplateSubHead subHead;

    public static IMessageTemplateHead parse(JsonObject jsonObject) {
        JsonElement element;
        if (jsonObject == null) {
            return null;
        }
        IMessageTemplateHead templateHead = new IMessageTemplateHead();
        if (jsonObject.has("text") && (element = jsonObject.get("text")) != null) {
            templateHead.setText(element.getAsString());
        }
        if (jsonObject.has("style") && (element = jsonObject.get("style")) != null) {
            templateHead.setStyle(IMessageTemplateTextStyle.parse(element.getAsJsonObject()));
        }
        if (jsonObject.has("subHead") && (element = jsonObject.get("subHead")) != null) {
            templateHead.setSubHead(IMessageTemplateSubHead.parse(element.getAsJsonObject()));
        }
        return templateHead;
    }

    public void writeJson(JsonWriter writer) throws IOException {
        writer.beginObject();
        if (this.text != null) {
            writer.name("text").value(this.text);
        }
        if (this.style != null) {
            writer.name("style");
            this.style.writeJson(writer);
        }
        if (this.subHead != null) {
            writer.name("subHead");
            this.subHead.writeJson(writer);
        }
        writer.endObject();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public IMessageTemplateTextStyle getStyle() {
        return this.style;
    }

    public void setStyle(IMessageTemplateTextStyle style2) {
        this.style = style2;
    }

    public IMessageTemplateSubHead getSubHead() {
        return this.subHead;
    }

    public void setSubHead(IMessageTemplateSubHead subHead) {
        this.subHead = subHead;
    }
}

