/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.stabilility;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.PTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.WakeUpMessagesReceiver;
import com.zipow.videobox.ZMBaseService;
import com.zipow.videobox.util.LogUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class StabilityService
extends ZMBaseService {
    private static final String TAG = StabilityService.class.getSimpleName();
    public static final String ACTION_LOG_CRASH = StabilityService.class.getName() + ".ACTION_LOG_CRASH";
    public static final String ACTION_NEW_CRASH_INFO = StabilityService.class.getName() + ".ACTION_NEW_CRASH_INFO";
    public static final String ACTION_PROTECT_PT = StabilityService.class.getName() + ".ACTION_PROTECT_PT";
    public static final String ARG_MEM_CPU = "memCpu";
    public static final String ARG_MEETING_INFO = "meetingInfo";
    public static final String ARG_PID = "pid";
    public static final String ARG_BAA_SECURITY_ENABLED = "BAASecurityEnabled";
    private LogMonitorThread mLogMonitorThread;
    private ServiceConnection mPTServiceConnection;
    private IPTService mPTService;
    private String mLastCrashedInfo_memCpu = null;
    private String mLastCrashedInfo_meetingInfo = null;
    private int mLastCrashedInfo_pid = 0;
    private boolean mLastCrashInfo_BAASecurityEnabled = false;
    private boolean mbNeedProtectPT = false;

    @Override
    public void onCreate() {
        super.onCreate();
        VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
        if (videoBoxApplication == null) {
            VideoBoxApplication.initialize(this.getApplicationContext(), false, 2, null);
            return;
        }
        if (!VideoBoxApplication.getInstance().hasPTProcess() && VideoBoxApplication.getInstance().isWakeUpMessagesReceiverEnabled()) {
            this.wakeupPT();
        }
    }

    public IBinder onBind(Intent arg0) {
        return null;
    }

    @SuppressLint(value={"NewApi"})
    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        if (!this.mbNeedProtectPT) {
            this.disconnectPTService();
            this.stopSelf();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (!this.mbNeedProtectPT) {
            this.disconnectPTService();
            android.os.Process.killProcess((int)android.os.Process.myPid());
        }
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
        super.onStartCommand(intent, flags, startId);
        return this.doCommand(intent);
    }

    private int doCommand(Intent intent) {
        int ret = 2;
        if (intent == null) {
            return ret;
        }
        String action = intent.getAction();
        if (ACTION_LOG_CRASH.equals(action)) {
            this.startCrashLogger();
        } else if (ACTION_NEW_CRASH_INFO.equals(action)) {
            this.mLastCrashedInfo_memCpu = intent.getStringExtra(ARG_MEM_CPU);
            this.mLastCrashedInfo_meetingInfo = intent.getStringExtra(ARG_MEETING_INFO);
            this.mLastCrashedInfo_pid = intent.getIntExtra(ARG_PID, 0);
            this.mLastCrashInfo_BAASecurityEnabled = intent.getBooleanExtra(ARG_BAA_SECURITY_ENABLED, this.mLastCrashInfo_BAASecurityEnabled);
            this.startCrashLogger();
        } else if (ACTION_PROTECT_PT.equals(action)) {
            this.mbNeedProtectPT = true;
            ret = 1;
        }
        this.connectPTService();
        return ret;
    }

    private void connectPTService() {
        if (this.mPTServiceConnection == null) {
            this.mPTServiceConnection = new ServiceConnection(){

                public void onServiceConnected(ComponentName componentName, IBinder serviceBounder) {
                    IPTService service = IPTService.Stub.asInterface(serviceBounder);
                    StabilityService.this.onPTServiceConnected(service);
                }

                public void onServiceDisconnected(ComponentName name) {
                    StabilityService.this.onPTServiceDisconnected();
                }
            };
        }
        int flag = 0;
        if (this.mbNeedProtectPT) {
            flag |= 1;
        }
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), PTService.class.getName());
        this.bindService(i, this.mPTServiceConnection, flag);
    }

    private void disconnectPTService() {
        if (this.mPTServiceConnection != null) {
            try {
                this.unbindService(this.mPTServiceConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPTServiceConnection = null;
            this.mPTService = null;
        }
    }

    private void onPTServiceDisconnected() {
        this.mPTService = null;
        if (this.mbNeedProtectPT) {
            this.wakeupPT();
        }
    }

    private void wakeupPT() {
        Intent intent = new Intent(this.getApplicationContext(), WakeUpMessagesReceiver.class);
        intent.setAction(ACTION_PROTECT_PT);
        this.sendBroadcast(intent);
    }

    private void onPTServiceConnected(IPTService service) {
        this.mPTService = service;
    }

    private boolean startCrashLogger() {
        if (this.checkCallingOrSelfPermission("android.permission.READ_LOGS") != 0) {
            return false;
        }
        if (this.mLogMonitorThread == null || !this.mLogMonitorThread.isAlive()) {
            this.mLogMonitorThread = new LogMonitorThread(this);
            this.mLogMonitorThread.start();
        }
        return true;
    }

    public String getZoomProcessMemInfoInString(int pid) {
        if (pid > 0 && pid == this.mLastCrashedInfo_pid) {
            return this.mLastCrashedInfo_memCpu;
        }
        return null;
    }

    public String getZoomProcessMeetingInfoInString(int pid) {
        if (pid > 0 && pid == this.mLastCrashedInfo_pid) {
            return this.mLastCrashedInfo_meetingInfo;
        }
        return null;
    }

    static class WriteLogFileThread
    extends Thread {
        private long mStartTime = 0L;
        private ByteArrayOutputStream mBos = null;
        private BufferedWriter mWriter = null;
        private boolean mStopped = false;
        private int mPid = 0;
        private String mProcessType = "";
        private boolean mHasStackInfo = false;
        private boolean mStackEnd = false;
        private String mMeetingInfo = null;
        private String mMemInfo;
        private boolean mIsBAASecurityEnabled = false;

        public WriteLogFileThread(int pid, String processType, String meetingInfo, String memInfo, boolean isBAASecurityEnabled) {
            super(WriteLogFileThread.class.getSimpleName());
            this.mPid = pid;
            this.mProcessType = processType;
            this.mStartTime = System.currentTimeMillis();
            this.mMeetingInfo = meetingInfo;
            this.mMemInfo = memInfo;
            this.mIsBAASecurityEnabled = isBAASecurityEnabled;
            this.mBos = new ByteArrayOutputStream();
            this.mWriter = new BufferedWriter(new OutputStreamWriter(this.mBos));
        }

        public synchronized void writeLine(String str) {
            if (this.mWriter == null) {
                return;
            }
            if (!this.mHasStackInfo && str.indexOf("#00  pc") > 0) {
                this.mHasStackInfo = true;
            }
            if (!this.mStackEnd && str.indexOf("code around pc:") > 0) {
                this.mStackEnd = true;
            }
            try {
                this.mWriter.write(str);
                this.mWriter.write(10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isStopped() {
            return this.mStopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String dir;
            boolean stackEnd = false;
            int round = 0;
            do {
                try {
                    WriteLogFileThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                WriteLogFileThread writeLogFileThread = this;
                synchronized (writeLogFileThread) {
                    stackEnd = this.mStackEnd;
                }
            } while (!stackEnd && ++round < 3);
            String prefix = "crash-native-";
            File file = null;
            WriteLogFileThread writeLogFileThread = this;
            synchronized (writeLogFileThread) {
                if (this.mPid > 0) {
                    try {
                        android.os.Process.killProcess((int)this.mPid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.mWriter.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.mHasStackInfo) {
                    return;
                }
                if (this.mBos != null) {
                    file = LogUtil.writeCrashLogToFile("crash-native-", "-" + this.mProcessType + "-" + this.mPid + ".log", 4, this.mStartTime, this.mMeetingInfo, this.mMemInfo, this.mIsBAASecurityEnabled, this.mBos.toByteArray());
                }
                try {
                    if (this.mBos != null) {
                        this.mBos.close();
                    }
                    if (this.mWriter != null) {
                        this.mWriter.close();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.mBos = null;
                    this.mWriter = null;
                }
            }
            if (file != null && LogUtil.isSameCrashReported(dir = AppUtil.getLogParentPath() + "/logs", file, "crash-native-")) {
                file.renameTo(new File(file.getAbsolutePath() + ".sent"));
            }
            this.mStopped = true;
        }
    }

    static class LogMonitorThread
    extends Thread {
        private boolean mStopped = false;
        private StabilityService mService = null;
        private String crashLogKeyword = ">>> " + AppUtil.getAppPackageName();

        public LogMonitorThread(StabilityService service) {
            super(LogMonitorThread.class.getSimpleName());
            this.mService = service;
        }

        public void stopMonitor() {
            this.mStopped = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.mStopped) {
                this.monitor();
                try {
                    LogMonitorThread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void monitor() {
            InputStream is = null;
            BufferedReader reader = null;
            try {
                Runtime.getRuntime().exec(new String[]{"logcat", "-c"});
                LogMonitorThread.sleep(1000L);
                Process process = Runtime.getRuntime().exec(new String[]{"logcat", "-vthreadtime", "DEBUG:I *:S"});
                if (process == null) {
                    this.mStopped = true;
                    return;
                }
                is = process.getInputStream();
                if (is == null) {
                    this.mStopped = true;
                    return;
                }
                reader = new BufferedReader(new InputStreamReader(is));
                WriteLogFileThread writeLogThread = null;
                boolean bCrashDetected = false;
                do {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        return;
                    }
                    if (line.indexOf(this.crashLogKeyword) > 0) {
                        String pid = this.parsePid(line);
                        int iPid = 0;
                        try {
                            iPid = Integer.parseInt(pid);
                        }
                        catch (Exception e) {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                                if (reader == null) return;
                                reader.close();
                                return;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return;
                        }
                        String processType = this.parseProcessType(line);
                        String meetingInfo = null;
                        if ("zVideoApp".equals(processType) && this.mService != null) {
                            meetingInfo = this.mService.getZoomProcessMeetingInfoInString(iPid);
                        }
                        String memInfo = null;
                        boolean isBAASecurityEnabled = false;
                        if (this.mService != null) {
                            memInfo = this.mService.getZoomProcessMemInfoInString(iPid);
                            isBAASecurityEnabled = this.mService.mLastCrashInfo_BAASecurityEnabled;
                        }
                        bCrashDetected = true;
                        writeLogThread = new WriteLogFileThread(iPid, processType, meetingInfo, memInfo, isBAASecurityEnabled);
                        writeLogThread.start();
                    }
                    if (!bCrashDetected || writeLogThread == null) continue;
                    if (writeLogThread.isStopped()) {
                        bCrashDetected = false;
                        writeLogThread = null;
                        continue;
                    }
                    writeLogThread.writeLine(line);
                } while (!this.mStopped);
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        private String parsePid(String line) {
            if (line == null) {
                return "0";
            }
            int start = line.indexOf("pid:");
            if (start < 0) {
                return "0";
            }
            int end = line.indexOf(",", start += 4);
            if (end < 0) {
                end = line.indexOf(this.crashLogKeyword);
            }
            if (end < 0) {
                return "0";
            }
            String sPid = line.substring(start, end).trim();
            return sPid;
        }

        private String parseProcessType(String line) {
            if (line == null) {
                return "";
            }
            int start = line.indexOf(">>>");
            if (start < 0) {
                return "";
            }
            int end = line.indexOf("<<<", start += 4);
            if (end < 0) {
                return "";
            }
            String sPName = line.substring(start, end).trim();
            if (sPName.endsWith(":conf")) {
                return "zVideoApp";
            }
            return "zChatApp";
        }
    }
}

