/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.stabilility;

import android.app.Activity;
import android.database.sqlite.SQLiteDiskIOException;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import com.zipow.cmmlib.AppContext;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.SystemInfoHelper;
import com.zipow.videobox.stabilility.NativeCrashException;
import com.zipow.videobox.util.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.ZMLog;

public class JavaCrashHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = JavaCrashHandler.class.getSimpleName();
    private Thread.UncaughtExceptionHandler mNextHandler;
    private static boolean s_hasJavaThreadCrashed = false;
    private static String EXTRA_CRASH_INFO;
    private Handler mHandler = new Handler();

    public static boolean hasJavaThreadCrashed() {
        return s_hasJavaThreadCrashed;
    }

    public static void setJavaThreadCrashed() {
        s_hasJavaThreadCrashed = true;
    }

    public static void setExtraCrashInfo(String extraCrashInfo) {
        EXTRA_CRASH_INFO = extraCrashInfo;
    }

    public JavaCrashHandler(Thread.UncaughtExceptionHandler nextHandler) {
        this.mNextHandler = nextHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        String prefix;
        String dir;
        ZMActivity activity;
        File file;
        JavaCrashHandler.setJavaThreadCrashed();
        if (Mainboard.isNativeCrashed()) {
            if (this.mNextHandler != null) {
                this.mNextHandler.uncaughtException(thread, ex);
            }
            return;
        }
        if (ex instanceof UnsatisfiedLinkError || ex instanceof SQLiteDiskIOException) {
            if (this.mNextHandler != null) {
                this.mNextHandler.uncaughtException(thread, ex);
            }
            return;
        }
        if (VideoBoxApplication.getInstance().isConfApp()) {
            ZMActivity activity2 = ZMActivity.getFrontActivity();
            if (ConfUI.getInstance().isLeaveComplete() || activity2 instanceof ConfActivity && (activity2.isFinishing() || ZMActivity.isActivityDestroyed((Activity)activity2))) {
                Log.e((String)TAG, (String)"", (Throwable)ex);
                VideoBoxApplication.getInstance().stopConfService();
                return;
            }
        }
        int pid = Process.myPid();
        String pname = null;
        pname = VideoBoxApplication.getInstance().isConfApp() ? "zVideoApp" : (VideoBoxApplication.getInstance().isSipApp() ? "zSipApp" : "zChatApp");
        String codeLevel = "java-";
        if (ex instanceof NativeCrashException) {
            codeLevel = "native-zmdump-";
        }
        if ((file = LogUtil.getNewLogFile("crash-" + codeLevel, "-" + pname + "-" + pid + ".log", 5, System.currentTimeMillis())) == null) {
            if (this.mNextHandler != null) {
                this.mNextHandler.uncaughtException(thread, ex);
            }
            return;
        }
        PrintStream os = null;
        try {
            String[] meetingInfo = null;
            boolean isBAASecurityEnabled = AppContext.BAASecurity_IsEnabled();
            if (VideoBoxApplication.getInstance().isConfApp()) {
                Callable<String[]> callable = new Callable<String[]>(){

                    @Override
                    public String[] call() throws Exception {
                        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                        if (confContext != null) {
                            String meetingId = confContext.getMeetingId();
                            long meetingNumber = confContext.getConfNumber();
                            CmmUser user = ConfMgr.getInstance().getMyself();
                            long nodeId = user != null ? user.getNodeId() : 0L;
                            boolean baaSec = confContext.isBAASecurityMeeting();
                            String[] res = new String[]{meetingId, String.valueOf(meetingNumber), String.valueOf(nodeId), String.valueOf(baaSec)};
                            return res;
                        }
                        return null;
                    }
                };
                if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId()) {
                    meetingInfo = (String[])callable.call();
                } else {
                    FutureTask<String[]> task = new FutureTask<String[]>(callable);
                    this.mHandler.post(task);
                    try {
                        meetingInfo = task.get(3L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                    }
                }
            }
            if (meetingInfo != null && meetingInfo.length == 4) {
                isBAASecurityEnabled |= Boolean.valueOf((String)meetingInfo[3]).booleanValue();
            }
            os = new PrintStream(file);
            os.println("version: " + VideoBoxApplication.getInstance().getVersionName());
            os.println("Kernel Version: " + VideoBoxApplication.getInstance().getKernelVersion());
            os.println("OS: " + SystemInfoHelper.getOSInfo());
            if (!isBAASecurityEnabled) {
                os.println("Hardware: " + SystemInfoHelper.getHardwareInfo());
            }
            os.println("IsProcessAtFront: " + VideoBoxApplication.getInstance().isAtFront());
            os.println("Activity: " + ZMActivity.getFrontActivity());
            os.println("MemCPU: " + VideoBoxApplication.getMemoryCPUStatistics());
            if (!isBAASecurityEnabled && meetingInfo != null && meetingInfo.length == 4) {
                String meetingId = meetingInfo[0];
                String meetingNumber = meetingInfo[1];
                String nodeId = meetingInfo[2];
                StringBuilder sb = new StringBuilder();
                sb.append("MeetingId:").append(meetingId).append("; ").append("MeetingNo:").append(meetingNumber).append("; ").append("NodeId:").append(nodeId);
                os.println(sb.toString());
            }
            os.println();
            ex.printStackTrace(os);
        }
        catch (Exception e) {
            file.delete();
            file = null;
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception e) {}
            }
        }
        if (!(ex instanceof NativeCrashException) && (activity = ZMActivity.getFrontActivity()) != null) {
            String[] args = new String[]{"Fragment"};
            OutputStreamWriter fwr = null;
            BufferedWriter bwr = null;
            PrintWriter out = null;
            try {
                if (file != null) {
                    fwr = new FileWriter(file, true);
                    bwr = new BufferedWriter(fwr);
                    out = new PrintWriter(bwr);
                    out.println();
                    if (activity.getSupportFragmentManager() != null) {
                        activity.getSupportFragmentManager().dump("", new FileDescriptor(), out, args);
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (fwr != null) {
                    try {
                        fwr.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bwr != null) {
                    try {
                        bwr.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        if (file != null && LogUtil.isSameCrashReported(dir = AppUtil.getLogParentPath() + "/logs", file, prefix = "crash-" + codeLevel)) {
            file.renameTo(new File(file.getAbsolutePath() + ".sent"));
        }
        if (ex instanceof NativeCrashException) {
            VideoBoxApplication.getInstance().killCurrentProcess();
        } else if (this.mNextHandler != null) {
            this.mNextHandler.uncaughtException(thread, ex);
        }
    }
}

