/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sip.client;

import android.os.Process;
import android.os.RemoteException;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.VideoBoxApplication;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.NumberUtil;

public class SIPIPCPort {
    private static final String TAG = SIPIPCPort.class.getSimpleName();
    private static SIPIPCPort instance = null;
    private long mNativeHandle = 0L;
    private List<byte[]> mSendMessageBuff = new ArrayList<byte[]>();
    private List<byte[]> mReceiveMessageBuff = new ArrayList<byte[]>();

    private SIPIPCPort() {
    }

    public static synchronized SIPIPCPort getInstance() {
        if (instance == null) {
            instance = new SIPIPCPort();
        }
        return instance;
    }

    public void initialize() {
        this.nativeInit();
    }

    public boolean sendMessage(byte[] message) {
        if (message == null) {
            return false;
        }
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService == null) {
            this.mSendMessageBuff.add(message);
            return false;
        }
        boolean success = true;
        try {
            this.sendBufferedMessages(ptService);
            this.sendMessageImpl(message, ptService);
        }
        catch (Exception e) {
            this.mSendMessageBuff.add(message);
            success = false;
        }
        return success;
    }

    public void sendBufferedMessages() {
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService == null) {
            return;
        }
        try {
            this.sendBufferedMessages(ptService);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void sendBufferedMessages(IPTService ptService) throws RemoteException {
        if (this.mSendMessageBuff.size() > 0) {
            for (int i = this.mSendMessageBuff.size() - 1; i >= 0; --i) {
                byte[] msgTmp = this.mSendMessageBuff.get(i);
                this.sendMessageImpl(msgTmp, ptService);
                this.mSendMessageBuff.remove(i);
            }
        }
    }

    public synchronized void onMessageReceived(byte[] message) {
        if (message == null || message.length <= 4) {
            return;
        }
        int myPid = Process.myPid();
        int pid = NumberUtil.byteArrayToInt((byte[])message, (int)0);
        if (pid != myPid) {
            return;
        }
        if (this.mNativeHandle == 0L) {
            this.mReceiveMessageBuff.add(message);
            return;
        }
        try {
            this.onMessageReceivedImpl(this.mNativeHandle, message, 4);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public synchronized void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.receiveBufferedMessages();
    }

    private void receiveBufferedMessages() {
        if (this.mReceiveMessageBuff.size() > 0) {
            for (byte[] message : this.mReceiveMessageBuff) {
                try {
                    this.onMessageReceivedImpl(this.mNativeHandle, message, 4);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            this.mReceiveMessageBuff.clear();
        }
    }

    private void sendMessageImpl(byte[] message, IPTService ptService) throws RemoteException {
        try {
            int myPid = Process.myPid();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(NumberUtil.intToByteArray((int)myPid));
            os.write(message);
            byte[] buff = os.toByteArray();
            os.close();
            ptService.sendMessageFromSip(buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private native void nativeInit();

    private native void onMessageReceivedImpl(long var1, byte[] var3, int var4);
}

