/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sip;

import android.text.TextUtils;
import com.google.protobuf.InvalidProtocolBufferException;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.CallHistory;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;

public class CallHistoryMgr {
    private long mNativeHandle;
    private static final String TAG = CallHistoryMgr.class.getSimpleName();

    public CallHistoryMgr(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public List<CallHistory> getCallHistory(boolean isMissed) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] data = this.getCallHistoryImpl(this.mNativeHandle);
        if (data == null) {
            return null;
        }
        PTAppProtos.CallHistoryList list = null;
        try {
            list = PTAppProtos.CallHistoryList.parseFrom(data);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        if (list == null) {
            return null;
        }
        ArrayList<CallHistory> callList = new ArrayList<CallHistory>();
        for (int i = 0; i < list.getCallhistorysCount(); ++i) {
            PTAppProtos.CallHistoryProto pCall = list.getCallhistorys(i);
            if (isMissed) {
                int state = pCall.getState();
                if (pCall.getDirection() != 1 || state != 1 && state != 4) continue;
            }
            CallHistory call = new CallHistory();
            call.setCalleeJid(pCall.getCalleeJid());
            call.setCalleeUri(pCall.getCalleeUri());
            call.setCalleeDisplayName(pCall.getCalleeDisplayName());
            call.setCallerJid(pCall.getCallerJid());
            call.setCallerUri(pCall.getCallerUri());
            call.setCallerDisplayName(pCall.getCallerDisplayName());
            call.setId(pCall.getId());
            call.setNumber(pCall.getNumber());
            call.setState(pCall.getState());
            call.setTime(pCall.getTime());
            call.setTimeLong(pCall.getTimeLong());
            call.setType(pCall.getType());
            call.setDirection(pCall.getDirection());
            call.updateZOOMDisplayName();
            callList.add(call);
        }
        return callList;
    }

    public void insertZoomMeetingHistory(String meetingId, int callState, String jid, boolean isAudio, boolean isCallOut) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        CallHistory item = new CallHistory();
        item.setType(isAudio ? 2 : 1);
        item.setState(callState);
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        String name = BuddyNameUtil.getBuddyDisplayName(buddy, null);
        if (isCallOut) {
            item.setCalleeJid(jid);
            item.setDirection(2);
            item.setCalleeDisplayName(name);
        } else {
            item.setCallerJid(jid);
            item.setDirection(1);
            item.setCallerDisplayName(name);
        }
        item.setId(meetingId);
        item.setNumber(meetingId);
        item.setTime(CmmTime.getMMNow());
        this.addCallHistory(item);
    }

    public boolean clearAllCallHistory() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.clearAllCallHistoryImpl(this.mNativeHandle);
    }

    public boolean deleteCallHistory(String id2) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)id2)) {
            return false;
        }
        return this.deleteCallHistoryImpl(this.mNativeHandle, id2);
    }

    public boolean addCallHistory(CallHistory item) {
        if (this.mNativeHandle == 0L || item == null || StringUtil.isEmptyOrNull((String)item.getId())) {
            return false;
        }
        PTAppProtos.CallHistoryProto proto = this.itemToProto(item);
        if (proto == null) {
            return false;
        }
        return this.addCallHistoryImpl(this.mNativeHandle, proto.toByteArray());
    }

    public boolean addOrUpdateCallHistory(CallHistory item) {
        if (item == null || StringUtil.isEmptyOrNull((String)item.getId())) {
            return false;
        }
        String id2 = item.getId();
        if (this.hasHistoryWithIdImpl(this.mNativeHandle, id2)) {
            return this.updateCallHistory(item);
        }
        return this.addCallHistory(item);
    }

    public boolean addCallHistoryList(List<CallHistory> list) {
        if (this.mNativeHandle == 0L || CollectionsUtil.isListEmpty(list)) {
            return false;
        }
        PTAppProtos.CallHistoryList.Builder builder = PTAppProtos.CallHistoryList.newBuilder();
        for (CallHistory h : list) {
            PTAppProtos.CallHistoryProto proto = this.itemToProto(h);
            if (proto == null) continue;
            builder.addCallhistorys(proto);
        }
        return this.addCallHistoryListImpl(this.mNativeHandle, builder.build().toByteArray());
    }

    public boolean updateCallHistory(CallHistory item) {
        if (this.mNativeHandle == 0L || item == null || StringUtil.isEmptyOrNull((String)item.getId())) {
            return false;
        }
        PTAppProtos.CallHistoryProto proto = this.itemToProto(item);
        if (proto == null) {
            return false;
        }
        return this.updateCallHistoryImpl(this.mNativeHandle, proto.toByteArray());
    }

    private PTAppProtos.CallHistoryProto itemToProto(CallHistory item) {
        if (item == null) {
            return null;
        }
        try {
            PTAppProtos.CallHistoryProto.Builder builder = PTAppProtos.CallHistoryProto.newBuilder();
            if (item.getCalleeJid() != null) {
                builder.setCalleeJid(item.getCalleeJid());
            }
            if (item.getCalleeUri() != null) {
                builder.setCalleeUri(item.getCalleeUri());
            }
            if (item.getCalleeDisplayName() != null) {
                builder.setCalleeDisplayName(item.getCalleeDisplayName());
            }
            if (item.getCallerJid() != null) {
                builder.setCallerJid(item.getCallerJid());
            }
            if (item.getCallerUri() != null) {
                builder.setCallerUri(item.getCallerUri());
            }
            if (item.getCallerDisplayName() != null) {
                builder.setCallerDisplayName(item.getCallerDisplayName());
            }
            builder.setId(item.getId());
            builder.setNumber(item.getNumber());
            builder.setState(item.getState());
            builder.setTime(item.getTime());
            builder.setTimeLong(item.getTimeLong());
            builder.setType(item.getType());
            builder.setDirection(item.getDirection());
            return builder.build();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getMissedCallInCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getMissedCallInCountImpl(this.mNativeHandle);
    }

    public boolean clearMissedCallIn() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.clearMissedCallInImpl(this.mNativeHandle);
    }

    public CallHistory getCallHistoryByID(String callID) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)callID)) {
            return null;
        }
        byte[] data = this.getCallHistoryByIDImpl(this.mNativeHandle, callID);
        if (data == null || data.length <= 0) {
            return null;
        }
        PTAppProtos.CallHistoryProto pCall = null;
        try {
            pCall = PTAppProtos.CallHistoryProto.parseFrom(data);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        if (pCall == null) {
            return null;
        }
        CallHistory call = new CallHistory();
        call.setCalleeJid(pCall.getCalleeJid());
        call.setCalleeUri(pCall.getCalleeUri());
        call.setCalleeDisplayName(pCall.getCalleeDisplayName());
        call.setCallerJid(pCall.getCallerJid());
        call.setCallerUri(pCall.getCallerUri());
        call.setCallerDisplayName(pCall.getCallerDisplayName());
        call.setId(pCall.getId());
        call.setNumber(pCall.getNumber());
        call.setState(pCall.getState());
        call.setTime(pCall.getTime());
        call.setTimeLong(pCall.getTimeLong());
        call.setType(pCall.getType());
        call.setDirection(pCall.getDirection());
        call.updateZOOMDisplayName();
        return call;
    }

    private native byte[] getCallHistoryImpl(long var1);

    private native byte[] getAllMissedCallInImpl(long var1);

    private native boolean clearAllCallHistoryImpl(long var1);

    private native boolean deleteCallHistoryImpl(long var1, String var3);

    private native boolean addCallHistoryImpl(long var1, byte[] var3);

    private native boolean addCallHistoryListImpl(long var1, byte[] var3);

    private native boolean updateCallHistoryImpl(long var1, byte[] var3);

    private native int getMissedCallInCountImpl(long var1);

    private native boolean clearMissedCallInImpl(long var1);

    private native boolean hasHistoryWithIdImpl(long var1, String var3);

    private native byte[] getCallHistoryByIDImpl(long var1, String var3);
}

