/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sip;

import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.io.Serializable;
import us.zoom.androidlib.util.StringUtil;

public class CallHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int type;
    private String id;
    private String number;
    private String callerUri;
    private String callerJid;
    private String callerDisplayName;
    private String calleeUri;
    private String calleeJid;
    private String calleeDisplayName;
    private long time;
    private int state;
    private long timeLong;
    private int direction;
    private String mZOOMDisplayName;
    private String buddyJid;

    public CallHistory() {
    }

    public CallHistory(int type, String id2, String number, String callerUri, String callerJid, String callerDisplayName, String calleeUri, String calleeJid, String calleeDisplayName, long time, int state, long timeLong, int direction) {
        this.type = type;
        this.id = id2;
        this.calleeDisplayName = calleeDisplayName;
        this.calleeJid = calleeJid;
        this.calleeUri = callerUri;
        this.callerDisplayName = callerDisplayName;
        this.callerJid = callerJid;
        this.callerUri = callerUri;
        this.time = time;
        this.state = state;
        this.timeLong = timeLong;
        this.direction = direction;
        this.number = number;
    }

    public void updateZOOMDisplayName() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (this.type == 2 || this.type == 1) {
            String jid = this.direction == 1 ? this.callerJid : this.calleeJid;
            if (StringUtil.isEmptyOrNull((String)jid)) {
                return;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null) {
                return;
            }
            this.buddyJid = buddy.getJid();
            this.mZOOMDisplayName = BuddyNameUtil.getBuddyDisplayName(buddy, null);
        } else {
            if (StringUtil.isEmptyOrNull((String)this.number)) {
                return;
            }
            ZoomBuddy buddy = messenger.getBuddyWithSipPhone(this.number);
            if (buddy == null) {
                return;
            }
            this.buddyJid = buddy.getJid();
            this.mZOOMDisplayName = BuddyNameUtil.getBuddyDisplayName(buddy, null);
        }
    }

    public String getZOOMDisplayName() {
        if (StringUtil.isEmptyOrNull((String)this.mZOOMDisplayName)) {
            return this.direction == 1 ? this.callerDisplayName : this.calleeDisplayName;
        }
        return this.mZOOMDisplayName;
    }

    public String getBuddyJid() {
        return this.buddyJid;
    }

    public String getCallerUri() {
        return this.callerUri;
    }

    public void setCallerUri(String callerUri) {
        this.callerUri = callerUri;
    }

    public String getCallerJid() {
        return this.callerJid;
    }

    public void setCallerJid(String callerJid) {
        this.callerJid = callerJid;
    }

    public String getCalleeUri() {
        return this.calleeUri;
    }

    public void setCalleeUri(String calleeUri) {
        this.calleeUri = calleeUri;
    }

    public String getCalleeJid() {
        return this.calleeJid;
    }

    public void setCalleeJid(String calleeJid) {
        this.calleeJid = calleeJid;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getCallerDisplayName() {
        return this.callerDisplayName;
    }

    public void setCallerDisplayName(String callerDisplayName) {
        this.callerDisplayName = callerDisplayName;
    }

    public String getCalleeDisplayName() {
        return this.calleeDisplayName;
    }

    public void setCalleeDisplayName(String calleeDisplayName) {
        this.calleeDisplayName = calleeDisplayName;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public long getTimeLong() {
        return this.timeLong;
    }

    public void setTimeLong(long timeLong) {
        this.timeLong = timeLong;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

