/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.provider.MediaStore;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zipow.annotate.AnnotateDrawingView;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.share.IShareServer;
import com.zipow.videobox.share.IShareView;
import com.zipow.videobox.share.Point;
import com.zipow.videobox.share.ShareBaseView;
import com.zipow.videobox.share.ShareException;
import com.zipow.videobox.share.ShareImageView;
import com.zipow.videobox.share.SharePDFView;
import com.zipow.videobox.share.ShareServerImpl;
import com.zipow.videobox.share.ShareWebView;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ShareView
extends FrameLayout
implements IShareView,
ShareBaseView.IShareBaseViewListener {
    private Context mContext;
    private Handler mHandler;
    private IShareServer mShareServer;
    private GestureDetector mGestureDetector;
    private FrameLayout mShareContainer;
    private ImageView mToolbarBtn;
    private ShareBaseView mContentView;
    private ShareBaseView mDrawingView;
    private Bitmap mCachedBitmap;
    private Canvas mCachedCanvas;
    private int mCacheW = 0;
    private int mCacheH = 0;
    private boolean mAutoCapture = false;
    private boolean mStopped = false;
    private ShareViewListener shareListener;
    private Point mDrawingBtnLastPos = null;
    private int mLeft = 0;
    private int mBottom = 0;
    private boolean mbHasBottomBar = false;
    private boolean mbEditStatus = false;
    private boolean mbAnnoationEnable = false;
    private boolean mbSharing = true;
    private boolean mbAnnotateBtnCanVisible = false;
    private boolean mbAnnotateStart = false;
    private static final String TAG = ShareView.class.getSimpleName();

    public ShareView(Context context) {
        super(context);
        this.init(context);
    }

    public ShareView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mHandler = new Handler();
        if (!this.isInEditMode()) {
            this.mShareServer = new ShareServerImpl(this.mHandler);
        }
        View view = LayoutInflater.from((Context)context).inflate(R.layout.zm_sharinglayout, null, false);
        this.mShareContainer = (FrameLayout)view.findViewById(R.id.shareContainer);
        this.mToolbarBtn = (ImageView)view.findViewById(R.id.btnDrawing);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GuestureListener());
        this.mGestureDetector.setIsLongpressEnabled(false);
        this.mToolbarBtn.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                ShareView.this.refreshUI();
                return ShareView.this.mGestureDetector.onTouchEvent(event);
            }
        });
        this.mToolbarBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
            }
        });
        this.addView(view);
        if (!this.isInEditMode()) {
            this.mDrawingView = new AnnotateDrawingView(this.mContext);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            this.mDrawingView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.mDrawingView.setShareBaseViewListener(this);
        }
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mLeft = left;
        this.mBottom = bottom;
        super.onLayout(changed, left, top, right, bottom);
        this.refreshUI();
        this.onRepaint();
    }

    public void start() {
        this.mDrawingView.setIsPresenter(true);
        this.mShareServer.setCacheView(this);
        try {
            this.mShareServer.startShare(this.mAutoCapture);
        }
        catch (ShareException shareException) {
            // empty catch block
        }
        this.refreshUI();
    }

    public void pause() {
        this.mShareServer.pauseShare();
        this.refreshUI();
        if (this.mbEditStatus) {
            this.mDrawingView.pause();
            this.mDrawingView.closeAnnotateView();
        }
    }

    public void resume() {
        this.mShareServer.resumeShare();
        this.refreshUI();
    }

    public void stop() {
        this.mAutoCapture = false;
        this.mShareContainer.removeView((View)this.mDrawingView);
        this.mShareServer.endShare();
        if (this.mbAnnotateStart) {
            this.mDrawingView.setIsPresenter(false);
            this.mDrawingView.stopAnnotation();
            this.mbAnnotateStart = false;
        }
        this.release();
    }

    public void setAnnotationEnable(boolean enable) {
        this.mbAnnoationEnable = enable;
        this.setAnnoBtnCanVisible();
        if (!this.mbAnnoationEnable) {
            this.mDrawingView.notifyCloseView();
        }
        this.setAnnotateBtnVisible();
        this.closeTableView();
    }

    public void setSharePauseStatuChanged(boolean bPaused) {
        this.mbSharing = !bPaused;
        this.setAnnoBtnCanVisible();
        this.setAnnotateBtnVisible();
        this.closeTableView();
    }

    public void onAnnotateViewSizeChanged() {
        this.mDrawingView.onAnnotateViewSizeChanged();
    }

    private void onRepaint() {
        this.mShareServer.onRepaint();
    }

    private void release() {
        this.mDrawingView.stop();
        if (this.mContentView != null) {
            this.mContentView.stop();
        }
        this.mContentView = null;
        this.mCacheW = 0;
        this.mCacheH = 0;
        this.setEidtModel(false);
        this.mShareContainer.removeAllViews();
    }

    public boolean setImageUri(Uri uri) {
        ShareImageView shareview = new ShareImageView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
        shareview.setShareBaseViewListener(this);
        boolean ret = shareview.setImageUri(uri);
        if (!ret) {
            return false;
        }
        this.mbHasBottomBar = false;
        this.mDrawingBtnLastPos = null;
        this.mContentView = shareview;
        this.mShareContainer.addView((View)shareview);
        this.mAutoCapture = false;
        return true;
    }

    public boolean setImageBitmap(Bitmap bmp) {
        ShareImageView shareview = new ShareImageView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
        shareview.setShareBaseViewListener(this);
        boolean ret = shareview.setImageBitmap(bmp);
        if (!ret) {
            return false;
        }
        this.mbHasBottomBar = false;
        this.mDrawingBtnLastPos = null;
        this.mContentView = shareview;
        this.mShareContainer.addView((View)shareview);
        this.mAutoCapture = false;
        return true;
    }

    public boolean setWhiteboardBackground() {
        ShareImageView shareview = new ShareImageView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
        shareview.setShareBaseViewListener(this);
        shareview.showWhiteboard();
        this.mbHasBottomBar = false;
        this.mDrawingBtnLastPos = null;
        this.mContentView = shareview;
        this.mShareContainer.addView((View)shareview);
        this.mAutoCapture = false;
        return true;
    }

    public boolean setUrl(String url) {
        return this.setUrl(url, true);
    }

    public boolean setUrl(String url, boolean isBookmarkBtnVisible) {
        ShareWebView shareview = new ShareWebView(this.mContext);
        shareview.setBookmarkBtnVisibility(isBookmarkBtnVisible);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
        shareview.setShareBaseViewListener(this);
        boolean success = shareview.setWebUrl(url);
        if (!success) {
            return false;
        }
        this.mbHasBottomBar = false;
        this.mDrawingBtnLastPos = null;
        this.mContentView = shareview;
        this.mShareContainer.addView((View)shareview);
        this.mAutoCapture = true;
        return true;
    }

    public boolean setPdf(String filePath, String password) {
        SharePDFView shareview = new SharePDFView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        shareview.setLayoutParams((ViewGroup.LayoutParams)lp);
        shareview.setShareBaseViewListener(this);
        boolean success = shareview.setPdfFile(filePath, password);
        if (!success) {
            return false;
        }
        this.mbHasBottomBar = shareview.hasBottomBar();
        this.mDrawingBtnLastPos = null;
        this.mContentView = shareview;
        this.mShareContainer.addView((View)shareview);
        this.mAutoCapture = false;
        return true;
    }

    private boolean isDrawingViewVisible() {
        int count = this.mShareContainer.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.mShareContainer.getChildAt(i);
            if (view != this.mDrawingView) continue;
            return true;
        }
        return false;
    }

    private boolean isContentViewVisible() {
        if (this.mContentView == null) {
            return false;
        }
        int count = this.mShareContainer.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.mShareContainer.getChildAt(i);
            if (view != this.mContentView) continue;
            return true;
        }
        return false;
    }

    private void checkCachedSize() {
        if (this.mShareContainer == null || this.mContentView == null) {
            return;
        }
        int count = this.mShareContainer.getChildCount();
        if (count <= 0) {
            return;
        }
        this.mCacheW = this.mContentView.getShareContentWidth();
        this.mCacheH = this.mContentView.getShareContentHeight();
    }

    private void destroyCachedBitmap() {
        if (this.mCachedBitmap != null) {
            this.mCachedBitmap.recycle();
            this.mCachedBitmap = null;
        }
        this.mCachedCanvas = null;
    }

    private boolean checkCacheBitmap() {
        this.checkCachedSize();
        if (this.mCacheW <= 0 || this.mCacheH <= 0) {
            return false;
        }
        if (this.mCachedBitmap != null && (this.mCachedBitmap.getWidth() != this.mCacheW || this.mCachedBitmap.getHeight() != this.mCacheH)) {
            this.destroyCachedBitmap();
        }
        if (this.mCachedBitmap == null) {
            try {
                this.mCachedBitmap = Bitmap.createBitmap((int)this.mCacheW, (int)this.mCacheH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError e) {
                this.notifyError();
                return false;
            }
            if (this.mCachedBitmap == null) {
                return false;
            }
            this.mCachedCanvas = new Canvas(this.mCachedBitmap);
        }
        return true;
    }

    private void notifyError() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ShareView.this.shareListener != null) {
                    ShareView.this.shareListener.onShareError();
                }
            }
        });
    }

    @Override
    public Bitmap getCacheDrawingView() {
        if (this.mStopped) {
            return null;
        }
        boolean success = this.checkCacheBitmap();
        if (!success) {
            return null;
        }
        if (this.isContentViewVisible()) {
            this.mContentView.drawShareContent(this.mCachedCanvas);
        }
        if (this.isDrawingViewVisible()) {
            this.mDrawingView.drawShareContent(this.mCachedCanvas);
        }
        return this.mCachedBitmap;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean done = false;
        switch (requestCode) {
            case 1006: {
                String url;
                Bundle bundle;
                if (resultCode == -1 && data != null && (bundle = data.getExtras()) != null && (url = bundle.getString("bookmark_url")) != null && !url.isEmpty()) {
                    this.setUrl(url);
                }
                done = true;
            }
        }
        return done;
    }

    public void setShareListener(ShareViewListener shareListener) {
        this.shareListener = shareListener;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (!this.isDrawingViewVisible() && this.mContentView instanceof ShareWebView) {
            boolean handle = this.mContentView.handleKeydown(keyCode, event);
            if (handle) {
                this.onRepaint();
            }
            return handle;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void showDrawingView() {
        if (!this.isDrawingViewVisible()) {
            this.mShareContainer.addView((View)this.mDrawingView);
        }
    }

    private void hideDrawingView() {
        if (this.mDrawingView == null) {
            return;
        }
        if (this.mContentView != null) {
            this.mContentView.setDrawingMode(false);
        }
        this.setEidtModel(false);
    }

    protected void switchToEditMode() {
        this.showDrawingView();
        this.setEidtModel(true);
        if (this.shareListener != null) {
            this.shareListener.onStartEdit();
        }
        this.mbAnnotateBtnCanVisible = false;
        this.refreshUI();
        if (this.mContentView != null) {
            this.mContentView.setDrawingMode(true);
        }
        this.mbAnnotateStart = true;
        this.mDrawingView.startAnnotation();
    }

    public void refreshUI() {
        this.setAnnotateBtnVisible();
        this.reLayoutDrawingBtn();
    }

    private void reLayoutDrawingBtn() {
        int y;
        int x;
        if (this.mDrawingBtnLastPos == null) {
            if (!this.mbHasBottomBar) {
                return;
            }
            x = this.mLeft + UIUtil.dip2px((Context)this.mContext, (float)30.0f);
            y = this.mBottom - UIUtil.dip2px((Context)this.mContext, (float)46.0f);
        } else {
            x = (int)((float)this.mLeft + this.mDrawingBtnLastPos.getX());
            y = (int)((float)this.mBottom + this.mDrawingBtnLastPos.getY());
        }
        int left = x - this.mToolbarBtn.getWidth() / 2;
        int top = y - this.mToolbarBtn.getHeight();
        int bottom = top + this.mToolbarBtn.getHeight();
        int right = left + this.mToolbarBtn.getWidth();
        if (left < this.mShareContainer.getLeft()) {
            left = this.mShareContainer.getLeft();
            right = left + this.mToolbarBtn.getWidth();
        }
        if (right > this.mShareContainer.getRight()) {
            right = this.mShareContainer.getRight();
            left = right - this.mToolbarBtn.getWidth();
        }
        if (top < this.mShareContainer.getTop()) {
            top = this.mShareContainer.getTop();
            bottom = top + this.mToolbarBtn.getHeight();
        }
        if (bottom > this.mShareContainer.getBottom()) {
            bottom = this.mShareContainer.getBottom();
            top = bottom - this.mToolbarBtn.getHeight();
        }
        this.mToolbarBtn.layout(left, top, right, bottom);
    }

    @Override
    public void onSavePhoto(ShareBaseView view) {
        if (null != this.mCachedBitmap) {
            MediaStore.Images.Media.insertImage((ContentResolver)this.getContext().getContentResolver(), (Bitmap)this.mCachedBitmap, (String)"title", (String)"description");
        }
    }

    @Override
    public void onRepaint(ShareBaseView view) {
        this.onRepaint();
    }

    @Override
    public void onCloseView(ShareBaseView view) {
        if (view == null) {
            return;
        }
        if (view instanceof AnnotateDrawingView) {
            this.mToolbarBtn.setVisibility(0);
            this.hideDrawingView();
        }
        if (this.shareListener != null) {
            this.shareListener.onStopEdit();
        }
        this.setEidtModel(false);
        this.setAnnoBtnCanVisible();
    }

    public void stopAnnotation() {
        if (this.mbEditStatus) {
            this.mDrawingView.closeAnnotateView();
        }
    }

    public void unregisterAnnotateListener() {
        if (null != this.mDrawingView) {
            this.mDrawingView.unregisterAnnotateListener();
        }
    }

    public void otherStartShare() {
        this.mDrawingView.setIsPresenter(false);
    }

    private void setEidtModel(boolean bEidt) {
        this.mbEditStatus = bEidt;
        this.mDrawingView.setEidtModel(bEidt);
    }

    public void showAnnotateOnMyShareStart() {
        if (this.mShareContainer == null || this.mDrawingView == null) {
            return;
        }
        this.mShareContainer.removeView((View)this.mDrawingView);
        this.showDrawingView();
        this.mDrawingView.setVisibility(0);
        this.mDrawingView.setIsPresenter(true);
        this.mDrawingView.startAnnotation();
    }

    private void setAnnotateBtnVisible() {
        if (this.mbAnnotateBtnCanVisible) {
            this.mToolbarBtn.setVisibility(0);
        } else {
            this.mToolbarBtn.setVisibility(8);
        }
    }

    private void closeTableView() {
        if (!this.mbAnnoationEnable || !this.mbSharing) {
            this.mDrawingView.closeTableView();
        }
    }

    private void setAnnoBtnCanVisible() {
        this.mbAnnotateBtnCanVisible = this.mbAnnoationEnable && this.mbSharing && !this.mbEditStatus && !ConfMgr.getInstance().isViewOnlyMeeting();
    }

    public void setToolbarBtnPosition(int offsetX, int offsetY) {
        if (this.mDrawingBtnLastPos == null) {
            this.mDrawingBtnLastPos = new Point(offsetX, offsetY);
        } else {
            this.mDrawingBtnLastPos.setX(offsetX);
            this.mDrawingBtnLastPos.setY(offsetY);
        }
        this.refreshUI();
    }

    private class GuestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onSingleTapUp(MotionEvent e) {
            ShareView.this.switchToEditMode();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            Rect outBound = new Rect();
            ShareView.this.mShareContainer.getDrawingRect(outBound);
            float offsetX = e2.getRawX() - (float)ShareView.this.mLeft;
            float offsetY = e2.getRawY() - (float)ShareView.this.mBottom;
            if (ShareView.this.mDrawingBtnLastPos == null) {
                ShareView.this.mDrawingBtnLastPos = new Point(offsetX, offsetY);
            } else {
                ShareView.this.mDrawingBtnLastPos.setX(offsetX);
                ShareView.this.mDrawingBtnLastPos.setY(offsetY);
            }
            ShareView.this.refreshUI();
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }
    }

    public static interface ShareViewListener {
        public void onStopEdit();

        public void onStartEdit();

        public void onShareError();
    }
}

