/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.graphics.Bitmap;
import android.os.Handler;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.share.IShareServer;
import com.zipow.videobox.share.IShareView;

public class ShareServerImpl
implements IShareServer {
    private static final String TAG = ShareServerImpl.class.getSimpleName();
    private IShareView cacheView;
    private transient boolean doRunning = false;
    private Handler mHandler;
    private Runnable mShareServerRunnable;
    private boolean bAutoCapture = true;
    private static final int INTERVAL_TIME = 500;

    public ShareServerImpl(Handler handler) {
        this.mHandler = handler;
        this.mShareServerRunnable = this.createShareServerRunnable();
    }

    private boolean translateBitmap(Bitmap bitmap) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        boolean success = shareSession.setCaptureFrame(bitmap);
        return success;
    }

    private Runnable createShareServerRunnable() {
        Runnable shareRunnable = new Runnable(){

            @Override
            public void run() {
                ShareServerImpl.this.doShareFrame();
                if (ShareServerImpl.this.doRunning && ShareServerImpl.this.mHandler != null && ShareServerImpl.this.bAutoCapture) {
                    ShareServerImpl.this.mHandler.postDelayed(ShareServerImpl.this.mShareServerRunnable, 500L);
                }
            }
        };
        return shareRunnable;
    }

    @Override
    public void startShare(boolean autoCapture) {
        this.bAutoCapture = autoCapture;
        this.startShareServer();
    }

    private void startShareServer() {
        this.doRunning = true;
        if (this.mShareServerRunnable == null) {
            this.mShareServerRunnable = this.createShareServerRunnable();
        }
        this.mHandler.post(this.mShareServerRunnable);
    }

    @Override
    public void pauseShare() {
        this.doRunning = false;
    }

    @Override
    public void endShare() {
        if (this.mShareServerRunnable != null) {
            this.mHandler.removeCallbacks(this.mShareServerRunnable);
        }
        this.doRunning = false;
        this.mShareServerRunnable = null;
    }

    @Override
    public void setCacheView(IShareView shareView) {
        this.cacheView = shareView;
    }

    private boolean doShareFrame() {
        Bitmap bitmap = null;
        if (this.cacheView != null) {
            bitmap = this.cacheView.getCacheDrawingView();
        }
        if (bitmap != null) {
            return this.translateBitmap(bitmap);
        }
        return false;
    }

    @Override
    public boolean isShared() {
        return this.doRunning;
    }

    @Override
    public void resumeShare() {
        this.startShareServer();
    }

    @Override
    public void onRepaint() {
        if (this.doRunning) {
            if (this.mShareServerRunnable == null) {
                this.mShareServerRunnable = this.createShareServerRunnable();
            }
            this.mHandler.removeCallbacks(this.mShareServerRunnable);
            this.mHandler.post(this.mShareServerRunnable);
        }
    }
}

