/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.zipow.videobox.pdf.PDFView;
import com.zipow.videobox.share.ShareBaseView;
import us.zoom.videomeetings.R;

public class SharePDFView
extends ShareBaseView
implements PDFView.PDFViewListener {
    private static final String TAG = SharePDFView.class.getSimpleName();
    private PDFView mPDFView;
    private boolean mSuccess = false;
    private View mToolbar;

    public SharePDFView(Context context) {
        super(context);
        this.init(context);
    }

    public SharePDFView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SharePDFView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.zm_share_pdf_view, null, false);
        this.mPDFView = (PDFView)view.findViewById(R.id.pdfPage);
        this.mToolbar = view.findViewById(R.id.sharePdfToolbar);
        if (this.mPDFView != null) {
            this.mPDFView.setListener(this);
        }
        this.addView(view);
    }

    public boolean setPdfFile(String filePath, String password) {
        this.mSuccess = this.mPDFView.setPdfFile(filePath, password);
        return this.mSuccess;
    }

    @Override
    public void stop() {
        if (!this.mSuccess) {
            return;
        }
        this.mPDFView.closeFile();
    }

    @Override
    public void drawShareContent(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        View pageView = this.mPDFView.getPageContent();
        if (pageView != null) {
            pageView.draw(canvas);
        }
    }

    @Override
    public int getShareContentWidth() {
        return this.mPDFView.getPageWidth();
    }

    @Override
    public int getShareContentHeight() {
        return this.mPDFView.getPageHeight();
    }

    @Override
    public void setDrawingMode(boolean flag) {
        if (flag) {
            this.mToolbar.setVisibility(0);
            this.mPDFView.setSeekBarVisible(4);
        } else {
            this.mToolbar.setVisibility(8);
        }
    }

    @Override
    public void setDrawingModeForSDK(boolean flag) {
        if (flag) {
            this.mPDFView.setSeekBarVisible(4);
        }
        this.mToolbar.setVisibility(8);
    }

    public boolean hasBottomBar() {
        return this.mPDFView.needShowSeekBar();
    }

    @Override
    public void onPDFViewPageChanged() {
        this.notifyRefresh();
    }

    @Override
    public void onPDFViewClicked() {
    }
}

