/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.zipow.videobox.share.ShareBaseView;
import com.zipow.videobox.util.ImageUtil;
import us.zoom.androidlib.widget.TouchImageView;
import us.zoom.videomeetings.R;

public class ShareImageView
extends ShareBaseView
implements TouchImageView.OnViewPortChangedListener {
    public static final int MAX_IMAGE_WIDTH_HEIGHT = 1280;
    private Context mContext;
    private TouchImageView mImage;
    private Uri mUri;
    private Bitmap mBitmap;
    private View mToolbar;

    public ShareImageView(Context context) {
        super(context);
        this.init(context);
    }

    public ShareImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ShareImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.zm_share_image_view, null, false);
        this.mImage = (TouchImageView)view.findViewById(R.id.imageview);
        this.mToolbar = view.findViewById(R.id.shareImageToolbar);
        this.mImage.setOnViewPortChangedListener((TouchImageView.OnViewPortChangedListener)this);
        this.addView(view);
    }

    public boolean setImageUri(Uri uri) {
        if (uri == null) {
            return false;
        }
        this.mUri = uri;
        String imagePath = ImageUtil.getPathFromUri(this.mContext, uri);
        if (!ImageUtil.isValidImageFile(imagePath)) {
            return false;
        }
        Bitmap bmp = ImageUtil.translateImageAsSmallBitmap(this.getContext(), imagePath, 1280, false);
        return this.setImageBitmap(bmp);
    }

    public boolean setImageBitmap(Bitmap bmp) {
        if (bmp == null) {
            return false;
        }
        this.mBitmap = bmp;
        this.mImage.setImageBitmap(this.mBitmap);
        return true;
    }

    public boolean showWhiteboard() {
        this.mImage.setBackgroundColor(-1);
        return true;
    }

    @Override
    public void drawShareContent(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        this.mImage.draw(canvas);
    }

    @Override
    public int getShareContentWidth() {
        return this.mImage.getWidth();
    }

    @Override
    public int getShareContentHeight() {
        return this.mImage.getHeight();
    }

    public void onViewPortChanged() {
        this.notifyRefresh();
    }

    @Override
    public void setDrawingMode(boolean flag) {
        if (flag) {
            this.mToolbar.setVisibility(0);
        } else {
            this.mToolbar.setVisibility(8);
        }
    }

    @Override
    public void setDrawingModeForSDK(boolean flag) {
        this.mToolbar.setVisibility(8);
    }
}

