/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.SeekBar;
import android.widget.TextView;
import com.zipow.videobox.share.ColorSelectedImage;
import com.zipow.videobox.share.ColorTable;
import com.zipow.videobox.share.DrawingView;
import com.zipow.videobox.share.IColorChangedListener;
import com.zipow.videobox.share.IDrawingViewListener;
import com.zipow.videobox.share.ShareBaseView;
import com.zipow.videobox.view.ToolbarButton;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ShareDrawingView
extends ShareBaseView
implements IColorChangedListener,
IDrawingViewListener,
View.OnClickListener {
    private DrawingView mDrawingView;
    private ImageView mCloseBtn;
    private View mToolbars;
    private int mLineWidth = 2;
    private ColorTable mColorTable;
    private TextView txtLineWidth;
    private PopupWindow mColorTableView;
    private SeekBar mLineWidthSeekBar;
    private ToolbarButton mSpotlight;
    private ToolbarButton mHighlight;
    private ToolbarButton mPen;
    private ToolbarButton mErase;
    private View mColorIndicator;
    private ColorSelectedImage mColorImage;

    public ShareDrawingView(Context context) {
        super(context);
        this.init(context);
    }

    public ShareDrawingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ShareDrawingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.zm_share_draw_view, null, false);
        this.mDrawingView.registerUpdateListener(this);
        this.mDrawingView.setEnabled(true);
        this.mLineWidth = this.mDrawingView.getCurrentWidth();
        this.mCloseBtn = (ImageView)view.findViewById(R.id.shareEditBtn);
        this.mCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                ShareDrawingView.this.notifyCloseView();
            }
        });
        this.mSpotlight = (ToolbarButton)view.findViewById(R.id.btnSpotlight);
        this.mHighlight = (ToolbarButton)view.findViewById(R.id.btnHighlight);
        this.mPen = (ToolbarButton)view.findViewById(R.id.btnPen);
        this.mErase = (ToolbarButton)view.findViewById(R.id.btnErase);
        this.mColorIndicator = view.findViewById(R.id.btnColorIndicator);
        this.mColorImage = (ColorSelectedImage)this.mColorIndicator.findViewById(R.id.colorImage);
        this.mSpotlight.setOnClickListener(this);
        this.mHighlight.setOnClickListener(this);
        this.mPen.setOnClickListener(this);
        this.mErase.setOnClickListener(this);
        this.mColorIndicator.setOnClickListener((View.OnClickListener)this);
        this.mToolbars = view.findViewById(R.id.drawingtools);
        View contentView = ShareDrawingView.inflate((Context)this.getContext(), (int)R.layout.zm_annocolorlayout, null);
        this.mColorTableView = new PopupWindow(contentView, -1, UIUtil.dip2px((Context)context, (float)100.0f));
        this.mColorTable = (ColorTable)contentView.findViewById(R.id.colorTable);
        this.txtLineWidth = (TextView)contentView.findViewById(R.id.txtLineWidth);
        this.mColorTableView.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.zm_transparent));
        this.mColorTableView.setContentView(contentView);
        this.mColorTableView.setFocusable(true);
        this.mColorTableView.setOutsideTouchable(true);
        this.mColorTable.setOnColorChangedListener(this);
        this.mLineWidthSeekBar = (SeekBar)contentView.findViewById(R.id.seekbar);
        this.mLineWidthSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar arg0) {
                ShareDrawingView.this.mDrawingView.setCurrentWidth(65535, ShareDrawingView.this.mLineWidth);
            }

            public void onStartTrackingTouch(SeekBar arg0) {
            }

            public void onProgressChanged(SeekBar arg0, int value, boolean arg2) {
                ShareDrawingView.this.mLineWidth = value > 0 ? value : 1;
                ShareDrawingView.this.updateLineWidthPromt();
            }
        });
        this.updateSelection();
        this.addView(view);
    }

    private void updateSelection() {
        switch (this.mDrawingView.getCurrentMode()) {
            case 1: {
                this.mSpotlight.setSelected(true);
                this.mHighlight.setSelected(false);
                this.mPen.setSelected(false);
                break;
            }
            case 2: {
                this.mSpotlight.setSelected(false);
                this.mHighlight.setSelected(true);
                this.mPen.setSelected(false);
                this.mLineWidth = this.mDrawingView.getCurrentWidth();
                break;
            }
            case 4: {
                this.mSpotlight.setSelected(false);
                this.mHighlight.setSelected(false);
                this.mPen.setSelected(true);
                this.mLineWidth = this.mDrawingView.getCurrentWidth();
            }
        }
        this.mColorImage.setColor(this.mDrawingView.getCurrentColor());
    }

    public void onClick(View v) {
        if (v == this.mSpotlight) {
            this.mDrawingView.setCurrentMode(1);
        } else if (v == this.mHighlight) {
            this.mDrawingView.setCurrentMode(2);
        } else if (v == this.mPen) {
            this.mDrawingView.setCurrentMode(4);
        } else if (v == this.mErase) {
            this.mDrawingView.eraseAll();
            this.mDrawingView.refresh();
            this.notifyRefresh();
        } else if (v == this.mColorIndicator && this.mDrawingView.isCurrentModeSupportColor()) {
            if (this.mColorTableView.isShowing()) {
                this.mColorTableView.dismiss();
            } else {
                this.mColorTableView.showAsDropDown(this.mToolbars);
                this.updateLineWidthPromt();
            }
        }
        this.updateSelection();
        this.notifyRefresh();
    }

    private void updateLineWidthPromt() {
        if (this.mColorTableView.isShowing()) {
            this.mLineWidthSeekBar.setProgress(this.mLineWidth);
            this.txtLineWidth.setText((CharSequence)String.valueOf(this.mLineWidth));
        }
    }

    @Override
    public void drawShareContent(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        this.mDrawingView.drawShareContent(canvas);
    }

    @Override
    public int getShareContentWidth() {
        return this.mDrawingView.getWidth();
    }

    @Override
    public int getShareContentHeight() {
        return this.mDrawingView.getHeight();
    }

    @Override
    public void onColorChanged(View view, int newColor) {
    }

    @Override
    public void onColorPicked(View view, int newColor) {
        this.mDrawingView.setCurrentColor(65535, newColor);
        if (this.mDrawingView.isCurrentModeSupportColor()) {
            this.mColorImage.setColor(newColor);
        }
    }

    @Override
    public void onRepaint() {
        this.notifyRefresh();
    }

    @Override
    public void onBitmapChanged(Canvas canvas) {
        this.notifyRefresh();
    }

    @Override
    public void onLongPressed(boolean bLongClicked) {
    }

    @Override
    public void onBeginEditing(int x, int y) {
    }

    @Override
    public void onEndEditing() {
    }

    @Override
    public void onAnnotateViewSizeChanged() {
    }
}

