/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.share;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.zipow.videobox.share.IDrawingViewListener;
import com.zipow.videobox.share.Point;
import com.zipow.videobox.share.ZMDrawObject;
import com.zipow.videobox.share.ZMLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class DrawingView
extends SurfaceView
implements SurfaceHolder.Callback {
    public static final int MODE_ALL = 65535;
    public static final int MODE_SPOT = 1;
    public static final int MODE_HIGHLIGHT = 2;
    public static final int MODE_PEN = 4;
    public static final int MODE_ERASER = 8;
    public static final int MODE_DEFAULT = 4;
    private static final int ERASE_COLOR = 0xFFFFFF;
    private static final int ERASE_WIDTH = 30;
    private static final int ALL_POINTS = -1;
    private Bitmap mBackgroundImage;
    private Canvas mBackgroundCanvas;
    private Bitmap mSpotBitmap;
    private HashSet<IDrawingViewListener> mListeners;
    private Uri mBackgroundUri;
    static final int VIRTUAL_WIDTH = 768;
    private int mPenColor = ZMDrawObject.DFT_CLR;
    private int mPenLineWidth = 2;
    private int mHLColor = ZMDrawObject.DFT_CLR;
    private int mHLLineWidth = 2;
    private List<ZMDrawObject> zmDrawObjects;
    private int currentDrawingMode;
    private Point mSpotPoint;
    private Paint linePaint;
    private SurfaceHolder _surfaceHolder;
    private Context mContext;
    @SuppressLint(value={"UseSparseArrays"})
    private Map<Integer, Path> mCurrentPaths = new HashMap<Integer, Path>();

    public DrawingView(Context context) {
        super(context);
        this.init(context);
    }

    public DrawingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DrawingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public void onLayoutChange(boolean changed, int left, int top, int right, int bottom) {
        if (changed) {
            this.layoutChange(right - left, bottom - top);
            this.paintAllDrawObject(this.mBackgroundCanvas);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.destroyBackground();
    }

    private void init(Context context) {
        this.mContext = context;
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.zmDrawObjects = new ArrayList<ZMDrawObject>();
        this.currentDrawingMode = 4;
        this.linePaint = new Paint();
        this.linePaint.setDither(true);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setStrokeJoin(Paint.Join.ROUND);
        this.linePaint.setStrokeCap(Paint.Cap.ROUND);
        this.linePaint.setColor(0xFF000000 | this.mPenColor);
        this.linePaint.setStrokeWidth((float)UIUtil.dip2px((Context)this.mContext, (float)this.mPenLineWidth));
        this.mSpotBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.zm_share_spot);
        this.mListeners = new HashSet();
        this.setWillNotDraw(false);
        this.setWillNotCacheDrawing(true);
    }

    public void registerUpdateListener(IDrawingViewListener listener) {
        if (listener == null) {
            return;
        }
        this.mListeners.add(listener);
    }

    public void unRegisterUpdateListener(IDrawingViewListener listener) {
        if (listener == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    public void clearUpdateListener() {
        this.mListeners.clear();
    }

    private void onRepaint() {
        for (IDrawingViewListener listener : this.mListeners) {
            listener.onRepaint();
        }
    }

    private void onBackgroundBitmapChange(Canvas canvas) {
        for (IDrawingViewListener listener : this.mListeners) {
            listener.onBitmapChanged(canvas);
        }
    }

    private void updateSpotPoint(float x, float y) {
        if (x < 0.0f || y < 0.0f) {
            return;
        }
        if (this.mSpotPoint == null) {
            this.mSpotPoint = new Point();
        }
        this.mSpotPoint.setX(x);
        this.mSpotPoint.setY(y);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        int pointerIndex = (action & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == -1) {
            return true;
        }
        UIUtil.closeSoftKeyboard((Context)this.mContext, (View)this);
        switch (action & 0xFF) {
            case 0: {
                if (this.currentDrawingMode == 1) break;
                this.startStroke(pointerId, pointerIndex, ev);
                break;
            }
            case 1: {
                if (this.currentDrawingMode == 1) {
                    this.updateSpotPoint(ev.getX(), ev.getY());
                    this.repaint(false, true);
                } else {
                    this.finishStroke(pointerId, pointerIndex, ev);
                }
                this.onRepaint();
                this.mCurrentPaths.clear();
                break;
            }
            case 2: {
                if (this.currentDrawingMode != 1) {
                    this.updateStrokes(ev);
                } else {
                    this.updateSpotPoint(ev.getX(0), ev.getY(0));
                }
                this.repaint(false, false);
                break;
            }
            case 6: {
                this.finishStroke(pointerId, pointerIndex, ev);
                this.onRepaint();
                this.resetCurrentPath(pointerId);
                break;
            }
            case 5: {
                this.startStroke(pointerId, pointerIndex, ev);
                break;
            }
            case 3: {
                this.mCurrentPaths.clear();
            }
        }
        return true;
    }

    void updateStrokes(MotionEvent ev) {
        Path path;
        int id2;
        int p;
        int historySize = ev.getHistorySize();
        int pointerCount = ev.getPointerCount();
        for (p = 0; p < pointerCount; ++p) {
            id2 = ev.getPointerId(p);
            path = this.mCurrentPaths.get(id2);
            if (path == null) continue;
            for (int h = 0; h < historySize; ++h) {
                int x = this.localToVirt(ev.getHistoricalX(p, h));
                int y = this.localToVirt(ev.getHistoricalY(p, h));
                this.updateCurrentPath(id2, x, y);
            }
        }
        for (p = 0; p < pointerCount; ++p) {
            id2 = ev.getPointerId(p);
            path = this.mCurrentPaths.get(id2);
            if (path == null) continue;
            int x = this.localToVirt(ev.getX(p));
            int y = this.localToVirt(ev.getY(p));
            this.updateCurrentPath(id2, x, y);
        }
    }

    private void updateCurrentPath(int id2, int x, int y) {
        Path path = this.mCurrentPaths.get(id2);
        if (path != null) {
            path.lineTo((float)x, (float)y);
        }
    }

    private void resetCurrentPath(int id2) {
        if (!this.mCurrentPaths.containsKey(id2)) {
            this.mCurrentPaths.put(id2, new Path());
        } else {
            this.mCurrentPaths.get(id2).reset();
        }
    }

    private void startCurrentPath(int id2, int x, int y) {
        this.resetCurrentPath(id2);
        this.mCurrentPaths.get(id2).moveTo((float)x, (float)y);
    }

    private void startStroke(int pointerId, int pointerIndex, MotionEvent ev) {
        this.resetCurrentPath(pointerId);
        if (ev != null) {
            int x = this.localToVirt(ev.getX(pointerIndex));
            int y = this.localToVirt(ev.getY(pointerIndex));
            this.startCurrentPath(pointerId, x, y);
        }
    }

    private void finishStroke(int pointerId, int pointerIndex, MotionEvent ev) {
        this.addDrawPathObject(pointerId);
        this.repaint(false, true, pointerId);
    }

    public boolean gatherTransparentRegion(Region region) {
        this.setZOrderOnTop(false);
        boolean result = super.gatherTransparentRegion(region);
        this.setZOrderOnTop(true);
        return result;
    }

    private void paintAllDrawObject(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        for (int i = 0; i < this.zmDrawObjects.size(); ++i) {
            this.zmDrawObjects.get(i).draw(canvas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void surfaceDraw(Bitmap bitmap, boolean pathComplete, int completedPoint) {
        if (bitmap == null || this._surfaceHolder == null) {
            return;
        }
        Canvas canvas = null;
        try {
            canvas = this._surfaceHolder.lockCanvas(null);
            if (canvas != null) {
                Paint paint = new Paint();
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
                canvas.drawPaint(paint);
                canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                this.paintCurrentPaths(canvas, !pathComplete, completedPoint);
                this.checkDrawSpotImage(canvas);
            }
        }
        finally {
            if (canvas != null) {
                this._surfaceHolder.unlockCanvasAndPost(canvas);
            }
        }
    }

    private void checkDrawSpotImage(Canvas canvas) {
        if (canvas == null || this.mSpotBitmap == null || this.mSpotBitmap.getWidth() <= 0 || this.mSpotBitmap.getWidth() <= 0) {
            return;
        }
        if (this.currentDrawingMode == 1 && this.mSpotPoint != null) {
            float xRadioSize = this.mSpotBitmap.getWidth() / 2;
            float left = this.mSpotPoint.getX() - xRadioSize;
            float right = this.mSpotPoint.getX() + xRadioSize;
            if (right > (float)canvas.getWidth()) {
                left = canvas.getWidth() - this.mSpotBitmap.getWidth();
            }
            if (left < 0.0f) {
                left = 0.0f;
            }
            float yRadioSize = this.mSpotBitmap.getHeight() / 2;
            float top = this.mSpotPoint.getY() - yRadioSize;
            float bottom = this.mSpotPoint.getY() + yRadioSize;
            if (bottom > (float)canvas.getHeight()) {
                top = canvas.getHeight() - this.mSpotBitmap.getHeight();
            }
            if (top < 0.0f) {
                top = 0.0f;
            }
            canvas.drawBitmap(this.mSpotBitmap, left, top, null);
        }
    }

    public void refresh() {
        this.mCurrentPaths.clear();
        this.paintAllDrawObject(this.mBackgroundCanvas);
        this.surfaceDraw(this.mBackgroundImage, false, -1);
        this.onRepaint();
    }

    public void repaint(boolean repaintAll, boolean pathComplete) {
        this.repaint(repaintAll, pathComplete, -1);
    }

    public void repaint(boolean repaintAll, boolean pathComplete, int completedPoint) {
        if (this.mBackgroundImage != null) {
            if (this.mBackgroundCanvas == null) {
                this.mBackgroundCanvas = new Canvas(this.mBackgroundImage);
            }
            if (repaintAll) {
                this.mBackgroundCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            }
            if (this.currentDrawingMode != 1 && pathComplete) {
                this.paintCurrentPaths(this.mBackgroundCanvas, true, completedPoint);
            }
            this.surfaceDraw(this.mBackgroundImage, pathComplete, completedPoint);
        }
    }

    private void addDrawPathObject(int pointId) {
        Path path = this.mCurrentPaths.get(pointId);
        if (path != null && !path.isEmpty()) {
            ZMLine zmLine = new ZMLine();
            zmLine.setPath(path);
            zmLine.setPaint(this.linePaint);
            int alpha = this.linePaint.getAlpha();
            zmLine.setAlpha(alpha);
            this.zmDrawObjects.add(zmLine);
        }
    }

    private void paintCurrentPaths(Canvas canvas, boolean paintCurrentPoint, int currentPointId) {
        block6: {
            block4: {
                Path path;
                block5: {
                    if (this.mCurrentPaths == null || this.mCurrentPaths.isEmpty() || currentPointId != -1 && currentPointId < 0) {
                        return;
                    }
                    if (!paintCurrentPoint) break block4;
                    if (currentPointId != -1) break block5;
                    for (int pointId : this.mCurrentPaths.keySet()) {
                        Path path2 = this.mCurrentPaths.get(pointId);
                        if (path2 == null || path2.isEmpty()) continue;
                        canvas.drawPath(path2, this.linePaint);
                    }
                    break block6;
                }
                if (currentPointId < 0 || (path = this.mCurrentPaths.get(currentPointId)) == null || path.isEmpty()) break block6;
                canvas.drawPath(path, this.linePaint);
                break block6;
            }
            if (currentPointId != -1) {
                for (int pointId : this.mCurrentPaths.keySet()) {
                    Path path;
                    if (pointId == currentPointId || (path = this.mCurrentPaths.get(pointId)) == null || path.isEmpty()) continue;
                    canvas.drawPath(path, this.linePaint);
                }
            }
        }
    }

    public Uri getBackgroundUri() {
        return this.mBackgroundUri;
    }

    public void setBackgroundUri(Uri mBackgroundUri) {
        this.mBackgroundUri = mBackgroundUri;
    }

    private int localToVirt(float val) {
        return (int)val;
    }

    public int getCurrentMode() {
        return this.currentDrawingMode;
    }

    public void setCurrentMode(int currentMode) {
        int preMode = this.currentDrawingMode;
        this.currentDrawingMode = currentMode;
        this.updatePaintColor();
        this.updatePaintWidth();
        if (preMode == 1 && currentMode != preMode) {
            this.mSpotPoint = null;
            this.repaint(false, false);
        }
    }

    public int getCurrentColor() {
        int color2;
        switch (this.getCurrentMode()) {
            case 2: {
                color2 = 0xFF000000 | this.mHLColor;
                break;
            }
            case 4: {
                color2 = 0xFF000000 | this.mPenColor;
                break;
            }
            case 8: {
                color2 = -1;
                break;
            }
            default: {
                color2 = 0;
            }
        }
        return color2;
    }

    public boolean isCurrentModeSupportColor() {
        boolean support = false;
        switch (this.getCurrentMode()) {
            case 2: 
            case 4: 
            case 8: {
                support = true;
            }
        }
        return support;
    }

    public void setCurrentColor(int mode, int currentColor) {
        if ((mode & 2) == 2) {
            this.mHLColor = currentColor;
        }
        if ((mode & 4) == 4) {
            this.mPenColor = currentColor;
        }
        this.updatePaintColor();
    }

    public void setCurrentColor(int currentColor) {
        this.setCurrentColor(this.getCurrentMode(), currentColor);
    }

    private void updatePaintColor() {
        if (this.getCurrentMode() == 2) {
            this.linePaint.setAlpha(128);
            this.linePaint.setColor(0xFFFFFF & this.mHLColor | Integer.MIN_VALUE);
        } else if (this.getCurrentMode() == 8) {
            this.linePaint.setAlpha(255);
            this.linePaint.setColor(-1);
        } else {
            this.linePaint.setAlpha(255);
            this.linePaint.setColor(0xFF000000 | this.mPenColor);
        }
    }

    private void updatePaintWidth() {
        if (this.getCurrentMode() == 8) {
            this.linePaint.setStrokeWidth((float)UIUtil.dip2px((Context)this.mContext, (float)30.0f));
        } else if (this.getCurrentMode() == 2) {
            this.linePaint.setStrokeWidth((float)UIUtil.dip2px((Context)this.mContext, (float)this.mHLLineWidth));
        } else {
            this.linePaint.setStrokeWidth((float)UIUtil.dip2px((Context)this.mContext, (float)this.mPenLineWidth));
        }
    }

    public int getCurrentWidth() {
        int width = this.getCurrentMode() == 2 ? this.mHLLineWidth : (this.getCurrentMode() == 8 ? 30 : this.mPenLineWidth);
        return width;
    }

    public void setCurrentWidth(int mode, int currentWidth) {
        if ((mode & 2) == 2) {
            this.mHLLineWidth = currentWidth;
        }
        if ((mode & 4) == 4) {
            this.mPenLineWidth = currentWidth;
        }
        this.updatePaintWidth();
    }

    public void setCurrentWidth(int currentWidth) {
        this.setCurrentWidth(this.getCurrentMode(), currentWidth);
    }

    public void eraseAll() {
        this.zmDrawObjects.clear();
        this.mCurrentPaths.clear();
        this.mSpotPoint = null;
        if (this.mBackgroundCanvas != null) {
            this.mBackgroundCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
    }

    private void destroyBackground() {
        if (this.mBackgroundImage != null) {
            this.mBackgroundImage.recycle();
            this.mBackgroundImage = null;
        }
        this.mBackgroundCanvas = null;
    }

    private void initBackgroundImage(int width, int height) {
        if (this.mBackgroundImage != null && (this.mBackgroundImage.getWidth() != width || this.mBackgroundImage.getHeight() != height)) {
            this.destroyBackground();
        }
        if (this.mBackgroundImage == null) {
            try {
                this.mBackgroundImage = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mBackgroundCanvas = new Canvas(this.mBackgroundImage);
            }
            catch (Exception exception) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
    }

    private void layoutChange(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        this.initBackgroundImage(width, height);
        if (this.mBackgroundCanvas != null) {
            this.onBackgroundBitmapChange(this.mBackgroundCanvas);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.layoutChange(width, height);
        this.refresh();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this._surfaceHolder = holder;
        this.setZOrderOnTop(true);
        this._surfaceHolder.setFormat(-3);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this._surfaceHolder = null;
        this.mSpotPoint = null;
        this.mCurrentPaths.clear();
        this.destroyBackground();
    }

    public void drawShareContent(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        if (this.mBackgroundImage == null) {
            return;
        }
        canvas.drawBitmap(this.mBackgroundImage, 0.0f, 0.0f, null);
        this.checkDrawSpotImage(canvas);
    }
}

