/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.widget.TextView;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.sdk.ISDKVideoUnit;
import com.zipow.videobox.util.ZMBitmapFactory;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.videomeetings.R;

public class SDKVideoUnit
implements ISDKVideoUnit {
    private String TAG = SDKVideoUnit.class.getSimpleName();
    public static final int SSB_MC_FREEWAY_INDEX = 1;
    public static final int TYPE_ATTENDEE = 0;
    public static final int TYPE_ACTIVE = 1;
    public static final int BORDER_TYPE_NORMAL = 0;
    public static final int BORDER_TYPE_ACTIVE = 1;
    public static final int BORDER_TYPE_LOCKED = 2;
    private static final int PIC_AVATAR = 0;
    private static final int PIC_USERNAME = 1;
    private static final int PIC_AUDIO_OFF = 3;
    private static final int PIC_NETWORK_STATUS = 5;
    private static final int PIC_BORDER_LEFT = 6;
    private static final int PIC_BORDER_TOP = 7;
    private static final int PIC_BORDER_RIGHT = 8;
    private static final int PIC_BORDER_BOTTOM = 9;
    private static final int AVATAR_TYPE_NONE = 0;
    private static final int AVATAR_TYPE_SMALL = 1;
    private static final int AVATAR_TYPE_BIG = 2;
    private static final int TEXT_PADDING_VERTICAL = 2;
    private static final int TEXT_SIZE = 16;
    private static final int MAX_AVATAR_AREA = 160000;
    private boolean mIsDestroyed = false;
    private String mUnitName = null;
    private int mLeft;
    private int mTop;
    private int mWidth;
    private int mHeight;
    private long mRenderInfo;
    private boolean mIsKeyUnit;
    private long mUserId = 0L;
    private long mPausedUserId = 0L;
    private long mShowType = -1L;
    private boolean mbShowingVideo = false;
    private boolean mbPreviewing = false;
    private int mType = 0;
    private boolean mHasAvatar = false;
    private boolean mHasBorder = false;
    private boolean mIsMySelf = false;
    private boolean mIsPaused = false;
    private boolean mIsUserNameVisible = true;
    private boolean mIsBorderVisible = false;
    private boolean mCanShowAudioOff = false;
    private boolean mCanShowNetworkStatus = false;
    private boolean mbAudioOff = false;
    private long mAudioType = 0L;
    private int mVideoType = 2;
    private int mNetworkStatus = -1;
    private boolean mbUserNameResourceHasLeftPaddingForAudioOff = false;
    private boolean mbUserNameResourceHasLeftPaddingForNetworkStatus = false;
    private int mAvatarType = 0;
    private int mBorderType = 0;
    private String mUserName;
    private String mAvatarSmall;
    private String mAvatarBig;
    private boolean mIsPureCallInUser = false;
    private boolean mIsH323User = false;
    private boolean mIsFloating = false;
    private ISDKVideoUnit.SDKPicInfo mPiAvatar;
    private ISDKVideoUnit.SDKPicInfo mPiUserName;
    private ISDKVideoUnit.SDKPicInfo mPiBorderLeft;
    private ISDKVideoUnit.SDKPicInfo mPiBorderTop;
    private ISDKVideoUnit.SDKPicInfo mPiBorderRight;
    private ISDKVideoUnit.SDKPicInfo mPiBorderBottom;
    private ISDKVideoUnit.SDKPicInfo mPiAudioOff;
    private ISDKVideoUnit.SDKPicInfo mPiNetworkStatus;
    private ISDKVideoUnit.SDKPicInfo mPiWaterMark;
    private int mBkColor = 0;
    private boolean mbNetworkRestrictionMode = false;
    private static Typeface s_typeface;
    private static int s_textHeight;
    private static TextPaint s_textPaint;
    private static int s_waterMarkTopMargin;
    private static int sAudioOffWidth;
    private static int sNetworkStatusWidth;

    public static void initDefaultResources() {
        s_textPaint = new TextPaint();
        s_typeface = new TextView((Context)VideoBoxApplication.getInstance()).getTypeface();
        s_textPaint.setTypeface(s_typeface);
        s_textPaint.setTextSize((float)UIUtil.sp2px((Context)VideoBoxApplication.getInstance(), (float)16.0f));
        s_textPaint.setColor(-1);
        s_textPaint.setAntiAlias(true);
        Paint.FontMetrics fontMetrics = s_textPaint.getFontMetrics();
        s_textHeight = (int)(fontMetrics.bottom - fontMetrics.top) + UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)4.0f);
        s_waterMarkTopMargin = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)8.0f);
    }

    public SDKVideoUnit(boolean isKeyUnit, long renderInfo, RendererUnitInfo info) {
        this.mIsKeyUnit = isKeyUnit;
        this.mRenderInfo = renderInfo;
        if (info != null) {
            this.mLeft = info.left;
            this.mTop = info.top;
            this.mWidth = info.width;
            this.mHeight = info.height;
        }
    }

    @Override
    public void setUnitName(String name) {
        this.mUnitName = name;
        this.TAG = StringUtil.isEmptyOrNull((String)this.mUnitName) ? SDKVideoUnit.class.getSimpleName() : SDKVideoUnit.class.getSimpleName() + ":" + this.mUnitName;
    }

    @Override
    public String getUnitName() {
        return this.mUnitName;
    }

    public boolean isKeyUnit() {
        return this.mIsKeyUnit;
    }

    @Override
    public long getRendererInfo() {
        return this.mRenderInfo;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getLeft() {
        return this.mLeft;
    }

    @Override
    public int getTop() {
        return this.mTop;
    }

    @Override
    public int getRight() {
        return this.mLeft + this.mWidth;
    }

    @Override
    public int getBottom() {
        return this.mTop + this.mHeight;
    }

    public boolean isPointInUnit(float x, float y) {
        return x >= (float)this.getLeft() && x <= (float)this.getRight() && y >= (float)this.getTop() && y <= (float)this.getBottom();
    }

    public boolean isMySelf() {
        return this.mIsMySelf;
    }

    @Override
    public void pause() {
        if (!this.mIsPaused) {
            this.mIsPaused = true;
            this.mShowType = 0L;
            if (this.mbShowingVideo) {
                this.stopVideo(false);
            }
        }
    }

    @Override
    public void resume() {
        if (this.mIsPaused) {
            this.mIsPaused = false;
            if (this.mPausedUserId != 0L) {
                this.setUser(this.mPausedUserId);
            } else if (this.mUserId != 0L) {
                this.setUser(this.mUserId);
                this.startVideo();
            }
        }
    }

    @Override
    public boolean isPaused() {
        return this.mIsPaused;
    }

    public void setUserNameVisible(boolean visible) {
        this.setUserNameVisible(visible, false, false);
    }

    public void setUserNameVisible(boolean visible, boolean networkStatusVisible) {
        this.setUserNameVisible(visible, true, networkStatusVisible);
    }

    private void setUserNameVisible(boolean visible, boolean withNetworkStatus, boolean networkStatusVisible) {
        if (this.mIsUserNameVisible == visible) {
            return;
        }
        this.mIsUserNameVisible = visible;
        if (withNetworkStatus) {
            this.mCanShowNetworkStatus = networkStatusVisible;
        }
        if (this.mUserId != 0L) {
            if (this.mIsUserNameVisible) {
                this.showUserName();
            } else {
                this.removeUserName();
            }
            if (withNetworkStatus) {
                this.updateNetworkStatus();
            }
        }
    }

    public boolean isUserNameVisible() {
        return this.mIsUserNameVisible;
    }

    public void setBorderVisible(boolean visible) {
        if (this.mIsBorderVisible == visible && this.mHasBorder == visible) {
            return;
        }
        this.mIsBorderVisible = visible;
        if (this.mIsBorderVisible) {
            this.showBorder();
        } else {
            this.removeBorder();
        }
    }

    public void setBorderType(int type) {
        if (this.mBorderType == type) {
            return;
        }
        this.mPiBorderLeft = null;
        this.mPiBorderTop = null;
        this.mPiBorderRight = null;
        this.mPiBorderBottom = null;
        this.mBorderType = type;
        if (this.mIsBorderVisible) {
            this.showBorder();
        }
    }

    public void setBackgroundColor(int color2) {
        if (color2 == this.mBkColor) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.setRendererBackgroudColor(this.mRenderInfo, color2);
        this.mBkColor = color2;
    }

    public boolean isBorderVisible() {
        return this.mIsBorderVisible;
    }

    public void setCanShowAudioOff(boolean can) {
        this.mCanShowAudioOff = can;
        if (this.mUserId == 0L) {
            return;
        }
        this.updateAudioOff();
    }

    public boolean getCanShowAudioOff() {
        return this.mCanShowAudioOff;
    }

    public boolean getCanShowNetworkStatus() {
        return this.mCanShowNetworkStatus;
    }

    public void setIsFloating(boolean b) {
        this.mIsFloating = b;
    }

    public boolean isFloating() {
        return this.mIsFloating;
    }

    public void updateUnitInfo(int viewWidth, int viewHeight, RendererUnitInfo unitInfo) {
        VideoSessionMgr videoMgr;
        if (unitInfo == null) {
            return;
        }
        if (this.isSameInfo(unitInfo)) {
            return;
        }
        boolean sizeChanged = this.mWidth != unitInfo.width || this.mHeight != unitInfo.height;
        this.mLeft = unitInfo.left;
        this.mTop = unitInfo.top;
        this.mWidth = unitInfo.width;
        this.mHeight = unitInfo.height;
        if (sizeChanged) {
            this.mPiUserName = null;
            this.mPiBorderLeft = null;
            this.mPiBorderTop = null;
            this.mPiBorderRight = null;
            this.mPiBorderBottom = null;
            this.mPiAvatar = null;
        }
        if ((videoMgr = ConfMgr.getInstance().getVideoObj()) == null) {
            return;
        }
        videoMgr.updateUnitLayout(this.mRenderInfo, viewWidth, viewHeight, unitInfo);
        if (this.isBorderVisible()) {
            this.showBorder();
        }
        this.showAudioOff(this.mUserId != 0L && this.mbAudioOff && this.mCanShowAudioOff);
        this.showNetworkStatus(this.mUserId != 0L && this.mNetworkStatus != -1 && this.mCanShowNetworkStatus, false);
        if (this.mUserId != 0L && this.isUserNameVisible()) {
            this.showUserName();
        }
        if (this.mHasAvatar) {
            this.showAvatar();
        }
    }

    private boolean isSameInfo(RendererUnitInfo unitInfo) {
        if (unitInfo == null) {
            return false;
        }
        return this.mLeft == unitInfo.left && this.mTop == unitInfo.top && this.mWidth == unitInfo.width && this.mHeight == unitInfo.height;
    }

    public void setType(int type) {
        this.mType = type;
        if (this.isBorderVisible()) {
            this.showBorder();
        }
    }

    public int getType() {
        return this.mType;
    }

    @Override
    public void setUser(long userId) {
        String userName;
        if (userId == 0L) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.isSameVideo(this.mUserId, userId)) {
            this.updateRenderContainer(userId);
        }
        if (!videoMgr.isSameVideo(this.mUserId, userId) || !this.mbShowingVideo) {
            this.subscribeVideo(userId);
        }
        this.updateAudioOff();
        this.updateNetworkStatus();
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null && !StringUtil.isSameString((String)(userName = this.getUserDisplayName(user)), (String)this.mUserName)) {
            this.mPiUserName = null;
            this.mUserName = userName;
        }
    }

    private String getUserDisplayName(CmmUser user) {
        if (user == null) {
            return null;
        }
        String name = user.getScreenName();
        return name;
    }

    private void updateRenderContainer(long userId) {
        if (this.isPaused()) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        this.mVideoType = videoMgr.getVideoTypeByID(userId);
        if (userId == 1L || videoMgr.isSelectedUser(userId)) {
            CmmUser user = ConfMgr.getInstance().getUserById(userId);
            if (user != null) {
                this.mPiAvatar = null;
                this.mPiUserName = null;
                this.mUserName = this.getUserDisplayName(user);
                this.mAvatarSmall = user.getSmallPicPath();
                this.mAvatarBig = user.getLocalPicPath();
                this.mIsPureCallInUser = user.isPureCallInUser();
                this.mIsH323User = user.isH323User();
                if (this.isUserNameVisible()) {
                    this.showUserName();
                }
            }
        } else if ((long)this.mVideoType == this.mShowType) {
            return;
        }
        boolean bIsMy = confStatus.isMyself(this.mUserId);
        if (this.mVideoType == 0) {
            if (bIsMy) {
                this.stopVideo(true);
            }
            this.clearRenderer();
            if (!bIsMy || !videoMgr.isVideoStarted() && !videoMgr.isPreviewing()) {
                this.mShowType = this.mVideoType;
                this.showAvatar();
            }
        } else if ((long)this.mVideoType != this.mShowType) {
            this.mShowType = this.mVideoType;
            if (bIsMy) {
                this.startVideo();
            }
        }
    }

    private void subscribeVideo(long userId) {
        if (userId == 0L) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (null == videoMgr) {
            return;
        }
        if (this.mUserId != 0L && !videoMgr.isSameVideo(this.mUserId, userId)) {
            this.removeUser();
        } else if (this.mbPreviewing) {
            this.removeUser(!confStatus.isMyself(userId));
        }
        if (this.isPaused()) {
            this.mPausedUserId = userId;
            return;
        }
        this.mPausedUserId = 0L;
        if (userId != 1L && !videoMgr.querySubStatus(userId)) {
            this.mUserId = 0L;
            return;
        }
        this.mUserId = userId;
        this.startVideo();
        this.mPiAvatar = null;
        this.mPiUserName = null;
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null) {
            this.mUserName = this.getUserDisplayName(user);
            this.mAvatarSmall = user.getSmallPicPath();
            this.mAvatarBig = user.getLocalPicPath();
            this.mIsPureCallInUser = user.isPureCallInUser();
            this.mIsH323User = user.isH323User();
        }
        this.mIsMySelf = this.mUserId == 0L ? false : confStatus.isMyself(this.mUserId);
        this.mVideoType = videoMgr.getVideoTypeByID(this.mUserId);
        if (this.mVideoType < 0) {
            this.mVideoType = 2;
        }
        if (this.mVideoType == 0) {
            this.clearRenderer();
            if (!this.mIsMySelf || !videoMgr.isVideoStarted() && !videoMgr.isPreviewing()) {
                this.mShowType = this.mVideoType;
                this.showAvatar();
            }
        } else {
            this.mShowType = this.mVideoType;
        }
        if (this.isBorderVisible()) {
            this.showBorder();
        }
        if (this.isUserNameVisible()) {
            this.showUserName();
        }
    }

    private Bitmap createAvatarBitmap() {
        Bitmap bitmap = null;
        if (this.mIsPureCallInUser || this.mIsH323User) {
            int width;
            int resId = this.mIsPureCallInUser ? R.drawable.zm_phone_inmeeting : R.drawable.zm_h323_inmeeting;
            Drawable drawable2 = VideoBoxApplication.getInstance().getResources().getDrawable(resId);
            int height2 = width = Math.min(Math.min(this.getWidth(), this.getHeight()), drawable2.getIntrinsicWidth());
            bitmap = Bitmap.createBitmap((int)width, (int)height2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, width, height2);
            drawable2.draw(canvas);
            this.mAvatarType = 2;
        } else if (!StringUtil.isEmptyOrNull((String)this.mAvatarBig)) {
            bitmap = ZMBitmapFactory.decodeFile(this.mAvatarBig, 160000, false, false);
            if (bitmap != null) {
                this.mAvatarType = 2;
            } else if (!StringUtil.isEmptyOrNull((String)this.mAvatarSmall)) {
                bitmap = ZMBitmapFactory.decodeFile(this.mAvatarSmall, 160000, false, false);
                this.mAvatarType = 1;
            }
        } else if (!StringUtil.isEmptyOrNull((String)this.mAvatarSmall)) {
            bitmap = ZMBitmapFactory.decodeFile(this.mAvatarSmall, 160000, false, false);
            if (bitmap != null) {
                this.mAvatarType = 1;
            } else if (!StringUtil.isEmptyOrNull((String)this.mAvatarBig)) {
                bitmap = ZMBitmapFactory.decodeFile(this.mAvatarBig, 160000, false, false);
                this.mAvatarType = 1;
            }
        }
        if (bitmap == null) {
            Drawable drawable3 = VideoBoxApplication.getInstance().getResources().getDrawable(R.drawable.zm_no_avatar);
            int width = drawable3.getIntrinsicWidth();
            int height = drawable3.getIntrinsicHeight();
            try {
                bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError height2) {
                // empty catch block
            }
            if (bitmap != null) {
                Canvas canvas = new Canvas(bitmap);
                drawable3.setBounds(0, 0, width, height);
                drawable3.draw(canvas);
            }
            this.mAvatarType = 0;
        }
        return bitmap;
    }

    private Bitmap createUserNameBitmap() {
        if (this.mUserName == null) {
            return null;
        }
        int paddingLeft = 0;
        if (this.mbAudioOff && this.mCanShowAudioOff) {
            paddingLeft += this.getAudioOffWidth();
            this.mbUserNameResourceHasLeftPaddingForAudioOff = true;
        } else {
            this.mbUserNameResourceHasLeftPaddingForAudioOff = false;
        }
        if (this.mNetworkStatus != -1 && this.mCanShowNetworkStatus) {
            paddingLeft += this.getNetworkStatusWidth();
            this.mbUserNameResourceHasLeftPaddingForNetworkStatus = true;
        } else {
            this.mbUserNameResourceHasLeftPaddingForNetworkStatus = false;
        }
        Bitmap bmp = this.createTextBmp(this.mUserName, paddingLeft, this.mWidth);
        return bmp;
    }

    private int getAudioOffWidth() {
        if (sAudioOffWidth > 0) {
            return sAudioOffWidth;
        }
        int resId = this.mAudioType == 0L ? R.drawable.zm_audio_off_small : R.drawable.zm_phone_off_small;
        Drawable drawable2 = VideoBoxApplication.getInstance().getResources().getDrawable(resId);
        int width = drawable2.getIntrinsicWidth();
        return width + UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)2.0f);
    }

    private int getNetworkStatusWidth() {
        if (sNetworkStatusWidth > 0) {
            return sNetworkStatusWidth;
        }
        Drawable drawable2 = VideoBoxApplication.getInstance().getResources().getDrawable(R.drawable.zm_network_good);
        int width = drawable2.getIntrinsicWidth();
        return width + UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)2.0f);
    }

    @Override
    public long getUser() {
        return this.mUserId;
    }

    @Override
    public void removeUser() {
        this.removeUser(true);
    }

    public void removeUser(boolean clearRenderer) {
        this.mPausedUserId = 0L;
        if (this.mbPreviewing) {
            this.stopPreview(clearRenderer);
        }
        if (this.mUserId == 0L) {
            return;
        }
        this.stopVideo(false);
        this.mUserId = 0L;
        this.mUserName = null;
        this.mIsMySelf = false;
        this.mbAudioOff = false;
        this.mNetworkStatus = -1;
        if (this.mUserId == 0L) {
            this.removeAvatar();
            this.removeUserName();
            this.showAudioOff(false);
            this.showNetworkStatus(false, false);
        }
    }

    public boolean isVideoShowing() {
        return this.mbShowingVideo;
    }

    public void startVideo() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        this.mbShowingVideo = true;
        int height = (int)UIUtil.px2dip((Context)VideoBoxApplication.getInstance(), (int)this.getHeight());
        switch (this.mType) {
            case 0: {
                if (this.mbNetworkRestrictionMode) {
                    height = 90;
                }
                videoMgr.showAttendeeVideo(this.mRenderInfo, this.mUserId, height, this.mIsFloating);
                break;
            }
            case 1: {
                if (this.isFloating()) {
                    height = 90;
                } else {
                    videoMgr.enable180p(false);
                    if (this.mbNetworkRestrictionMode) {
                        height = 360;
                    }
                }
                videoMgr.showActiveVideo(this.mRenderInfo, this.mUserId, height);
            }
        }
    }

    public void stopVideo(boolean clearRenderer) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        this.mbShowingVideo = false;
        if (this.mUserId != 0L) {
            videoMgr.stopShowVideo(this.mRenderInfo);
        }
        this.mShowType = -1L;
        if (clearRenderer && this.mRenderInfo != 0L) {
            videoMgr.clearRenderer(this.mRenderInfo);
        }
    }

    public void setNetworkRestrictionMode(boolean isNetworkRestrictionMode, boolean bRestartVideo) {
        if (bRestartVideo) {
            this.stopVideo(false);
        }
        this.mbNetworkRestrictionMode = isNetworkRestrictionMode;
        if (bRestartVideo) {
            this.startVideo();
        }
    }

    public void startPreview(String cameraId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.startPreviewDevice(this.mRenderInfo, cameraId)) {
            this.mbPreviewing = true;
            this.mbShowingVideo = true;
        }
    }

    public void stopPreview() {
        this.stopPreview(true);
    }

    public void stopPreview(boolean clearRenderer) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.stopPreviewDevice(this.mRenderInfo);
        if (this.mUserId == 0L) {
            this.mbShowingVideo = false;
        }
        this.mbPreviewing = false;
        this.removeBorder();
        if (clearRenderer && this.mRenderInfo != 0L) {
            videoMgr.clearRenderer(this.mRenderInfo);
        }
    }

    @Override
    public void clearRenderer() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.clearRenderer(this.mRenderInfo);
    }

    @Override
    public void onIdle() {
        if (this.mUserId != 0L && this.mVideoType == 2 && this.mHasAvatar && !this.isPaused()) {
            this.removeAvatar();
        }
        if (this.isBorderVisible() && !this.mHasBorder) {
            this.showBorder();
        }
    }

    @Override
    public void onCreate() {
        this.mIsDestroyed = false;
    }

    @Override
    public void onDestroy() {
        this.removeAvatar();
        this.removeBorder();
        this.removeUserName();
        this.showAudioOff(false);
        this.showNetworkStatus(false, false);
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.destroyVideoUnit(this);
        this.mIsDestroyed = true;
    }

    @Override
    public void onGLViewSizeChanged(int width, int height) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.glViewSizeChanged(this.mRenderInfo, width, height);
    }

    private void showAvatar() {
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        Bitmap bmp = null;
        int width = 0;
        int height = 0;
        if (this.mPiAvatar != null) {
            width = this.mPiAvatar.bmpWidth;
            height = this.mPiAvatar.bmpHeight;
        } else {
            bmp = this.createAvatarBitmap();
            if (bmp == null) {
                return;
            }
            width = bmp.getWidth();
            height = bmp.getHeight();
        }
        if (width == 0 || height == 0) {
            return;
        }
        int minSize = 0;
        minSize = this.mAvatarType == 2 ? UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)200.0f) : UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)60.0f);
        if (width < minSize) {
            if (width < minSize) {
                height = minSize * height / width;
                width = minSize;
            }
            if (height < minSize) {
                width = minSize * width / height;
                height = minSize;
            }
        }
        if (width > this.mWidth) {
            height = this.mWidth * height / width;
            width = this.mWidth;
        }
        if (height > this.mHeight) {
            width = this.mHeight * width / height;
            height = this.mHeight;
        }
        int left = (this.mWidth - width) / 2;
        int right = left + width;
        int top = (this.mHeight - height) / 2;
        int bottom = top + height;
        long dataHandle = 0L;
        if (this.mPiAvatar == null) {
            videoMgr.removePic(this.mRenderInfo, 0);
            dataHandle = videoMgr.addPic(this.mRenderInfo, 0, bmp, 255, 0, left, top, right, bottom);
            if (dataHandle != 0L) {
                this.mPiAvatar = new ISDKVideoUnit.SDKPicInfo(dataHandle, bmp.getWidth(), bmp.getHeight());
            }
            bmp.recycle();
        } else {
            dataHandle = videoMgr.movePic2(this.mRenderInfo, 0, left, top, right, bottom);
        }
        this.mHasAvatar = true;
    }

    private void removeAvatar() {
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.removePic(this.mRenderInfo, 0)) {
            this.mPiAvatar = null;
            this.mHasAvatar = false;
        }
    }

    private void showUserName() {
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        Bitmap bmp = null;
        int width = 0;
        int height = 0;
        if (!(this.mPiUserName == null || this.mCanShowAudioOff && this.mbUserNameResourceHasLeftPaddingForAudioOff != this.mbAudioOff || this.mCanShowNetworkStatus && this.mbUserNameResourceHasLeftPaddingForNetworkStatus != (this.mNetworkStatus != -1))) {
            width = this.mPiUserName.bmpWidth;
            height = this.mPiUserName.bmpHeight;
        } else {
            this.mPiUserName = null;
            bmp = this.createUserNameBitmap();
            if (bmp == null) {
                return;
            }
            width = bmp.getWidth();
            height = bmp.getHeight();
        }
        int left = 0;
        int right = width;
        int top = this.getHeight() - height;
        int bottom = this.getHeight();
        long dataHandle = 0L;
        if (this.mPiUserName == null) {
            videoMgr.removePic(this.mRenderInfo, 1);
            dataHandle = videoMgr.addPic(this.mRenderInfo, 1, bmp, 128, 0, left, top, right, bottom);
            if (dataHandle != 0L) {
                this.mPiUserName = new ISDKVideoUnit.SDKPicInfo(dataHandle, bmp.getWidth(), bmp.getHeight());
            }
            bmp.recycle();
        } else {
            dataHandle = videoMgr.movePic2(this.mRenderInfo, 1, left, top, right, bottom);
        }
    }

    private Bitmap createTextBmp(String text, int paddingLeft, int maxWidth) {
        Bitmap bitmap;
        TextPaint textPaint = s_textPaint;
        Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
        int horizontalPadding = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)6.0f);
        String name = this.ellipseName(text, textPaint, maxWidth - paddingLeft - horizontalPadding);
        int textWidth = (int)textPaint.measureText(name);
        int width = textWidth + horizontalPadding + paddingLeft;
        int height = s_textHeight;
        if (width > maxWidth) {
            width = maxWidth;
        }
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Throwable e) {
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        Paint paint = new Paint();
        paint.setColor(-16777216);
        canvas.drawRect(rect, paint);
        canvas.drawText(name, (float)(paddingLeft + horizontalPadding / 2), (float)(canvas.getHeight() / 2) - ((fontMetrics.bottom - fontMetrics.top) / 2.0f + fontMetrics.top), (Paint)textPaint);
        return bitmap;
    }

    private void removeUserName() {
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.removePic(this.mRenderInfo, 1)) {
            this.mPiUserName = null;
        }
    }

    private void showBorder() {
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int left = 0;
        int right = left + width;
        int top = 0;
        int bottom = top + height;
        int borderWidth = 0;
        Bitmap bmpV = null;
        if (this.mPiBorderLeft == null || this.mPiBorderRight == null) {
            bmpV = this.createVBorderBitmap();
            if (bmpV == null) {
                return;
            }
            borderWidth = bmpV.getWidth();
        } else {
            borderWidth = this.mPiBorderLeft.bmpWidth;
        }
        long dataHandleLeft = 0L;
        if (this.mPiBorderLeft == null) {
            videoMgr.removePic(this.mRenderInfo, 6);
            dataHandleLeft = videoMgr.addPic(this.mRenderInfo, 6, bmpV, 255, 0, left, top, left + borderWidth, bottom);
            if (dataHandleLeft != 0L) {
                this.mPiBorderLeft = new ISDKVideoUnit.SDKPicInfo(dataHandleLeft, bmpV.getWidth(), bmpV.getHeight());
            }
        } else {
            dataHandleLeft = videoMgr.movePic2(this.mRenderInfo, 6, left, top, left + borderWidth, bottom);
        }
        long dataHandleRight = 0L;
        if (this.mPiBorderRight == null) {
            videoMgr.removePic(this.mRenderInfo, 8);
            dataHandleRight = videoMgr.addPic(this.mRenderInfo, 8, bmpV, 255, 0, right - borderWidth, top, right, bottom);
            if (dataHandleRight != 0L) {
                this.mPiBorderRight = new ISDKVideoUnit.SDKPicInfo(dataHandleRight, bmpV.getWidth(), bmpV.getHeight());
            }
        } else {
            dataHandleRight = videoMgr.movePic2(this.mRenderInfo, 8, right - borderWidth, top, right, bottom);
        }
        Bitmap bmpH = null;
        if ((this.mPiBorderTop == null || this.mPiBorderBottom == null) && (bmpH = this.createHBorderBitmap()) == null) {
            return;
        }
        long dataHandleTop = 0L;
        if (this.mPiBorderTop == null) {
            videoMgr.removePic(this.mRenderInfo, 7);
            dataHandleTop = videoMgr.addPic(this.mRenderInfo, 7, bmpH, 255, 0, left + 1, top, right - 1, top + borderWidth);
            if (dataHandleTop != 0L) {
                this.mPiBorderTop = new ISDKVideoUnit.SDKPicInfo(dataHandleTop, bmpH.getWidth(), bmpH.getHeight());
            }
        } else {
            dataHandleTop = videoMgr.movePic2(this.mRenderInfo, 7, left, top, right, top + borderWidth);
        }
        long dataHandleBottom = 0L;
        if (this.mPiBorderBottom == null) {
            videoMgr.removePic(this.mRenderInfo, 9);
            dataHandleBottom = videoMgr.addPic(this.mRenderInfo, 9, bmpH, 255, 0, left + 1, bottom - borderWidth, right - 1, bottom);
            if (dataHandleBottom != 0L) {
                this.mPiBorderBottom = new ISDKVideoUnit.SDKPicInfo(dataHandleBottom, bmpH.getWidth(), bmpH.getHeight());
            }
        } else {
            dataHandleBottom = videoMgr.movePic2(this.mRenderInfo, 9, left, bottom - borderWidth, right, bottom);
        }
        this.mHasBorder = true;
        if (bmpV != null) {
            bmpV.recycle();
        }
        if (bmpH != null) {
            bmpH.recycle();
        }
    }

    private Bitmap createHBorderBitmap() {
        float strokeWidth = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)2.0f);
        int h = (int)strokeWidth;
        if (h <= 0) {
            h = 1;
        }
        int w = this.getWidth();
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        int color2 = 0;
        switch (this.mBorderType) {
            case 1: {
                color2 = R.color.zm_video_border_active;
                break;
            }
            case 2: {
                color2 = R.color.zm_video_border_locked;
                break;
            }
            default: {
                color2 = R.color.zm_video_border_normal;
            }
        }
        int colorVal = VideoBoxApplication.getInstance().getResources().getColor(color2);
        canvas.drawColor(colorVal);
        return bitmap;
    }

    private Bitmap createVBorderBitmap() {
        int h;
        float strokeWidth = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)2.0f);
        int w = (int)strokeWidth;
        if (w <= 0) {
            w = 1;
        }
        if ((h = this.getHeight()) <= 0) {
            h = 1;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        int color2 = 0;
        switch (this.mBorderType) {
            case 1: {
                color2 = R.color.zm_video_border_active;
                break;
            }
            case 2: {
                color2 = R.color.zm_video_border_locked;
                break;
            }
            default: {
                color2 = R.color.zm_video_border_normal;
            }
        }
        int colorVal = VideoBoxApplication.getInstance().getResources().getColor(color2);
        canvas.drawColor(colorVal);
        return bitmap;
    }

    private void removeBorder() {
        if (!this.mHasBorder) {
            return;
        }
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.removePic(this.mRenderInfo, 6)) {
            this.mPiBorderLeft = null;
        }
        if (videoMgr.removePic(this.mRenderInfo, 7)) {
            this.mPiBorderTop = null;
        }
        if (videoMgr.removePic(this.mRenderInfo, 8)) {
            this.mPiBorderRight = null;
        }
        if (videoMgr.removePic(this.mRenderInfo, 9)) {
            this.mPiBorderBottom = null;
        }
        this.mHasBorder = false;
    }

    private String ellipseName(String screenName, TextPaint paint, int maxWidth) {
        return StringUtil.ellipseString((String)screenName, (int)maxWidth, (TextPaint)paint);
    }

    private void showAudioOff(boolean show) {
        if (!this.getCanShowAudioOff()) {
            show = false;
        }
        if (this.mIsUserNameVisible && this.mUserId != 0L) {
            this.showUserName();
        }
        boolean _show = show;
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (!_show) {
            if (videoMgr.removePic(this.mRenderInfo, 3)) {
                this.mPiAudioOff = null;
            }
            return;
        }
        Bitmap bmp = null;
        int width = 0;
        int height = 0;
        if (this.mPiAudioOff != null) {
            width = this.mPiAudioOff.bmpWidth;
            height = this.mPiAudioOff.bmpHeight;
        } else {
            bmp = this.createAudioOffBitmap();
            if (bmp == null) {
                return;
            }
            width = bmp.getWidth();
            height = bmp.getHeight();
        }
        int marginHorizontal = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)2.0f);
        if (this.mCanShowNetworkStatus && this.mNetworkStatus != -1) {
            marginHorizontal += this.getNetworkStatusWidth();
        }
        int marginVertical = (s_textHeight - height) / 2;
        int left = marginHorizontal;
        int right = left + width;
        int top = this.getHeight() - height - marginVertical;
        int bottom = top + height;
        long dataHandle = 0L;
        if (this.mPiAudioOff == null) {
            videoMgr.removePic(this.mRenderInfo, 3);
            dataHandle = videoMgr.addPic(this.mRenderInfo, 3, bmp, 255, 0, left, top, right, bottom);
            if (dataHandle != 0L) {
                this.mPiAudioOff = new ISDKVideoUnit.SDKPicInfo(dataHandle, bmp.getWidth(), bmp.getHeight());
            }
            bmp.recycle();
        } else {
            dataHandle = videoMgr.movePic2(this.mRenderInfo, 3, left, top, right, bottom);
        }
    }

    private Bitmap createAudioOffBitmap() {
        int resId = this.mAudioType == 0L ? R.drawable.zm_audio_off_small : R.drawable.zm_phone_off_small;
        Drawable drawable2 = VideoBoxApplication.getInstance().getResources().getDrawable(resId);
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }

    public void onUserAudioStatus() {
        if (this.getCanShowAudioOff()) {
            this.updateAudioOff();
        }
    }

    public void onUserVideoStatus() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (this.mUserId != 0L) {
            this.mVideoType = videoMgr.getVideoTypeByID(this.mUserId);
        }
    }

    private void updateAudioOff() {
        CmmUser user = ConfMgr.getInstance().getUserById(this.mUserId);
        if (user == null) {
            return;
        }
        CmmAudioStatus status = user.getAudioStatusObj();
        if (status == null) {
            return;
        }
        long oldAudioType = this.mAudioType;
        this.mAudioType = status.getAudiotype();
        boolean bl = this.mbAudioOff = status.getIsMuted() && this.mAudioType != 2L;
        if (this.mAudioType != oldAudioType) {
            this.mPiAudioOff = null;
        }
        this.showAudioOff(this.mbAudioOff);
    }

    public void onNetworkStatusChanged() {
        if (this.getCanShowNetworkStatus()) {
            this.updateNetworkStatus();
        }
        this.updateVideoSizeInfo();
    }

    private void updateVideoSizeInfo() {
        String userName;
        CmmUser user;
        if (ZMLog.isLogEnabled() && this.mType == 1 && this.isUserNameVisible() && (user = ConfMgr.getInstance().getUserById(this.mUserId)) != null && !StringUtil.isSameString((String)(userName = this.getUserDisplayName(user)), (String)this.mUserName)) {
            this.mPiUserName = null;
            this.mUserName = userName;
            this.showUserName();
        }
    }

    private void updateNetworkStatus() {
        CmmUser user = ConfMgr.getInstance().getUserById(this.mUserId);
        if (user == null) {
            return;
        }
        CmmVideoStatus status = user.getVideoStatusObj();
        if (status == null) {
            return;
        }
        int oldStatus = this.mNetworkStatus;
        this.mNetworkStatus = status.getVideoQuality();
        if (this.mNetworkStatus != oldStatus) {
            this.mPiNetworkStatus = null;
        }
        boolean visibilityChanged = oldStatus == -1 && this.mNetworkStatus != -1 || oldStatus != -1 && this.mNetworkStatus == -1;
        this.showNetworkStatus(this.mNetworkStatus != -1, visibilityChanged);
    }

    public void updateAvatar() {
        this.mPiAvatar = null;
        CmmUser user = ConfMgr.getInstance().getUserById(this.mUserId);
        if (user != null) {
            this.mAvatarSmall = user.getSmallPicPath();
            this.mAvatarBig = user.getLocalPicPath();
        }
        if (this.mHasAvatar) {
            this.showAvatar();
        }
    }

    private void showNetworkStatus(boolean show, boolean visibilityChanged) {
        if (!this.getCanShowNetworkStatus()) {
            show = false;
        }
        if (this.mIsUserNameVisible && this.mUserId != 0L && visibilityChanged) {
            this.showUserName();
        }
        if (this.mbAudioOff && this.mCanShowAudioOff && visibilityChanged) {
            this.showAudioOff(true);
        }
        boolean _show = show;
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (!_show) {
            if (videoMgr.removePic(this.mRenderInfo, 5)) {
                this.mPiNetworkStatus = null;
            }
            return;
        }
        Bitmap bmp = null;
        int width = 0;
        int height = 0;
        if (this.mPiNetworkStatus != null) {
            width = this.mPiNetworkStatus.bmpWidth;
            height = this.mPiNetworkStatus.bmpHeight;
        } else {
            bmp = this.createNetworkStatusBitmap();
            if (bmp == null) {
                return;
            }
            width = bmp.getWidth();
            height = bmp.getHeight();
        }
        int marginHorizontal = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)2.0f);
        int marginVertical = (s_textHeight - height) / 2;
        int left = marginHorizontal;
        int right = left + width;
        int top = this.getHeight() - height - marginVertical;
        int bottom = top + height;
        long dataHandle = 0L;
        if (this.mPiNetworkStatus == null) {
            videoMgr.removePic(this.mRenderInfo, 5);
            dataHandle = videoMgr.addPic(this.mRenderInfo, 5, bmp, 255, 0, left, top, right, bottom);
            if (dataHandle != 0L) {
                this.mPiNetworkStatus = new ISDKVideoUnit.SDKPicInfo(dataHandle, bmp.getWidth(), bmp.getHeight());
            }
            bmp.recycle();
        } else {
            dataHandle = videoMgr.movePic2(this.mRenderInfo, 5, left, top, right, bottom);
        }
    }

    private Bitmap createNetworkStatusBitmap() {
        int drawableId = 0;
        switch (this.mNetworkStatus) {
            case 0: {
                drawableId = R.drawable.zm_network_bad;
                break;
            }
            case 1: {
                drawableId = R.drawable.zm_network_normal;
                break;
            }
            default: {
                drawableId = R.drawable.zm_network_good;
            }
        }
        Drawable drawable2 = VideoBoxApplication.getInstance().getResources().getDrawable(drawableId);
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }

    @Override
    public void updateUnitInfo(RendererUnitInfo unitInfo) {
    }

    static {
        sAudioOffWidth = 0;
        sNetworkStatusWidth = 0;
    }
}

