/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sdk;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.zipow.annotate.ZoomShareData;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.util.DesktopModeReceiver;
import com.zipow.videobox.view.ShareToolbar;
import java.nio.ByteBuffer;
import us.zoom.androidlib.util.StringUtil;

@TargetApi(value=21)
public class SDKScreenShareMgr
implements ShareToolbar.Listener,
DesktopModeReceiver.DesktopModeListener {
    private PowerManager.WakeLock mWakeLock;
    private static final String TAG = SDKScreenShareMgr.class.getSimpleName();
    private final int MIN_CAPTURE_RESOTION = 540;
    private int mDisplayWidth;
    private int mDisplayHeight;
    private int mScreenDensity;
    private int mLogTimes = 0;
    private MediaProjectionManager mProjectionManager;
    private MediaProjection mMediaProjection;
    private VirtualDisplay mVirtualDisplay;
    private ImageReader mImageReader;
    private ImageReader mImageReaderRotated;
    private ImageAvailableListener mImageAvailableListener;
    private VirtualDisplayCallback mVirtualDisplayCallback;
    boolean mReloadingVirtualDisplay = false;
    boolean mIsSharing;
    boolean mIsShared = false;
    private BroadcastReceiver mScreenBroadcastReceiver;
    boolean mIsCustomShare;
    private Handler mHandler;
    byte[] mPixels;
    Intent mIntent;
    Listener mListener;
    private ShareToolbar mShareToolbar;
    private static SDKScreenShareMgr instance = null;
    private DesktopModeReceiver mDesktopReceiver;

    public static synchronized SDKScreenShareMgr getInstance() {
        if (instance == null) {
            instance = new SDKScreenShareMgr();
        }
        return instance;
    }

    private SDKScreenShareMgr() {
    }

    public void initialize(Listener l) {
        this.mListener = l;
    }

    public void unInitialize() {
        this.mListener = null;
    }

    @SuppressLint(value={"InlinedApi"})
    public void prepare(Intent data) {
        this.mIsSharing = true;
        this.mIntent = data;
        this.mShareToolbar = new ShareToolbar(this);
        this.mImageAvailableListener = new ImageAvailableListener();
        this.mVirtualDisplayCallback = new VirtualDisplayCallback();
        this.mProjectionManager = (MediaProjectionManager)VideoBoxApplication.getInstance().getSystemService("media_projection");
    }

    public boolean isSharing() {
        return this.mIsSharing;
    }

    private void adjustDisplayMetrics() {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)VideoBoxApplication.getInstance().getSystemService("window");
        if (wm == null) {
            return;
        }
        Display disp = wm.getDefaultDisplay();
        disp.getRealMetrics(metrics);
        this.mScreenDensity = metrics.densityDpi;
        int resolution = Math.min(metrics.widthPixels, metrics.heightPixels);
        if (resolution / 2 >= 540 && metrics.density >= 2.0f) {
            ZoomShareData.getInstance().setIsHDPI(true);
            this.mDisplayWidth = metrics.widthPixels / 2;
            this.mDisplayHeight = metrics.heightPixels / 2;
        } else {
            ZoomShareData.getInstance().setIsHDPI(false);
            this.mDisplayWidth = metrics.widthPixels;
            this.mDisplayHeight = metrics.heightPixels;
        }
    }

    private boolean screenRotated(int imageWidth, int imageHeight) {
        this.adjustDisplayMetrics();
        return imageWidth != this.mDisplayWidth || imageHeight != this.mDisplayHeight;
    }

    public void startShare() {
        if (this.mProjectionManager == null) {
            return;
        }
        if (this.mMediaProjection != null) {
            return;
        }
        if (!this.mIsSharing) {
            return;
        }
        this.mMediaProjection = this.mProjectionManager.getMediaProjection(-1, this.mIntent);
        if (this.mMediaProjection == null) {
            return;
        }
        this.mIsShared = true;
        if (this.mDesktopReceiver == null) {
            this.mDesktopReceiver = new DesktopModeReceiver();
        }
        this.mDesktopReceiver.setListener(this);
        this.mDesktopReceiver.registerReceiver((Context)VideoBoxApplication.getInstance());
        WorkThread workThread = new WorkThread();
        workThread.start();
        if (this.mShareToolbar != null) {
            this.mShareToolbar.showToolbar();
        }
        try {
            PowerManager pManager;
            if (this.mWakeLock == null && (pManager = (PowerManager)VideoBoxApplication.getInstance().getSystemService("power")) != null) {
                this.mWakeLock = pManager.newWakeLock(0x2000000A, "ZoomScreenShare");
                this.mWakeLock.acquire();
            }
        }
        catch (Exception pManager) {
            // empty catch block
        }
        if (this.mScreenBroadcastReceiver == null) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.SCREEN_OFF");
            this.mScreenBroadcastReceiver = new ScreenBroadcastReceiver();
            VideoBoxApplication.getInstance().registerReceiver(this.mScreenBroadcastReceiver, filter);
        }
    }

    public void onOrientationChanged() {
        if (this.mShareToolbar != null) {
            this.mShareToolbar.updateLayoutparameter();
        }
    }

    private void createImageReader() {
        this.adjustDisplayMetrics();
        if (this.mImageReader == null) {
            this.mImageReader = ImageReader.newInstance((int)this.mDisplayWidth, (int)this.mDisplayHeight, (int)1, (int)1);
            this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this.mImageAvailableListener, this.mHandler);
        } else if (this.mImageReader.getWidth() != this.mDisplayWidth && this.mImageReaderRotated == null) {
            this.mImageReaderRotated = ImageReader.newInstance((int)this.mDisplayWidth, (int)this.mDisplayHeight, (int)1, (int)1);
            this.mImageReaderRotated.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this.mImageAvailableListener, this.mHandler);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private void createVirtualDisplay() {
        if (this.mMediaProjection == null) {
            return;
        }
        this.createImageReader();
        try {
            this.mVirtualDisplay = this.mImageReader.getWidth() == this.mDisplayWidth ? this.mMediaProjection.createVirtualDisplay("ScreenSharing", this.mDisplayWidth, this.mDisplayHeight, this.mScreenDensity, 8, this.mImageReader.getSurface(), (VirtualDisplay.Callback)this.mVirtualDisplayCallback, this.mHandler) : this.mMediaProjection.createVirtualDisplay("ScreenSharing", this.mDisplayWidth, this.mDisplayHeight, this.mScreenDensity, 8, this.mImageReaderRotated.getSurface(), (VirtualDisplay.Callback)this.mVirtualDisplayCallback, this.mHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reloadVirtualDisplay() {
        if (this.mVirtualDisplay != null) {
            this.mReloadingVirtualDisplay = true;
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
        }
    }

    public void stopShare() {
        this.mIsSharing = false;
        this.mLogTimes = 0;
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
        }
        if (this.mMediaProjection != null) {
            this.mMediaProjection.stop();
            this.mMediaProjection = null;
        }
        if (this.mShareToolbar != null) {
            this.mShareToolbar.destroy();
            this.mShareToolbar = null;
        }
        if (this.mHandler != null) {
            this.mHandler.getLooper().quitSafely();
            this.mHandler = null;
        }
        try {
            if (this.mWakeLock != null) {
                this.mWakeLock.release();
                this.mWakeLock = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mScreenBroadcastReceiver != null) {
            VideoBoxApplication.getInstance().unregisterReceiver(this.mScreenBroadcastReceiver);
            this.mScreenBroadcastReceiver = null;
        }
        if (this.mDesktopReceiver != null) {
            this.mDesktopReceiver.unregisterReceiver((Context)VideoBoxApplication.getInstance());
            this.mDesktopReceiver = null;
        }
        this.mProjectionManager = null;
    }

    @Override
    public void onClickStopShare() {
        if (this.mListener != null) {
            this.mListener.onClickStopScreenShare();
        } else {
            this.stopShareSession();
            if (this.isSharing()) {
                this.stopShare();
            }
        }
    }

    @Override
    public void onAnnoStatusChanged() {
        if (this.mListener != null) {
            this.mListener.onAnnoStatusChanged();
        }
    }

    public boolean stopShareSession() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        return shareSession.stopShare();
    }

    public void setAnnoToolbarVisible(boolean bVisible) {
        if (this.mShareToolbar != null) {
            this.mShareToolbar.setAnnoToolbarVisible(bVisible);
        }
    }

    @Override
    public void onDesktopModeChange(boolean on) {
        boolean isAnnoToolbarVisible = false;
        if (this.mShareToolbar != null) {
            isAnnoToolbarVisible = this.mShareToolbar.isAnnotationStart();
            this.mShareToolbar.destroy();
            this.mShareToolbar = null;
        }
        this.mShareToolbar = new ShareToolbar(this);
        if (this.mIsShared) {
            this.mShareToolbar.showToolbar();
            if (isAnnoToolbarVisible) {
                this.mShareToolbar.setAnnoToolbarVisible(true);
            } else {
                this.mShareToolbar.setAnnoToolbarVisible(false);
            }
        }
    }

    class WorkThread
    extends Thread {
        WorkThread() {
        }

        @Override
        public void run() {
            Looper.prepare();
            SDKScreenShareMgr.this.mHandler = new Handler();
            SDKScreenShareMgr.this.createVirtualDisplay();
            Looper.loop();
            if (SDKScreenShareMgr.this.mImageReader != null) {
                SDKScreenShareMgr.this.mImageReader.close();
                SDKScreenShareMgr.this.mImageReader = null;
            }
            if (SDKScreenShareMgr.this.mImageReaderRotated != null) {
                SDKScreenShareMgr.this.mImageReaderRotated.close();
                SDKScreenShareMgr.this.mImageReaderRotated = null;
            }
        }
    }

    private class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        private ImageAvailableListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader reader) {
            try (Image img = null;){
                img = reader.acquireLatestImage();
                if (img == null) {
                    return;
                }
                if (SDKScreenShareMgr.this.screenRotated(img.getWidth(), img.getHeight())) {
                    SDKScreenShareMgr.this.reloadVirtualDisplay();
                    return;
                }
                Image.Plane[] planes = img.getPlanes();
                if (planes[0].getBuffer() == null) {
                    return;
                }
                ByteBuffer buffer = (ByteBuffer)planes[0].getBuffer().rewind();
                ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
                if (shareSession != null) {
                    shareSession.setCaptureFrame(img.getWidth(), img.getHeight(), planes[0].getRowStride(), buffer);
                }
            }
        }
    }

    private class VirtualDisplayCallback
    extends VirtualDisplay.Callback {
        private VirtualDisplayCallback() {
        }

        public void onPaused() {
        }

        public void onResumed() {
        }

        public void onStopped() {
            if (SDKScreenShareMgr.this.mReloadingVirtualDisplay) {
                SDKScreenShareMgr.this.mReloadingVirtualDisplay = false;
                SDKScreenShareMgr.this.createVirtualDisplay();
            }
        }
    }

    private class ScreenBroadcastReceiver
    extends BroadcastReceiver {
        private ScreenBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (StringUtil.isSameString((String)intent.getAction(), (String)"android.intent.action.SCREEN_OFF")) {
                SDKScreenShareMgr.this.onClickStopShare();
            }
        }
    }

    public static interface Listener {
        public void onClickStopScreenShare();

        public void onAnnoStatusChanged();
    }
}

