/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.sdk;

import com.zipow.annotate.AnnoToolType;
import com.zipow.videobox.sdk.ISDKAnnotateToolDelegate;

public class SDKAnnotationMgr {
    private ISDKAnnotateToolDelegate annotateToolDelegate;
    private static SDKAnnotationMgr instance = null;

    private SDKAnnotationMgr() {
    }

    public static synchronized SDKAnnotationMgr getInstance() {
        if (instance == null) {
            instance = new SDKAnnotationMgr();
        }
        return instance;
    }

    void setAnnotateToolDelegate(ISDKAnnotateToolDelegate delegate) {
        this.annotateToolDelegate = delegate;
    }

    static synchronized void clearInstance() {
        instance = null;
    }

    public boolean startAnnotation() {
        if (this.annotateToolDelegate == null) {
            return false;
        }
        this.annotateToolDelegate.startAnnotation();
        return true;
    }

    public boolean stopAnnotation() {
        if (this.annotateToolDelegate == null) {
            return false;
        }
        this.annotateToolDelegate.stopAnnotation();
        return true;
    }

    public boolean setToolWidth(int width) {
        if (this.annotateToolDelegate == null) {
            return false;
        }
        this.annotateToolDelegate.setToolWidth(width, true);
        return true;
    }

    public boolean setToolColor(int color2) {
        if (this.annotateToolDelegate == null) {
            return false;
        }
        this.annotateToolDelegate.setToolColor(color2);
        return true;
    }

    public boolean setToolType(AnnoToolType toolType) {
        if (this.annotateToolDelegate == null) {
            return false;
        }
        this.annotateToolDelegate.setCurAnnoTool(toolType);
        return true;
    }

    public boolean redo() {
        if (this.annotateToolDelegate == null) {
            return false;
        }
        this.annotateToolDelegate.redo();
        return true;
    }

    public boolean undo() {
        if (this.annotateToolDelegate == null) {
            return false;
        }
        this.annotateToolDelegate.undo();
        return true;
    }

    public boolean eraseAll() {
        if (this.annotateToolDelegate == null) {
            return false;
        }
        this.annotateToolDelegate.eraseAll();
        return true;
    }

    public boolean isPresenter() {
        if (this.annotateToolDelegate == null) {
            return false;
        }
        return this.annotateToolDelegate.isPresenter();
    }
}

