/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import com.google.protobuf.InvalidProtocolBufferException;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomPublicRoomSearchUI;
import com.zipow.videobox.view.mm.MMZoomXMPPRoom;

public class ZoomPublicRoomSearchData {
    private long mNativeHandle = 0L;

    public ZoomPublicRoomSearchData(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void setCallback(ZoomPublicRoomSearchUI ui) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.setCallbackImpl(this.mNativeHandle, ui.getNativeHandle());
    }

    public boolean search(String key, int maxSize) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (key == null) {
            key = "";
        }
        return this.searchImpl(this.mNativeHandle, key, maxSize);
    }

    public boolean getNextPage() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.getNextPageImpl(this.mNativeHandle);
    }

    public void cancelSearch() {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.cancelSearchImpl(this.mNativeHandle);
    }

    public int getRoomCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getRoomCountImpl(this.mNativeHandle);
    }

    public MMZoomXMPPRoom getZoomXMPPRoomAt(int idx) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] data = this.getZoomXMPPRoomAtImpl(this.mNativeHandle, idx);
        if (data == null) {
            return null;
        }
        try {
            PTAppProtos.ZoomXMPPRoom room = PTAppProtos.ZoomXMPPRoom.parseFrom(data);
            MMZoomXMPPRoom mmRoom = new MMZoomXMPPRoom();
            mmRoom.setJid(room.getJid());
            mmRoom.setName(room.getName());
            mmRoom.setCount(room.getMemberCount());
            return mmRoom;
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    public String getSearchKey() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getSearchKeyImpl(this.mNativeHandle);
    }

    public boolean hasMoreDataOnServerSide() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.hasMoreDataOnServerSideImpl(this.mNativeHandle);
    }

    public boolean isSearching() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isSearchingImpl(this.mNativeHandle);
    }

    public boolean joinRoom(String roomJID) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.joinRoomImpl(this.mNativeHandle, roomJID);
    }

    private native void setCallbackImpl(long var1, long var3);

    private native boolean searchImpl(long var1, String var3, int var4);

    private native boolean getNextPageImpl(long var1);

    private native void cancelSearchImpl(long var1);

    private native int getRoomCountImpl(long var1);

    private native byte[] getZoomXMPPRoomAtImpl(long var1, int var3);

    private native String getSearchKeyImpl(long var1);

    private native boolean hasMoreDataOnServerSideImpl(long var1);

    private native boolean isSearchingImpl(long var1);

    private native boolean joinRoomImpl(long var1, String var3);
}

