/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.util.EmojiHelper;
import java.io.IOException;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class ZoomMessage {
    private static final String TAG = ZoomMessage.class.getSimpleName();
    private long mNativeHandle = 0L;

    public ZoomMessage(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public String getMessageID() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getMessageIDImpl(this.mNativeHandle);
    }

    public int getMessageType() {
        if (this.mNativeHandle == 0L) {
            return -1;
        }
        return this.getMessageTypeImpl(this.mNativeHandle);
    }

    public int getMessageState() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getMessageStateImpl(this.mNativeHandle);
    }

    public boolean isUnread() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isUnreadImpl(this.mNativeHandle);
    }

    public void setAsReaded(boolean readed) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.setAsReadedImpl(this.mNativeHandle, readed);
    }

    public boolean isPlayed() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isPlayedImpl(this.mNativeHandle);
    }

    public void setAsPlayed(boolean played) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        this.setAsPlayedImpl(this.mNativeHandle, played);
    }

    public String getReceiverID() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getReceiverIDImpl(this.mNativeHandle);
    }

    public String getSenderID() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getSenderIDImpl(this.mNativeHandle);
    }

    public String getGroupID() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getGroupIDImpl(this.mNativeHandle);
    }

    public long getStamp() {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        return this.getStampImpl(this.mNativeHandle) * 1000L;
    }

    public long getServerSideTime() {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        return this.getServerSideTimeImpl(this.mNativeHandle);
    }

    public CharSequence getBodyWithShortcut() {
        CharSequence cs;
        if (this.mNativeHandle == 0L) {
            return null;
        }
        String msg = this.getBodyImpl(this.mNativeHandle);
        if (msg != null && (cs = StringUtil.compatNewLineForAllOS((CharSequence)msg)) != null) {
            msg = cs.toString();
        }
        return EmojiHelper.getInstance().tranToShortcutText(msg, this.getEmojiList());
    }

    public CharSequence getBody() {
        CharSequence cs;
        if (this.mNativeHandle == 0L) {
            return null;
        }
        String msg = this.getBodyImpl(this.mNativeHandle);
        if (msg != null && (cs = StringUtil.compatNewLineForAllOS((CharSequence)msg)) != null) {
            msg = cs.toString();
        }
        return EmojiHelper.getInstance().tranToEmojiText(msg, this.getEmojiList());
    }

    public List<String> getMsgAtList() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getMessageAtListImpl(this.mNativeHandle);
    }

    public String getLocalFilePath() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getLocalFilePathImpl(this.mNativeHandle);
    }

    public String getPicturePreviewPath() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getPicturePreviewPathImpl(this.mNativeHandle);
    }

    public boolean isFileDownloaded() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isFileDownloadedImpl(this.mNativeHandle);
    }

    public int getAudioLength() {
        if (this.mNativeHandle == 0L) {
            return -1;
        }
        return this.getAudioLengthImpl(this.mNativeHandle);
    }

    public int getVideoLength() {
        if (this.mNativeHandle == 0L) {
            return -1;
        }
        return this.getVideoLengthImpl(this.mNativeHandle);
    }

    public boolean isE2EMessage() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isE2EMessageImpl(this.mNativeHandle);
    }

    public boolean isMessageAtEveryone() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isMessageAtEveryoneImpl(this.mNativeHandle);
    }

    public boolean isHistorySyncMessage() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isHistorySyncMessageImpl(this.mNativeHandle);
    }

    public FileInfo getFileInfo() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        Object[] ret = new Object[2];
        boolean succ = this.getFileInfoImpl(this.mNativeHandle, ret);
        if (!succ) {
            return null;
        }
        FileInfo info = new FileInfo();
        if (ret[0] instanceof Number) {
            info.size = ((Number)ret[0]).longValue();
        }
        if (ret[1] instanceof String) {
            info.name = (String)ret[1];
        }
        return info;
    }

    public FileTransferInfo getFileTransferInfo() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        Object[] ret = new Object[5];
        boolean succ = this.getFileTransferInfoImpl(this.mNativeHandle, ret);
        if (!succ) {
            return null;
        }
        FileTransferInfo info = new FileTransferInfo();
        if (ret[0] instanceof Number) {
            info.state = ((Number)ret[0]).intValue();
        }
        if (ret[1] instanceof Number) {
            info.percentage = ((Number)ret[1]).intValue();
        }
        if (ret[2] instanceof Number) {
            info.bitsPerSecond = ((Number)ret[2]).longValue();
        }
        if (ret[3] instanceof Number) {
            info.transferredSize = ((Number)ret[3]).longValue();
        }
        if (ret[4] instanceof Number) {
            info.prevError = ((Number)ret[4]).intValue();
        }
        return info;
    }

    public PTAppProtos.EmojiList getEmojiList() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] content = this.getEmojiListImpl(this.mNativeHandle);
        try {
            return content == null ? null : PTAppProtos.EmojiList.parseFrom(content);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getMessageXMPPGuid() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getMessageXMPPGuidImpl(this.mNativeHandle);
    }

    public String getSenderName() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getSenderNameImpl(this.mNativeHandle);
    }

    public boolean isStickerMessage() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isStickerMessageImpl(this.mNativeHandle);
    }

    public boolean isSupportedMessage() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isSupportedMessageImpl(this.mNativeHandle);
    }

    public long getEditActionMilliSecTime() {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        return this.getEditActionMilliSecTimeImpl(this.mNativeHandle);
    }

    public String getGiphyID() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getGiphyIDImpl(this.mNativeHandle);
    }

    public boolean isMessageAtMe() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isMessageAtMeImpl(this.mNativeHandle);
    }

    public int getMessageFilterResult() {
        if (this.mNativeHandle == 0L) {
            return 1;
        }
        return this.getMessageFilterResultImpl(this.mNativeHandle);
    }

    public boolean isOfflineMessage() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.IsOfflineMessageImpl(this.mNativeHandle);
    }

    public boolean needTriggerUpdate() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.needTriggerUpdateImpl(this.mNativeHandle);
    }

    private native String getMessageIDImpl(long var1);

    private native String getReceiverIDImpl(long var1);

    private native String getSenderIDImpl(long var1);

    private native String getGroupIDImpl(long var1);

    private native long getStampImpl(long var1);

    private native long getServerSideTimeImpl(long var1);

    private native String getBodyImpl(long var1);

    private native String getLocalFilePathImpl(long var1);

    private native String getPicturePreviewPathImpl(long var1);

    private native int getMessageTypeImpl(long var1);

    private native int getMessageStateImpl(long var1);

    private native int getAudioLengthImpl(long var1);

    private native int getVideoLengthImpl(long var1);

    private native boolean isUnreadImpl(long var1);

    private native boolean isFileDownloadedImpl(long var1);

    private native boolean isPlayedImpl(long var1);

    private native void setAsReadedImpl(long var1, boolean var3);

    private native void setAsPlayedImpl(long var1, boolean var3);

    private native boolean getFileInfoImpl(long var1, Object[] var3);

    private native boolean getFileTransferInfoImpl(long var1, Object[] var3);

    private native List<String> getMessageAtListImpl(long var1);

    private native byte[] getEmojiListImpl(long var1);

    private native boolean isE2EMessageImpl(long var1);

    private native boolean isMessageAtEveryoneImpl(long var1);

    private native boolean isHistorySyncMessageImpl(long var1);

    private native String getMessageXMPPGuidImpl(long var1);

    private native String getSenderNameImpl(long var1);

    private native boolean isStickerMessageImpl(long var1);

    private native boolean isSupportedMessageImpl(long var1);

    private native long getEditActionMilliSecTimeImpl(long var1);

    private native String getGiphyIDImpl(long var1);

    private native boolean isMessageAtMeImpl(long var1);

    private native int getMessageFilterResultImpl(long var1);

    private native boolean IsOfflineMessageImpl(long var1);

    private native boolean needTriggerUpdateImpl(long var1);

    public static class FileTransferInfo {
        public int state;
        public int percentage;
        public long bitsPerSecond;
        public long transferredSize;
        public int prevError;
    }

    public static class FileInfo {
        public long size;
        public String name;
    }
}

