/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import android.content.Context;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class ZoomGroup {
    private static final String TAG = ZoomGroup.class.getSimpleName();
    private long mNativeHandle = 0L;

    public ZoomGroup(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public String getGroupID() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getGroupIDImpl(this.mNativeHandle);
    }

    public String getGroupName() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getGroupNameImpl(this.mNativeHandle);
    }

    public static String createDefaultMUCName(List<String> buddies) {
        int i;
        if (CollectionsUtil.isListEmpty(buddies)) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return "";
        }
        StringBuilder nameBuilder = new StringBuilder();
        String comma = VideoBoxApplication.getInstance().getString(R.string.zm_mm_group_names_list_comma) + " ";
        ArrayList<String> buddyNames = new ArrayList<String>();
        for (String jid : buddies) {
            String name;
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null || StringUtil.isEmptyOrNull((String)(name = BuddyNameUtil.getBuddyDisplayName(buddy, null, false)))) continue;
            buddyNames.add(name);
        }
        if (buddyNames.size() > 3) {
            for (i = 0; i < 2; ++i) {
                nameBuilder.append((String)buddyNames.get(i)).append(comma);
            }
        } else {
            for (i = 0; i < buddyNames.size(); ++i) {
                nameBuilder.append((String)buddyNames.get(i)).append(comma);
            }
        }
        if (nameBuilder.length() > 0) {
            nameBuilder.setLength(nameBuilder.length() - comma.length());
            nameBuilder.trimToSize();
        }
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (buddyNames.size() > 3 && context != null) {
            return context.getString(R.string.zm_lbl_empty_group_name_greater_3, new Object[]{nameBuilder.toString()});
        }
        return nameBuilder.toString();
    }

    public String getGroupDisplayName(Context context) {
        String groupName = this.getGroupName();
        if (!StringUtil.isEmptyOrNull((String)groupName)) {
            return groupName;
        }
        String groupId = this.getGroupID();
        if (groupId == null) {
            return "";
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return "";
        }
        ZoomGroup group = messenger.getGroupById(groupId);
        if (group == null) {
            return "";
        }
        int count = group.getBuddyCount();
        ArrayList<String> jids = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            ZoomBuddy buddy = group.getBuddyAt(i);
            if (buddy == null) continue;
            jids.add(buddy.getJid());
        }
        return ZoomGroup.createDefaultMUCName(jids);
    }

    public String getGroupOwner() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getGroupOwnerImpl(this.mNativeHandle);
    }

    public int getBuddyCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getBuddyCountImpl(this.mNativeHandle);
    }

    public ZoomBuddy getBuddyAt(int idx) {
        if (this.mNativeHandle == 0L || idx < 0) {
            return null;
        }
        long buddyHandle = this.getBuddyAtImpl(this.mNativeHandle, idx);
        if (buddyHandle == 0L) {
            return null;
        }
        return new ZoomBuddy(buddyHandle);
    }

    public boolean amIInGroup() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.amIInGroupImpl(this.mNativeHandle);
    }

    public boolean isForceE2EGroup() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isForceE2EGroupImpl(this.mNativeHandle);
    }

    public static String getGroupAvatarPath(String groupId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        String sessionDataFolder = messenger.getSessionDataFolder(groupId);
        if (StringUtil.isEmptyOrNull((String)sessionDataFolder)) {
            return null;
        }
        String avatarPath = sessionDataFolder + "/avatar.png";
        return avatarPath;
    }

    public boolean isPublicRoom() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isPublicRoomImpl(this.mNativeHandle);
    }

    public boolean isPrivateRoom() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isPrivateRoomImpl(this.mNativeHandle);
    }

    public boolean isNewMUC() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isNewMUCImpl(this.mNativeHandle);
    }

    public int getMucType() {
        if (this.mNativeHandle == 0L) {
            return -1;
        }
        return this.getMucTypeImpl(this.mNativeHandle);
    }

    public boolean isRoom() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isRoomImpl(this.mNativeHandle);
    }

    public List<String> getGroupAdmins() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getGroupAdminsImpl(this.mNativeHandle);
    }

    public boolean amIGroupAdmin() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.amIGroupAdminImpl(this.mNativeHandle);
    }

    public boolean amIGroupOwner() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.amIGroupOwnerImpl(this.mNativeHandle);
    }

    public boolean isGroupOperatorable() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (this.amIGroupAdmin()) {
            return true;
        }
        List<String> admins = this.getGroupAdmins();
        if (admins == null || admins.size() == 0) {
            return this.amIGroupOwner();
        }
        return false;
    }

    public List<String> getE2EOnLineMembers() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getE2EOnLineMembersImpl(this.mNativeHandle);
    }

    private native String getGroupIDImpl(long var1);

    private native String getGroupNameImpl(long var1);

    private native String getGroupOwnerImpl(long var1);

    private native int getBuddyCountImpl(long var1);

    private native long getBuddyAtImpl(long var1, int var3);

    private native boolean amIInGroupImpl(long var1);

    private native boolean isForceE2EGroupImpl(long var1);

    private native boolean isPublicRoomImpl(long var1);

    private native boolean isPrivateRoomImpl(long var1);

    private native boolean isNewMUCImpl(long var1);

    private native int getMucTypeImpl(long var1);

    private native boolean isRoomImpl(long var1);

    private native List<String> getGroupAdminsImpl(long var1);

    private native boolean amIGroupAdminImpl(long var1);

    private native boolean amIGroupOwnerImpl(long var1);

    private native List<String> getE2EOnLineMembersImpl(long var1);
}

