/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import android.os.Handler;
import android.os.Message;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.PinyinUtil;
import us.zoom.androidlib.util.StringUtil;

public class ZMBuddySyncInstance {
    private static ZMBuddySyncInstance mInstance;
    private static final String TAG;
    private static final int BUDDY_COUNT_PER_PAGE = 1000;
    private static final int MSG_REFRESH_ALL_BUDDIES = 1;
    private static final int MSG_BUDDY_INFO_UPDATE_CHECKER = 2;
    private Map<String, IMAddrBookItem> mBuddies = new HashMap<String, IMAddrBookItem>();
    private List<String> mDeletedJids = new ArrayList<String>();
    private ListenerList mListenerList = new ListenerList();
    private List<String> mPendingPresenceUpdateJids = new ArrayList<String>();
    private List<String> mPendingInfoUpdateJids = new ArrayList<String>();
    private static final int TYPE_BUDDY_NO_CHANGE = 0;
    private static final int TYPE_BUDDY_INFO_CHANGE = 1;
    private static final int TYPE_BUDDIES_SIZE_CHANGE = 2;
    private int mChangeType = 0;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ZMBuddySyncInstance.this.clearAllBuddies();
                    ZMBuddySyncInstance.this.loadAllBuddies();
                    break;
                }
                case 2: {
                    if (ZMBuddySyncInstance.this.mChangeType != 0) {
                        IListener[] listeners;
                        block8: for (IListener lTmp : listeners = ZMBuddySyncInstance.this.mListenerList.getAll()) {
                            ZMBuddyListListener l = (ZMBuddyListListener)lTmp;
                            switch (ZMBuddySyncInstance.this.mChangeType) {
                                case 1: {
                                    l.onBuddyInfoUpdate(ZMBuddySyncInstance.this.mPendingPresenceUpdateJids, ZMBuddySyncInstance.this.mPendingInfoUpdateJids);
                                    continue block8;
                                }
                                case 2: {
                                    l.onBuddyListUpdate();
                                    continue block8;
                                }
                            }
                        }
                        ZMBuddySyncInstance.this.mPendingPresenceUpdateJids.clear();
                        ZMBuddySyncInstance.this.mPendingInfoUpdateJids.clear();
                    }
                    ZMBuddySyncInstance.this.mChangeType = 0;
                    this.sendEmptyMessageDelayed(2, 1000L);
                    break;
                }
            }
        }
    };
    private Object mSortBuddiesLocker = new Object();
    private Runnable mLoadCaptureBuddiesRunnable = new Runnable(){

        @Override
        public void run() {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            byte[] res = ZMBuddySyncInstance.this.loadCaptureBuddies(1000);
            if (res != null) {
                try {
                    PTAppProtos.AllBuddyInfo info = PTAppProtos.AllBuddyInfo.parseFrom(res);
                    if (info == null || info.getJidsCount() == 0) {
                        ZMBuddySyncInstance.this.mDeletedJids.clear();
                        ZMBuddySyncInstance.this.mChangeType = 2;
                        return;
                    }
                    boolean isFirstLoad = ZMBuddySyncInstance.this.mBuddies.isEmpty();
                    for (int i = 0; i < info.getJidsCount(); ++i) {
                        IMAddrBookItem item;
                        String jid = info.getJids(i);
                        if (ZMBuddySyncInstance.this.mDeletedJids.contains(jid) || (item = (IMAddrBookItem)ZMBuddySyncInstance.this.mBuddies.get(jid)) != null && item.isPropertyInit()) continue;
                        item = new IMAddrBookItem(jid, info.getScreenName(i), info.getPhoneNumber(i), info.getIsBuddy(i), info.getIsDesktopOnLine(i), info.getIsMobileOnLine(i), info.getEmail(i), info.getIsZoomRoom(i), info.getSipPhoneNumber(i));
                        ZMBuddySyncInstance.this.mBuddies.put(jid, item);
                    }
                    if (isFirstLoad) {
                        ZMBuddySyncInstance.this.mChangeType = 2;
                    }
                    ZMBuddySyncInstance.this.mHandler.postDelayed((Runnable)this, 2000L);
                }
                catch (IOException e) {
                    ZMBuddySyncInstance.this.mHandler.postDelayed((Runnable)this, 10000L);
                }
            } else {
                ZMBuddySyncInstance.this.mHandler.postDelayed((Runnable)this, 10000L);
            }
        }
    };
    private boolean mRefreshAllBuddyThread = false;
    private Object mRefreshAllBuddyLocker = new Object();
    private Object mNaviteBuddyVetctLocker = new Object();

    public static synchronized ZMBuddySyncInstance getInsatance() {
        if (mInstance == null) {
            mInstance = new ZMBuddySyncInstance();
        }
        return mInstance;
    }

    private ZMBuddySyncInstance() {
        this.init();
    }

    public void addListener(ZMBuddyListListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((ZMBuddyListListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(ZMBuddyListListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public List<IMAddrBookItem> getAllBuddies() {
        ArrayList<IMAddrBookItem> list = new ArrayList<IMAddrBookItem>();
        for (IMAddrBookItem item : this.mBuddies.values()) {
            list.add(item);
        }
        return list;
    }

    public List<IMAddrBookItem> getAllSipBuddies() {
        ArrayList<IMAddrBookItem> list = new ArrayList<IMAddrBookItem>();
        for (IMAddrBookItem item : this.mBuddies.values()) {
            if (StringUtil.isEmptyOrNull((String)item.getSipPhoneNumber())) continue;
            list.add(item);
        }
        return list;
    }

    public IMAddrBookItem getBuddyByJid(String jid) {
        return this.mBuddies.get(jid);
    }

    private void init() {
        this.loadAllBuddies();
        this.mHandler.sendEmptyMessageDelayed(2, 1000L);
    }

    public void clearAllBuddies() {
        this.mHandler.removeCallbacks(this.mLoadCaptureBuddiesRunnable);
        this.clearAllCaptureBuddies();
        this.mBuddies.clear();
    }

    private void loadAllBuddies() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        int count = this.captureAllBuddies();
        if (count < 1000) {
            this.mHandler.post(this.mLoadCaptureBuddiesRunnable);
        } else {
            new Thread("sortAllBuddy"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ZMBuddySyncInstance.this.mSortBuddiesLocker;
                    synchronized (object) {
                        ZMBuddySyncInstance.this.sortAllBuddies();
                    }
                    ZMBuddySyncInstance.this.mHandler.post(ZMBuddySyncInstance.this.mLoadCaptureBuddiesRunnable);
                }
            }.start();
        }
    }

    public void Indicate_BlockedUsersUpdated() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        List<String> users = messenger.blockUserGetAll();
        for (Map.Entry<String, IMAddrBookItem> entry : this.mBuddies.entrySet()) {
            boolean newValue;
            String jid = entry.getKey();
            IMAddrBookItem item = entry.getValue();
            boolean oldValue = item.isBlocked();
            boolean bl = newValue = users != null && users.contains(jid);
            if (oldValue != newValue) {
                this.mPendingPresenceUpdateJids.add(jid);
            }
            entry.getValue().setBlocked(newValue);
        }
        if (this.mChangeType != 2) {
            this.mChangeType = 1;
        }
    }

    public void Indicate_BlockedUsersAdded(List<String> users) {
        if (users == null) {
            return;
        }
        for (String user : users) {
            IMAddrBookItem item = this.getBuddyByJid(user);
            if (item != null) {
                item.setBlocked(true);
            }
            this.mPendingPresenceUpdateJids.add(user);
        }
        if (this.mChangeType != 2) {
            this.mChangeType = 1;
        }
    }

    public void Indicate_BlockedUsersRemoved(List<String> users) {
        if (users == null) {
            return;
        }
        for (String user : users) {
            IMAddrBookItem item = this.getBuddyByJid(user);
            if (item != null) {
                item.setBlocked(false);
            }
            this.mPendingPresenceUpdateJids.add(user);
        }
        if (this.mChangeType != 2) {
            this.mChangeType = 1;
        }
    }

    public void onIndicateBuddyListUpdated() {
        this.refreshAllBuddy();
    }

    public void Indicate_VCardInfoReady(String jid) {
        this.indicate_BuddyInfoUpdatedWithJID(jid);
    }

    public void indicate_BuddyInfoUpdatedWithJID(String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        IMAddrBookItem item = this.mBuddies.get(jid);
        if (item != null) {
            boolean res = item.refreshBuddy();
            if (this.mChangeType != 2) {
                if (res) {
                    this.mPendingInfoUpdateJids.add(jid);
                } else {
                    this.mPendingPresenceUpdateJids.add(jid);
                }
                this.mChangeType = 1;
            }
        } else {
            item = IMAddrBookItem.fromZoomBuddy(buddy);
            if (item == null) {
                return;
            }
            this.mBuddies.put(jid, item);
            this.mChangeType = 2;
        }
    }

    public void on_RemoveBuddy(String jid, int result) {
        if (result != 0) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.mDeletedJids.add(jid);
        IMAddrBookItem item = this.mBuddies.remove(jid);
        if (item == null) {
            return;
        }
        item.checkIsMyContact(messenger);
        this.mChangeType = 2;
    }

    public void onSearchBuddyPicDownloaded(String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        IMAddrBookItem item = this.mBuddies.get(jid);
        if (item != null) {
            item.updatePicture(messenger);
            if (this.mChangeType != 2) {
                this.mPendingPresenceUpdateJids.add(jid);
                this.mChangeType = 1;
            }
        }
    }

    public boolean onNotifySubscriptionAccepted(String jid) {
        IMAddrBookItem item = this.mBuddies.get(jid);
        if (item == null) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return false;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null) {
                return false;
            }
            item = IMAddrBookItem.fromZoomBuddy(buddy);
            if (item == null) {
                return false;
            }
            this.mBuddies.put(jid, item);
        } else {
            item.refreshBuddy();
        }
        this.mChangeType = 2;
        return false;
    }

    public void onNotifySubscribeRequestUpdated(String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null || !messenger.isMyContact(jid)) {
            if (this.mBuddies.containsKey(jid)) {
                this.mBuddies.remove(jid);
                this.mChangeType = 2;
            }
            return;
        }
        IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
        if (item == null) {
            return;
        }
        this.mBuddies.put(jid, item);
        this.mChangeType = 2;
    }

    public boolean onNotifySubscriptionDenied(String jid) {
        if (this.mBuddies.remove(jid) != null) {
            this.mChangeType = 2;
        }
        return false;
    }

    public void Indicate_OnlineBuddies(List<String> jidList) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        for (String jid : jidList) {
            IMAddrBookItem item = this.mBuddies.get(jid);
            if (item == null) continue;
            item.updatePresence(messenger);
            if (this.mChangeType == 2) continue;
            this.mPendingPresenceUpdateJids.add(jid);
            this.mChangeType = 1;
        }
    }

    public void Indicate_GetContactsPresence(List<String> onLines, List<String> offlines) {
        IMAddrBookItem item;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        for (String jid : onLines) {
            item = this.mBuddies.get(jid);
            if (item == null) continue;
            item.updatePresence(messenger);
            if (this.mChangeType == 2) continue;
            this.mPendingPresenceUpdateJids.add(jid);
            this.mChangeType = 1;
        }
        for (String jid : offlines) {
            item = this.mBuddies.get(jid);
            if (item == null) continue;
            item.updatePresence(messenger);
            if (this.mChangeType == 2) continue;
            this.mPendingPresenceUpdateJids.add(jid);
            this.mChangeType = 1;
        }
    }

    public void Indicate_BuddyGroupsRemoved(List<String> groupIDs) {
        this.refreshAllBuddy();
    }

    public void requestBuddyListUpdate() {
        this.mChangeType = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllBuddy() {
        Object object = this.mRefreshAllBuddyLocker;
        synchronized (object) {
            if (this.mRefreshAllBuddyThread) {
                return;
            }
            this.mRefreshAllBuddyThread = true;
            new Thread("IndicateBuddyListUpdated"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ZMBuddySyncInstance.this.mSortBuddiesLocker;
                    synchronized (object) {
                        if (!ZMBuddySyncInstance.this.mHandler.hasMessages(1)) {
                            ZMBuddySyncInstance.this.mHandler.sendEmptyMessage(1);
                        }
                    }
                    object = ZMBuddySyncInstance.this.mRefreshAllBuddyLocker;
                    synchronized (object) {
                        ZMBuddySyncInstance.this.mRefreshAllBuddyThread = false;
                    }
                }
            }.start();
        }
    }

    public void Indicate_BuddyPresenceChanged(String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        IMAddrBookItem item = this.mBuddies.get(jid);
        if (item != null) {
            item.updatePresence(messenger);
            if (this.mChangeType != 2) {
                this.mPendingPresenceUpdateJids.add(jid);
                this.mChangeType = 1;
            }
        } else {
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null) {
                return;
            }
            item = IMAddrBookItem.fromZoomBuddy(buddy);
            if (item == null) {
                return;
            }
            this.mBuddies.put(jid, item);
            this.mChangeType = 2;
        }
    }

    public void Indicate_BuddyGroupMembersAdded(String groupID, List<String> jidList) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        for (String jid : jidList) {
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null) {
                return;
            }
            IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
            if (item == null) {
                return;
            }
            this.mBuddies.put(jid, item);
        }
        this.mChangeType = 2;
    }

    public void Indicate_BuddyGroupMembersRemoved(String groupID, List<String> jidList) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        for (String jid : jidList) {
            IMAddrBookItem item = this.mBuddies.get(jid);
            if (item == null) continue;
            item.checkIsMyContact(messenger);
        }
        this.mChangeType = 2;
    }

    public void Indicate_BuddyGroupMembersChanged(PTAppProtos.ChangedBuddyGroups changedBuddyGroups, boolean bLastPage) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || changedBuddyGroups == null) {
            return;
        }
        if (bLastPage) {
            this.refreshAllBuddy();
        } else if (this.mBuddies.size() < 1000) {
            HashSet<String> jids = new HashSet<String>();
            for (int i = 0; i < changedBuddyGroups.getBuddyGroupCount(); ++i) {
                PTAppProtos.BuddyGroupMemberChangeList list = changedBuddyGroups.getBuddyGroup(i);
                if (list == null) continue;
                jids.addAll(list.getAddedMemberJIDsList());
            }
            for (String jid : jids) {
                ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
                if (buddy == null) {
                    return;
                }
                IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
                if (item == null) {
                    return;
                }
                item.setIsMyContact(true);
                this.mBuddies.put(jid, item);
            }
            this.mChangeType = 2;
        }
    }

    public void Indicate_BuddyGroupMemberAdded(String groupName, String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        IMAddrBookItem item = this.mBuddies.get(jid);
        if (item == null) {
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null) {
                return;
            }
            item = IMAddrBookItem.fromZoomBuddy(buddy);
            if (item == null) {
                return;
            }
            this.mBuddies.put(jid, item);
            this.mChangeType = 2;
        }
    }

    public void Indicate_BuddyGroupMemberRemoved(String groupName, String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        IMAddrBookItem item = this.mBuddies.get(jid);
        if (item != null) {
            item.checkIsMyContact(messenger);
            this.mChangeType = 2;
        }
    }

    public void onAddBuddyByJid(String jid) {
        IMAddrBookItem item = this.mBuddies.get(jid);
        if (item != null) {
            item.refreshBuddy();
            this.mChangeType = 2;
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        item = IMAddrBookItem.fromZoomBuddy(buddy);
        if (item == null) {
            return;
        }
        this.mBuddies.put(jid, item);
        this.mDeletedJids.remove(jid);
        this.mChangeType = 2;
    }

    public void Indicate_BuddyAdded(String jid, List<String> groupIds) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        IMAddrBookItem item = this.mBuddies.get(jid);
        if (item == null) {
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null) {
                return;
            }
            item = IMAddrBookItem.fromZoomBuddy(buddy);
            if (item == null) {
                return;
            }
            this.mBuddies.put(jid, item);
            this.mDeletedJids.remove(jid);
            this.mChangeType = 2;
        }
    }

    protected char[] getSortKey(int[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        for (int value : values) {
            String key = PinyinUtil.getSortKey((String)new String(Character.toChars(value)));
            if (StringUtil.isEmptyOrNull((String)key)) {
                buff.append(Character.toChars(value));
                continue;
            }
            if (key.length() == 1) {
                buff.append(key);
                continue;
            }
            buff.append(key.charAt(0));
        }
        return buff.toString().toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllCaptureBuddies() {
        Object object = this.mNaviteBuddyVetctLocker;
        synchronized (object) {
            this.clearAllCaptureBuddiesImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int captureAllBuddies() {
        Object object = this.mNaviteBuddyVetctLocker;
        synchronized (object) {
            return this.captureAllBuddiesImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortAllBuddies() {
        Object object = this.mNaviteBuddyVetctLocker;
        synchronized (object) {
            this.sortAllBuddiesImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadCaptureBuddies(int size) {
        Object object = this.mNaviteBuddyVetctLocker;
        synchronized (object) {
            return this.loadCaptureBuddiesImpl(size);
        }
    }

    private native void clearAllCaptureBuddiesImpl();

    private native int captureAllBuddiesImpl();

    private native void sortAllBuddiesImpl();

    private native byte[] loadCaptureBuddiesImpl(int var1);

    static {
        TAG = ZMBuddySyncInstance.class.getSimpleName();
    }

    public static interface ZMBuddyListListener
    extends IListener {
        public void onBuddyListUpdate();

        public void onBuddyInfoUpdate(List<String> var1, List<String> var2);
    }
}

