/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import android.media.MediaRecorder;
import android.os.Handler;
import us.zoom.androidlib.util.ZMLog;

public class VoiceRecorder {
    public static final int ERROR_SERVER_DIED = 100;
    public static final int ERROR_UNKNOWN = 1;
    public static final int INFO_MAX_DURATION_REACHED = 800;
    public static final int INFO_MAX_FILESIZE_REACHED = 801;
    public static final int INFO_UNKNOWN = 1;
    private static final String TAG = VoiceRecorder.class.getSimpleName();
    private MediaRecorder mMediaRecorder;
    private IVoiceRecorderListener mListener;
    private String mOutputFile = null;
    private int mMaxDurationMs;
    private Handler mHandler = new Handler();
    private long mTimeStart = 0L;
    private long mLastTimePassed = 0L;
    private boolean mIsStarted = false;
    private MediaRecorder.OnErrorListener mOnErrorListener = new MediaRecorder.OnErrorListener(){

        public void onError(MediaRecorder mr, int what, int extra) {
            if (VoiceRecorder.this.mListener != null) {
                VoiceRecorder.this.mListener.onError(what, extra);
            }
        }
    };
    private MediaRecorder.OnInfoListener mOnInfoListener = new MediaRecorder.OnInfoListener(){

        public void onInfo(MediaRecorder mr, int what, int extra) {
            if (VoiceRecorder.this.mListener != null) {
                VoiceRecorder.this.mListener.onInfo(what, extra);
            }
            if (what == 800 || what == 801) {
                VoiceRecorder.this.stopRecord();
            }
        }
    };

    public VoiceRecorder() {
        this.mMediaRecorder = new MediaRecorder();
    }

    public void setListener(IVoiceRecorderListener l) {
        this.mListener = l;
    }

    public boolean startRecord() {
        try {
            this.mMediaRecorder.start();
            this.mIsStarted = true;
            this.startTimer();
            return true;
        }
        catch (Exception e) {
            ZMLog.e((String)TAG, (Throwable)e, (String)"start record failed", (Object[])new Object[0]);
            try {
                this.mIsStarted = false;
                this.mMediaRecorder.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    private void startTimer() {
        Runnable timerTask = new Runnable(){
            int[] permutationHigh = new int[]{4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
            int[] permutationLow = new int[]{0, 1, 2, 3};
            private int mVolumeLast = 0;
            private int _absMax = 0;
            private int _count = 0;

            @Override
            public void run() {
                if (!VoiceRecorder.this.mIsStarted) {
                    return;
                }
                if (VoiceRecorder.this.mListener != null) {
                    long timePassed;
                    int maxAmplitude = 0;
                    try {
                        maxAmplitude = VoiceRecorder.this.mMediaRecorder.getMaxAmplitude();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int volume = this.calculateVolume(maxAmplitude);
                    if (this.mVolumeLast != volume) {
                        this.mVolumeLast = volume;
                        float value = (float)volume / 9.0f;
                        VoiceRecorder.this.mListener.onVolumeUpdate(value);
                    }
                    if ((timePassed = System.currentTimeMillis() - VoiceRecorder.this.mTimeStart) > VoiceRecorder.this.mLastTimePassed) {
                        VoiceRecorder.this.mLastTimePassed = timePassed;
                        VoiceRecorder.this.mListener.onTimeUpdate((timePassed + 500L) / 1000L);
                    }
                    if (timePassed >= (long)VoiceRecorder.this.mMaxDurationMs) {
                        VoiceRecorder.this.stopRecord();
                    }
                }
                if (VoiceRecorder.this.mIsStarted) {
                    VoiceRecorder.this.mHandler.postDelayed((Runnable)this, 50L);
                }
            }

            private int calculateVolume(int absValue) {
                if (absValue > this._absMax) {
                    this._absMax = absValue;
                }
                int level = this.mVolumeLast;
                if (this._count++ == 2) {
                    this._count = 0;
                    if (this._absMax < 1000) {
                        int position = this._absMax / 250;
                        level = this.permutationLow[position];
                    } else {
                        int position = this._absMax / 1000 - 1;
                        if (position > 32) {
                            position = 32;
                        }
                        level = this.permutationHigh[position];
                    }
                    this._absMax >>= 2;
                }
                return level;
            }
        };
        this.mTimeStart = System.currentTimeMillis();
        this.mLastTimePassed = 0L;
        this.mHandler.postDelayed(timerTask, 50L);
    }

    public boolean stopRecord() {
        try {
            this.mIsStarted = false;
            this.mMediaRecorder.stop();
            this.mMediaRecorder.reset();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ZMLog.e((String)TAG, (Throwable)e, (String)"stopRecord record failed", (Object[])new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mTimeStart = 0L;
            this.mLastTimePassed = 0L;
            if (this.mListener != null) {
                this.mListener.onRecordEnd();
            }
        }
    }

    public void setMaxDuration(int max_duration_ms) {
        this.mMaxDurationMs = max_duration_ms;
        try {
            this.mMediaRecorder.setMaxDuration(max_duration_ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setOutputFile(String path) {
        if (path != null) {
            this.mOutputFile = path;
            try {
                this.mMediaRecorder.setOutputFile(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getOutputFile() {
        return this.mOutputFile;
    }

    public boolean prepare() {
        try {
            this.mMediaRecorder.setOnErrorListener(this.mOnErrorListener);
            this.mMediaRecorder.setOnInfoListener(this.mOnInfoListener);
            this.mMediaRecorder.setAudioSource(1);
            this.mMediaRecorder.setOutputFormat(3);
            this.mMediaRecorder.setAudioEncoder(1);
            this.mMediaRecorder.prepare();
            return true;
        }
        catch (Exception e) {
            ZMLog.e((String)TAG, (Throwable)e, (String)"prepare record failed", (Object[])new Object[0]);
            return false;
        }
    }

    public void release() {
        try {
            this.mMediaRecorder.release();
        }
        catch (Exception e) {
            ZMLog.e((String)TAG, (Throwable)e, (String)"release recorder failed", (Object[])new Object[0]);
        }
    }

    public static interface IVoiceRecorderListener {
        public void onError(int var1, int var2);

        public void onInfo(int var1, int var2);

        public void onTimeUpdate(long var1);

        public void onVolumeUpdate(float var1);

        public void onRecordEnd();
    }
}

