/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTAppProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;

public class NotificationSettingMgr {
    private long mNativeHandle;

    public NotificationSettingMgr(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void registerUICallBack(NotificationSettingUI callback) {
        if (this.mNativeHandle == 0L || callback == null) {
            return;
        }
        this.registerUICallBackImpl(this.mNativeHandle, callback.getNativeHandle());
    }

    public boolean applyBlockAllSettings(int action, int type, int timing) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.applyBlockAllSettingsImpl(this.mNativeHandle, action, type, timing);
    }

    public int[] getBlockAllSettings() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        int[] params = new int[3];
        boolean res = this.getBlockAllSettingsImpl(this.mNativeHandle, params);
        if (res) {
            return params;
        }
        return null;
    }

    public boolean applySnoozeSettings(long duration, long start, long end) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.applySnoozeSettingsImpl(this.mNativeHandle, duration, start, end);
    }

    public long[] getSnoozeSettings() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long[] params = new long[3];
        if (this.getSnoozeSettingsImpl(this.mNativeHandle, params)) {
            return params;
        }
        return null;
    }

    public boolean applyDndSettings(DndSetting setting) {
        if (this.mNativeHandle == 0L || setting == null) {
            return false;
        }
        return this.applyDndSettingsImpl(this.mNativeHandle, setting.params[0] == 1, setting.params[1], setting.params[2], setting.params[3], setting.params[4]);
    }

    public DndSetting getDndSettings() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        int[] params = new int[5];
        if (this.getDndSettingsImpl(this.mNativeHandle, params)) {
            return new DndSetting(params);
        }
        return null;
    }

    public List<String> getDisableMUCSettings() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getDisableMUCSettingsImpl(this.mNativeHandle);
    }

    public List<String> getReceiveAllMUCSettings() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getReceiveAllMUCSettingsImpl(this.mNativeHandle);
    }

    public boolean applyMUCSettings(String groupId, int type) {
        if (StringUtil.isEmptyOrNull((String)groupId)) {
            return false;
        }
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(groupId);
        return this.applyMUCSettings(groups, type);
    }

    public boolean applyMUCSettings(List<String> groupIds, int type) {
        if (this.mNativeHandle == 0L || CollectionsUtil.isListEmpty(groupIds)) {
            return false;
        }
        return this.applyMUCSettingsImpl(this.mNativeHandle, groupIds, type);
    }

    public List<String> getHLMUCSettings() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getHLMUCSettingsImpl(this.mNativeHandle);
    }

    public PTAppProtos.MUCNotifySettings getMUCSettings() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] data = this.getMUCSettingsImpl(this.mNativeHandle);
        if (data == null) {
            return null;
        }
        try {
            return PTAppProtos.MUCNotifySettings.parseFrom(data);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public PTAppProtos.MUCNotifySettings getMUCDiffFromGeneralSetting() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] data = this.getMUCDiffFromGeneralSettingImpl(this.mNativeHandle);
        if (data == null) {
            return null;
        }
        try {
            return PTAppProtos.MUCNotifySettings.parseFrom(data);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isSessionBlocked(String sessionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isSessionBlockedImpl(this.mNativeHandle, sessionId);
    }

    public boolean isMsgBlocked(String sessionId, String msgId, int callStatus) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isMsgBlockedImpl(this.mNativeHandle, sessionId, msgId, callStatus);
    }

    public boolean applyInCallSettings(boolean blockInCall) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.applyInCallSettingsImpl(this.mNativeHandle, blockInCall);
    }

    public boolean getInCallSettings() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.getInCallSettingsImpl(this.mNativeHandle);
    }

    public DndSetting getHistoryDNDSetting() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        int[] params = new int[5];
        if (this.getHistoryDNDSettingImpl(this.mNativeHandle, params)) {
            if (params[1] == 0 && params[2] == 0 && params[3] == 0 && params[4] == 0) {
                return null;
            }
            return new DndSetting(params);
        }
        return null;
    }

    public int getDNDNowSetting() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getDNDNowSettingImpl(this.mNativeHandle);
    }

    public boolean applyDNDNowSetting(int action) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.applyDNDNowSettingImpl(this.mNativeHandle, action);
    }

    public boolean resetMUCSettings(List<String> sessionIds) {
        if (this.mNativeHandle == 0L || CollectionsUtil.isListEmpty(sessionIds)) {
            return false;
        }
        return this.resetMUCSettingsImpl(this.mNativeHandle, sessionIds);
    }

    public List<String> getKeywordSetting() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getKeywordSettingImpl(this.mNativeHandle);
    }

    public boolean applyKeyword(List<String> addList, List<String> removeList) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if ((addList == null || addList.isEmpty()) && (removeList == null || removeList.isEmpty())) {
            return false;
        }
        return this.applyKeywordSettingImpl(this.mNativeHandle, addList, removeList);
    }

    public List<String> getPersonSetting() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getPersonSettingImpl(this.mNativeHandle);
    }

    public boolean applyPersonSetting(List<String> addList, List<String> removeList) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if ((addList == null || addList.isEmpty()) && (removeList == null || removeList.isEmpty())) {
            return false;
        }
        return this.applyPersonSettingImpl(this.mNativeHandle, addList, removeList);
    }

    public boolean isInDND() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isInDNDImpl(this.mNativeHandle);
    }

    private native boolean applyBlockAllSettingsImpl(long var1, int var3, int var4, int var5);

    private native boolean getBlockAllSettingsImpl(long var1, int[] var3);

    private native boolean applySnoozeSettingsImpl(long var1, long var3, long var5, long var7);

    private native boolean getSnoozeSettingsImpl(long var1, long[] var3);

    private native boolean applyDndSettingsImpl(long var1, boolean var3, int var4, int var5, int var6, int var7);

    private native boolean getDndSettingsImpl(long var1, int[] var3);

    private native boolean applyMUCSettingsImpl(long var1, List<String> var3, int var4);

    private native List<String> getDisableMUCSettingsImpl(long var1);

    private native List<String> getReceiveAllMUCSettingsImpl(long var1);

    private native byte[] getMUCSettingsImpl(long var1);

    private native byte[] getMUCDiffFromGeneralSettingImpl(long var1);

    private native List<String> getHLMUCSettingsImpl(long var1);

    private native void registerUICallBackImpl(long var1, long var3);

    private native boolean isSessionBlockedImpl(long var1, String var3);

    private native boolean isMsgBlockedImpl(long var1, String var3, String var4, int var5);

    private native boolean applyInCallSettingsImpl(long var1, boolean var3);

    private native boolean getInCallSettingsImpl(long var1);

    private native boolean getHistoryDNDSettingImpl(long var1, int[] var3);

    private native int getDNDNowSettingImpl(long var1);

    private native boolean applyDNDNowSettingImpl(long var1, int var3);

    private native boolean resetMUCSettingsImpl(long var1, List<String> var3);

    private native List<String> getKeywordSettingImpl(long var1);

    private native boolean applyKeywordSettingImpl(long var1, List<String> var3, List<String> var4);

    private native List<String> getPersonSettingImpl(long var1);

    private native boolean applyPersonSettingImpl(long var1, List<String> var3, List<String> var4);

    private native boolean isInDNDImpl(long var1);

    public static class DndSetting {
        int[] params = new int[5];

        DndSetting(int[] params) {
            this.params = params;
        }

        public boolean isEnable() {
            return this.params != null && this.params[0] == 1;
        }

        public void setEnable(boolean enable) {
            this.params[0] = enable ? 1 : 0;
        }

        public Calendar getStart() {
            if (this.params == null) {
                return null;
            }
            Calendar time = Calendar.getInstance();
            time.set(11, this.params[1]);
            time.set(12, this.params[2]);
            return time;
        }

        public Calendar getEnd() {
            if (this.params == null) {
                return null;
            }
            Calendar time = Calendar.getInstance();
            time.set(11, this.params[3]);
            time.set(12, this.params[4]);
            return time;
        }

        public void setStart(Calendar time) {
            if (time == null) {
                return;
            }
            this.params[1] = time.get(11);
            this.params[2] = time.get(12);
        }

        public void setEnd(Calendar time) {
            if (time == null) {
                return;
            }
            this.params[3] = time.get(11);
            this.params[4] = time.get(12);
        }
    }
}

