/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PrivateStickerUICallBack;
import us.zoom.androidlib.util.StringUtil;

public class MMPrivateStickerMgr {
    private long mNativeHandle = 0L;

    public MMPrivateStickerMgr(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void registerUICallBack(PrivateStickerUICallBack callback) {
        if (this.mNativeHandle == 0L || callback == null) {
            return;
        }
        this.registerUICallBackImpl(this.mNativeHandle, callback.getNativeHandle());
    }

    public PTAppProtos.StickerInfoList getStickers() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] data = this.getStickersImpl(this.mNativeHandle);
        if (data == null) {
            return null;
        }
        try {
            return PTAppProtos.StickerInfoList.parseFrom(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int uploadAndMakePrivateSticker(String path) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)path)) {
            return 0;
        }
        return this.uploadAndMakePrivateStickerImpl(this.mNativeHandle, path);
    }

    public int makePrivateSticker(String fileId) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)fileId)) {
            return 0;
        }
        return this.makePrivateStickerImpl(this.mNativeHandle, fileId);
    }

    public int discardPrivateSticker(String stickerId) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)stickerId)) {
            return 0;
        }
        return this.discardPrivateStickerImpl(this.mNativeHandle, stickerId);
    }

    public String downloadSticker(String stickerId, String path) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)stickerId) || StringUtil.isEmptyOrNull((String)path)) {
            return null;
        }
        return this.downloadStickerImpl(this.mNativeHandle, stickerId, path);
    }

    public int sendSticker(PTAppProtos.StickerInfo info, String receiverId) {
        if (this.mNativeHandle == 0L || info == null || StringUtil.isEmptyOrNull((String)receiverId)) {
            return 0;
        }
        byte[] data = info.toByteArray();
        if (data == null) {
            return 0;
        }
        return this.sendStickerImpl(this.mNativeHandle, data, receiverId);
    }

    public String downloadStickerPreview(String stickerId) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)stickerId)) {
            return null;
        }
        return this.downloadStickerPreviewImpl(this.mNativeHandle, stickerId);
    }

    private native byte[] getStickersImpl(long var1);

    private native int uploadAndMakePrivateStickerImpl(long var1, String var3);

    private native int makePrivateStickerImpl(long var1, String var3);

    private native int discardPrivateStickerImpl(long var1, String var3);

    private native String downloadStickerImpl(long var1, String var3, String var4);

    private native int sendStickerImpl(long var1, byte[] var3, String var4);

    private native void registerUICallBackImpl(long var1, long var3);

    private native String downloadStickerPreviewImpl(long var1, String var3);
}

