/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import android.text.TextUtils;
import com.google.protobuf.InvalidProtocolBufferException;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class MMFileContentMgr {
    private long mNativeHandle = 0L;

    public MMFileContentMgr(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public PTAppProtos.FileQueryResult queryFilesForSession(String session, long fromTimeStamp, int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] res = this.queryFilesForSessionImpl(this.mNativeHandle, session, fromTimeStamp, count);
        if (res == null) {
            return null;
        }
        PTAppProtos.FileQueryResult result = null;
        try {
            result = PTAppProtos.FileQueryResult.parseFrom(res);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        return result;
    }

    public PTAppProtos.FileQueryResult queryImagesForSession(String session, long fromTimeStamp, int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] res = this.queryImagesForSessionImpl(this.mNativeHandle, session, fromTimeStamp, count);
        if (res == null) {
            return null;
        }
        PTAppProtos.FileQueryResult result = null;
        try {
            result = PTAppProtos.FileQueryResult.parseFrom(res);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        return result;
    }

    public PTAppProtos.FileQueryResult queryOwnedFiles(String jid, long fromTimeStamp, int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] res = this.queryOwnedFilesImpl(this.mNativeHandle, jid, fromTimeStamp, count);
        if (res == null) {
            return null;
        }
        PTAppProtos.FileQueryResult result = null;
        try {
            result = PTAppProtos.FileQueryResult.parseFrom(res);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        return result;
    }

    public PTAppProtos.FileQueryResult queryOwnedImageFiles(String jid, long fromTimeStamp, int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] res = this.queryOwnedImageFilesImpl(this.mNativeHandle, jid, fromTimeStamp, count);
        if (res == null) {
            return null;
        }
        PTAppProtos.FileQueryResult result = null;
        try {
            result = PTAppProtos.FileQueryResult.parseFrom(res);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        return result;
    }

    public PTAppProtos.FileQueryResult queryFilesSharedWithMe(String jid, long fromTimeStamp, int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] res = this.queryFilesSharedWithMeImpl(this.mNativeHandle, jid, fromTimeStamp, count);
        if (res == null) {
            return null;
        }
        PTAppProtos.FileQueryResult result = null;
        try {
            result = PTAppProtos.FileQueryResult.parseFrom(res);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        return result;
    }

    public PTAppProtos.FileQueryResult queryImagesSharedWithMe(String jid, long fromTimeStamp, int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] res = this.queryImagesSharedWithMeImpl(this.mNativeHandle, jid, fromTimeStamp, count);
        if (res == null) {
            return null;
        }
        PTAppProtos.FileQueryResult result = null;
        try {
            result = PTAppProtos.FileQueryResult.parseFrom(res);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        return result;
    }

    public PTAppProtos.FileQueryResult queryAllFiles(long fromTimeStamp, int count) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] res = this.queryAllFilesImpl(this.mNativeHandle, fromTimeStamp, count);
        if (res == null) {
            return null;
        }
        PTAppProtos.FileQueryResult result = null;
        try {
            result = PTAppProtos.FileQueryResult.parseFrom(res);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        return result;
    }

    public ZoomFile getFileWithMessageID(String sessionId, String messageID) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)sessionId) || StringUtil.isEmptyOrNull((String)messageID)) {
            return null;
        }
        long handle = this.getFileWithMessageIDImpl(this.mNativeHandle, sessionId, messageID);
        if (handle != 0L) {
            return new ZoomFile(handle);
        }
        return null;
    }

    public ZoomFile getFileWithWebFileID(String webFileID) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)webFileID)) {
            return null;
        }
        long handle = this.getFileWithWebFileIDImpl(this.mNativeHandle, webFileID);
        if (handle != 0L) {
            return new ZoomFile(handle);
        }
        return null;
    }

    public boolean cancelFileTransfer(String reqId, String webFileID) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)reqId) || StringUtil.isEmptyOrNull((String)webFileID)) {
            return false;
        }
        return this.cancelFileTransferImpl(this.mNativeHandle, reqId, webFileID);
    }

    public String downloadImgPreview(String fileid) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)fileid)) {
            return null;
        }
        return this.downloadImgPreviewImpl(this.mNativeHandle, fileid);
    }

    public String uploadFile(String filePath) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)filePath)) {
            return null;
        }
        return this.uploadFileImpl(this.mNativeHandle, filePath);
    }

    public String downloadFile(String fileID, String localPath) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)fileID) || StringUtil.isEmptyOrNull((String)localPath)) {
            return null;
        }
        return this.downloadFileImpl(this.mNativeHandle, fileID, localPath);
    }

    public String deleteFile(MMZoomFile file, String sessionID) {
        if (file == null) {
            return null;
        }
        String reqId = null;
        if (TextUtils.isEmpty((CharSequence)sessionID)) {
            reqId = this.deleteFileByWebFileID(file.getWebID());
        } else {
            MMZoomShareAction action = null;
            List<MMZoomShareAction> actions = file.getShareAction();
            if (actions == null) {
                return null;
            }
            for (MMZoomShareAction item : actions) {
                if (!StringUtil.isSameString((String)item.getSharee(), (String)sessionID)) continue;
                action = item;
            }
            ArrayList<String> sharees = new ArrayList<String>();
            if (action == null || TextUtils.isEmpty((CharSequence)action.getSharee())) {
                sharees.add(sessionID);
            } else {
                sharees.add(action.getSharee());
            }
            reqId = this.unshareFile(file.getWebID(), sharees);
        }
        return reqId;
    }

    public String deleteFileByWebFileID(String webFileID) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.deleteFileByWebFileIDImpl(this.mNativeHandle, webFileID);
    }

    public String forwardFileMessage(String sessionID, String msgGuid, String to) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.forwardFileMessageImpl(this.mNativeHandle, sessionID, msgGuid, to);
    }

    public String shareFile(String fileID, String sharee) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)sharee) || StringUtil.isEmptyOrNull((String)fileID)) {
            return null;
        }
        return this.shareFileImpl(this.mNativeHandle, fileID, sharee);
    }

    public String unshareFile(String fileID, List<String> sharees) {
        if (this.mNativeHandle == 0L || sharees == null || sharees.size() == 0 || StringUtil.isEmptyOrNull((String)fileID)) {
            return null;
        }
        return this.unshareFileImpl(this.mNativeHandle, fileID, sharees);
    }

    public String renameFileByWebFileID(String fileId, String newName) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.renameFileByWebFileIDImpl(this.mNativeHandle, fileId, newName);
    }

    public String searchOwnerFilesContent(PTAppProtos.FileSearchFilter filter) {
        if (this.mNativeHandle == 0L || filter == null) {
            return null;
        }
        byte[] body = filter.toByteArray();
        return this.searchOwnerFilesContentImpl(this.mNativeHandle, body);
    }

    public String searchAllFilesContent(PTAppProtos.FileSearchFilter filter) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        byte[] body = filter.toByteArray();
        return this.searchAllFilesContentImpl(this.mNativeHandle, body);
    }

    public void destroyFileObject(ZoomFile file) {
        if (this.mNativeHandle == 0L || file == null) {
            return;
        }
        this.destroyFileObjectImpl(this.mNativeHandle, file.getNativeHandle());
    }

    public String syncFileInfoByFileID(String fileID) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.syncFileInfoByFileIDImpl(this.mNativeHandle, fileID);
    }

    public int getFileContentMgmtOption() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getFileContentMgmtOptionImpl(this.mNativeHandle);
    }

    private native byte[] queryFilesForSessionImpl(long var1, String var3, long var4, int var6);

    private native byte[] queryImagesForSessionImpl(long var1, String var3, long var4, int var6);

    private native byte[] queryOwnedFilesImpl(long var1, String var3, long var4, int var6);

    private native byte[] queryOwnedImageFilesImpl(long var1, String var3, long var4, int var6);

    private native byte[] queryFilesSharedWithMeImpl(long var1, String var3, long var4, int var6);

    private native byte[] queryImagesSharedWithMeImpl(long var1, String var3, long var4, int var6);

    private native byte[] queryAllFilesImpl(long var1, long var3, int var5);

    private native long getFileWithMessageIDImpl(long var1, String var3, String var4);

    private native long getFileWithWebFileIDImpl(long var1, String var3);

    private native String uploadFileImpl(long var1, String var3);

    private native String downloadFileImpl(long var1, String var3, String var4);

    private native String deleteFileByWebFileIDImpl(long var1, String var3);

    private native String forwardFileMessageImpl(long var1, String var3, String var4, String var5);

    private native String shareFileImpl(long var1, String var3, String var4);

    private native String renameFileByWebFileIDImpl(long var1, String var3, String var4);

    private native boolean cancelFileTransferImpl(long var1, String var3, String var4);

    private native String downloadImgPreviewImpl(long var1, String var3);

    private native String searchOwnerFilesContentImpl(long var1, byte[] var3);

    private native String searchAllFilesContentImpl(long var1, byte[] var3);

    private native void destroyFileObjectImpl(long var1, long var3);

    private native String unshareFileImpl(long var1, String var3, List<String> var4);

    private native String syncFileInfoByFileIDImpl(long var1, String var3);

    private native int getFileContentMgmtOptionImpl(long var1);
}

