/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import com.zipow.videobox.ptapp.IMCallbackUI;

public class GroupMemberSynchronizer {
    private long mNativeHandle;

    public GroupMemberSynchronizer(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void registerUICallback(IMCallbackUI groupMemberSynchronizerUI) {
        if (this.mNativeHandle == 0L || groupMemberSynchronizerUI == null) {
            return;
        }
        this.registerUICallbackImpl(this.mNativeHandle, groupMemberSynchronizerUI.getAsynReadGroupMemberHandle());
    }

    public boolean startAsynReadGroupMemberFromDB(String groupid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.startAsynReadGroupMemberFromDBImpl(this.mNativeHandle, groupid);
    }

    public boolean syncReadGroupMemberFromDB(String groupid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.syncReadGroupMemberFromDBImpl(this.mNativeHandle, groupid);
    }

    public boolean startAsyncGroupMemberFromXmpp(String groupid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.startAsyncGroupMemberFromXmppImpl(this.mNativeHandle, groupid);
    }

    public boolean needReadGroupMemberFromDB(String groupid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.needReadGroupMemberFromDBImpl(this.mNativeHandle, groupid);
    }

    public boolean needSyncGroupMemberFromXmpp(String groupid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.needSyncGroupMemberFromXmppImpl(this.mNativeHandle, groupid);
    }

    public boolean safeSyncGroupMemberFromXmpp(String groupid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (this.needSyncGroupMemberFromXmpp(groupid)) {
            return this.startAsyncGroupMemberFromXmpp(groupid);
        }
        return false;
    }

    private native void registerUICallbackImpl(long var1, long var3);

    private native boolean startAsynReadGroupMemberFromDBImpl(long var1, String var3);

    private native boolean syncReadGroupMemberFromDBImpl(long var1, String var3);

    private native boolean startAsyncGroupMemberFromXmppImpl(long var1, String var3);

    private native boolean needReadGroupMemberFromDBImpl(long var1, String var3);

    private native boolean needSyncGroupMemberFromXmppImpl(long var1, String var3);
}

