/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.mm;

import com.google.protobuf.InvalidProtocolBufferException;
import com.zipow.videobox.ptapp.CrawlerLinkPreviewUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUserProfile;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;

public class CrawlerLinkPreview {
    public static final int MAX_LINK_PREVIEWS = 4;
    private long mNativeHandle;

    public CrawlerLinkPreview(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void RegisterUICallback(CrawlerLinkPreviewUI crawlerLinkPreviewUI) {
        if (this.mNativeHandle == 0L || crawlerLinkPreviewUI == null) {
            return;
        }
        this.RegisterUICallbackImpl(this.mNativeHandle, crawlerLinkPreviewUI.getNativeHandle());
    }

    public String CrawlLinkMetaInfo(String sessionId, String guid, List<String> urls) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)sessionId) || StringUtil.isEmptyOrNull((String)guid) || CollectionsUtil.isListEmpty(urls)) {
            return null;
        }
        ArrayList<String> availableUrls = new ArrayList<String>();
        for (String url : urls) {
            if (!this.isAvailableUrl(url)) continue;
            availableUrls.add(url);
        }
        return this.CrawlLinkMetaInfoImpl(this.mNativeHandle, sessionId, guid, availableUrls);
    }

    public PTAppProtos.CrawlLinkMetaInfo FuzzyGetLinkMetaInfo(String link) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)link)) {
            return null;
        }
        if (!this.isAvailableUrl(link)) {
            return null;
        }
        byte[] data = this.FuzzyGetLinkMetaInfoImpl(this.mNativeHandle, link);
        if (data == null) {
            return null;
        }
        try {
            return PTAppProtos.CrawlLinkMetaInfo.parseFrom(data);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            return null;
        }
    }

    private boolean isAvailableUrl(String url) {
        return !StringUtil.isEmptyOrNull((String)url) && !url.contains("zoom.us/j/") && !url.contains("zoom.us/s/");
    }

    public boolean isLinkPreviewEnable() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        return profile != null && profile.isEnableLinkPreview();
    }

    public boolean NeedDownloadImage(String url) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.NeedDownloadImageImpl(this.mNativeHandle, url);
    }

    public boolean NeedDownloadFavicon(String url) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.NeedDownloadFaviconImpl(this.mNativeHandle, url);
    }

    public String DownloadImage(String url, String path) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.DownloadImageImpl(this.mNativeHandle, url, path);
    }

    public String DownloadFavicon(String url, String path) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.DownloadFaviconImpl(this.mNativeHandle, url, path);
    }

    public boolean sendLinkMetaInfo(String sessionId, String guid, List<String> urls) {
        if (this.mNativeHandle == 0L || StringUtil.isEmptyOrNull((String)sessionId) || StringUtil.isEmptyOrNull((String)guid) || CollectionsUtil.isListEmpty(urls)) {
            return false;
        }
        return this.sendLinkMetaInfoImpl(this.mNativeHandle, sessionId, guid, urls);
    }

    private native void RegisterUICallbackImpl(long var1, long var3);

    private native String CrawlLinkMetaInfoImpl(long var1, String var3, String var4, List<String> var5);

    private native byte[] FuzzyGetLinkMetaInfoImpl(long var1, String var3);

    private native boolean NeedDownloadImageImpl(long var1, String var3);

    private native boolean NeedDownloadFaviconImpl(long var1, String var3);

    private native String DownloadImageImpl(long var1, String var3, String var4);

    private native String DownloadFaviconImpl(long var1, String var3, String var4);

    private native boolean sendLinkMetaInfoImpl(long var1, String var3, String var4, List<String> var5);
}

