/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.delegate;

import android.os.RemoteException;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTBuddyHelper;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.delegate.PTUIDelegation;
import java.util.ArrayList;

public class PTBuddyHelperDelegation
implements PTUI.IIMListener {
    private static final String TAG = PTBuddyHelperDelegation.class.getSimpleName();
    private PTBuddyHelper mBuddyHelper;
    private ArrayList<PTAppProtos.BuddyItem> mBuddyItems = new ArrayList();

    protected PTBuddyHelperDelegation() {
        this.reloadAllBuddyItems();
        PTUIDelegation.getInstance().addIMListener(this);
    }

    protected PTBuddyHelperDelegation(PTBuddyHelper buddyHelper) {
        this.mBuddyHelper = buddyHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTAppProtos.BuddyItem getBuddyItem(int index) {
        if (this.mBuddyHelper != null) {
            return this.mBuddyHelper.getBuddyItem(index);
        }
        ArrayList<PTAppProtos.BuddyItem> arrayList = this.mBuddyItems;
        synchronized (arrayList) {
            return this.mBuddyItems.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBuddyItemCount() {
        if (this.mBuddyHelper != null) {
            return this.mBuddyHelper.getBuddyItemCount();
        }
        ArrayList<PTAppProtos.BuddyItem> arrayList = this.mBuddyItems;
        synchronized (arrayList) {
            return this.mBuddyItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTAppProtos.BuddyItem getBuddyItemByJid(String jid) {
        if (this.mBuddyHelper != null) {
            return this.mBuddyHelper.getBuddyItemByJid(jid);
        }
        ArrayList<PTAppProtos.BuddyItem> arrayList = this.mBuddyItems;
        synchronized (arrayList) {
            for (PTAppProtos.BuddyItem item : this.mBuddyItems) {
                if (!jid.equals(item.getJid())) continue;
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] filterBuddyWithInput(String input) {
        if (input == null) {
            return null;
        }
        if (this.mBuddyHelper != null) {
            return this.mBuddyHelper.filterBuddyWithInput(input);
        }
        ArrayList<PTAppProtos.BuddyItem> arrayList = this.mBuddyItems;
        synchronized (arrayList) {
            ArrayList<String> ids = new ArrayList<String>();
            for (PTAppProtos.BuddyItem item : this.mBuddyItems) {
                String name = item.getScreenName();
                if (name == null || name.toLowerCase().indexOf(input.toLowerCase()) < 0) continue;
                ids.add(item.getJid());
            }
            String[] resultSet = new String[ids.size()];
            return ids.toArray(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadAllBuddyItems() {
        ArrayList<PTAppProtos.BuddyItem> arrayList = this.mBuddyItems;
        synchronized (arrayList) {
            this.mBuddyItems.clear();
            IPTService ptService = VideoBoxApplication.getInstance().getPTService();
            if (ptService == null) {
                return;
            }
            try {
                ptService.reloadAllBuddyItems();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBuddyItems() {
        ArrayList<PTAppProtos.BuddyItem> arrayList = this.mBuddyItems;
        synchronized (arrayList) {
            this.mBuddyItems.clear();
        }
    }

    @Override
    public void onIMLocalStatusChanged(int status) {
        switch (status) {
            case 4: {
                this.reloadAllBuddyItems();
                break;
            }
            case 0: {
                this.clearBuddyItems();
            }
        }
    }

    @Override
    public void onIMReceived(PTAppProtos.IMMessage message) {
    }

    @Override
    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
        this.updateBuddyItem(item);
    }

    @Override
    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
        this.updateBuddyItem(item);
    }

    @Override
    public void onIMBuddySort() {
    }

    @Override
    public void onSubscriptionRequest() {
    }

    @Override
    public void onSubscriptionUpdate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBuddyItem(PTAppProtos.BuddyItem item) {
        ArrayList<PTAppProtos.BuddyItem> arrayList = this.mBuddyItems;
        synchronized (arrayList) {
            boolean found = false;
            for (int i = 0; i < this.mBuddyItems.size(); ++i) {
                PTAppProtos.BuddyItem tmpItem = this.mBuddyItems.get(i);
                if (tmpItem == null || item.getJid() == null || !item.getJid().equals(tmpItem.getJid())) continue;
                this.mBuddyItems.set(i, item);
                found = true;
                break;
            }
            if (!found) {
                this.mBuddyItems.add(item);
            }
        }
    }

    @Override
    public void onQuerySSOVanityURL(String reqId, int result, String url) {
    }

    @Override
    public void onQueryIPLocation(int result, PTAppProtos.IPLocationInfo ipInfo) {
    }
}

