/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.delegate;

import android.os.RemoteException;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.FavoriteMgr;
import com.zipow.videobox.ptapp.ZoomContact;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.List;

public class FavoriteMgrDelegation {
    private static final String TAG = FavoriteMgrDelegation.class.getSimpleName();
    private FavoriteMgr mFavMgr;

    protected FavoriteMgrDelegation() {
    }

    protected FavoriteMgrDelegation(FavoriteMgr favMgr) {
        this.mFavMgr = favMgr;
    }

    public String getLocalPicturePath(String email) {
        if (this.mFavMgr != null) {
            return this.mFavMgr.getLocalPicturePath(email);
        }
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService != null) {
            try {
                return ptService.FavoriteMgr_getLocalPicturePath(email);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean getFavoriteListWithFilter(String filter, List<ZoomContact> contacts) {
        if (this.mFavMgr != null) {
            return this.mFavMgr.getFavoriteListWithFilter(filter, contacts);
        }
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService != null) {
            try {
                byte[] data = ptService.FavoriteMgr_getFavoriteListWithFilter(filter);
                if (data == null) {
                    return false;
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                try {
                    ObjectInputStream is = new ObjectInputStream(bis);
                    Object obj = is.readObject();
                    List contactsTmp = (List)obj;
                    contacts.addAll(contactsTmp);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }
}

