/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp.delegate;

import android.os.RemoteException;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.ptapp.ABContactsHelper;
import java.util.ArrayList;
import java.util.List;

public class ABContactsHelperDelegation {
    private static final String TAG = ABContactsHelperDelegation.class.getSimpleName();
    private ABContactsHelper mContactsHelper;

    protected ABContactsHelperDelegation() {
    }

    protected ABContactsHelperDelegation(ABContactsHelper contactsHelper) {
        this.mContactsHelper = contactsHelper;
    }

    public int getMatchedPhoneNumbers(List<String> phoneNumbers) {
        if (this.mContactsHelper != null) {
            return this.mContactsHelper.getMatchedPhoneNumbers(phoneNumbers);
        }
        String[] numbersArr = this.getMatchedPhoneNumbers();
        if (numbersArr == null) {
            return 0;
        }
        for (int i = 0; i < numbersArr.length; ++i) {
            phoneNumbers.add(numbersArr[i]);
        }
        return phoneNumbers.size();
    }

    public String[] getMatchedPhoneNumbers() {
        if (this.mContactsHelper != null) {
            ArrayList<String> phoneNumbers = new ArrayList<String>();
            this.mContactsHelper.getMatchedPhoneNumbers(phoneNumbers);
            String[] arrNumbers = new String[phoneNumbers.size()];
            return phoneNumbers.toArray(arrNumbers);
        }
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService != null) {
            try {
                return ptService.ABContactsHelper_getMatchedPhoneNumbers();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public int inviteABContacts(String[] phoneNumbers, String invitationMsgTemplate) {
        if (phoneNumbers == null) {
            return 1;
        }
        if (this.mContactsHelper != null) {
            ArrayList<String> listPhoneNumbers = new ArrayList<String>();
            for (int i = 0; i < phoneNumbers.length; ++i) {
                listPhoneNumbers.add(phoneNumbers[i]);
            }
            return this.mContactsHelper.inviteABContacts(listPhoneNumbers, invitationMsgTemplate);
        }
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService != null) {
            try {
                return ptService.ABContactsHelper_inviteABContacts(phoneNumbers, invitationMsgTemplate);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 11;
    }

    public String getVerifiedPhoneNumber() {
        if (this.mContactsHelper != null) {
            return this.mContactsHelper.getVerifiedPhoneNumber();
        }
        if (VideoBoxApplication.getInstance().isConfApp()) {
            return ConfMgr.getInstance().getVerifiedPhoneNumber();
        }
        return null;
    }
}

