/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.text.TextUtils;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.nos.NOSMgr;
import com.zipow.videobox.ptapp.ContactsMatchHelper;
import com.zipow.videobox.ptapp.IncomingCallManager;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.SIPConfiguration;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.view.mm.sticker.StickerManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.app.ForegroundTask;
import us.zoom.androidlib.app.ForegroundTaskManager;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class ZoomMessengerUI {
    private static final String TAG = ZoomMessengerUI.class.getSimpleName();
    public static final int CONNECTION_STATUS_UNKNOWN = -1;
    public static final int CONNECTION_STATUS_DISCONNECTED = 0;
    public static final int CONNECTION_STATUS_CONNECTED = 1;
    public static final int CONNECTION_STATUS_CONNECTING = 2;
    private int mConnectionStatus = -1;
    private static ZoomMessengerUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle = 0L;
    private Handler mHandler = new Handler();

    public static synchronized ZoomMessengerUI getInstance() {
        if (instance == null) {
            instance = new ZoomMessengerUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private ZoomMessengerUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L) {
            this.nativeUninit(this.mNativeHandle);
        }
        super.finalize();
    }

    public void addListener(IZoomMessengerUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IZoomMessengerUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IZoomMessengerUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public int getConnectionStatus() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            boolean connectionGood = messenger.isConnectionGood();
            if (connectionGood && this.mConnectionStatus != 1) {
                this.mConnectionStatus = 1;
            } else if (!connectionGood) {
                if (this.mConnectionStatus == 1) {
                    this.mConnectionStatus = 0;
                } else if (this.mConnectionStatus == -1) {
                    this.mConnectionStatus = 2;
                }
            }
        }
        return this.mConnectionStatus;
    }

    protected void dataReady() {
    }

    protected void on_BeginConnect() {
        try {
            this.on_BeginConnectImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_BeginConnectImpl() {
        this.mConnectionStatus = 2;
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onBeginConnect();
            }
        }
    }

    protected void on_ConnectReturn(int errorCode) {
        try {
            this.on_ConnectReturnImpl(errorCode);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_ConnectReturnImpl(int errorCode) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            int n = this.mConnectionStatus = messenger.isConnectionGood() ? 1 : 0;
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onConnectReturn(errorCode);
            }
        }
        if (errorCode == 0) {
            NOSMgr.getInstance().onXMPPConnectSuccess();
        }
    }

    protected void indicate_BuddyInfoUpdated(String phoneNumber) {
        try {
            this.indicate_BuddyInfoUpdatedImpl(phoneNumber);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void indicate_BuddyInfoUpdatedImpl(String phoneNumber) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onIndicateBuddyInfoUpdated(phoneNumber);
            }
        }
    }

    protected void on_MakeGroup(String reqId, int result, String actionOwner, String groupId, long time, List<String> notAllowBuddies, String msgId, long tmServerside, long prevMsgtime) {
        try {
            this.on_MakeGroupImpl(reqId, result, actionOwner, groupId, time, notAllowBuddies, msgId, tmServerside, prevMsgtime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_MakeGroupImpl(String reqId, int result, String actionOwner, String groupId, long time, List<String> notAllowBuddies, String msgId, long tmServerside, long prevMsgtime) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        if (myJid == null) {
            return;
        }
        boolean isOwnerMe = actionOwner.equals(myJid);
        String ownerName = "";
        ZoomBuddy buddyOwner = null;
        if (isOwnerMe) {
            buddyOwner = myself;
            ownerName = BuddyNameUtil.getMyDisplayName(buddyOwner);
        } else {
            buddyOwner = messenger.getBuddyWithJID(actionOwner);
            if (buddyOwner != null) {
                ownerName = BuddyNameUtil.getBuddyDisplayName(buddyOwner, null, false);
            }
        }
        ArrayList<String> buddies = new ArrayList<String>();
        ZoomGroup group = messenger.getGroupById(groupId);
        boolean isMeInBuddies = false;
        if (group != null) {
            for (int i = 0; i < group.getBuddyCount(); ++i) {
                ZoomBuddy buddy = group.getBuddyAt(i);
                if (buddy == null) continue;
                if (myJid.equals(buddy.getJid())) {
                    isMeInBuddies = true;
                    continue;
                }
                if (StringUtil.isSameString((String)actionOwner, (String)buddy.getJid())) continue;
                String name = BuddyNameUtil.getBuddyDisplayName(buddy, null, false);
                buddies.add(name);
            }
        } else if (result == 0) {
            // empty if block
        }
        String[] arrBuddies = new String[buddies.size()];
        arrBuddies = buddies.toArray(arrBuddies);
        GroupAction action = new GroupAction(0, ownerName, arrBuddies, isOwnerMe, isMeInBuddies, null);
        action.setActionOwnerId(actionOwner);
        action.setGroupId(groupId);
        action.setTime(time);
        action.setNotAllowBuddies(notAllowBuddies);
        action.setReqId(reqId);
        if (result == 0) {
            String messageBody = GroupAction.serializeToString(action);
            msgId = messenger.insertSystemMessage(groupId, actionOwner, messageBody, time, 20, msgId, tmServerside, prevMsgtime);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onGroupAction(result, action, msgId);
            }
        }
    }

    protected void on_ModifyGroupName(int result, String actionOwner, String groupId, String newName, long time, String msgId, long tmServerside, long prevMsgtime) {
        try {
            this.on_ModifyGroupNameImpl(result, actionOwner, groupId, newName, time, msgId, tmServerside, prevMsgtime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_ModifyGroupNameImpl(int result, String actionOwner, String groupId, String newName, long time, String msgId, long tmServerside, long prevMsgtime) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        boolean isOwnerMe = actionOwner.equals(myJid);
        String ownerName = "";
        ZoomBuddy buddyOwner = null;
        if (isOwnerMe) {
            buddyOwner = myself;
            ownerName = BuddyNameUtil.getMyDisplayName(buddyOwner);
        } else {
            buddyOwner = messenger.getBuddyWithJID(actionOwner);
            if (buddyOwner == null) {
                // empty if block
            }
            ownerName = BuddyNameUtil.getBuddyDisplayName(buddyOwner, null, false);
        }
        GroupAction action = new GroupAction(1, ownerName, null, isOwnerMe, false, newName);
        action.setActionOwnerId(actionOwner);
        action.setGroupId(groupId);
        action.setTime(time);
        if (result == 0) {
            String messageBody = GroupAction.serializeToString(action);
            msgId = messenger.insertSystemMessage(groupId, actionOwner, messageBody, time, 24, msgId, tmServerside, prevMsgtime);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onGroupAction(result, action, msgId);
            }
        }
    }

    protected void on_DeleteGroup(int result, String actionOwner, String groupId, long time) {
        try {
            this.on_DeleteGroupImpl(result, actionOwner, groupId, time);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_DeleteGroupImpl(int result, String actionOwner, String groupId, long time) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.deleteCachedGroupAvatar(groupId);
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        boolean isOwnerMe = actionOwner.equals(myJid);
        String ownerName = "";
        ZoomBuddy buddyOwner = null;
        if (isOwnerMe) {
            buddyOwner = myself;
            ownerName = BuddyNameUtil.getMyDisplayName(buddyOwner);
        } else {
            buddyOwner = messenger.getBuddyWithJID(actionOwner);
            ownerName = BuddyNameUtil.getBuddyDisplayName(buddyOwner, null, false);
        }
        GroupAction action = new GroupAction(2, ownerName, null, isOwnerMe, false, null);
        action.setActionOwnerId(actionOwner);
        action.setGroupId(groupId);
        action.setTime(time);
        String msgId = null;
        if (result == 0) {
            String messageBody = GroupAction.serializeToString(action);
            msgId = messenger.insertSystemMessage(groupId, actionOwner, messageBody, time, 23, null, 0L, 0L);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onGroupAction(result, action, msgId);
            }
        }
    }

    protected void on_ModifyGroupOption(int result, String actionOwner, String groupId, int mucFlag, long time, long tmServerside, long prevMsgtime) {
        try {
            this.on_ModifyGroupOptionImpl(result, actionOwner, groupId, mucFlag, time, tmServerside, prevMsgtime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_ModifyGroupOptionImpl(int result, String actionOwner, String groupId, int mucFlag, long time, long tmServerside, long prevMsgtime) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        boolean isOwnerMe = actionOwner.equals(myJid);
        String ownerName = "";
        ZoomBuddy buddyOwner = null;
        if (isOwnerMe) {
            buddyOwner = myself;
            ownerName = BuddyNameUtil.getMyDisplayName(buddyOwner);
        } else {
            buddyOwner = messenger.getBuddyWithJID(actionOwner);
            ownerName = BuddyNameUtil.getBuddyDisplayName(buddyOwner, null, false);
        }
        GroupAction action = new GroupAction(6, ownerName, null, isOwnerMe, false, null);
        action.setActionOwnerId(actionOwner);
        action.setGroupId(groupId);
        action.setTime(time);
        action.setMucFlag(mucFlag);
        if (result == 0) {
            // empty if block
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onGroupAction(result, action, null);
            }
        }
    }

    protected void on_AddedToGroup(int result, String actionOwner, String groupId, List<String> buddies, List<String> buddyNames, long time, List<String> notAllowBuddies, List<String> notAllowBuddyNames, String msgId, long tmServerside, long prevMsgtime) {
        try {
            this.on_AddedToGroupImpl(result, actionOwner, groupId, buddies, buddyNames, time, notAllowBuddies, notAllowBuddyNames, msgId, tmServerside, prevMsgtime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_AddedToGroupImpl(int result, String actionOwner, String groupId, List<String> buddies, List<String> buddyNames, long time, List<String> notAllowBuddies, List<String> notAllowBuddyNames, String msgId, long tmServerside, long prevMsgtime) {
        IListener[] listeners;
        if (buddies == null && notAllowBuddies == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.deleteCachedGroupAvatar(groupId);
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        boolean isOwnerMe = actionOwner.equals(myJid);
        String ownerName = "";
        ZoomBuddy buddyOwner = null;
        if (isOwnerMe) {
            buddyOwner = myself;
            ownerName = BuddyNameUtil.getMyDisplayName(buddyOwner);
        } else {
            buddyOwner = messenger.getBuddyWithJID(actionOwner);
            ownerName = BuddyNameUtil.getBuddyDisplayName(buddyOwner, null, false);
        }
        boolean isMeInBuddies = false;
        ArrayList<String> buddiesNames = new ArrayList<String>();
        if (!CollectionsUtil.isCollectionEmpty(buddies)) {
            for (int i = 0; i < buddies.size(); ++i) {
                String jid = buddies.get(i);
                if (myJid.equals(jid)) {
                    isMeInBuddies = true;
                    continue;
                }
                String name = buddyNames.get(i);
                if (StringUtil.isEmptyOrNull((String)name)) {
                    ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
                    if (buddy == null) continue;
                    name = BuddyNameUtil.getBuddyDisplayName(buddy, null, false);
                }
                buddiesNames.add(name);
            }
        }
        String[] arrBuddies = new String[buddiesNames.size()];
        arrBuddies = buddiesNames.toArray(arrBuddies);
        GroupAction action = new GroupAction(3, ownerName, arrBuddies, isOwnerMe, isMeInBuddies, null);
        action.setActionOwnerId(actionOwner);
        action.setGroupId(groupId);
        action.setTime(time);
        action.setNotAllowBuddies(notAllowBuddyNames);
        if (result == 0) {
            String messageBody = GroupAction.serializeToString(action);
            msgId = messenger.insertSystemMessage(groupId, actionOwner, messageBody, time, 21, msgId, tmServerside, prevMsgtime);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onGroupAction(result, action, msgId);
            }
        }
    }

    protected void on_RemovedFromGroup(int result, String actionOwner, String groupId, String buddyJid, String buddyName, long time, String msgId, long tmServerside, long prevMsgtime) {
        try {
            this.on_RemovedFromGroupImpl(result, actionOwner, groupId, buddyJid, buddyName, time, msgId, tmServerside, prevMsgtime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_RemovedFromGroupImpl(int result, String actionOwner, String groupId, String buddyJid, String buddyName, long time, String msgId, long tmServerside, long prevMsgtime) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isSameString((String)actionOwner, (String)buddyJid) && !StringUtil.isEmptyOrNull((String)actionOwner)) {
            this.on_QuitGroup(result, actionOwner, buddyName, groupId, time, tmServerside, prevMsgtime, msgId);
            return;
        }
        this.deleteCachedGroupAvatar(groupId);
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        boolean isOwnerMe = actionOwner.equals(myJid);
        String ownerName = "";
        ZoomBuddy buddyOwner = null;
        if (isOwnerMe) {
            buddyOwner = myself;
            ownerName = BuddyNameUtil.getMyDisplayName(buddyOwner);
        } else {
            buddyOwner = messenger.getBuddyWithJID(actionOwner);
            ownerName = BuddyNameUtil.getBuddyDisplayName(buddyOwner, null, false);
        }
        boolean isMeInBuddies = myJid.equals(buddyJid);
        String name = buddyName;
        if (StringUtil.isEmptyOrNull((String)name)) {
            ZoomBuddy buddy = messenger.getBuddyWithJID(buddyJid);
            if (buddy == null) {
                return;
            }
            name = BuddyNameUtil.getBuddyDisplayName(buddy, null, false);
        }
        String[] arrBuddies = null;
        if (!isMeInBuddies) {
            arrBuddies = new String[]{name};
        }
        GroupAction action = new GroupAction(4, ownerName, arrBuddies, isOwnerMe, isMeInBuddies, null);
        action.setActionOwnerId(actionOwner);
        action.setGroupId(groupId);
        action.setTime(time);
        if (result == 0) {
            String messageBody = GroupAction.serializeToString(action);
            msgId = messenger.insertSystemMessage(groupId, actionOwner, messageBody, time, 22, msgId, tmServerside, prevMsgtime);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onGroupAction(result, action, msgId);
            }
        }
    }

    protected void on_BatchRemovedFromGroup(int result, String actionOwner, String groupId, List<String> buddies, List<String> buddyNames, long time, String msgId, long tmServerside, long prevMsgtime) {
        try {
            this.on_BatchRemovedFromGroupImpl(result, actionOwner, groupId, buddies, buddyNames, time, msgId, tmServerside, prevMsgtime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_BatchRemovedFromGroupImpl(int result, String actionOwner, String groupId, List<String> buddies, List<String> buddyNames, long time, String msgId, long tmServerside, long prevMsgtime) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (buddies == null) {
            return;
        }
        if (buddies.size() == 1) {
            this.on_RemovedFromGroupImpl(result, actionOwner, groupId, buddies.get(0), buddyNames.get(0), time, msgId, tmServerside, prevMsgtime);
            return;
        }
        this.deleteCachedGroupAvatar(groupId);
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        boolean isOwnerMe = actionOwner.equals(myJid);
        String ownerName = "";
        ZoomBuddy buddyOwner = null;
        if (isOwnerMe) {
            buddyOwner = myself;
            ownerName = BuddyNameUtil.getMyDisplayName(buddyOwner);
        } else {
            buddyOwner = messenger.getBuddyWithJID(actionOwner);
            ownerName = BuddyNameUtil.getBuddyDisplayName(buddyOwner, null, false);
        }
        boolean isMeInBuddies = false;
        ArrayList<String> buddiesNames = new ArrayList<String>();
        for (int i = 0; i < buddies.size(); ++i) {
            String name;
            String jid = buddies.get(i);
            if (myJid.equals(jid)) {
                isMeInBuddies = true;
                continue;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null || StringUtil.isEmptyOrNull((String)(name = BuddyNameUtil.getBuddyDisplayName(buddy, null, false)))) continue;
            buddiesNames.add(name);
        }
        String[] arrBuddies = new String[buddiesNames.size()];
        arrBuddies = buddiesNames.toArray(arrBuddies);
        GroupAction action = new GroupAction(4, ownerName, arrBuddies, isOwnerMe, isMeInBuddies, null);
        action.setActionOwnerId(actionOwner);
        action.setGroupId(groupId);
        action.setTime(time);
        if (result == 0) {
            String messageBody = GroupAction.serializeToString(action);
            msgId = messenger.insertSystemMessage(groupId, actionOwner, messageBody, time, 22, msgId, tmServerside, prevMsgtime);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onGroupAction(result, action, msgId);
            }
        }
    }

    private void on_QuitGroup(int result, String actionOwner, String actionName, String groupId, long time, long tmServerside, long prevMsgtime, String msgId) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.deleteCachedGroupAvatar(groupId);
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        boolean isOwnerMe = actionOwner.equals(myJid);
        String ownerName = "";
        ZoomBuddy buddyOwner = null;
        if (isOwnerMe) {
            buddyOwner = myself;
            ownerName = BuddyNameUtil.getMyDisplayName(buddyOwner);
        } else if (StringUtil.isEmptyOrNull((String)actionName)) {
            buddyOwner = messenger.getBuddyWithJID(actionOwner);
            ownerName = BuddyNameUtil.getBuddyDisplayName(buddyOwner, null, false);
        } else {
            ownerName = actionName;
        }
        GroupAction action = new GroupAction(5, ownerName, null, isOwnerMe, false, null);
        action.setActionOwnerId(actionOwner);
        action.setGroupId(groupId);
        action.setTime(time);
        if (result == 0) {
            String messageBody = GroupAction.serializeToString(action);
            msgId = messenger.insertSystemMessage(groupId, actionOwner, messageBody, time, 23, msgId, tmServerside, prevMsgtime);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onGroupAction(result, action, msgId);
            }
        }
    }

    private void deleteCachedGroupAvatar(String groupId) {
        ZoomMessenger messenger;
        File file;
        String avatarPath = ZoomGroup.getGroupAvatarPath(groupId);
        if (avatarPath != null && (file = new File(avatarPath)).exists()) {
            file.delete();
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
            return;
        }
        String sessionDataFolder = messenger.getSessionDataFolder(groupId);
        if (StringUtil.isEmptyOrNull((String)sessionDataFolder)) {
            return;
        }
        File dir = new File(sessionDataFolder);
        if (dir.exists()) {
            dir.delete();
        }
    }

    protected void notify_MUCGroupInfoUpdated(String groupID) {
        try {
            this.notify_MUCGroupInfoUpdatedImpl(groupID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_MUCGroupInfoUpdatedImpl(String groupID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onNotify_MUCGroupInfoUpdatedImpl(groupID);
            }
        }
    }

    protected void notify_SessionMarkUnreadCtx(String reqID, int result, String session, List<String> msgGuids) {
        try {
            this.notify_SessionMarkUnreadCtxImpl(reqID, result, session, msgGuids);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_SessionMarkUnreadCtxImpl(String reqID, int result, String session, List<String> msgGuids) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onNotify_SessionMarkUnreadCtx(reqID, result, session, msgGuids);
            }
        }
    }

    protected void notify_ChatSessionUnreadUpdate() {
        try {
            this.notify_ChatSessionUnreadUpdateImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_ChatSessionUnreadUpdateImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onNotify_ChatSessionUnreadUpdate();
            }
        }
    }

    protected void notify_ChatSessionListUpdate() {
        try {
            this.notify_ChatSessionListUpdateImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_ChatSessionListUpdateImpl() {
        ZoomMessenger messenger;
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onNotify_ChatSessionListUpdate();
            }
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) != null && messenger.getTotalUnreadMessageCount() <= 0) {
            NotificationMgr.removeMessageNotificationMM((Context)VideoBoxApplication.getInstance());
        }
    }

    protected void notify_ChatSessionUpdate(String sessionId) {
        try {
            this.notify_ChatSessionUpdateImpl(sessionId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_ChatSessionUpdateImpl(String sessionId) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onNotify_ChatSessionUpdate(sessionId);
            }
        }
    }

    protected void confirm_MessageSent(String sessionId, String messageId, int result) {
        try {
            this.confirm_MessageSentImpl(sessionId, messageId, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void confirm_MessageSentImpl(String sessionId, String messageId, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onConfirm_MessageSent(sessionId, messageId, result);
            }
        }
    }

    protected void confirm_FileDownloaded(String sessionId, String messageId, int result) {
        try {
            this.confirm_FileDownloadedImpl(sessionId, messageId, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void confirm_FileDownloadedImpl(String sessionId, String messageId, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onConfirmFileDownloaded(sessionId, messageId, result);
            }
        }
    }

    protected void confirm_PreviewPicFileDownloaded(String sessionId, String messageId, int result) {
        try {
            this.confirm_PreviewPicFileDownloadedImpl(sessionId, messageId, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void confirm_PreviewPicFileDownloadedImpl(String sessionId, String messageId, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onConfirmPreviewPicFileDownloaded(sessionId, messageId, result);
            }
        }
    }

    protected void indicate_MessageReceived(String sessionId, String senderJid, String messageId) {
        try {
            this.indicate_MessageReceivedImpl(sessionId, senderJid, messageId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    protected void indicate_IMCMD_Received(String sessionId, String senderName, String messageId, long date, int messageType) {
        try {
            this.indicate_IMCMD_ReceivedImpl(sessionId, senderName, messageId, date, messageType);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void indicate_MessageReceivedImpl(String sessionId, String senderJid, String messageId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || messenger.imChatGetOption() == 2) {
            return;
        }
        boolean read = false;
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                if (!l.onIndicateMessageReceived(sessionId, senderJid, messageId)) continue;
                read = true;
            }
        }
        if (!read) {
            this.showMmMessageUnreadNotificationDelayed(sessionId, messageId, 1500L);
        }
    }

    private void indicate_IMCMD_ReceivedImpl(String sessionId, String senderName, String messageId, long date, int messageType) {
        IListener[] listeners;
        if (messageType == 50) {
            ZoomMessenger zm = PTApp.getInstance().getZoomMessenger();
            if (StringUtil.isEmptyOrNull((String)sessionId) || zm == null) {
                return;
            }
            zm.insertSystemMessage("", sessionId, VideoBoxApplication.getInstance().getString(R.string.zm_mm_miss_call), date / 1000L, false, 50, null);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onIndicateIMCMDReceivedImpl(sessionId, senderName, messageId, date, messageType);
            }
        }
    }

    private void showMmMessageUnreadNotificationDelayed(final String sessionId, final String messageId, long delayMillis) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                ZoomChatSession session = messenger.getSessionById(sessionId);
                if (session == null) {
                    return;
                }
                ZoomMessage msg = session.getMessageById(messageId);
                if (msg == null) {
                    return;
                }
                if (msg.getMessageFilterResult() != 1) {
                    return;
                }
                NotificationMgr.showMessageNotificationMM((Context)VideoBoxApplication.getInstance(), true, sessionId);
            }
        }, delayMillis);
    }

    protected void indicate_InputStateChanged(String sessionId, int state) {
        try {
            this.indicate_InputStateChangedImpl(sessionId, state);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void indicate_InputStateChangedImpl(String sessionId, int state) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onIndicateInputStateChanged(sessionId, state);
            }
        }
    }

    protected void on_ReceivedCall(String groupId, String senderJid, byte[] content) {
        try {
            this.on_ReceivedCallImpl(groupId, senderJid, content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_ReceivedCallImpl(String groupId, String senderJid, byte[] content) {
        PTAppProtos.InvitationItem item = null;
        try {
            item = PTAppProtos.InvitationItem.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        long meetingNumber = item.getMeetingNumber();
        long activeMeetingNumber = PTApp.getInstance().getActiveMeetingNo();
        if (activeMeetingNumber == meetingNumber) {
            return;
        }
        this.onConfInvitation(item);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onReceivedCall(groupId, senderJid, item);
            }
        }
    }

    protected void notify_JIDUpdated() {
        try {
            this.notify_JIDUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_JIDUpdatedImpl() {
        ContactsMatchHelper.getInstance().matchAllNumbers((Context)VideoBoxApplication.getInstance());
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onNotify_JIDUpdated();
            }
        }
    }

    private void onConfInvitation(PTAppProtos.InvitationItem invitation) {
        IncomingCallManager.getInstance().onConfInvitation(invitation);
    }

    protected void indicate_BuddyListUpdated() {
        try {
            this.indicate_BuddyListUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void indicate_BuddyListUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onIndicateBuddyListUpdated();
            }
        }
    }

    protected void indicate_BuddyBigPictureDownloaded(String jid, int result) {
        try {
            this.indicate_BuddyBigPictureDownloadedImpl(jid, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void indicate_BuddyBigPictureDownloadedImpl(String jid, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onIndicate_BuddyBigPictureDownloaded(jid, result);
            }
        }
    }

    protected void indicate_BuddyInfoUpdatedWithJID(String jid) {
        try {
            this.indicate_BuddyInfoUpdatedWithJIDImpl(jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void indicate_BuddyInfoUpdatedWithJIDImpl(String jid) {
        ZMBuddySyncInstance.getInsatance().indicate_BuddyInfoUpdatedWithJID(jid);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onIndicateInfoUpdatedWithJID(jid);
            }
        }
    }

    protected void on_AddBuddy(String jid, int result, String reasonString) {
        try {
            this.on_AddBuddyImpl(jid, result, reasonString);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_AddBuddyImpl(String jid, int result, String reasonString) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onAddBuddy(jid, result, reasonString);
            }
        }
    }

    protected void on_AddBuddyByEmail(String email, int result) {
        try {
            this.on_AddBuddyByEmailImpl(email, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_AddBuddyByEmailImpl(String email, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onAddBuddyByEmail(email, result);
            }
        }
    }

    protected void on_RemoveBuddy(String jid, int result) {
        try {
            this.on_RemoveBuddyImpl(jid, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_RemoveBuddyImpl(String jid, int result) {
        ZMBuddySyncInstance.getInsatance().on_RemoveBuddy(jid, result);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onRemoveBuddy(jid, result);
            }
        }
    }

    protected void on_SearchBuddy(String email, int result) {
        try {
            this.on_SearchBuddyImpl(email, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_SearchBuddyImpl(String email, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onSearchBuddy(email, result);
            }
        }
    }

    protected void on_SearchBuddyByKey(String key, int result) {
        try {
            this.on_SearchBuddyByKeyImpl(key, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_SearchBuddyByKeyImpl(String key, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onSearchBuddyByKey(key, result);
            }
        }
    }

    protected void on_SearchBuddyPicDownloaded(String jid) {
        try {
            this.on_SearchBuddyPicDownloadedImpl(jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void on_SearchBuddyPicDownloadedImpl(String jid) {
        ZMBuddySyncInstance.getInsatance().onSearchBuddyPicDownloaded(jid);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onSearchBuddyPicDownloaded(jid);
            }
        }
    }

    protected void notify_SubscribeRequest(String jid, String msg) {
        try {
            this.notify_SubscribeRequestImpl(jid, msg);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_SubscribeRequestImpl(String jid, String msg) {
        IListener[] listeners = this.mListenerList.getAll();
        boolean isReaded = false;
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                isReaded |= l.onNotifySubscribeRequest(jid, msg);
            }
        }
        if (!isReaded) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null || messenger.imChatGetOption() == 2) {
                        return;
                    }
                    NotificationMgr.showMessageNotificationMM((Context)VideoBoxApplication.getInstance(), true, "######SYSTEM_NOTIFICATION_SESSION");
                }
            }, 1500L);
        }
    }

    protected void notify_SubscriptionAccepted(String jid) {
        try {
            this.notify_SubscriptionAcceptedImpl(jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_SubscriptionAcceptedImpl(String jid) {
        ZMBuddySyncInstance.getInsatance().onNotifySubscriptionAccepted(jid);
        IListener[] listeners = this.mListenerList.getAll();
        boolean isReaded = false;
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                isReaded |= l.onNotifySubscriptionAccepted(jid);
            }
        }
        if (!isReaded) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null || messenger.imChatGetOption() == 2) {
                        return;
                    }
                    NotificationMgr.showMessageNotificationMM((Context)VideoBoxApplication.getInstance(), true, "######SYSTEM_NOTIFICATION_SESSION");
                }
            }, 1500L);
        }
    }

    protected void notify_SubscriptionDenied(String jid) {
        try {
            this.notify_SubscriptionDeniedImpl(jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_SubscriptionDeniedImpl(String jid) {
        ZMBuddySyncInstance.getInsatance().onNotifySubscriptionDenied(jid);
        IListener[] listeners = this.mListenerList.getAll();
        boolean isReaded = false;
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                isReaded |= l.onNotifySubscriptionDenied(jid);
            }
        }
        if (!isReaded) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null || messenger.imChatGetOption() == 2) {
                        return;
                    }
                    NotificationMgr.showMessageNotificationMM((Context)VideoBoxApplication.getInstance(), true, "######SYSTEM_NOTIFICATION_SESSION");
                }
            }, 1500L);
        }
    }

    protected void Indicate_TPV2_GetContactsPresence(List<String> onLines, List<String> offlines) {
        try {
            this.Indicate_TPV2_GetContactsPresenceImpl(onLines, offlines);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_TPV2_GetContactsPresenceImpl(List<String> onLines, List<String> offlines) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_TPV2_GetContactsPresence(onLines, offlines);
            }
        }
    }

    protected void Indicate_TPV2_SubscribePresence(List<String> jIDs) {
        try {
            this.Indicate_TPV2_SubscribePresenceImpl(jIDs);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_TPV2_SubscribePresenceImpl(List<String> jIDs) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_TPV2_SubscribePresence(jIDs);
            }
        }
    }

    protected void Indicate_TPV2_WillExpirePresence(List<String> jIDs, int type) {
        try {
            this.Indicate_TPV2_WillExpirePresenceImpl(jIDs, type);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_TPV2_WillExpirePresenceImpl(List<String> jIDs, int type) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && type == 3) {
            messenger.TPV2_UnsubscribePresence(jIDs);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_TPV2_WillExpirePresence(jIDs, type);
            }
        }
    }

    protected void notify_UnsubscribeRequest(String strBareJid, String message) {
        try {
            this.notify_UnsubscribeRequestImpl(strBareJid, message);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notify_UnsubscribeRequestImpl(String strBareJid, String message) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onNotifyUnsubscribeRequest(strBareJid, message);
            }
        }
    }

    protected void notifyBuddyJIDUpgrade(String phoneNo, String oldJid, String newJid) {
        try {
            this.notifyBuddyJIDUpgradeImpl(phoneNo, oldJid, newJid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notifyBuddyJIDUpgradeImpl(String phoneNo, String oldJid, String newJid) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onNotifyBuddyJIDUpgrade(phoneNo, oldJid, newJid);
            }
        }
    }

    protected void FT_OnSent(String sessionID, String messageID, int result) {
        try {
            this.FT_OnSentImpl(sessionID, messageID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void FT_OnSentImpl(String sessionID, String messageID, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.FT_OnSent(sessionID, messageID, result);
            }
        }
    }

    protected void FT_OnProgress(String sessionID, String messageID, int ratio, long completeSize, long bitPerSecond) {
        try {
            this.FT_OnProgressImpl(sessionID, messageID, ratio, completeSize, bitPerSecond);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void FT_OnProgressImpl(String sessionID, String messageID, int ratio, long completeSize, long bitPerSecond) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.FT_OnProgress(sessionID, messageID, ratio, completeSize, bitPerSecond);
            }
        }
    }

    protected void E2E_MyStateUpdate(int myE2EState) {
        try {
            this.E2E_MyStateUpdateImpl(myE2EState);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void E2E_MyStateUpdateImpl(int myE2EState) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.E2E_MyStateUpdate(myE2EState);
            }
        }
    }

    protected void E2E_SessionStateUpdate(String sessionID, String tid, int e2eSessionState, int e2eError) {
        try {
            this.E2E_SessionStateUpdateImpl(sessionID, tid, e2eSessionState, e2eError);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void E2E_SessionStateUpdateImpl(String sessionID, String tid, int e2eSessionState, int e2eError) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.E2E_SessionStateUpdate(sessionID, tid, e2eSessionState, e2eError);
            }
        }
    }

    protected void E2E_MessageStateUpdate(String sessionID, String messageId, int newState) {
        try {
            this.E2E_MessageStateUpdateImpl(sessionID, messageId, newState);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void E2E_MessageStateUpdateImpl(String sessionID, String messageId, int newState) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.E2E_MessageStateUpdate(sessionID, messageId, newState);
            }
        }
    }

    protected void E2E_NotifyAutoLogoff() {
        try {
            this.E2E_NotifyAutoLogoffImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void E2E_NotifyAutoLogoffImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.E2E_NotifyAutoLogoff();
            }
        }
    }

    protected void FT_OnResumed(String sessionID, String messageID, int result) {
        try {
            this.FT_OnResumedImpl(sessionID, messageID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void FT_OnResumedImpl(String sessionID, String messageID, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.FT_OnResumed(sessionID, messageID, result);
            }
        }
    }

    protected void Notify_SubscribeRequestUpdated(String jid) {
        try {
            this.Notify_SubscribeRequestUpdatedImpl(jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Notify_SubscribeRequestUpdatedImpl(String jid) {
        ZMBuddySyncInstance.getInsatance().onNotifySubscribeRequestUpdated(jid);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.onNotifySubscribeRequestUpdated(jid);
            }
        }
    }

    protected void Confirm_HistoryReqComplete(String requestId, String sessionId, int result, int count) {
        try {
            this.Confirm_HistoryReqCompleteImpl(requestId, sessionId, result, count);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Confirm_HistoryReqCompleteImpl(String requestId, String sessionId, int result, int count) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Confirm_HistoryReqComplete(requestId, sessionId, result, count);
            }
        }
    }

    protected void Indicate_OnlineBuddies(List<String> jidList) {
        try {
            this.Indicate_OnlineBuddiesImpl(jidList);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_OnlineBuddiesImpl(List<String> jidList) {
        ZMBuddySyncInstance.getInsatance().Indicate_OnlineBuddies(jidList);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_OnlineBuddies(jidList);
            }
        }
    }

    protected void Indicate_BuddyGroupsRemoved(List<String> jidList) {
        try {
            this.Indicate_BuddyGroupsRemovedImpl(jidList);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyGroupsRemovedImpl(List<String> jidList) {
        ZMBuddySyncInstance.getInsatance().Indicate_BuddyGroupsRemoved(jidList);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyGroupsRemoved(jidList);
            }
        }
    }

    protected void Indicate_BuddyPresenceChanged(String jid) {
        try {
            this.Indicate_BuddyPresenceChangedImpl(jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyPresenceChangedImpl(String jid) {
        ZMBuddySyncInstance.getInsatance().Indicate_BuddyPresenceChanged(jid);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyPresenceChanged(jid);
            }
        }
    }

    protected void Indicate_BuddyGroupAdded(String groupID) {
        try {
            this.Indicate_BuddyGroupAddedImpl(groupID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyGroupAddedImpl(String groupID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyGroupAdded(groupID);
            }
        }
    }

    protected void Indicate_BuddyGroupInfoUpdated(String groupID) {
        try {
            this.Indicate_BuddyGroupInfoUpdatedImpl(groupID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyGroupInfoUpdatedImpl(String groupID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyGroupInfoUpdated(groupID);
            }
        }
    }

    protected void Indicate_BuddyGroupMembersAdded(String groupID, List<String> jidList) {
        try {
            this.Indicate_BuddyGroupMembersAddedImpl(groupID, jidList);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyGroupMembersAddedImpl(String groupID, List<String> jidList) {
        ZMBuddySyncInstance.getInsatance().Indicate_BuddyGroupMembersAdded(groupID, jidList);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyGroupMembersAdded(groupID, jidList);
            }
        }
    }

    protected void Indicate_BuddyGroupMembersRemoved(String groupID, List<String> jidList) {
        try {
            this.Indicate_BuddyGroupMembersRemoveddImpl(groupID, jidList);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyGroupMembersRemoveddImpl(String groupID, List<String> jidList) {
        ZMBuddySyncInstance.getInsatance().Indicate_BuddyGroupMembersRemoved(groupID, jidList);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyGroupMembersRemoved(groupID, jidList);
            }
        }
    }

    protected void Indicate_BuddyGroupMembersChanged(byte[] changeBytes, boolean bLastPage) {
        try {
            if (changeBytes == null) {
                return;
            }
            PTAppProtos.ChangedBuddyGroups groups = PTAppProtos.ChangedBuddyGroups.parseFrom(changeBytes);
            this.Indicate_BuddyGroupMembersChangedImpl(groups, bLastPage);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyGroupMembersChangedImpl(PTAppProtos.ChangedBuddyGroups groups, boolean bLastPage) {
        ZMBuddySyncInstance.getInsatance().Indicate_BuddyGroupMembersChanged(groups, bLastPage);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyGroupMembersChanged(groups, bLastPage);
            }
        }
    }

    protected void Indicate_BuddyGroupMemberAdded(String groupName, String jid) {
        try {
            this.Indicate_BuddyGroupMemberAddedImpl(groupName, jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyGroupMemberAddedImpl(String groupName, String jid) {
        ZMBuddySyncInstance.getInsatance().Indicate_BuddyGroupMemberAdded(groupName, jid);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyGroupMemberAdded(groupName, jid);
            }
        }
    }

    protected void Indicate_BuddyGroupMemberRemoved(String groupName, String jid) {
        try {
            this.Indicate_BuddyGroupMemberRemovedImpl(groupName, jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyGroupMemberRemovedImpl(String groupName, String jid) {
        ZMBuddySyncInstance.getInsatance().Indicate_BuddyGroupMemberRemoved(groupName, jid);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyGroupMemberRemoved(groupName, jid);
            }
        }
    }

    protected void On_AddLocalPendingBuddy(String jid, int result, String groupJid) {
        try {
            this.On_AddLocalPendingBuddyImpl(jid, result, groupJid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void On_AddLocalPendingBuddyImpl(String jid, int result, String groupJid) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.On_AddLocalPendingBuddy(jid, result, groupJid);
            }
        }
    }

    protected void Indicate_BuddyAdded(String jid, List<String> groupIds) {
        try {
            this.Indicate_BuddyAddedImpl(jid, groupIds);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BuddyAddedImpl(String jid, List<String> groupIds) {
        ZMBuddySyncInstance.getInsatance().Indicate_BuddyAdded(jid, groupIds);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BuddyAdded(jid, groupIds);
            }
        }
    }

    protected void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        try {
            this.FT_DownloadByFileID_OnProgressImpl(reqId, webFileID, ratio, completeSize, bitPerSecond);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void FT_DownloadByFileID_OnProgressImpl(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.FT_DownloadByFileID_OnProgress(reqId, webFileID, ratio, completeSize, bitPerSecond);
            }
        }
    }

    protected void FT_UploadToMyList_OnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
        try {
            this.FT_UploadToMyList_OnProgressImpl(reqID, ratio, completeSize, bitPerSecond);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void FT_UploadToMyList_OnProgressImpl(String reqID, int ratio, int completeSize, int bitPerSecond) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.FT_UploadToMyList_OnProgress(reqID, ratio, completeSize, bitPerSecond);
            }
        }
    }

    protected void Indicate_FileDeleted(String reqId, String webFileID, int result) {
        try {
            this.Indicate_FileDeletedImpl(reqId, webFileID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_FileDeletedImpl(String reqId, String webFileID, int result) {
        IListener[] listeners;
        Context context;
        if (result != 0 && (context = VideoBoxApplication.getGlobalContext()) != null) {
            String errorMsg = context.getString(R.string.zm_alert_delete_file_failed);
            this.promptIMErrorMsg(errorMsg, result);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_FileDeleted(reqId, webFileID, result);
            }
        }
    }

    protected void Indicate_FileForwarded(String reqId, String origMsgXmppID, String newSession, String newMsgXmppID, int result) {
        try {
            this.Indicate_FileForwardedImpl(reqId, origMsgXmppID, newSession, newMsgXmppID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_FileForwardedImpl(String reqId, String origMsgXmppID, String newSession, String newMsgXmppID, int result) {
        IListener[] listeners;
        Context context = VideoBoxApplication.getGlobalContext();
        if (context != null) {
            String errorMsg = result == 0 ? context.getString(R.string.zm_alert_msg_success) : context.getString(R.string.zm_alert_share_file_failed);
            this.promptIMErrorMsg(errorMsg, result);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_FileForwarded(reqId, origMsgXmppID, newSession, newMsgXmppID, result);
            }
        }
    }

    protected void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        try {
            this.Indicate_FileSharedImpl(reqId, webFileID, sharee, newSession, newMsgXmppID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_FileSharedImpl(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        IListener[] listeners;
        Context context = VideoBoxApplication.getGlobalContext();
        if (context != null) {
            String errorMsg = result == 0 ? context.getString(R.string.zm_alert_msg_success) : context.getString(R.string.zm_alert_share_file_failed);
            this.promptIMErrorMsg(errorMsg, result);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_FileShared(reqId, webFileID, sharee, newSession, newMsgXmppID, result);
            }
        }
    }

    protected void Indicate_FileUnshared(String reqId, String webFileID, int result) {
        try {
            this.Indicate_FileUnsharedImpl(reqId, webFileID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_FileUnsharedImpl(String reqId, String webFileID, int result) {
        IListener[] listeners;
        Context context;
        if (result != 0 && (context = VideoBoxApplication.getGlobalContext()) != null) {
            String errorMsg = context.getString(R.string.zm_alert_unshare_file_failed);
            this.promptIMErrorMsg(errorMsg, result);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_FileUnshared(reqId, webFileID, result);
            }
        }
    }

    protected void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
        try {
            this.Indicate_UploadToMyFiles_SentImpl(reqID, webFileID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_UploadToMyFiles_SentImpl(String reqID, String webFileID, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_UploadToMyFiles_Sent(reqID, webFileID, result);
            }
        }
    }

    protected void Indicate_QuerySessionFilesResponse(String reqId, String session, int result, List<String> arrWebFileID, long queryEndTime) {
        try {
            this.Indicate_QuerySessionFilesResponseImpl(reqId, session, result, arrWebFileID, queryEndTime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_QuerySessionFilesResponseImpl(String reqId, String session, int result, List<String> arrWebFileID, long queryEndTime) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_QuerySessionFilesResponse(reqId, session, result, arrWebFileID, queryEndTime);
            }
        }
    }

    protected void Indicate_QueryMyFilesResponse(String reqId, int result, List<String> arrWebFileID, long queryEndTime) {
        try {
            this.Indicate_QueryMyFilesResponseImpl(reqId, result, arrWebFileID, queryEndTime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_QueryMyFilesResponseImpl(String reqId, int result, List<String> arrWebFileID, long queryEndTime) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_QueryMyFilesResponse(reqId, result, arrWebFileID, queryEndTime);
            }
        }
    }

    protected void Indicate_QueryAllFilesResponse(String reqId, int result, List<String> arrWebFileID, long queryEndTime) {
        try {
            this.Indicate_QueryAllFilesResponseImpl(reqId, result, arrWebFileID, queryEndTime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_QueryAllFilesResponseImpl(String reqId, int result, List<String> arrWebFileID, long queryEndTime) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_QueryAllFilesResponse(reqId, result, arrWebFileID, queryEndTime);
            }
        }
    }

    protected void Indicate_QueryFilesSharedWithMeResponse(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
        try {
            this.Indicate_QueryFilesSharedWithMeResponseImpl(reqId, result, arrWebFiles, queryEndTime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_QueryFilesSharedWithMeResponseImpl(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_QueryFilesSharedWithMeResponse(reqId, result, arrWebFiles, queryEndTime);
            }
        }
    }

    protected void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
        try {
            this.Indicate_RenameFileResponseImpl(result, reqId, fileId, newName);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_RenameFileResponseImpl(int result, String reqId, String fileId, String newName) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_RenameFileResponse(result, reqId, fileId, newName);
            }
        }
    }

    protected void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
        try {
            this.Indicate_PreviewDownloadedImpl(reqId, webFileID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_PreviewDownloadedImpl(String reqId, String webFileID, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_PreviewDownloaded(reqId, webFileID, result);
            }
        }
    }

    protected void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
        try {
            this.Indicate_FileDownloadedImpl(reqID, webFileID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_FileDownloadedImpl(String reqID, String webFileID, int result) {
        IListener[] listeners;
        Context context;
        if (result != 0 && (context = VideoBoxApplication.getGlobalContext()) != null) {
            String errorMsg = context.getString(R.string.zm_alert_download_file_failed);
            this.promptIMErrorMsg(errorMsg, result);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_FileDownloaded(reqID, webFileID, result);
            }
        }
    }

    protected void Indicate_FileStatusUpdated(String fileID) {
        try {
            this.Indicate_FileStatusUpdatedImpl(fileID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_FileStatusUpdatedImpl(String fileID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_FileStatusUpdated(fileID);
            }
        }
    }

    protected void Indicate_FileContentSearchResult(String reqID, int result, byte[] data) {
        try {
            this.Indicate_FileContentSearchResultImpl(reqID, result, data);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_FileContentSearchResultImpl(String reqID, int result, byte[] data) {
        if (data == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        PTAppProtos.FileFilterSearchResults response = null;
        try {
            response = PTAppProtos.FileFilterSearchResults.parseFrom(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response == null) {
            return;
        }
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_FileContentSearchResult(reqID, result, response);
            }
        }
    }

    protected void Indicate_MessageContentSearchResult(String reqID, int result, byte[] data) {
        try {
            this.Indicate_MessageContentSearchResultImpl(reqID, result, data);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_MessageContentSearchResultImpl(String reqID, int result, byte[] data) {
        if (data == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        PTAppProtos.MessageContentSearchResponse response = null;
        try {
            response = PTAppProtos.MessageContentSearchResponse.parseFrom(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response == null) {
            return;
        }
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_MessageContentSearchResult(reqID, result, response);
            }
        }
    }

    protected void Indicate_GetContactsPresence(List<String> onLines, List<String> offlines) {
        try {
            this.Indicate_GetContactsPresenceImpl(onLines, offlines);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_GetContactsPresenceImpl(List<String> onLines, List<String> offlines) {
        ZMBuddySyncInstance.getInsatance().Indicate_GetContactsPresence(onLines, offlines);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_GetContactsPresence(onLines, offlines);
            }
        }
    }

    protected void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, List<String> sessionIds, long time, long preMsgTime, String msgId) {
        try {
            this.Indicate_FileActionStatusImpl(actionType, fileId, actionOwner, fileName, sessionIds, time, preMsgTime, msgId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_FileActionStatusImpl(int actionType, String fileId, String actionOwner, String fileName, List<String> sessionIds, long time, long preMsgTime, String msgId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (sessionIds != null && sessionIds.size() > 0) {
            for (String sessionId : sessionIds) {
                IListener[] listeners;
                String groupId = "";
                String buddyId = "";
                ZoomChatSession session = messenger.getSessionById(sessionId);
                if (session == null) continue;
                if (actionType == 1 || actionType == 2) {
                    boolean isRoom;
                    if (session.isGroup()) {
                        groupId = sessionId;
                    } else {
                        buddyId = sessionId;
                    }
                    ZoomBuddy owner = messenger.getBuddyWithJID(actionOwner);
                    if (owner == null) {
                        return;
                    }
                    ZoomBuddy myself = messenger.getMyself();
                    if (myself == null) {
                        return;
                    }
                    boolean bInsertMsg = false;
                    boolean isFileOwner = false;
                    MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
                    if (mgr == null) {
                        return;
                    }
                    ZoomFile file = mgr.getFileWithWebFileID(fileId);
                    if (file != null) {
                        isFileOwner = StringUtil.isSameString((String)file.getOwner(), (String)myself.getJid());
                        mgr.destroyFileObject(file);
                    }
                    boolean bl = isRoom = session.isGroup() && session.getSessionGroup() != null && session.getSessionGroup().isRoom();
                    if (isRoom) {
                        if (StringUtil.isSameString((String)actionOwner, (String)myself.getJid()) || session.getSessionGroup().isGroupOperatorable() || isFileOwner) {
                            bInsertMsg = true;
                        }
                    } else {
                        if (session.isGroup() && session.getSessionGroup() == null) continue;
                        if (StringUtil.isSameString((String)owner.getJid(), (String)myself.getJid()) || isFileOwner) {
                            bInsertMsg = true;
                        }
                    }
                    if (bInsertMsg) {
                        msgId = messenger.insertSystemMessage(groupId, buddyId, actionOwner, time / 1000L, 80, msgId, time, preMsgTime);
                    }
                }
                if ((listeners = this.mListenerList.getAll()) == null) continue;
                for (IListener lTmp : listeners) {
                    IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                    l.Indicate_FileActionStatus(actionType, fileId, actionOwner, fileName, sessionId, msgId);
                }
            }
        }
    }

    protected void Indicate_NewFileSharedByOthers(String fileID) {
        try {
            this.Indicate_NewFileSharedByOthersImpl(fileID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_NewFileSharedByOthersImpl(String fileID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_NewFileSharedByOthers(fileID);
            }
        }
    }

    protected void Indicate_NewPersonalFile(String fileID) {
        try {
            this.Indicate_NewPersonalFileImpl(fileID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_NewPersonalFileImpl(String fileID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_NewPersonalFile(fileID);
            }
        }
    }

    protected void FT_OnDownloadByMsgIDTimeOut(String sessionID, String messageID) {
        try {
            this.FT_OnDownloadByMsgIDTimeOutImpl(sessionID, messageID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void FT_OnDownloadByMsgIDTimeOutImpl(String sessionID, String messageID) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            messenger.FT_Cancel(sessionID, messageID);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.FT_OnDownloadByMsgIDTimeOut(sessionID, messageID);
            }
        }
    }

    protected void FT_UploadFileInChatTimeOut(String sessionID, String messageID) {
        try {
            this.FT_UploadFileInChatTimeOutImpl(sessionID, messageID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void FT_UploadFileInChatTimeOutImpl(String sessionID, String messageID) {
        IListener[] listeners;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            messenger.FT_Cancel(sessionID, messageID);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.FT_UploadFileInChatTimeOut(sessionID, messageID);
            }
        }
    }

    protected void FT_OnDownloadByFileIDTimeOut(String reqID, String webFileID) {
        try {
            this.FT_OnDownloadByFileIDTimeOutImpl(reqID, webFileID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void FT_OnDownloadByFileIDTimeOutImpl(String reqID, String webFileID) {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr != null) {
            mgr.cancelFileTransfer(reqID, webFileID);
        }
        StickerManager.FT_OnDownloadByFileIDTimeOutImpl(reqID, webFileID);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.FT_OnDownloadByFileIDTimeOut(reqID, webFileID);
            }
        }
    }

    protected void FT_UploadToMyList_TimeOut(String reqID) {
        try {
            this.FT_UploadToMyList_TimeOutImpl(reqID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void FT_UploadToMyList_TimeOutImpl(String reqID) {
        IListener[] listeners;
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr != null) {
            mgr.cancelFileTransfer(reqID, reqID);
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.FT_UploadToMyList_TimeOut(reqID);
            }
        }
    }

    protected void Indicate_MessageDeleted(String sessionID, String msgID) {
        try {
            this.Indicate_MessageDeletedImpl(sessionID, msgID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_MessageDeletedImpl(String sessionID, String msgID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_MessageDeleted(sessionID, msgID);
            }
        }
    }

    protected void Indicate_MessageContext(int result, String reqID, String session, List<String> msgGuids) {
        try {
            this.Indicate_MessageContextImpl(result, reqID, session, msgGuids);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_MessageContextImpl(int result, String reqID, String session, List<String> msgGuids) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_MessageContext(result, reqID, session, msgGuids);
            }
        }
    }

    protected void Indicate_BlockedUsersUpdated() {
        try {
            this.Indicate_BlockedUsersUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BlockedUsersUpdatedImpl() {
        ZMBuddySyncInstance.getInsatance().Indicate_BlockedUsersUpdated();
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BlockedUsersUpdated();
            }
        }
    }

    protected void Indicate_BlockedUsersAdded(List<String> users) {
        try {
            this.Indicate_BlockedUsersAddedImpl(users);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BlockedUsersAddedImpl(List<String> users) {
        ZMBuddySyncInstance.getInsatance().Indicate_BlockedUsersAdded(users);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BlockedUsersAdded(users);
            }
        }
    }

    protected void Indicate_BlockedUsersRemoved(List<String> users) {
        try {
            this.Indicate_BlockedUsersRemovedImpl(users);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_BlockedUsersRemovedImpl(List<String> users) {
        ZMBuddySyncInstance.getInsatance().Indicate_BlockedUsersRemoved(users);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_BlockedUsersRemoved(users);
            }
        }
    }

    protected void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
        try {
            this.On_NotifyGroupDestroyImpl(groupID, groupName, tm);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void On_NotifyGroupDestroyImpl(String groupID, String groupName, long tm) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.On_NotifyGroupDestroy(groupID, groupName, tm);
            }
        }
    }

    protected void On_DestroyGroup(int result, String actionOwner, String groupID, String groupName, long tm) {
        try {
            this.On_DestroyGroupImpl(result, actionOwner, groupID, groupName, tm);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void On_DestroyGroupImpl(int result, String actionOwner, String groupID, String groupName, long tm) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.On_DestroyGroup(result, actionOwner, groupID, groupName, tm);
            }
        }
    }

    protected void On_AssignGroupAdmins(int result, String actionOwner, String groupID, List<String> buddies, long tm, String msgId, long tmServerside, long prevMsgtime) {
        try {
            this.On_AssignGroupAdminsImpl(result, actionOwner, groupID, buddies, tm, msgId, tmServerside, prevMsgtime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void On_AssignGroupAdminsImpl(int result, String actionOwner, String groupID, List<String> buddies, long tm, String msgId, long tmServerside, long prevMsgtime) {
        IListener[] listeners;
        if (buddies == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        String[] arrBuddies = new String[buddies.size()];
        arrBuddies = buddies.toArray(arrBuddies);
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        if (myJid == null) {
            return;
        }
        boolean isOwnerMe = actionOwner.equals(myJid);
        String ownerName = "";
        ZoomBuddy buddyOwner = null;
        if (isOwnerMe) {
            buddyOwner = myself;
            ownerName = BuddyNameUtil.getMyDisplayName(buddyOwner);
        } else {
            buddyOwner = messenger.getBuddyWithJID(actionOwner);
            if (buddyOwner != null) {
                ownerName = BuddyNameUtil.getBuddyDisplayName(buddyOwner, null, false);
            }
        }
        boolean isMeInBuddies = false;
        for (String jid : arrBuddies) {
            if (!StringUtil.isSameString((String)jid, (String)myJid)) continue;
            isMeInBuddies = true;
            break;
        }
        GroupAction action = new GroupAction(7, ownerName, arrBuddies, isOwnerMe, isMeInBuddies, null);
        action.setActionOwnerId(actionOwner);
        action.setGroupId(groupID);
        action.setTime(tm);
        if (result == 0) {
            String messageBody = GroupAction.serializeToString(action);
            msgId = messenger.insertSystemMessage(groupID, actionOwner, messageBody, tm, 20, msgId, tmServerside, prevMsgtime);
            IListener[] listeners2 = this.mListenerList.getAll();
            if (listeners2 != null) {
                IListener[] iListenerArray = listeners2;
                int n = iListenerArray.length;
                for (int i = 0; i < n; ++i) {
                    IListener lTmp = iListenerArray[i];
                    IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                    l.onGroupAction(result, action, msgId);
                }
            }
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.On_AssignGroupAdmins(result, actionOwner, groupID, buddies, tm);
            }
        }
    }

    protected void Indicate_FetchUserProfileResult(byte[] content) {
        try {
            this.Indicate_FetchUserProfileResultImpl(content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_FetchUserProfileResultImpl(byte[] content) {
        if (content == null) {
            return;
        }
        PTAppProtos.UserProfileResult result = null;
        try {
            result = PTAppProtos.UserProfileResult.parseFrom(content);
        }
        catch (IOException e) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_FetchUserProfileResult(result);
            }
        }
    }

    protected void Indicate_SignatureSet(String reqID, int result) {
        try {
            this.Indicate_SignatureSetImpl(reqID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_SignatureSetImpl(String reqID, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_SignatureSet(reqID, result);
            }
        }
    }

    protected void Indicate_VCardInfoReady(String jid) {
        try {
            this.Indicate_VCardInfoReadyImpl(jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_VCardInfoReadyImpl(String jid) {
        ZMBuddySyncInstance.getInsatance().Indicate_VCardInfoReady(jid);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_VCardInfoReady(jid);
            }
        }
    }

    protected void Indicate_RevokeMessageResult(String actionOwner, String sessionId, String guid, boolean result, long time, String messageOwner, int messageType, long serverTime, long preMsgTime) {
        try {
            this.Indicate_RevokeMessageResultImpl(actionOwner, sessionId, guid, result, time, messageOwner, messageType, serverTime, preMsgTime);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_RevokeMessageResultImpl(String actionOwner, String sessionId, String guid, boolean result, long time, String messageOwner, int messageType, long serverTime, long preMsgTime) {
        IListener[] listeners;
        String messageId = null;
        if (result) {
            boolean isText;
            ZoomMessenger zm = PTApp.getInstance().getZoomMessenger();
            if (StringUtil.isEmptyOrNull((String)sessionId) || zm == null) {
                return;
            }
            ZoomChatSession session = zm.getSessionById(sessionId);
            if (session == null) {
                return;
            }
            ZoomBuddy buddy = zm.getMyself();
            if (buddy == null) {
                return;
            }
            boolean isRoom = session.isGroup() && session.getSessionGroup() != null && session.getSessionGroup().isRoom();
            boolean bl = isText = messageType == 0 || messageType == 2;
            if (TextUtils.equals((CharSequence)actionOwner, (CharSequence)buddy.getJid()) || TextUtils.equals((CharSequence)messageOwner, (CharSequence)buddy.getJid()) || !isText && isRoom && session.getSessionGroup().isGroupOperatorable()) {
                String buddyId;
                String groupId;
                if (zm.getGroupById(sessionId) != null) {
                    groupId = sessionId;
                    buddyId = "";
                } else {
                    groupId = "";
                    buddyId = sessionId;
                }
                messageId = zm.insertSystemMessage(groupId, buddyId, actionOwner, time / 1000L, true, 80, guid, serverTime, preMsgTime);
            }
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_RevokeMessageResult(actionOwner, sessionId, guid, messageId, result);
            }
        }
    }

    protected void Indicate_HistoryMessageArrived(int result, String reqId, List<String> msgGuids, boolean isFirstSync, String sessionId) {
        try {
            this.Indicate_HistoryMessageArrivedImpl(result, reqId, msgGuids, isFirstSync, sessionId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_HistoryMessageArrivedImpl(int result, String reqId, List<String> msgIds, boolean isFirstSync, String sessionId) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_HistoryMessageArrived(result, reqId, msgIds, isFirstSync, sessionId);
            }
        }
    }

    protected void Notify_DBLoadSessionLastMessagesDone() {
        try {
            this.Notify_DBLoadSessionLastMessagesDoneImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Notify_DBLoadSessionLastMessagesDoneImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Notify_DBLoadSessionLastMessagesDone();
            }
        }
    }

    private void NotifyOutdatedHistoryRemoved(List<String> sessionIDs, long eraseTime) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.NotifyOutdatedHistoryRemoved(sessionIDs, eraseTime);
            }
        }
    }

    public void ZoomPrensece_OnUserOptionUpated() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.ZoomPrensece_OnUserOptionUpated();
            }
        }
    }

    public void notifyWebSipStatus(SIPConfiguration sipConfiguration) {
        PTApp.getInstance().updateSipPhoneStatus(sipConfiguration);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.notifyWebSipStatus(sipConfiguration);
            }
        }
    }

    public void NotifyLocalAddressChanged(String old_ip, String new_ip) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.NotifyLocalAddressChanged(old_ip, new_ip);
            }
        }
    }

    private void promptIMErrorMsg(final String message, final int errroCode) {
        ZMActivity curFrontActivity = ZMActivity.getFrontActivity();
        if (curFrontActivity != null && curFrontActivity.isActive() && !curFrontActivity.isFinishing()) {
            IntegrationActivity.promptIMErrorMsg(VideoBoxApplication.getInstance(), message, errroCode);
        } else {
            ForegroundTask task = new ForegroundTask("promptIMErrorMsg"){

                public void run(ZMActivity activity) {
                    IntegrationActivity.promptIMErrorMsg(VideoBoxApplication.getInstance(), message, errroCode);
                }

                public boolean isValidActivity(String activityClass) {
                    if (LauncherActivity.class.getName().equals(activityClass)) {
                        return false;
                    }
                    return super.isValidActivity(activityClass);
                }

                public boolean hasAnotherProcessAtFront() {
                    IConfService confService = VideoBoxApplication.getInstance().getConfService();
                    if (confService != null) {
                        try {
                            return confService.isConfAppAtFront();
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    return false;
                }
            };
            ForegroundTaskManager.getInstance().runInForeground(task);
        }
    }

    protected void Indicate_DownloadFileByUrl(String reqId, int result) {
        try {
            this.Indicate_DownloadFileByUrlIml(reqId, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_DownloadFileByUrlIml(String reqID, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_DownloadFileByUrlIml(reqID, result);
            }
        }
    }

    protected void Indicate_SendAddonCommandResult(String msgID, boolean result) {
        try {
            this.Indicate_SendAddonCommandResultIml(msgID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_SendAddonCommandResultIml(String msgID, boolean result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_SendAddonCommandResultIml(msgID, result);
            }
        }
    }

    private void Indicate_EditMessageResult(String actionOwner, String sessionId, String guid, long msgTime, long serverTime, boolean result) {
        try {
            this.Indicate_EditMessageResultIml(actionOwner, sessionId, guid, msgTime, serverTime, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_EditMessageResultIml(String actionOwner, String sessionId, String guid, long msgTime, long serverTime, boolean result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_EditMessageResultIml(actionOwner, sessionId, guid, msgTime, serverTime, result);
            }
        }
    }

    private void Indicate_GetHotGiphyInfoResult(int result, String reqID, List<String> giphyIds, String msgStr, String sessionID) {
        try {
            this.Indicate_GetHotGiphyInfoResultIml(result, reqID, giphyIds, msgStr, sessionID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_GetHotGiphyInfoResultIml(int result, String reqID, List<String> giphyIds, String msgStr, String sessionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_GetHotGiphyInfoResult(result, reqID, giphyIds, msgStr, sessionID);
            }
        }
    }

    private void indicate_CallActionResponded(String senderJID, String senderName, long time, int type, String msgID, long serverTime, long prevMsgTime, long meetingNO, boolean isVideoCall) {
        try {
            this.indicate_CallActionRespondedIml(senderJID, senderName, time, type, msgID, serverTime, prevMsgTime, meetingNO, isVideoCall);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void indicate_CallActionRespondedIml(String senderJID, String senderName, long time, int type, String msgID, long serverTime, long prevMsgTime, long meetingNO, boolean isVideoCall) {
        IncomingCallManager.getInstance().insertCallActionMessage(senderJID, senderName, time, type, msgID, serverTime, prevMsgTime, meetingNO, isVideoCall);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.indicate_CallActionRespondedIml(senderJID, senderName, time, type, msgID, serverTime, prevMsgTime, meetingNO, isVideoCall);
            }
        }
    }

    private void confirm_EditedFileDownloaded(Map<String, String> map, int result) {
        try {
            this.confirm_EditedFileDownloadedIml(result, map);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void confirm_EditedFileDownloadedIml(int result, Map<String, String> map) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.confirm_EditedFileDownloadedIml(result, map);
            }
        }
    }

    private void Indicate_GetGIFFromGiphyResult(int result, String reqID, List<String> giphyIds, String msgStr, String sessionID) {
        try {
            this.Indicate_GetGIFFromGiphyResultIml(result, reqID, giphyIds, msgStr, sessionID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_GetGIFFromGiphyResultIml(int result, String reqID, List<String> giphyIds, String msgStr, String sessionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_GetGIFFromGiphyResultIml(result, reqID, giphyIds, msgStr, sessionID);
            }
        }
    }

    private void Indicate_DownloadGIFFromGiphyResult(int result, String reqID, String url, String localPath, String sessionID, String giphyID) {
        try {
            this.Indicate_DownloadGIFFromGiphyResultIml(result, reqID, url, localPath, sessionID, giphyID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void Indicate_DownloadGIFFromGiphyResultIml(int result, String reqID, String url, String localPath, String sessionID, String giphyID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.Indicate_DownloadGIFFromGiphyResultIml(result, reqID, url, localPath, sessionID, giphyID);
            }
        }
    }

    private void On_MyPresenceChanged(int presence, int presenceStatus) {
        try {
            this.On_MyPresenceChangedIml(presence, presenceStatus);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void On_MyPresenceChangedIml(int presence, int presenceStatus) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessengerUIListener l = (IZoomMessengerUIListener)lTmp;
                l.On_MyPresenceChanged(presence, presenceStatus);
            }
        }
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleZoomMessengerUIListener
    implements IZoomMessengerUIListener {
        @Override
        public void onBeginConnect() {
        }

        @Override
        public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
        }

        @Override
        public void onConnectReturn(int errorCode) {
        }

        @Override
        public void onIndicateBuddyInfoUpdated(String phoneNumber) {
        }

        @Override
        public void onIndicateIMCMDReceivedImpl(String sessionId, String senderName, String messageId, long date, int messageType) {
        }

        @Override
        public void onIndicateBuddyListUpdated() {
        }

        @Override
        public void onIndicate_BuddyBigPictureDownloaded(String jid, int result) {
        }

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
        }

        @Override
        public void onNotify_ChatSessionListUpdate() {
        }

        @Override
        public void onConfirm_MessageSent(String sessionId, String messageId, int result) {
        }

        @Override
        public void onConfirmFileDownloaded(String sessionId, String messageId, int result) {
        }

        @Override
        public void onConfirmPreviewPicFileDownloaded(String sessionId, String messageId, int result) {
        }

        @Override
        public boolean onIndicateMessageReceived(String sessionId, String senderJid, String messageId) {
            return false;
        }

        @Override
        public void onIndicateInputStateChanged(String sessionId, int state) {
        }

        @Override
        public void onReceivedCall(String groupId, String senderJid, PTAppProtos.InvitationItem item) {
        }

        @Override
        public void onNotify_ChatSessionUpdate(String sessionId) {
        }

        @Override
        public void onNotify_JIDUpdated() {
        }

        @Override
        public void onIndicateInfoUpdatedWithJID(String jid) {
        }

        @Override
        public void onAddBuddy(String jid, int result, String reasonString) {
        }

        @Override
        public void onAddBuddyByEmail(String email, int result) {
        }

        @Override
        public void onRemoveBuddy(String jid, int result) {
        }

        @Override
        public void onSearchBuddy(String email, int result) {
        }

        @Override
        public void onSearchBuddyByKey(String key, int result) {
        }

        @Override
        public void onSearchBuddyPicDownloaded(String jid) {
        }

        @Override
        public boolean onNotifySubscribeRequest(String jid, String msg) {
            return false;
        }

        @Override
        public boolean onNotifySubscriptionAccepted(String jid) {
            return false;
        }

        @Override
        public boolean onNotifySubscriptionDenied(String jid) {
            return false;
        }

        @Override
        public void onNotifyUnsubscribeRequest(String strBareJid, String message) {
        }

        @Override
        public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        }

        @Override
        public void onNotifyBuddyJIDUpgrade(String phoneNo, String oldJid, String newJid) {
        }

        @Override
        public void FT_OnSent(String sessionID, String messageID, int result) {
        }

        @Override
        public void FT_OnProgress(String sessionID, String messageID, int ratio, long completeSize, long bitPerSecond) {
        }

        @Override
        public void FT_OnResumed(String sessionID, String messageID, int result) {
        }

        @Override
        public void E2E_MyStateUpdate(int myE2EState) {
        }

        @Override
        public void E2E_SessionStateUpdate(String sessionID, String tid, int e2eSessionState, int e2eError) {
        }

        @Override
        public void E2E_MessageStateUpdate(String sessionID, String messageID, int newState) {
        }

        @Override
        public void E2E_NotifyAutoLogoff() {
        }

        @Override
        public void onNotifySubscribeRequestUpdated(String jid) {
        }

        @Override
        public void Confirm_HistoryReqComplete(String requestId, String sessionId, int result, int count) {
        }

        @Override
        public void Indicate_OnlineBuddies(List<String> jidList) {
        }

        @Override
        public void Indicate_BuddyGroupsRemoved(List<String> groupIDs) {
        }

        @Override
        public void Indicate_BuddyPresenceChanged(String jid) {
        }

        @Override
        public void Indicate_BuddyGroupAdded(String groupID) {
        }

        @Override
        public void Indicate_BuddyGroupInfoUpdated(String groupID) {
        }

        @Override
        public void Indicate_BuddyGroupMembersAdded(String groupID, List<String> jidList) {
        }

        @Override
        public void Indicate_BuddyGroupMembersRemoved(String groupID, List<String> jidList) {
        }

        @Override
        public void Indicate_BuddyGroupMembersChanged(PTAppProtos.ChangedBuddyGroups changedBuddyGroups, boolean bLastPage) {
        }

        @Override
        public void Indicate_BuddyGroupMemberAdded(String groupName, String jid) {
        }

        @Override
        public void Indicate_BuddyGroupMemberRemoved(String groupName, String jid) {
        }

        @Override
        public void On_AddLocalPendingBuddy(String jid, int result, String groupJid) {
        }

        @Override
        public void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        }

        @Override
        public void FT_UploadToMyList_OnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
        }

        @Override
        public void Indicate_FileDeleted(String reqId, String webFileID, int result) {
        }

        @Override
        public void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        }

        @Override
        public void Indicate_FileForwarded(String reqId, String origMsgXmppID, String newSession, String newMsgXmppID, int result) {
        }

        @Override
        public void Indicate_FileUnshared(String reqId, String webFileID, int result) {
        }

        @Override
        public void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
        }

        @Override
        public void Indicate_QuerySessionFilesResponse(String reqId, String session, int result, List<String> arrWebFileID, long queryEndTime) {
        }

        @Override
        public void Indicate_QueryMyFilesResponse(String reqId, int result, List<String> arrWebFileID, long queryEndTime) {
        }

        @Override
        public void Indicate_QueryFilesSharedWithMeResponse(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
        }

        @Override
        public void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
        }

        @Override
        public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
        }

        @Override
        public void Indicate_FileStatusUpdated(String fileID) {
        }

        @Override
        public void Indicate_FileContentSearchResult(String reqID, int result, PTAppProtos.FileFilterSearchResults response) {
        }

        @Override
        public void Indicate_MessageContentSearchResult(String reqID, int result, PTAppProtos.MessageContentSearchResponse response) {
        }

        @Override
        public void Indicate_BuddyAdded(String jid, List<String> groupIds) {
        }

        @Override
        public void Indicate_GetContactsPresence(List<String> onLines, List<String> offlines) {
        }

        @Override
        public void Indicate_NewFileSharedByOthers(String fileID) {
        }

        @Override
        public void Indicate_NewPersonalFile(String fileID) {
        }

        @Override
        public void Indicate_QueryAllFilesResponse(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
        }

        @Override
        public void Indicate_MessageDeleted(String sessionID, String msgID) {
        }

        @Override
        public void Indicate_MessageContext(int result, String reqID, String session, List<String> msgGuids) {
        }

        @Override
        public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
        }

        @Override
        public void FT_OnDownloadByMsgIDTimeOut(String sessionID, String messageID) {
        }

        @Override
        public void FT_UploadFileInChatTimeOut(String session, String messageID) {
        }

        @Override
        public void FT_OnDownloadByFileIDTimeOut(String reqID, String webFileID) {
        }

        @Override
        public void FT_UploadToMyList_TimeOut(String reqID) {
        }

        @Override
        public void Indicate_BlockedUsersUpdated() {
        }

        @Override
        public void Indicate_BlockedUsersAdded(List<String> users) {
        }

        @Override
        public void Indicate_BlockedUsersRemoved(List<String> users) {
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
        }

        @Override
        public void On_DestroyGroup(int result, String actionOwner, String groupID, String groupName, long tm) {
        }

        @Override
        public void On_AssignGroupAdmins(int result, String actionOwner, String groupID, List<String> buddies, long tm) {
        }

        @Override
        public void Indicate_FetchUserProfileResult(PTAppProtos.UserProfileResult result) {
        }

        @Override
        public void Indicate_RevokeMessageResult(String actionOwner, String sessionId, String guid, String recallMsgId, boolean result) {
        }

        @Override
        public void Indicate_SignatureSet(String reqId, int result) {
        }

        @Override
        public void Indicate_VCardInfoReady(String jid) {
        }

        @Override
        public void Indicate_DownloadFileByUrlIml(String reqID, int result) {
        }

        @Override
        public void Indicate_SendAddonCommandResultIml(String msgID, boolean result) {
        }

        @Override
        public void Indicate_EditMessageResultIml(String actionOwner, String sessionId, String guid, long msgTime, long serverTime, boolean result) {
        }

        @Override
        public void ZoomPrensece_OnUserOptionUpated() {
        }

        @Override
        public void notifyWebSipStatus(SIPConfiguration sipConfiguration) {
        }

        @Override
        public void NotifyLocalAddressChanged(String old_ip, String new_ip) {
        }

        @Override
        public void onNotify_ChatSessionUnreadUpdate() {
        }

        @Override
        public void onNotify_SessionMarkUnreadCtx(String reqID, int result, String session, List<String> msgGuids) {
        }

        @Override
        public void Indicate_GetGIFFromGiphyResultIml(int result, String reqID, List<String> giphyIds, String msgStr, String sessionID) {
        }

        @Override
        public void Indicate_GetHotGiphyInfoResult(int result, String reqID, List<String> giphyIds, String msgStr, String sessionID) {
        }

        @Override
        public void Indicate_DownloadGIFFromGiphyResultIml(int result, String reqID, String url, String localPath, String sessionID, String giphyID) {
        }

        @Override
        public void Indicate_HistoryMessageArrived(int result, String reqId, List<String> msgGuids, boolean isFirstSync, String sessionId) {
        }

        @Override
        public void NotifyOutdatedHistoryRemoved(List<String> sessionIDs, long eraseTime) {
        }

        @Override
        public void indicate_CallActionRespondedIml(String senderJID, String senderName, long time, int type, String msgID, long serverTime, long prevMsgTime, long meetingNO, boolean isVideoCall) {
        }

        @Override
        public void Notify_DBLoadSessionLastMessagesDone() {
        }

        @Override
        public void On_MyPresenceChanged(int presence, int presenceStatus) {
        }

        @Override
        public void Indicate_TPV2_GetContactsPresence(List<String> onlineJIDs, List<String> offlineJIDs) {
        }

        @Override
        public void Indicate_TPV2_SubscribePresence(List<String> JIDs) {
        }

        @Override
        public void Indicate_TPV2_WillExpirePresence(List<String> JIDs, int type) {
        }

        @Override
        public void confirm_EditedFileDownloadedIml(int result, Map<String, String> map) {
        }
    }

    public static interface IZoomMessengerUIListener
    extends IListener {
        public void onBeginConnect();

        public void onConnectReturn(int var1);

        public void onIndicateBuddyInfoUpdated(String var1);

        public void onIndicateBuddyListUpdated();

        public void onIndicate_BuddyBigPictureDownloaded(String var1, int var2);

        public void onGroupAction(int var1, GroupAction var2, String var3);

        public void onNotify_ChatSessionListUpdate();

        public void onConfirm_MessageSent(String var1, String var2, int var3);

        public void onConfirmFileDownloaded(String var1, String var2, int var3);

        public void onConfirmPreviewPicFileDownloaded(String var1, String var2, int var3);

        public boolean onIndicateMessageReceived(String var1, String var2, String var3);

        public void onIndicateIMCMDReceivedImpl(String var1, String var2, String var3, long var4, int var6);

        public void onIndicateInputStateChanged(String var1, int var2);

        public void onReceivedCall(String var1, String var2, PTAppProtos.InvitationItem var3);

        public void onNotify_ChatSessionUpdate(String var1);

        public void onNotify_ChatSessionUnreadUpdate();

        public void onNotify_SessionMarkUnreadCtx(String var1, int var2, String var3, List<String> var4);

        public void onNotify_JIDUpdated();

        public void onIndicateInfoUpdatedWithJID(String var1);

        public void onAddBuddy(String var1, int var2, String var3);

        public void onAddBuddyByEmail(String var1, int var2);

        public void onRemoveBuddy(String var1, int var2);

        public void onSearchBuddy(String var1, int var2);

        public void onSearchBuddyByKey(String var1, int var2);

        public void onSearchBuddyPicDownloaded(String var1);

        public boolean onNotifySubscribeRequest(String var1, String var2);

        public boolean onNotifySubscriptionAccepted(String var1);

        public boolean onNotifySubscriptionDenied(String var1);

        public void onNotifyUnsubscribeRequest(String var1, String var2);

        public void onNotify_MUCGroupInfoUpdatedImpl(String var1);

        public void onNotifyBuddyJIDUpgrade(String var1, String var2, String var3);

        public void FT_OnSent(String var1, String var2, int var3);

        public void On_NotifyGroupDestroy(String var1, String var2, long var3);

        public void On_DestroyGroup(int var1, String var2, String var3, String var4, long var5);

        public void On_AssignGroupAdmins(int var1, String var2, String var3, List<String> var4, long var5);

        public void FT_OnProgress(String var1, String var2, int var3, long var4, long var6);

        public void FT_OnResumed(String var1, String var2, int var3);

        public void E2E_MyStateUpdate(int var1);

        public void E2E_SessionStateUpdate(String var1, String var2, int var3, int var4);

        public void E2E_MessageStateUpdate(String var1, String var2, int var3);

        public void onNotifySubscribeRequestUpdated(String var1);

        public void E2E_NotifyAutoLogoff();

        public void Confirm_HistoryReqComplete(String var1, String var2, int var3, int var4);

        public void Indicate_OnlineBuddies(List<String> var1);

        public void Indicate_BuddyGroupsRemoved(List<String> var1);

        public void Indicate_BuddyPresenceChanged(String var1);

        public void Indicate_BuddyGroupAdded(String var1);

        public void Indicate_BuddyGroupInfoUpdated(String var1);

        public void Indicate_BuddyGroupMembersAdded(String var1, List<String> var2);

        public void Indicate_BuddyGroupMembersRemoved(String var1, List<String> var2);

        public void Indicate_BuddyGroupMembersChanged(PTAppProtos.ChangedBuddyGroups var1, boolean var2);

        public void Indicate_BuddyGroupMemberAdded(String var1, String var2);

        public void Indicate_BuddyGroupMemberRemoved(String var1, String var2);

        public void On_AddLocalPendingBuddy(String var1, int var2, String var3);

        public void Indicate_BuddyAdded(String var1, List<String> var2);

        public void Indicate_GetContactsPresence(List<String> var1, List<String> var2);

        public void FT_DownloadByFileID_OnProgress(String var1, String var2, int var3, int var4, int var5);

        public void FT_UploadToMyList_OnProgress(String var1, int var2, int var3, int var4);

        public void Indicate_FileDeleted(String var1, String var2, int var3);

        public void Indicate_FileShared(String var1, String var2, String var3, String var4, String var5, int var6);

        public void Indicate_FileForwarded(String var1, String var2, String var3, String var4, int var5);

        public void Indicate_FileUnshared(String var1, String var2, int var3);

        public void Indicate_UploadToMyFiles_Sent(String var1, String var2, int var3);

        public void Indicate_QuerySessionFilesResponse(String var1, String var2, int var3, List<String> var4, long var5);

        public void Indicate_QueryMyFilesResponse(String var1, int var2, List<String> var3, long var4);

        public void Indicate_QueryFilesSharedWithMeResponse(String var1, int var2, List<String> var3, long var4);

        public void Indicate_QueryAllFilesResponse(String var1, int var2, List<String> var3, long var4);

        public void Indicate_RenameFileResponse(int var1, String var2, String var3, String var4);

        public void Indicate_PreviewDownloaded(String var1, String var2, int var3);

        public void Indicate_DownloadFileByUrlIml(String var1, int var2);

        public void Indicate_FileDownloaded(String var1, String var2, int var3);

        public void Indicate_FileStatusUpdated(String var1);

        public void Indicate_FileContentSearchResult(String var1, int var2, PTAppProtos.FileFilterSearchResults var3);

        public void Indicate_MessageContentSearchResult(String var1, int var2, PTAppProtos.MessageContentSearchResponse var3);

        public void Indicate_NewFileSharedByOthers(String var1);

        public void Indicate_NewPersonalFile(String var1);

        public void Indicate_MessageDeleted(String var1, String var2);

        public void Indicate_MessageContext(int var1, String var2, String var3, List<String> var4);

        public void Indicate_FileActionStatus(int var1, String var2, String var3, String var4, String var5, String var6);

        public void FT_OnDownloadByMsgIDTimeOut(String var1, String var2);

        public void FT_UploadFileInChatTimeOut(String var1, String var2);

        public void FT_OnDownloadByFileIDTimeOut(String var1, String var2);

        public void FT_UploadToMyList_TimeOut(String var1);

        public void Indicate_BlockedUsersUpdated();

        public void Indicate_BlockedUsersAdded(List<String> var1);

        public void Indicate_BlockedUsersRemoved(List<String> var1);

        public void Indicate_FetchUserProfileResult(PTAppProtos.UserProfileResult var1);

        public void Indicate_RevokeMessageResult(String var1, String var2, String var3, String var4, boolean var5);

        public void Indicate_SignatureSet(String var1, int var2);

        public void Indicate_VCardInfoReady(String var1);

        public void Indicate_SendAddonCommandResultIml(String var1, boolean var2);

        public void Indicate_EditMessageResultIml(String var1, String var2, String var3, long var4, long var6, boolean var8);

        public void ZoomPrensece_OnUserOptionUpated();

        public void notifyWebSipStatus(SIPConfiguration var1);

        public void NotifyLocalAddressChanged(String var1, String var2);

        public void Indicate_GetGIFFromGiphyResultIml(int var1, String var2, List<String> var3, String var4, String var5);

        public void Indicate_DownloadGIFFromGiphyResultIml(int var1, String var2, String var3, String var4, String var5, String var6);

        public void Indicate_GetHotGiphyInfoResult(int var1, String var2, List<String> var3, String var4, String var5);

        public void Indicate_HistoryMessageArrived(int var1, String var2, List<String> var3, boolean var4, String var5);

        public void NotifyOutdatedHistoryRemoved(List<String> var1, long var2);

        public void Notify_DBLoadSessionLastMessagesDone();

        public void On_MyPresenceChanged(int var1, int var2);

        public void indicate_CallActionRespondedIml(String var1, String var2, long var3, int var5, String var6, long var7, long var9, long var11, boolean var13);

        public void Indicate_TPV2_GetContactsPresence(List<String> var1, List<String> var2);

        public void Indicate_TPV2_SubscribePresence(List<String> var1);

        public void Indicate_TPV2_WillExpirePresence(List<String> var1, int var2);

        public void confirm_EditedFileDownloadedIml(int var1, Map<String, String> var2);
    }
}

