/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class ZoomMessageTemplateUI {
    private static final String TAG = ZoomMessageTemplateUI.class.getSimpleName();
    private static ZoomMessageTemplateUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle;

    public void addListener(IZoomMessageTemplateUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IZoomMessageTemplateUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IZoomMessageTemplateUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public static synchronized ZoomMessageTemplateUI getInstance() {
        if (instance == null) {
            instance = new ZoomMessageTemplateUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private ZoomMessageTemplateUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void notifySendPostHttpMessageDone(String reqID, int result) {
        try {
            this.notifySendPostHttpMessageDoneImpl(reqID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notifySendPostHttpMessageDoneImpl(String reqID, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessageTemplateUIListener l = (IZoomMessageTemplateUIListener)lTmp;
                l.Notify_SendPostHttpMessageDone(reqID, result);
            }
        }
    }

    protected void notifySendGetHttpMessageDone(String reqID, int result) {
        try {
            this.notifySendGetHttpMessageDoneImpl(reqID, result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notifySendGetHttpMessageDoneImpl(String reqID, int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomMessageTemplateUIListener l = (IZoomMessageTemplateUIListener)lTmp;
                l.Notify_SendGetHttpMessageDone(reqID, result);
            }
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleZoomMessageTemplateUIListener
    implements IZoomMessageTemplateUIListener {
        @Override
        public void Notify_SendPostHttpMessageDone(String reqID, int result) {
        }

        @Override
        public void Notify_SendGetHttpMessageDone(String reqID, int result) {
        }
    }

    public static interface IZoomMessageTemplateUIListener
    extends IListener {
        public void Notify_SendPostHttpMessageDone(String var1, int var2);

        public void Notify_SendGetHttpMessageDone(String var1, int var2);
    }
}

