/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.PreferenceUtil;
import java.util.UUID;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.HardwareUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;

public class SystemInfoHelper {
    private static final String TAG = SystemInfoHelper.class.getSimpleName();

    public static String getMacAddress() {
        try {
            return SystemInfoHelper.getMacAddressImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return "";
        }
    }

    private static String getMacAddressImpl() {
        String macAddr = SystemInfoHelper.getCachedWifiMacAddress();
        if (StringUtil.isEmptyOrNull((String)macAddr)) {
            macAddr = SystemInfoHelper.makeDummyMacAddress();
            SystemInfoHelper.cacheWifiMacAddress(macAddr);
        }
        String androidId = null;
        try {
            String id2 = PreferenceUtil.readStringValue("system_device_id", null);
            if (StringUtil.isEmptyOrNull((String)id2)) {
                androidId = Settings.Secure.getString((ContentResolver)VideoBoxApplication.getInstance().getContentResolver(), (String)"android_id");
                PreferenceUtil.saveStringValue("system_device_id", androidId);
            } else {
                androidId = id2;
            }
        }
        catch (Exception id2) {
            // empty catch block
        }
        String deviceId = androidId + "-" + macAddr;
        return deviceId;
    }

    public static String getDeviceId() {
        return SystemInfoHelper.getMacAddress();
    }

    private static String makeDummyMacAddress() {
        String str = UUID.randomUUID().toString();
        if ((str = str.replaceAll("\\-", "")).length() >= 12) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 6; ++i) {
                sb.append(str.substring(i * 2, (i + 1) * 2));
                if (i >= 5) continue;
                sb.append(":");
            }
            return sb.toString();
        }
        return str;
    }

    private static void cacheWifiMacAddress(String macAddr) {
        PreferenceUtil.saveStringValue("wifi_mac_address", macAddr);
    }

    private static String getCachedWifiMacAddress() {
        return PreferenceUtil.readStringValue("wifi_mac_address", null);
    }

    public static String getOSInfo() {
        return "Android " + Build.VERSION.RELEASE;
    }

    public static String getClientInfo() {
        return "Android";
    }

    public static String getHardwareInfo() {
        try {
            String[] mccMnc = SystemInfoHelper.getMccAndMnc();
            return "DeviceID:" + Settings.System.getString((ContentResolver)VideoBoxApplication.getInstance().getContentResolver(), (String)"android_id") + ";Manufacturer:" + Build.MANUFACTURER + ";Model:" + Build.MODEL + ";OS:Android " + Build.VERSION.RELEASE + ";CPU_ABI:" + HardwareUtil.getPreferredCpuABI() + ";PRODUCT:" + Build.PRODUCT + ";FINGERPRINT:" + Build.FINGERPRINT + ";DisplaySize:" + UIUtil.getDisplayWidth((Context)VideoBoxApplication.getInstance()) + "x" + UIUtil.getDisplayHeight((Context)VideoBoxApplication.getInstance()) + ";DisplayDensity:" + VideoBoxApplication.getInstance().getResources().getDisplayMetrics().density + ";ScreenCategory:" + UIUtil.getScreenCategoryName((Context)VideoBoxApplication.getInstance()) + ";mcc:" + mccMnc[0] + ";mnc:" + mccMnc[1] + ";country:" + SystemInfoHelper.getCountryIso() + ";language:" + SystemInfoHelper.getLanguage() + ";CPU Kernels:" + HardwareUtil.getCPUKernalNumbers() + ";CPU Frequency:" + HardwareUtil.getCPUKernelFrequency((int)0, (int)2);
        }
        catch (Throwable e) {
            return e.getMessage();
        }
    }

    private static String[] getMccAndMnc() {
        int networkType;
        NetworkInfo ni;
        String[] codes = new String[2];
        ConnectivityManager cm = (ConnectivityManager)VideoBoxApplication.getInstance().getSystemService("connectivity");
        if (cm != null && (ni = cm.getActiveNetworkInfo()) != null && (networkType = ni.getType()) == 1) {
            codes[0] = "wifi";
            codes[1] = "NA";
            return codes;
        }
        TelephonyManager tel = (TelephonyManager)VideoBoxApplication.getInstance().getSystemService("phone");
        if (tel != null) {
            String networkOperator = tel.getNetworkOperator();
            if (networkOperator != null && networkOperator.length() == 5) {
                codes[0] = networkOperator.substring(0, 3);
                codes[1] = networkOperator.substring(3);
            } else {
                codes[0] = "NA";
                codes[1] = "NA";
            }
        }
        return codes;
    }

    private static String getCountryIso() {
        TelephonyManager tm = (TelephonyManager)VideoBoxApplication.getInstance().getSystemService("phone");
        String countryCode = null;
        if (tm != null && ((countryCode = tm.getSimCountryIso()) == null || countryCode.length() == 0)) {
            countryCode = CompatUtils.getLocalDefault().getCountry();
        }
        return countryCode;
    }

    private static String getLanguage() {
        return CompatUtils.getLocalDefault().getLanguage();
    }
}

