/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import com.zipow.videobox.ptapp.PTAppProtos;
import java.io.IOException;

public class PTBuddyHelper {
    private static final String TAG = PTBuddyHelper.class.getSimpleName();
    private long mNativeHandle = 0L;

    public PTBuddyHelper(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public PTAppProtos.BuddyItem getBuddyItem(int index) {
        if (index < 0 || index >= this.getBuddyItemCount()) {
            return null;
        }
        byte[] data = this.getBuddyItemProtoData(this.mNativeHandle, index);
        if (data == null || data.length == 0) {
            return null;
        }
        PTAppProtos.BuddyItem item = null;
        try {
            item = PTAppProtos.BuddyItem.parseFrom(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return item;
    }

    public String getBuddyItemJid(int index) {
        return this.getBuddyItemJidImpl(this.mNativeHandle, index);
    }

    public int getBuddyItemCount() {
        return this.getBuddyItemCountImpl(this.mNativeHandle);
    }

    public PTAppProtos.BuddyItem getBuddyItemByJid(String jid) {
        if (jid == null) {
            return null;
        }
        byte[] data = this.getBuddyItemProtoDataByJid(this.mNativeHandle, jid);
        if (data == null || data.length == 0) {
            return null;
        }
        PTAppProtos.BuddyItem item = null;
        try {
            item = PTAppProtos.BuddyItem.parseFrom(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return item;
    }

    public String[] filterBuddyWithInput(String input) {
        if (input == null) {
            input = "";
        }
        String[] jids = this.filterBuddyWithInputImpl(this.mNativeHandle, input);
        return jids;
    }

    public byte[] getBuddyItemData(int index) {
        return this.getBuddyItemProtoData(this.mNativeHandle, index);
    }

    public byte[] getBuddyItemDataByJid(String jid) {
        return this.getBuddyItemProtoDataByJid(this.mNativeHandle, jid);
    }

    private native int getBuddyItemCountImpl(long var1);

    private native byte[] getBuddyItemProtoData(long var1, int var3);

    private native String getBuddyItemJidImpl(long var1, int var3);

    private native byte[] getBuddyItemProtoDataByJid(long var1, String var3);

    private native String[] filterBuddyWithInputImpl(long var1, String var3);
}

