/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import android.os.RemoteException;
import com.zipow.videobox.ISIPService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.sip.server.SIPProcessMgr;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.NumberUtil;

public class PT4SIPIPCPort {
    private static final String TAG = PT4SIPIPCPort.class.getSimpleName();
    private static PT4SIPIPCPort instance = null;
    private long mNativeHandle = 0L;
    private List<byte[]> mSendMessageBuff = new ArrayList<byte[]>();
    private List<byte[]> mReceiveMessageBuff = new ArrayList<byte[]>();

    private PT4SIPIPCPort() {
    }

    public static synchronized PT4SIPIPCPort getInstance() {
        if (instance == null) {
            instance = new PT4SIPIPCPort();
        }
        return instance;
    }

    public void initialize() {
        this.nativeInit();
    }

    public boolean sendMessage(byte[] message) {
        if (message == null) {
            return false;
        }
        ISIPService sipService = VideoBoxApplication.getInstance().getSIPService();
        if (sipService == null) {
            this.mSendMessageBuff.add(message);
            return false;
        }
        boolean success = true;
        try {
            this.sendBufferedMessages(sipService);
            this.sendMessageImpl(message, sipService);
        }
        catch (Exception e) {
            this.mSendMessageBuff.add(message);
            success = false;
        }
        return success;
    }

    public void sendBufferedMessages() {
        ISIPService sipService = VideoBoxApplication.getInstance().getSIPService();
        if (sipService == null) {
            return;
        }
        try {
            this.sendBufferedMessages(sipService);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void sendBufferedMessages(ISIPService sipService) throws RemoteException {
        if (this.mSendMessageBuff.size() > 0) {
            for (int i = this.mSendMessageBuff.size() - 1; i >= 0; --i) {
                byte[] msgTmp = this.mSendMessageBuff.get(i);
                this.sendMessageImpl(msgTmp, sipService);
                this.mSendMessageBuff.remove(i);
            }
        }
    }

    public synchronized void onMessageReceived(byte[] message) {
        int curSipPid;
        if (message == null || message.length <= 4) {
            return;
        }
        int pid = NumberUtil.byteArrayToInt((byte[])message, (int)0);
        if (pid != (curSipPid = SIPProcessMgr.getInstance().getCurrentSipProcessId())) {
            return;
        }
        if (this.mNativeHandle == 0L) {
            this.mReceiveMessageBuff.add(message);
            return;
        }
        try {
            this.onMessageReceivedImpl(this.mNativeHandle, message, 4);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public synchronized void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        if (this.mNativeHandle != 0L) {
            this.receiveBufferedMessages();
        }
    }

    private void receiveBufferedMessages() {
        if (this.mReceiveMessageBuff.size() > 0) {
            for (byte[] message : this.mReceiveMessageBuff) {
                try {
                    this.onMessageReceivedImpl(this.mNativeHandle, message, 4);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            this.mReceiveMessageBuff.clear();
        }
    }

    private void sendMessageImpl(byte[] message, ISIPService sipService) throws RemoteException {
        try {
            int pid = SIPProcessMgr.getInstance().getCurrentSipProcessId();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(NumberUtil.intToByteArray((int)pid));
            os.write(message);
            byte[] buff = os.toByteArray();
            os.close();
            sipService.sendMessage(buff);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private native void nativeInit();

    private native void onMessageReceivedImpl(long var1, byte[] var3, int var4);
}

