/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.ptapp;

import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class NotificationSettingUI {
    private static final String TAG = NotificationSettingUI.class.getSimpleName();
    private static NotificationSettingUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle;

    public void addListener(INotificationSettingUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((INotificationSettingUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(INotificationSettingUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public static synchronized NotificationSettingUI getInstance() {
        if (instance == null) {
            instance = new NotificationSettingUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    private NotificationSettingUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void OnBlockAllSettingsUpdated() {
        try {
            this.OnBlockAllSettingsUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnBlockAllSettingsUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                INotificationSettingUIListener l = (INotificationSettingUIListener)lTmp;
                l.OnBlockAllSettingsUpdated();
            }
        }
    }

    protected void OnDNDSettingsUpdated() {
        try {
            this.OnDNDSettingsUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnDNDSettingsUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                INotificationSettingUIListener l = (INotificationSettingUIListener)lTmp;
                l.OnDNDSettingsUpdated();
            }
        }
    }

    protected void OnSnoozeSettingsUpdated() {
        try {
            this.OnSnoozeSettingsUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnSnoozeSettingsUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                INotificationSettingUIListener l = (INotificationSettingUIListener)lTmp;
                l.OnSnoozeSettingsUpdated();
            }
        }
    }

    protected void OnMUCSettingUpdated() {
        try {
            this.OnMUCSettingUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnMUCSettingUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                INotificationSettingUIListener l = (INotificationSettingUIListener)lTmp;
                l.OnMUCSettingUpdated();
            }
        }
    }

    protected void OnInCallSettingUpdated() {
        try {
            this.OnInCallSettingUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnInCallSettingUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                INotificationSettingUIListener l = (INotificationSettingUIListener)lTmp;
                l.OnInCallSettingUpdated();
            }
        }
    }

    protected void OnDNDNowSettingUpdated() {
        try {
            this.OnDNDNowSettingUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnDNDNowSettingUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                INotificationSettingUIListener l = (INotificationSettingUIListener)lTmp;
                l.OnDNDNowSettingUpdated();
            }
        }
    }

    protected void OnHLPersonSettingUpdated() {
        try {
            this.OnHLPersonSettingUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnHLPersonSettingUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                INotificationSettingUIListener l = (INotificationSettingUIListener)lTmp;
                l.OnHLPersonSettingUpdated();
            }
        }
    }

    protected void OnKeyWordSettingUpdated() {
        try {
            this.OnKeyWordSettingUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void OnKeyWordSettingUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                INotificationSettingUIListener l = (INotificationSettingUIListener)lTmp;
                l.OnKeyWordSettingUpdated();
            }
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L) {
            this.nativeUninit(this.mNativeHandle);
        }
        super.finalize();
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleNotificationSettingUIListener
    implements INotificationSettingUIListener {
        @Override
        public void OnBlockAllSettingsUpdated() {
        }

        @Override
        public void OnDNDSettingsUpdated() {
        }

        @Override
        public void OnSnoozeSettingsUpdated() {
        }

        @Override
        public void OnMUCSettingUpdated() {
        }

        @Override
        public void OnInCallSettingUpdated() {
        }

        @Override
        public void OnDNDNowSettingUpdated() {
        }

        @Override
        public void OnHLPersonSettingUpdated() {
        }

        @Override
        public void OnKeyWordSettingUpdated() {
        }
    }

    public static interface INotificationSettingUIListener
    extends IListener {
        public void OnBlockAllSettingsUpdated();

        public void OnDNDSettingsUpdated();

        public void OnSnoozeSettingsUpdated();

        public void OnMUCSettingUpdated();

        public void OnInCallSettingUpdated();

        public void OnDNDNowSettingUpdated();

        public void OnHLPersonSettingUpdated();

        public void OnKeyWordSettingUpdated();
    }
}

